/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki.cmp;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJException;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.provider.pki.cmp.CMP;
import com.rsa.certj.provider.pki.cmp.CMPException;
import com.rsa.certj.provider.pki.cmp.CMPProtectInfo;
import com.rsa.certj.provider.pki.cmp.PKIHeader;
import com.rsa.certj.provider.pki.cmp.TypeAndValue;
import com.rsa.certj.spi.pki.PKIRequestMessage;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_MAC;
import com.rsa.jsafe.JSAFE_MessageDigest;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_Signature;
import java.security.SecureRandom;
import java.util.StringTokenizer;

abstract class CMPRequestCommon
extends PKIRequestMessage {
    private static final int a = 20;
    private static final int b = 1024;
    private static final byte[] c = new byte[]{43, 6, 1, 5, 5, 8, 1, 2};
    private byte[] d = null;
    private TypeAndValue[] e = null;
    private int f;

    protected CMPRequestCommon(int n, byte[] byArray) throws InvalidParameterException {
        this(n, byArray, null, null);
    }

    protected CMPRequestCommon(int n, byte[] byArray, String[] stringArray, TypeAndValue[] typeAndValueArray) throws InvalidParameterException {
        super(null, null);
        this.f = n;
        this.d = byArray;
        this.e = typeAndValueArray;
        this.setFreeText(stringArray);
    }

    protected int getMessageType() {
        return this.f;
    }

    protected byte[] getRecipNonce() {
        return this.d;
    }

    protected TypeAndValue[] getGeneralInfo() {
        return this.e;
    }

    protected void setRecipNonce(byte[] byArray) {
        this.d = byArray;
    }

    protected byte[] derEncodeBody(CertJ certJ) throws CMPException {
        throw new CMPException("CMPRequestCommon.derEncode: this method should be overwritten by sublclasses.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] derEncode(CMPProtectInfo cMPProtectInfo, CertJ certJ) throws CMPException {
        Object object;
        Object object2;
        JSAFE_SecureRandom jSAFE_SecureRandom;
        try {
            jSAFE_SecureRandom = certJ.getRandomObject();
        }
        catch (CertJException certJException) {
            throw new CMPException("CMPRequestCommon.writeMessage:unable to get a registered random service(" + certJException.getMessage() + ").");
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        int n = -1;
        byte[] byArray3 = this.derEncodeBody(certJ);
        if (cMPProtectInfo != null) {
            if (cMPProtectInfo.pbmProtected()) {
                object2 = cMPProtectInfo.getAlgorithm();
                if (!((String)object2).startsWith("PBE/HMAC/SHA1")) throw new CMPException("CMPRequestCommon.writeMessage: PBM MAC algorithm specified by " + (String)object2 + " is not supported.");
                byArray2 = jSAFE_SecureRandom.generateRandomBytes(20);
                object = new StringTokenizer((String)object2, "-");
                if (((StringTokenizer)object).hasMoreTokens()) {
                    ((StringTokenizer)object).nextToken();
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        n = Integer.parseInt(((StringTokenizer)object).nextToken());
                    }
                }
                if (n <= 0) {
                    n = 1024;
                }
                byArray = this.a(byArray2, n, certJ);
            } else {
                byArray = this.a(cMPProtectInfo.getAlgorithm(), certJ);
            }
        }
        object2 = new PKIHeader(this, cMPProtectInfo, byArray, jSAFE_SecureRandom).derEncode();
        object = CMP.derEncodeProtectedPart((byte[])object2, 0, ((Object)object2).length, byArray3, 0, byArray3.length);
        byte[] byArray4 = null;
        if (cMPProtectInfo == null) return this.a((byte[])object2, byArray3, byArray4, this.getExtraCerts());
        byArray4 = cMPProtectInfo.pbmProtected() ? this.a((byte[])object, cMPProtectInfo, byArray2, n, certJ) : this.a((byte[])object, cMPProtectInfo, jSAFE_SecureRandom, certJ);
        return this.a((byte[])object2, byArray3, byArray4, this.getExtraCerts());
    }

    private byte[] a(byte[] byArray, CMPProtectInfo cMPProtectInfo, JSAFE_SecureRandom jSAFE_SecureRandom, CertJ certJ) throws CMPException {
        DatabaseService databaseService = cMPProtectInfo.getDatabase();
        X509Certificate x509Certificate = cMPProtectInfo.getSenderCert();
        JSAFE_PrivateKey jSAFE_PrivateKey = null;
        try {
            jSAFE_PrivateKey = databaseService.selectPrivateKeyByCertificate(x509Certificate);
        }
        catch (CertJException certJException) {
            throw new CMPException("CMPRequestCommon.computeProtection: unable to find a signer private key in the database(" + certJException.getMessage() + ").");
        }
        if (jSAFE_PrivateKey == null) {
            throw new CMPException("CMPRequestCommon.computeProtection: unable to find a signer private key in the database.");
        }
        String string = cMPProtectInfo.getAlgorithm();
        try {
            JSAFE_Signature jSAFE_Signature = JSAFE_Signature.getInstance((String)string, (String)certJ.getDevice());
            jSAFE_Signature.signInit(jSAFE_PrivateKey, null, (SecureRandom)jSAFE_SecureRandom, certJ.getPKCS11Sessions());
            jSAFE_Signature.signUpdate(byArray, 0, byArray.length);
            byte[] byArray2 = jSAFE_Signature.signFinal();
            return byArray2;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CMPException("CMPRequestCommon.createSginatureProtectionDER: unable to generate a signature for " + string + "(" + jSAFE_Exception.getMessage() + ").");
        }
        finally {
            jSAFE_PrivateKey.clearSensitiveData();
        }
    }

    private byte[] a(byte[] byArray, CMPProtectInfo cMPProtectInfo, byte[] byArray2, int n, CertJ certJ) throws CMPException {
        JSAFE_MAC jSAFE_MAC = null;
        try {
            jSAFE_MAC = JSAFE_MAC.getInstance((String)cMPProtectInfo.getAlgorithm(), (String)certJ.getDevice());
            jSAFE_MAC.setSalt(byArray2, 0, byArray2.length);
            JSAFE_SecretKey jSAFE_SecretKey = jSAFE_MAC.getBlankKey();
            char[] cArray = cMPProtectInfo.getSharedSecret();
            jSAFE_SecretKey.setPassword(cArray, 0, cArray.length);
            jSAFE_MAC.macInit(jSAFE_SecretKey, null);
            jSAFE_MAC.macUpdate(byArray, 0, byArray.length);
            byte[] byArray3 = jSAFE_MAC.macFinal();
            return byArray3;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CMPException("CMPRequestCommon.createPBMProtection: unable to compute PBM(" + jSAFE_Exception.getMessage() + ").");
        }
        finally {
            if (jSAFE_MAC != null) {
                jSAFE_MAC.clearSensitiveData();
            }
        }
    }

    private byte[] a(byte[] byArray, byte[] byArray2, byte[] byArray3, Certificate[] certificateArray) throws CMPException {
        try {
            ASN1Container aSN1Container = this.a(certificateArray);
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            EncodedContainer encodedContainer = new EncodedContainer(0, true, 0, byArray, 0, byArray.length);
            EncodedContainer encodedContainer2 = new EncodedContainer(0, true, 0, byArray2, 0, byArray2.length);
            BitStringContainer bitStringContainer = byArray3 == null ? new BitStringContainer(0xA10000, false, 0, 0, 0, false) : new BitStringContainer(0xA10000, true, 0, byArray3, 0, byArray3.length, byArray3.length * 8, false);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, encodedContainer2, bitStringContainer, aSN1Container, endContainer};
            ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray);
            byte[] byArray4 = new byte[aSN1Template.derEncodeInit()];
            aSN1Template.derEncode(byArray4, 0);
            return byArray4;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CMPException("CMPRequestCommon.derEncodePKIMessage: Encoding CMP message faild(" + aSN_Exception.getMessage() + ").");
        }
    }

    private ASN1Container a(Certificate[] certificateArray) throws CMPException, ASN_Exception {
        if (certificateArray == null) {
            return new EncodedContainer(0xA10001, false, 0, null, 0, 0);
        }
        OfContainer ofContainer = new OfContainer(0xA10001, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
        for (int i = 0; i < certificateArray.length; ++i) {
            byte[] byArray;
            Certificate certificate = certificateArray[i];
            if (!(certificate instanceof X509Certificate)) {
                throw new CMPException("CMPRequestCommon.createExtraCertsContainer:certificate in extraCerts should be an instance of X509Certificate.");
            }
            try {
                byArray = new byte[((X509Certificate)certificate).getDERLen(0)];
                ((X509Certificate)certificate).getDEREncoding(byArray, 0, 0);
            }
            catch (CertificateException certificateException) {
                throw new CMPException("CMPRequestCommon.createExtraCertsContainer: Encoding a certificate faild(" + certificateException.getMessage() + ").");
            }
            try {
                ofContainer.addContainer((ASN1Container)new EncodedContainer(0, true, 0, byArray, 0, byArray.length));
                continue;
            }
            catch (ASN_Exception aSN_Exception) {
                throw new CMPException("CMPRequestCommon.createExtraCertsContainer: unable to add an element of extraCerts(" + aSN_Exception.getMessage() + ").");
            }
        }
        return ofContainer;
    }

    private byte[] a(byte[] byArray, int n, CertJ certJ) throws CMPException {
        byte[] byArray2 = this.b(byArray, n, certJ);
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0xA10001, true, 0);
            OIDContainer oIDContainer = new OIDContainer(0x1000000, true, 0, CMP.PASSWORD_BASED_MAC_OID, 0, CMP.PASSWORD_BASED_MAC_OID.length);
            EncodedContainer encodedContainer = new EncodedContainer(77824, true, 0, byArray2, 0, byArray2.length);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
            ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray);
            byte[] byArray3 = new byte[aSN1Template.derEncodeInit()];
            aSN1Template.derEncode(byArray3, 0);
            return byArray3;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CMPException("CMPRequestCommon.encodePBMAlgorithmIdentifier: unable to encodeEncoding PBMAlgorithmIdentifier(" + aSN_Exception.getMessage() + ").");
        }
    }

    private byte[] a(String string, CertJ certJ) throws CMPException {
        byte[] byArray;
        try {
            byArray = JSAFE_Signature.getInstance((String)string, (String)certJ.getDevice()).getDERAlgorithmID();
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CMPException("CMPRequestCommon.derEncodeSignatureAlgorithm: unable to get algorithm identifier for " + string + "(" + jSAFE_Exception.getMessage() + ").");
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0x800001, true, 0);
            EncodedContainer encodedContainer = new EncodedContainer(0, true, 0, byArray, 0, byArray.length);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, endContainer};
            ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray);
            byte[] byArray2 = new byte[aSN1Template.derEncodeInit()];
            aSN1Template.derEncode(byArray2, 0);
            return byArray2;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CMPException("CMPRequestCommon.derEncodeSignatureAlgorithm: unable to encode signature algorithm(" + aSN_Exception.getMessage() + ").");
        }
    }

    private byte[] b(byte[] byArray, int n, CertJ certJ) throws CMPException {
        JSAFE_MAC jSAFE_MAC;
        JSAFE_MessageDigest jSAFE_MessageDigest;
        String string = certJ.getDevice();
        try {
            jSAFE_MessageDigest = JSAFE_MessageDigest.getInstance((String)"SHA1", (String)string);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CMPException("CMPRequestCommon.derEncodePBMParameter: " + jSAFE_Exception.getMessage());
        }
        byte[] byArray2 = jSAFE_MessageDigest.getDERAlgorithmID();
        try {
            jSAFE_MAC = JSAFE_MAC.getInstance((String)"HMAC/SHA1", (String)string);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CMPException("CMPRequestCommon.derEncodePBMParameter: " + jSAFE_Exception.getMessage());
        }
        byte[] byArray3 = this.a(jSAFE_MAC);
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            OctetStringContainer octetStringContainer = new OctetStringContainer(0, true, 0, byArray, 0, byArray.length);
            EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, byArray2, 0, byArray2.length);
            IntegerContainer integerContainer = new IntegerContainer(0, true, 0, n);
            EncodedContainer encodedContainer2 = new EncodedContainer(12288, true, 0, byArray3, 0, byArray3.length);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, octetStringContainer, encodedContainer, integerContainer, encodedContainer2, endContainer};
            ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray);
            byte[] byArray4 = new byte[aSN1Template.derEncodeInit()];
            aSN1Template.derEncode(byArray4, 0);
            return byArray4;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CMPException("CMPRequestCommon.derEncodePBMParameter: Encoding PBMParameter faild(" + aSN_Exception.getMessage() + ").");
        }
    }

    private byte[] a(JSAFE_MAC jSAFE_MAC) throws CMPException {
        String string = jSAFE_MAC.getMACAlgorithm();
        String string2 = jSAFE_MAC.getDigestAlgorithm();
        if (!jSAFE_MAC.getMACAlgorithm().equals("HMAC") || !jSAFE_MAC.getDigestAlgorithm().equals("SHA1")) {
            throw new CMPException("CMPRequestCommon.getMACAlgorithmID: algorithm(" + string + "/" + string2 + ") not supported.  Use HMAC/SHA1.");
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            OIDContainer oIDContainer = new OIDContainer(0x1000000, true, 0, c, 0, c.length);
            EncodedContainer encodedContainer = new EncodedContainer(77824, false, 5, null, 0, 0);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
            ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray);
            byte[] byArray = new byte[aSN1Template.derEncodeInit()];
            aSN1Template.derEncode(byArray, 0);
            return byArray;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CMPException("CMPRequestCommon.getMACAlgorithmID: Encoding MAC Algorithm Identifier faild(" + aSN_Exception.getMessage() + ").");
        }
    }
}

