/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki.cmp;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.UTF8StringContainer;
import com.rsa.certj.provider.pki.cmp.CMPException;
import com.rsa.certj.provider.pki.cmp.CMPResponseCommon;
import com.rsa.certj.provider.pki.cmp.PKIHeader;
import com.rsa.certj.spi.pki.PKIException;
import com.rsa.certj.spi.pki.PKIStatusInfo;

public final class CMPErrorMessage
extends CMPResponseCommon {
    private boolean a = false;
    private int b;
    private String[] c = null;

    private CMPErrorMessage(PKIHeader pKIHeader, PKIStatusInfo pKIStatusInfo, boolean bl, int n, String[] stringArray) throws CMPException {
        super(23, pKIHeader, pKIStatusInfo);
        this.a = bl;
        this.b = n;
        this.c = stringArray;
    }

    protected static CMPErrorMessage berDecodeBody(PKIHeader pKIHeader, byte[] byArray, int n) throws CMPException {
        Object object;
        EncodedContainer encodedContainer = null;
        IntegerContainer integerContainer = null;
        OfContainer ofContainer = null;
        try {
            encodedContainer = new EncodedContainer(12288);
            integerContainer = new IntegerContainer(65536);
            ofContainer = new OfContainer(65536, 12288, (ASN1Container)new EncodedContainer(3072));
            object = new ASN1Container[]{new SequenceContainer(10551319), encodedContainer, integerContainer, ofContainer, new EndContainer()};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])object);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CMPException("CMPErrorMessage.berDecodeBody: decoding ErrorMsgContent faild(" + aSN_Exception.getMessage() + ").");
        }
        try {
            object = new PKIStatusInfo(encodedContainer.data, encodedContainer.dataOffset, 0);
        }
        catch (PKIException pKIException) {
            throw new CMPException("CMPErrorMessage$ErrorMsgContent.ErrorMsgContent: unable to instantiate PKIStatusInfo(" + pKIException.getMessage() + ").");
        }
        boolean bl = integerContainer.dataPresent;
        int n2 = -1;
        if (bl) {
            try {
                n2 = integerContainer.getValueAsInt();
            }
            catch (ASN_Exception aSN_Exception) {
                throw new CMPException("CMPErrorMessage$ErrorMsgContent.ErrorMsgContent: unable to get ErrorMsgContent.errorCode as int(" + aSN_Exception.getMessage() + ").");
            }
        }
        String[] stringArray = null;
        if (ofContainer.dataPresent) {
            int n3 = ofContainer.getContainerCount();
            stringArray = new String[n3];
            for (int i = 0; i < n3; ++i) {
                try {
                    ASN1Container aSN1Container = ofContainer.containerAt(i);
                    UTF8StringContainer uTF8StringContainer = new UTF8StringContainer(0);
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{uTF8StringContainer};
                    ASN1.berDecode((byte[])aSN1Container.data, (int)aSN1Container.dataOffset, (ASN1Container[])aSN1ContainerArray);
                    if (uTF8StringContainer.dataPresent && uTF8StringContainer.dataLen != 0) {
                        stringArray[i] = new String(uTF8StringContainer.data, uTF8StringContainer.dataOffset, uTF8StringContainer.dataLen);
                        continue;
                    }
                    stringArray[i] = null;
                    continue;
                }
                catch (ASN_Exception aSN_Exception) {
                    throw new CMPException("CMPErrorMessage$ErrorMsgContent.ErrorMsgContent: unable to extract and decode an errorDetails(" + aSN_Exception.getMessage() + ").");
                }
            }
        }
        return new CMPErrorMessage(pKIHeader, (PKIStatusInfo)object, bl, n2, stringArray);
    }

    public boolean errorCodePresent() {
        return this.a;
    }

    public int getErrorCode() throws CMPException {
        if (!this.a) {
            throw new CMPException("CMPErrorMessage.getErrorCode: error code not returned.");
        }
        return this.b;
    }

    public String[] getErrorDetails() {
        return this.c;
    }
}

