/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJException;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.PKCS10CertRequest;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.attributes.V3ExtensionAttribute;
import com.rsa.certj.cert.attributes.VeriSignCRSFailureInfo;
import com.rsa.certj.cert.attributes.VeriSignCRSMessageType;
import com.rsa.certj.cert.attributes.VeriSignCRSPKIStatus;
import com.rsa.certj.cert.attributes.VeriSignCRSRecipientNonce;
import com.rsa.certj.cert.attributes.VeriSignCRSSenderNonce;
import com.rsa.certj.cert.attributes.VeriSignCRSTransactionID;
import com.rsa.certj.cert.attributes.VeriSignCRSVersion;
import com.rsa.certj.cert.attributes.X501Attribute;
import com.rsa.certj.pkcs7.ContentInfo;
import com.rsa.certj.pkcs7.Data;
import com.rsa.certj.pkcs7.EnvelopedData;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.pkcs7.RecipientInfo;
import com.rsa.certj.pkcs7.SignedData;
import com.rsa.certj.pkcs7.SignerInfo;
import com.rsa.certj.provider.pki.Cr;
import com.rsa.certj.provider.pki.Cs;
import com.rsa.certj.provider.pki.PKICommonImplementation;
import com.rsa.certj.provider.pki.PKIDebug;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.pki.PKIException;
import com.rsa.certj.spi.pki.PKIInterface;
import com.rsa.certj.spi.pki.PKIMessage;
import com.rsa.certj.spi.pki.PKIRequestMessage;
import com.rsa.certj.spi.pki.PKIResponseMessage;
import com.rsa.certj.spi.pki.PKIResult;
import com.rsa.certj.spi.pki.PKIStatusInfo;
import com.rsa.certj.spi.pki.PKITransportException;
import com.rsa.certj.spi.pki.POPGenerationInfo;
import com.rsa.certj.spi.pki.POPValidationInfo;
import com.rsa.certj.spi.pki.ProtectInfo;
import com.rsa.certj.spi.pki.ProtectInfoPublicKey;
import com.rsa.certj.spi.random.RandomException;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_MessageDigest;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_Recode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class CRS
extends Provider
implements PKIDebug {
    public static final int POP_TYPE_CSR = 1;
    private static final int a = 1;
    private static final int b = 0;
    private static final String c = "-----BEGIN NEW CERTIFICATE REQUEST-----";
    private static final String d = "-----END NEW CERTIFICATE REQUEST-----";
    private static final String e = "application/octet-stream";
    private static final String f = "application/x-crs-message";
    private static final int g = 0;
    private static final int h = 19;
    private static final int i = 20;
    private static final int j = 3;
    private static final String k = "VeriSign";
    private static final int l = 76;
    private static final int[] m = new int[]{256, 261, 262, 263, 264, 266, 268, 269, 272, 276, 277, 288, 293, 294, 296, 298, 306, 307, 316, 317, 325, 326, 327, 328, 330, 4101, 12353, 12359, 12380, 12384, 12385, 12393, 12420, 14593, 14594, 14595, 14596, 14597, 14598, 14599, 14600, 14601, 14602, 14603, 14604, 14605, 14606, 14607, 14608, 14609, 14610, 14611, 14612, 14613, 14614, 14615, 14617, 14619, 14620, 14623, 14624, 14625, 14626, 14627, 14628, 14629, 14630, 14631, 14632, 14633, 14634, 14639, 14640, 14641, 14642, 14643};
    private static final int[] n = new int[]{0x200000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x40000000, 0x4000000, 0x4000000, Integer.MIN_VALUE, Integer.MIN_VALUE, 0x100000, Integer.MIN_VALUE, Integer.MIN_VALUE, 0x20000000, 0x40000000, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x8000000, 0x100000, 0x100000, 0x100000, 0x8000000, 0x8000000, 0x1000000, 0x1000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x40000000, 0x40000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x100000, 0x100000, 0x100000, 0x100000, 0x100000, 0x100000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x8000000, 0x4000000, 0x8000000, 0x8000000, 0x4000000, 0x100000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x8000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x8000000};
    private static final int o = 16;
    private Hashtable p;

    public CRS(String string, InputStream inputStream) throws InvalidParameterException {
        super(4, string);
        if (inputStream == null) {
            throw new InvalidParameterException("CRS.CRS: configStream should not be null.");
        }
        this.p = PKICommonImplementation.loadProperties(inputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CRS(String string, File file) throws InvalidParameterException {
        super(4, string);
        if (file == null) {
            throw new InvalidParameterException("CRS.CRS: configFile should not be null.");
        }
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                this.p = PKICommonImplementation.loadProperties(fileInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new InvalidParameterException("CRS.CRS: " + file.toString() + " does not exist.");
            }
            Object var6_4 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (fileInputStream == null) throw throwable;
            try {
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        ((InputStream)fileInputStream).close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CRS(String string, String string2) throws InvalidParameterException {
        super(4, string);
        if (string2 == null) {
            throw new InvalidParameterException("CRS.CRS: configFileName should not be null.");
        }
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(new File(string2));
                this.p = PKICommonImplementation.loadProperties(fileInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new InvalidParameterException("CRS.CRS: " + string2 + " does not exist.");
            }
            Object var6_4 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (fileInputStream == null) throw throwable;
            try {
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        ((InputStream)fileInputStream).close();
        return;
    }

    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            return new Implementation(certJ, this.getName(), null);
        }
        catch (Exception exception) {
            throw new ProviderManagementException("CRS.instantiate: " + exception.getMessage());
        }
    }

    public void saveMessage(byte[] byArray, PKIMessage pKIMessage, ProtectInfo protectInfo) throws PKIException {
    }

    public void saveCertificate(PKIResponseMessage pKIResponseMessage) throws PKIException {
    }

    public void saveData(byte[] byArray, String string) throws PKIException {
    }

    class ResponseData {
        byte[] a = null;
        byte[] b = null;

        public ResponseData(byte[] byArray, byte[] byArray2) {
            this.b = byArray;
            this.a = byArray2;
        }
    }

    private final class Implementation
    extends PKICommonImplementation
    implements PKIInterface {
        private Implementation(CertJ certJ, String string) throws InvalidParameterException, PKIException {
            super(certJ, string);
            this.loadConfig(CRS.this.p);
            if (this.profile == null) {
                this.profile = CRS.k;
            }
        }

        public PKIResponseMessage readCertificationResponseMessage(byte[] byArray, ProtectInfo protectInfo) throws NotSupportedException, PKIException {
            boolean bl;
            if (!(protectInfo instanceof ProtectInfoPublicKey)) {
                throw new PKIException("CRS$Implementation.readCertificationResponseMessage:protectInfo should be an instance of ProtectInfoPublicKey.");
            }
            ProtectInfoPublicKey protectInfoPublicKey = (ProtectInfoPublicKey)protectInfo;
            SignedData signedData = new SignedData(this.certJ, protectInfoPublicKey.getCertPathCtx());
            try {
                bl = signedData.readInit(byArray, 0, byArray.length);
                if (bl) {
                    bl = signedData.readFinal();
                }
            }
            catch (Exception exception) {
                if (byArray[0] == 48) {
                    throw new PKIException("CRS$Implementation.readCertificationResponseMessage:decoding response or signature verification failed(" + exception.getMessage() + ").");
                }
                String[] stringArray = new String[]{new String(byArray)};
                throw new PKITransportException("CRS$Implementation.readCertificationResponseMessage:error returned in HTML. See the value returned by thisException.getStatusInfo().getStatusStrings[0] for the contents of the HTML response." + new String(byArray) + ").", new PKIStatusInfo(2, 0x200000, stringArray, -1));
            }
            if (!bl) {
                throw new PKIException("CRS$Implementation.readCertificationResponseMessage: Decoding of SignedData failed.");
            }
            return this.a(signedData, protectInfoPublicKey);
        }

        public byte[] writeCertificationRequestMessage(PKIRequestMessage pKIRequestMessage, ProtectInfo protectInfo) throws NotSupportedException, PKIException {
            ContentInfo contentInfo;
            byte[] byArray;
            if (!(protectInfo instanceof ProtectInfoPublicKey)) {
                throw new PKIException("CRS$Implementation.writeCertificationRequestMessage: ProtectInfo should be an instance of ProtectInfoPublicKey.");
            }
            if (pKIRequestMessage.getRegInfo() == null) {
                throw new PKIException("CRS$Implementation.writeCertificationRequestMessage: RegInfo of the request message should not be null.");
            }
            if (pKIRequestMessage.getSender() == null) {
                throw new PKIException("CRS$Implementation.writeCertificationRequestMessage: Sender information of the request message should not be null.");
            }
            Cs cs = (Cs)pKIRequestMessage.getProviderData();
            if (cs == null || cs.b == null || cs.b.length == 0) {
                throw new PKIException("CRS$Implementation.writeCertificationRequestMessage: POP of the request message should not be null.Use generateProofOfPossession to set it.");
            }
            boolean bl = cs.e;
            int n = pKIRequestMessage.getWrapType();
            if (n != 1 && n != 4) {
                throw new PKIException("CRS$Implementation.writeCertificationRequestMessage: Only WRAP_SIGN or WRAP_ENVELOPE_THEN_SIGN is supported.");
            }
            if (pKIRequestMessage.getVersion() == -1) {
                pKIRequestMessage.setVersion(0);
            } else if (pKIRequestMessage.getVersion() != 0) {
                throw new PKIException("CRS$Implementation.writeCertificationRequestMessage: CRS version (" + pKIRequestMessage.getVersion() + ") is not the same as supported version(" + 0 + ").");
            }
            ProtectInfoPublicKey protectInfoPublicKey = (ProtectInfoPublicKey)protectInfo;
            try {
                byArray = bl ? this.a(pKIRequestMessage, protectInfoPublicKey.getCertPathCtx()) : cs.b;
                byte[] byArray2 = this.a(byArray, pKIRequestMessage.getRegInfo());
                Data data = new Data();
                data.setContent(byArray2, 0, byArray2.length);
                if (n == 4) {
                    if (pKIRequestMessage.getRecipient() == null) {
                        throw new PKIException("Implementation.writeCertificationRequestMessage: Recipent info of the request message should not be null.");
                    }
                    contentInfo = this.a(protectInfoPublicKey.getCertPathCtx(), pKIRequestMessage, data);
                } else {
                    contentInfo = data;
                }
                X501Attributes x501Attributes = pKIRequestMessage.getSender().getAuthenticatedAttrs();
                if (x501Attributes == null) {
                    x501Attributes = new X501Attributes();
                }
                if (x501Attributes.getAttributeByType(12) == null) {
                    x501Attributes.addAttribute(new VeriSignCRSVersion(pKIRequestMessage.getVersion()));
                }
                if (x501Attributes.getAttributeByType(6) == null) {
                    if (cs.e) {
                        x501Attributes.addAttribute(new VeriSignCRSMessageType(20));
                    } else {
                        x501Attributes.addAttribute(new VeriSignCRSMessageType(19));
                    }
                }
                if (x501Attributes.getAttributeByType(11) == null) {
                    if (pKIRequestMessage.getTransactionID() == null) {
                        pKIRequestMessage.setTransactionID(this.a(data));
                    }
                    x501Attributes.addAttribute(new VeriSignCRSTransactionID(pKIRequestMessage.getTransactionID(), 0, pKIRequestMessage.getTransactionID().length));
                }
                if (x501Attributes.getAttributeByType(9) == null) {
                    if (cs.a == null) {
                        cs.a = this.a();
                    }
                    x501Attributes.addAttribute(new VeriSignCRSSenderNonce(cs.a, 0, cs.a.length));
                }
                pKIRequestMessage.getSender().setAuthenticatedAttrs(x501Attributes);
            }
            catch (PKCS7Exception pKCS7Exception) {
                throw new PKIException("CRS$Implementation.writeCertificationRequestMessage: " + pKCS7Exception.getMessage());
            }
            byArray = this.a(protectInfoPublicKey.getCertPathCtx(), pKIRequestMessage, contentInfo);
            pKIRequestMessage.setMessageTime(new Date());
            return byArray;
        }

        public PKIResponseMessage sendRequest(PKIRequestMessage pKIRequestMessage, ProtectInfo protectInfo, DatabaseService databaseService) throws NotSupportedException, PKIException {
            Object object;
            byte[] byArray = this.writeCertificationRequestMessage(pKIRequestMessage, protectInfo);
            CRS.this.saveMessage(byArray, pKIRequestMessage, protectInfo);
            PKIResult pKIResult = this.sendMessage(byArray);
            PKIStatusInfo pKIStatusInfo = pKIResult.getStatusInfo();
            if (pKIStatusInfo.getStatus() != 0) {
                return new PKIResponseMessage(pKIStatusInfo);
            }
            byte[] byArray2 = pKIResult.getEncodedResponse();
            CRS.this.saveData(byArray2, "RespTemp.ber");
            PKIResponseMessage pKIResponseMessage = this.readCertificationResponseMessage(byArray2, protectInfo);
            CRS.this.saveMessage(byArray2, pKIResponseMessage, protectInfo);
            pKIStatusInfo = pKIResponseMessage.getStatusInfo();
            int n = pKIStatusInfo.getStatus();
            if (n != 0 && n != 3 && (pKIStatusInfo.getFailInfo() & 0x200000) != 0) {
                return pKIResponseMessage;
            }
            if (n == 0 || n == 3) {
                if (!CertJUtils.byteArraysEqual(pKIRequestMessage.getTransactionID(), pKIResponseMessage.getTransactionID())) {
                    throw new PKIException("CRS$Implementation.sendRequest: Transaction IDs do not match.");
                }
                if (!this.a(pKIRequestMessage, pKIResponseMessage)) {
                    throw new PKIException("CRS$Implementation.sendRequest: Nonces do not match.");
                }
            }
            if (n == 3) {
                object = (Cs)pKIRequestMessage.getProviderData();
                ((Cs)object).e = true;
            }
            if ((object = this.findCertificateReturned(pKIRequestMessage, pKIResponseMessage)) != null) {
                pKIResponseMessage.setCertificate((Certificate)object);
            }
            if (databaseService != null) {
                this.disperseCertsAndCRLs(pKIResponseMessage, databaseService);
            }
            CRS.this.saveCertificate(pKIResponseMessage);
            return pKIResponseMessage;
        }

        public PKIResponseMessage requestCertification(PKIRequestMessage pKIRequestMessage, ProtectInfo protectInfo, DatabaseService databaseService) throws NotSupportedException, PKIException {
            return this.sendRequest(pKIRequestMessage, protectInfo, databaseService);
        }

        public PKIResult sendMessage(byte[] byArray) throws NotSupportedException, PKIException {
            for (int i = 0; i < this.destList.length; ++i) {
                boolean bl;
                URL uRL;
                String string = this.destList[i];
                try {
                    uRL = new URL(string);
                }
                catch (Exception exception) {
                    continue;
                }
                String string2 = uRL.getProtocol();
                if (!string2.equals("http")) continue;
                String[] stringArray = new String[]{"User-Agent: Cert-J/2.0", "Content-type: application/octet-stream"};
                String[] stringArray2 = new String[]{"Content-type: application/x-crs-message"};
                PKIResult pKIResult = this.sendAndReceiveHttp(uRL, stringArray, this.proxyList, byArray, stringArray2);
                boolean bl2 = bl = (pKIResult.getStatusInfo().getFailInfo() & 0x200000) != 0;
                if (pKIResult.getStatusInfo().getStatus() == 2 && bl) continue;
                return pKIResult;
            }
            throw new PKIException("CRS$Implementation.sendMessage: Unable to connect to an auto-responder.");
        }

        public void generateProofOfPossession(PKIRequestMessage pKIRequestMessage, JSAFE_PrivateKey jSAFE_PrivateKey, POPGenerationInfo pOPGenerationInfo) throws NotSupportedException, PKIException {
            Cloneable cloneable;
            if (jSAFE_PrivateKey == null) {
                throw new PKIException("CRS$Implementation.generateProofOfPossession: privateKey cannot be null.");
            }
            int n = pKIRequestMessage.getPopType();
            if (n == -1) {
                pKIRequestMessage.setPopType(1);
            } else if (n != 1) {
                throw new PKIException("CRS$Implementation.generateProofOfPossession: POP type should be signature.");
            }
            PKCS10CertRequest pKCS10CertRequest = new PKCS10CertRequest();
            X509Certificate x509Certificate = (X509Certificate)pKIRequestMessage.getCertificateTemplate();
            Cs cs = new Cs(CRS.this);
            pKIRequestMessage.setProviderData(cs);
            try {
                Object object;
                if (x509Certificate.getVersion() == -1) {
                    pKCS10CertRequest.setVersion(0);
                }
                if (x509Certificate.getSubjectName() == null) {
                    throw new PKIException("CRS$Implementation.generateProofOfPossession: Subject name is not specified.");
                }
                pKCS10CertRequest.setSubjectName(x509Certificate.getSubjectName());
                if (x509Certificate.getSubjectPublicKey(this.certJ.getDevice()) == null) {
                    throw new PKIException("CRS$Implementation.generateProofOfPossession: No public key in template.");
                }
                pKCS10CertRequest.setSubjectPublicKey(x509Certificate.getSubjectPublicKey(this.certJ.getDevice()));
                cloneable = x509Certificate.getExtensions();
                if (cloneable != null) {
                    object = new X501Attributes();
                    ((X501Attributes)object).addAttribute(new V3ExtensionAttribute((X509V3Extensions)cloneable));
                    pKCS10CertRequest.setAttributes((X501Attributes)object);
                }
                try {
                    pKCS10CertRequest.signCertRequest("MD5/RSA/PKCS1Block01Pad", this.certJ.getDevice(), jSAFE_PrivateKey, (SecureRandom)this.certJ.getRandomObject());
                }
                catch (NoServiceException noServiceException) {
                    throw new PKIException("CRS$Implementation.generateProofOfPossession: No Random service provider available(" + noServiceException.getMessage() + ").");
                }
                catch (RandomException randomException) {
                    throw new PKIException("CRS$Implementation.generateProofOfPossession: " + randomException.getMessage());
                }
                object = new byte[pKCS10CertRequest.getDERLen(0)];
                cs.b = (byte[])object;
                pKCS10CertRequest.getDEREncoding((byte[])object, 0, 0);
            }
            catch (CertificateException certificateException) {
                throw new PKIException("CRS$Implementation.generateProofOfPossession: " + certificateException.getMessage());
            }
            cloneable = pKIRequestMessage.getSender();
            if (cloneable == null) {
                throw new PKIException("CRS$Implementation.generateProofOfPossession: Sender is not specified.");
            }
            try {
                if (((SignerInfo)cloneable).getIssuerName().equals(x509Certificate.getSubjectName()) && CertJUtils.byteArraysEqual(((SignerInfo)cloneable).getSerialNumber(), x509Certificate.getSerialNumber())) {
                    this.a(pKIRequestMessage, jSAFE_PrivateKey);
                }
            }
            catch (PKCS7Exception pKCS7Exception) {
                throw new PKIException("CRS$Implementation.generateProofOfPossession: " + pKCS7Exception.getMessage());
            }
        }

        public boolean validateProofOfPossession(PKIMessage pKIMessage, POPValidationInfo pOPValidationInfo) throws NotSupportedException, PKIException {
            throw new NotSupportedException("CRS$Implementation.validateProofOfPossession: not supported.");
        }

        public void provideProofOfPossession(PKIRequestMessage pKIRequestMessage, int n, byte[] byArray) throws PKIException {
            if (n != 1) {
                throw new PKIException("CRS$Implementation.provideProofOfPossession: Unsupported POP type(" + n + ").");
            }
            if (byArray == null || byArray.length == 0) {
                throw new PKIException("CRS$Implementation.provideProofOfPossession: POP data is empty.");
            }
            int n2 = this.a(byArray, CRS.c);
            int n3 = this.b(byArray, CRS.d);
            if (n3 < n2) {
                throw new PKIException("CRS$Implementation.provideProofOfPossession: Ill-formated POP data.");
            }
            byte[] byArray2 = this.a(byArray, n2, n3);
            try {
                new PKCS10CertRequest(byArray2, 0, 0);
            }
            catch (CertificateException certificateException) {
                throw new PKIException("CRS$Implementation.provideProofOfPossession: POP is not in PKCS10 format(" + certificateException.getMessage() + ").");
            }
            Cs cs = new Cs(CRS.this);
            cs.b = byArray2;
            pKIRequestMessage.setProviderData(cs);
        }

        private byte[] a(PKIRequestMessage pKIRequestMessage, CertPathCtx certPathCtx) throws PKIException {
            try {
                X500Name x500Name;
                SignerInfo signerInfo = pKIRequestMessage.getSender();
                Vector vector = new Vector();
                DatabaseService databaseService = certPathCtx.getDatabase();
                int n = databaseService.selectCertificateByIssuerAndSerialNumber(signerInfo.getIssuerName(), signerInfo.getSerialNumber(), vector);
                X500Name x500Name2 = n == 0 ? new X500Name() : ((X509Certificate)vector.elementAt(0)).getSubjectName();
                RecipientInfo recipientInfo = pKIRequestMessage.getRecipient();
                if (recipientInfo == null) {
                    x500Name = new X500Name();
                } else {
                    vector = new Vector();
                    n = databaseService.selectCertificateByIssuerAndSerialNumber(recipientInfo.getIssuerName(), recipientInfo.getSerialNumber(), vector);
                    x500Name = n == 0 ? new X500Name() : ((X509Certificate)vector.elementAt(0)).getSubjectName();
                }
                byte[] byArray = new byte[x500Name.getDERLen(0)];
                x500Name.getDEREncoding(byArray, 0, 0);
                byte[] byArray2 = new byte[x500Name2.getDERLen(0)];
                x500Name2.getDEREncoding(byArray2, 0, 0);
                SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
                EndContainer endContainer = new EndContainer();
                EncodedContainer encodedContainer = new EncodedContainer(0, true, 0, byArray, 0, byArray.length);
                EncodedContainer encodedContainer2 = new EncodedContainer(0, true, 0, byArray2, 0, byArray2.length);
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, encodedContainer2, endContainer};
                byte[] byArray3 = ASN1.derEncode((ASN1Container[])aSN1ContainerArray);
                return byArray3;
            }
            catch (ASN_Exception aSN_Exception) {
                throw new PKIException("CRS$Implementation.createCertInitialBodyDER: " + aSN_Exception.getMessage());
            }
            catch (CertJException certJException) {
                throw new PKIException("CRS$Implementation.createCertInitialBodyDER: " + certJException.getMessage());
            }
            catch (NameException nameException) {
                throw new PKIException("CRS$Implementation.createCertInitialBodyDER: " + nameException.getMessage());
            }
        }

        private byte[] a(byte[] byArray, Properties properties) throws PKIException {
            try {
                String string = this.urlEncodeRegInfo(properties);
                byte[] byArray2 = string.getBytes();
                OctetStringContainer octetStringContainer = new OctetStringContainer(0, true, 0, byArray2, 0, byArray2.length);
                SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
                EndContainer endContainer = new EndContainer();
                EncodedContainer encodedContainer = new EncodedContainer(0, true, 0, byArray, 0, byArray.length);
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, octetStringContainer, endContainer};
                return ASN1.derEncode((ASN1Container[])aSN1ContainerArray);
            }
            catch (ASN_Exception aSN_Exception) {
                throw new PKIException("CRS$Implementation.createCertReqBodyDER: " + aSN_Exception.getMessage());
            }
        }

        private boolean a(PKIRequestMessage pKIRequestMessage, PKIResponseMessage pKIResponseMessage) {
            Cs cs = (Cs)pKIRequestMessage.getProviderData();
            ResponseData responseData = (ResponseData)pKIResponseMessage.getProviderData();
            return CertJUtils.byteArraysEqual(cs.a, responseData.a);
        }

        private byte[] a(CertPathCtx certPathCtx, PKIRequestMessage pKIRequestMessage, ContentInfo contentInfo) throws PKIException {
            Cs cs = (Cs)pKIRequestMessage.getProviderData();
            DatabaseService databaseService = certPathCtx.getDatabase();
            X509Certificate x509Certificate = cs.c;
            if (x509Certificate != null) {
                try {
                    databaseService.insertCertificate(x509Certificate);
                    databaseService.insertPrivateKeyByCertificate(x509Certificate, cs.d);
                }
                catch (Exception exception) {
                    throw new PKIException("CRS$Implementation.signMessage: Storing EE signing key failed(" + exception.getMessage() + ").");
                }
            }
            try {
                Object object;
                CRL[] cRLArray;
                SignedData signedData = new SignedData(this.certJ, certPathCtx);
                signedData.setVersionNumber(1);
                SignerInfo signerInfo = pKIRequestMessage.getSender();
                signedData.addSignerInfo(signerInfo);
                signedData.setContentInfo(contentInfo);
                Certificate[] certificateArray = pKIRequestMessage.getExtraCerts();
                if (certificateArray != null) {
                    for (int i = 0; i < certificateArray.length; ++i) {
                        signedData.addCertificate((X509Certificate)certificateArray[i]);
                    }
                }
                if ((cRLArray = pKIRequestMessage.getExtraCRLs()) != null) {
                    for (int i = 0; i < cRLArray.length; ++i) {
                        signedData.addCRL((X509CRL)cRLArray[i]);
                    }
                }
                DatabaseService databaseService2 = certPathCtx.getDatabase();
                Vector vector = new Vector();
                int n = databaseService2.selectCertificateByIssuerAndSerialNumber(signerInfo.getIssuerName(), signerInfo.getSerialNumber(), vector);
                if (n > 0) {
                    object = (Certificate)vector.elementAt(0);
                    this.certJ.buildCertPath(certPathCtx, object, vector, null, null, null);
                    for (int i = 0; i < vector.size(); ++i) {
                        signedData.addCertificate((X509Certificate)vector.elementAt(i));
                    }
                }
                n = signedData.getContentInfoDERLen();
                object = new byte[n];
                signedData.writeMessage((byte[])object, 0);
                return object;
            }
            catch (CertJException certJException) {
                throw new PKIException("CRS$Implementation.signMessage: " + certJException.getMessage());
            }
        }

        private EnvelopedData a(CertPathCtx certPathCtx, PKIRequestMessage pKIRequestMessage, Data data) throws PKIException {
            try {
                EnvelopedData envelopedData = new EnvelopedData(this.certJ, certPathCtx);
                envelopedData.setVersionNumber(0);
                int[] nArray = pKIRequestMessage.getEncryptionParams();
                envelopedData.setEncryptionAlgorithm(pKIRequestMessage.getEncryptionName(), nArray == null ? -1 : nArray[0]);
                envelopedData.setContentInfo(data);
                envelopedData.addRecipientInfo(pKIRequestMessage.getRecipient());
                return envelopedData;
            }
            catch (PKCS7Exception pKCS7Exception) {
                throw new PKIException("CRS$Implementation.envelopeMessage: " + pKCS7Exception.getMessage());
            }
        }

        private byte[] a(Data data) throws PKIException {
            try {
                byte[] byArray = new byte[data.getContentInfoDERLen()];
                data.writeMessage(byArray, 0);
                JSAFE_MessageDigest jSAFE_MessageDigest = JSAFE_MessageDigest.getInstance((String)"MD5", (String)this.certJ.getDevice());
                byte[] byArray2 = new byte[jSAFE_MessageDigest.getDigestSize()];
                jSAFE_MessageDigest.digestInit();
                jSAFE_MessageDigest.digestUpdate(byArray, 0, byArray.length);
                jSAFE_MessageDigest.digestFinal(byArray2, 0);
                if ((byArray2[0] & 0x80) == 0) {
                    return byArray2;
                }
                byte[] byArray3 = new byte[byArray2.length + 1];
                System.arraycopy(byArray2, 0, byArray3, 1, byArray2.length);
                byArray3[0] = 0;
                return byArray3;
            }
            catch (PKCS7Exception pKCS7Exception) {
                throw new PKIException("CRS$Implementation.createTransactionID: " + pKCS7Exception.getMessage());
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                throw new PKIException("CRS$Implementation.createTransactionID: " + jSAFE_Exception.getMessage());
            }
        }

        private byte[] a() throws PKIException {
            try {
                return this.certJ.getRandomObject().generateRandomBytes(16);
            }
            catch (NoServiceException noServiceException) {
                throw new PKIException("CRS$Implementation.createNonce: No random provider available(" + noServiceException.getMessage() + ").");
            }
            catch (RandomException randomException) {
                throw new PKIException("CRS$Implementation.createNonce: " + randomException.getMessage());
            }
        }

        private PKIResponseMessage a(SignedData signedData, ProtectInfoPublicKey protectInfoPublicKey) throws PKIException {
            X501Attributes x501Attributes;
            Cloneable cloneable;
            Vector vector;
            byte[] byArray;
            int n;
            ContentInfo contentInfo = signedData.getContent();
            RecipientInfo recipientInfo = null;
            switch (contentInfo.getContentType()) {
                case 1: {
                    n = 1;
                    byArray = ((Data)contentInfo).getData();
                    break;
                }
                case 3: {
                    n = 4;
                    vector = ((EnvelopedData)contentInfo).getRecipientInfos();
                    if (vector == null || vector.size() != 1) {
                        throw new PKIException("CRS$Implementation.readSignedResponse: Only one recipient is expected.");
                    }
                    recipientInfo = (RecipientInfo)vector.elementAt(0);
                    cloneable = contentInfo.getContent();
                    if (((ContentInfo)cloneable).getContentType() != 1) {
                        throw new PKIException("CRS$Implementation.readSignedResponse: Content of EnvelopedData should be Data.");
                    }
                    byArray = ((Data)cloneable).getData();
                    break;
                }
                default: {
                    throw new PKIException("CRS$Implementation.readSignedResponse: Invalid response message foramt(" + contentInfo.getContentType() + "). Valid formats are DATA and " + "ENVELOPED_DATA.");
                }
            }
            vector = new Vector();
            cloneable = new Vector();
            this.a(byArray, protectInfoPublicKey, vector, (Vector)cloneable);
            SignerInfo signerInfo = this.a(signedData);
            try {
                x501Attributes = signerInfo.getAuthenticatedAttrs();
            }
            catch (PKCS7Exception pKCS7Exception) {
                throw new PKIException("CRS$Implementation.readSignedResponse: " + pKCS7Exception.getMessage());
            }
            int n2 = -1;
            if (x501Attributes == null) {
                throw new PKIException("CRS$Implementation.readSignedResponse: No authenticated attributes included.");
            }
            X501Attribute x501Attribute = x501Attributes.getAttributeByType(12);
            if (x501Attribute == null) {
                throw new PKIException("CRS$Implementation.readSignedResponse: Version attribute not found.");
            }
            n2 = ((VeriSignCRSVersion)x501Attribute).getVersion();
            x501Attribute = x501Attributes.getAttributeByType(6);
            if (x501Attribute == null) {
                throw new PKIException("CRS$Implementation.readSignedResponse: Message Type attribute not found.");
            }
            int n3 = ((VeriSignCRSMessageType)x501Attribute).getMessageType();
            if (n3 != 3) {
                throw new PKIException("CRS$Implementation.readSignedResponse: Message Type CertResponse (3) is expected.");
            }
            x501Attribute = x501Attributes.getAttributeByType(9);
            if (x501Attribute == null) {
                throw new PKIException("CRS$Implementation.readSignedResponse: Sender nonce attribute not found.");
            }
            byte[] byArray2 = ((VeriSignCRSSenderNonce)x501Attribute).getSenderNonce();
            x501Attribute = x501Attributes.getAttributeByType(10);
            if (x501Attribute == null) {
                throw new PKIException("CRS$Implementation.readSignedResponse: Recipient nonce attribute not found.");
            }
            byte[] byArray3 = ((VeriSignCRSRecipientNonce)x501Attribute).getRecipientNonce();
            Object[] objectArray = new Certificate[vector.size()];
            vector.copyInto(objectArray);
            Object[] objectArray2 = new CRL[((Vector)cloneable).size()];
            ((Vector)cloneable).copyInto(objectArray2);
            PKIResponseMessage pKIResponseMessage = new PKIResponseMessage(this.b(x501Attributes));
            ResponseData responseData = new ResponseData(byArray2, byArray3);
            pKIResponseMessage.setProviderData(responseData);
            pKIResponseMessage.setVersion(n2);
            pKIResponseMessage.setWrapInfo(n, signerInfo, recipientInfo, null, null);
            pKIResponseMessage.setTransactionID(this.a(x501Attributes));
            pKIResponseMessage.setExtraCerts((Certificate[])objectArray);
            pKIResponseMessage.setExtraCRLs((CRL[])objectArray2);
            return pKIResponseMessage;
        }

        private void a(PKIRequestMessage pKIRequestMessage, JSAFE_PrivateKey jSAFE_PrivateKey) throws PKIException {
            String string = "MD5/RSA/PKCS1Block01Pad";
            X509Certificate x509Certificate = (X509Certificate)pKIRequestMessage.getCertificateTemplate();
            try {
                Date date;
                if (x509Certificate.getIssuerName() == null) {
                    x509Certificate.setIssuerName(x509Certificate.getSubjectName());
                }
                long l = System.currentTimeMillis();
                Date date2 = x509Certificate.getStartDate();
                long l2 = 3600000L;
                if (date2 == null) {
                    date2 = new Date(l - 720L * l2);
                }
                if ((date = x509Certificate.getEndDate()) == null) {
                    date = new Date(l + 8760L * l2);
                }
                x509Certificate.setValidity(date2, date);
                X509Certificate x509Certificate2 = x509Certificate;
                x509Certificate2.signCertificate(string, this.certJ.getDevice(), jSAFE_PrivateKey, (SecureRandom)this.certJ.getRandomObject());
                Cs cs = (Cs)pKIRequestMessage.getProviderData();
                cs.d = jSAFE_PrivateKey;
                cs.c = x509Certificate2;
                Certificate[] certificateArray = pKIRequestMessage.getExtraCerts();
                int n = certificateArray == null ? 0 : certificateArray.length;
                Certificate[] certificateArray2 = new Certificate[n + 1];
                if (certificateArray != null) {
                    System.arraycopy(certificateArray, 0, certificateArray2, 0, n);
                }
                certificateArray2[n] = x509Certificate2;
                pKIRequestMessage.setExtraCerts(certificateArray2);
            }
            catch (CertificateException certificateException) {
                throw new PKIException("CRS$Implementation.storeSelfSignedInfo: " + certificateException.getMessage());
            }
            catch (CertJException certJException) {
                throw new PKIException("CRS$Implementation.storeSelfSignedInfo: " + certJException.getMessage());
            }
        }

        private SignerInfo a(SignedData signedData) throws PKIException {
            Vector vector = signedData.getSignerInfos();
            if (vector == null || vector.size() > 2 || vector.size() == 0) {
                throw new PKIException("CRS$Implementation.getSender: Expected exactly one signer.");
            }
            return (SignerInfo)vector.elementAt(0);
        }

        private byte[] a(X501Attributes x501Attributes) throws PKIException {
            VeriSignCRSTransactionID veriSignCRSTransactionID = (VeriSignCRSTransactionID)x501Attributes.getAttributeByType(11);
            if (veriSignCRSTransactionID == null) {
                throw new PKIException("CRS$Implementation.extractTransactionID: Transaction ID attribute not found.");
            }
            return veriSignCRSTransactionID.getTransactionID();
        }

        private PKIStatusInfo b(X501Attributes x501Attributes) throws PKIException {
            X501Attribute x501Attribute = x501Attributes.getAttributeByType(7);
            if (x501Attribute == null) {
                throw new PKIException("CRS$Implementation.extractStatusInfo: No status attribute found.");
            }
            int n = ((VeriSignCRSPKIStatus)x501Attribute).getPKIStatus();
            n = this.a(n);
            int n2 = -1;
            int n3 = -1;
            if (n == 2) {
                x501Attribute = x501Attributes.getAttributeByType(8);
                if (x501Attribute == null) {
                    throw new PKIException("CRS$Implementation.extractStatusInfo: No Failure Info attribute found.");
                }
                n2 = ((VeriSignCRSFailureInfo)x501Attribute).getFailureInfo();
                n3 = this.b(n2);
            }
            return new PKIStatusInfo(n, n3, null, n2);
        }

        private int a(int n) throws PKIException {
            switch (n) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 3;
                }
                case 2: {
                    return 2;
                }
            }
            throw new PKIException("CRS$Implementation.mapStatusInfo: Status value(" + n + ") is not valid. Valid values are 0, " + "1, and 2.");
        }

        private int b(int n) {
            if (this.profile.equals(CRS.k)) {
                for (int i = 0; i < 76; ++i) {
                    if (m[i] != n) continue;
                    return n[i];
                }
            }
            return 0x20000000;
        }

        private Properties a(byte[] byArray, ProtectInfoPublicKey protectInfoPublicKey, Vector vector, Vector vector2) throws PKIException {
            if (byArray == null || byArray.length == 0) {
                return null;
            }
            try {
                SequenceContainer sequenceContainer = new SequenceContainer(0);
                EndContainer endContainer = new EndContainer();
                EncodedContainer encodedContainer = new EncodedContainer(77824);
                OctetStringContainer octetStringContainer = new OctetStringContainer(0);
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, octetStringContainer, endContainer};
                ASN1.berDecode((byte[])byArray, (int)0, (ASN1Container[])aSN1ContainerArray);
                if (encodedContainer.dataLen != 0) {
                    int n;
                    SignedData signedData = new SignedData(this.certJ, protectInfoPublicKey.getCertPathCtx());
                    boolean bl = signedData.readInit(encodedContainer.data, encodedContainer.dataOffset, encodedContainer.dataLen);
                    if (bl) {
                        bl = signedData.readFinal();
                    }
                    if (!bl) {
                        throw new PKIException("CRS$Implementation.processResponseBody: Unable to decode degenerate PKCS7.");
                    }
                    Vector vector3 = signedData.getCertificates();
                    if (vector3 != null) {
                        for (n = 0; n < vector3.size(); ++n) {
                            vector.addElement(vector3.elementAt(n));
                        }
                    }
                    if ((vector3 = signedData.getCRLs()) != null) {
                        for (n = 0; n < vector3.size(); ++n) {
                            vector2.addElement(vector3.elementAt(n));
                        }
                    }
                }
                return this.urlDecodeRegInfo(new String(octetStringContainer.data, octetStringContainer.dataOffset, octetStringContainer.dataLen));
            }
            catch (ASN_Exception aSN_Exception) {
                throw new PKIException("CRS$Implementation.processResponseBody: Unable to decode innerDER(" + aSN_Exception.getMessage() + ").");
            }
            catch (PKCS7Exception pKCS7Exception) {
                throw new PKIException("CRS$Implementation.processResponseBody: Unable to decode degenerated PKCS7(" + pKCS7Exception.getMessage() + ").");
            }
        }

        private int a(byte[] byArray, String string) {
            int n;
            int n2 = byArray.length - string.length();
            for (n = 0; n < n2; ++n) {
                if (!this.a(byArray, n, string)) continue;
                n += string.length();
                break;
            }
            if (n == n2) {
                return 0;
            }
            if (!(byArray[n] != 13 && byArray[n] != 10 || byArray[++n] != 13 && byArray[n] != 10)) {
                ++n;
            }
            return n;
        }

        private int b(byte[] byArray, String string) {
            int n;
            int n2 = byArray.length - string.length();
            for (n = 0; n < n2 && !this.a(byArray, n, string); ++n) {
            }
            if (n == n2) {
                return byArray.length;
            }
            return n;
        }

        private boolean a(byte[] byArray, int n, String string) {
            if (byArray.length - n < string.length()) {
                return false;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (byArray[n + i] == (byte)string.charAt(i)) continue;
                return false;
            }
            return true;
        }

        private byte[] a(byte[] byArray, int n, int n2) throws PKIException {
            try {
                JSAFE_Recode jSAFE_Recode = JSAFE_Recode.getInstance((String)"Base64-76", (String)this.certJ.getDevice());
                jSAFE_Recode.decodeInit();
                int n3 = jSAFE_Recode.getOutputBufferSize(n2);
                byte[] byArray2 = new byte[n3];
                int n4 = jSAFE_Recode.decodeUpdate(byArray, n, n2, byArray2, 0);
                int n5 = jSAFE_Recode.decodeFinal(byArray2, n4);
                int n6 = n4 + n5;
                if (n6 != n3) {
                    byte[] byArray3 = new byte[n6];
                    System.arraycopy(byArray2, 0, byArray3, 0, n6);
                    return byArray3;
                }
                return byArray2;
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                throw new PKIException("CRS$Implementation.base64Decode: " + jSAFE_Exception.getMessage());
            }
        }

        public String toString() {
            return "CRS provider named: " + super.getName();
        }

        /* synthetic */ Implementation(CertJ certJ, String string, Cr cr) throws InvalidParameterException, PKIException {
            this(certJ, string);
        }
    }
}

