/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.path;

import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.AttributeValueAssertion;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.NameMatcher;
import com.rsa.certj.cert.RDN;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.AuthorityKeyID;
import com.rsa.certj.cert.extensions.BasicConstraints;
import com.rsa.certj.cert.extensions.CertPolicies;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.GeneralSubtrees;
import com.rsa.certj.cert.extensions.InhibitAnyPolicy;
import com.rsa.certj.cert.extensions.IssuerAltName;
import com.rsa.certj.cert.extensions.KeyUsage;
import com.rsa.certj.cert.extensions.NameConstraints;
import com.rsa.certj.cert.extensions.PolicyConstraints;
import com.rsa.certj.cert.extensions.PolicyMappings;
import com.rsa.certj.cert.extensions.PolicyQualifiers;
import com.rsa.certj.cert.extensions.SubjectAltName;
import com.rsa.certj.cert.extensions.SubjectKeyID;
import com.rsa.certj.cert.extensions.X509V3Extension;
import com.rsa.certj.provider.path.CertPathCommon;
import com.rsa.certj.provider.path.Cm;
import com.rsa.certj.provider.path.Cn;
import com.rsa.certj.provider.path.Co;
import com.rsa.certj.provider.path.Cp;
import com.rsa.certj.provider.path.PKIXCertPathResult;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.path.CertPathException;
import com.rsa.certj.spi.path.CertPathResult;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.security.SecureRandom;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public final class PKIXCertPath
extends Provider {
    public PKIXCertPath(String string) throws InvalidParameterException {
        super(3, string);
    }

    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            return new Implementation(certJ, this.getName(), null);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new ProviderManagementException("PKIXCertPath.instantiate: " + invalidParameterException.getMessage());
        }
    }

    private class CertPathState {
        protected Vector initialPolicySet;
        protected Cn validPolicyTree;
        protected Map constrainedSubtrees;
        protected GeneralNames excludedSubtrees;
        protected int explicitPolicy;
        protected int policyMapping;
        protected int inhibitAnyPolicy;
        protected int maxPathLen;
        protected String workingPubKeyAlg;
        protected byte[] workingPubKey;
        protected byte[][] workingPubKeyParams;

        protected CertPathState(Vector vector, Cn cn, Map map, GeneralNames generalNames, int n, int n2, int n3, int n4, String string, byte[] byArray, byte[][] byArray2) {
            this.initialPolicySet = vector;
            this.validPolicyTree = cn;
            this.constrainedSubtrees = map;
            this.excludedSubtrees = generalNames;
            this.explicitPolicy = n;
            this.policyMapping = n2;
            this.inhibitAnyPolicy = n3;
            this.maxPathLen = n4;
            this.workingPubKeyAlg = string;
            this.workingPubKey = byArray;
            this.workingPubKeyParams = byArray2;
        }
    }

    private final class Implementation
    extends CertPathCommon {
        private Implementation(CertJ certJ, String string) throws InvalidParameterException {
            super(certJ, string);
        }

        protected void getNextCertCandidates(CertPathCtx certPathCtx, Object object, Vector vector) throws CertPathException {
            X500Name x500Name = null;
            X509V3Extensions x509V3Extensions = null;
            if (object instanceof X509Certificate) {
                X509Certificate x509Certificate = (X509Certificate)object;
                x500Name = x509Certificate.getIssuerName();
                x509V3Extensions = x509Certificate.getExtensions();
            } else if (object instanceof X509CRL) {
                X509CRL x509CRL = (X509CRL)object;
                x500Name = x509CRL.getIssuerName();
                x509V3Extensions = x509CRL.getExtensions();
            } else {
                throw new CertPathException("PKIXCertPath$Implementation.getNextCertCandidates: does not support startObjects other than X509Certificate or X509CRL.");
            }
            this.a(certPathCtx, x500Name, x509V3Extensions, vector);
        }

        protected boolean verifyPath(CertPathCtx certPathCtx, Vector vector, Vector vector2, Vector vector3, Vector vector4, CertPathResult certPathResult) throws CertPathException {
            PKIXCertPathResult pKIXCertPathResult = null;
            Vector vector5 = vector2 == null ? null : new Vector();
            Vector vector6 = vector3 == null ? null : new Vector();
            int n = vector.size();
            int n2 = n - 1;
            int n3 = 0;
            X509Certificate x509Certificate = null;
            X509Certificate x509Certificate2 = (X509Certificate)vector.elementAt(n2);
            if (x509Certificate2 == null) {
                throw new CertPathException("The certificate path was not built correctly. A null certificate was found.");
            }
            CertPathState certPathState = this.a(certPathCtx, x509Certificate2, n);
            pKIXCertPathResult = certPathResult != null && certPathResult instanceof PKIXCertPathResult ? (PKIXCertPathResult)certPathResult : new PKIXCertPathResult();
            while (n2 > 0) {
                ++n3;
                if ((x509Certificate = (X509Certificate)vector.elementAt(--n2)) == null) {
                    throw new CertPathException("The certificate path was not built correctly. A null certificate was found.");
                }
                if (!this.a(certPathCtx, certPathState, x509Certificate, x509Certificate2)) {
                    pKIXCertPathResult.setValidationResult(false);
                    pKIXCertPathResult.b("Signature of certificate with subject " + x509Certificate.getSubjectName().toString() + "could not be verified!");
                    return false;
                }
                if (!this.verifyRevocation(certPathCtx, x509Certificate, vector5, vector6)) {
                    pKIXCertPathResult.setValidationResult(false);
                    pKIXCertPathResult.b("Certificate with subject " + x509Certificate.getSubjectName().toString() + " is either revoked or the revocation could not " + "be determined!");
                    return false;
                }
                if (!(n2 != 0 && this.a(x509Certificate) || this.b(certPathState, x509Certificate))) {
                    pKIXCertPathResult.setValidationResult(false);
                    pKIXCertPathResult.b("Subject/issuer name chain error!");
                    return false;
                }
                if (!this.a(certPathState, x509Certificate, n3, n - 1)) {
                    pKIXCertPathResult.setValidationResult(false);
                    pKIXCertPathResult.b("Policy info check error!");
                    return false;
                }
                if (n2 != 0 && !this.a(certPathCtx, certPathState, x509Certificate, n3, pKIXCertPathResult)) {
                    return false;
                }
                x509Certificate2 = x509Certificate;
            }
            CertJUtils.mergeLists(vector2, vector5);
            CertJUtils.mergeLists(vector3, vector6);
            if (x509Certificate == null) {
                pKIXCertPathResult.setValidationResult(true);
                pKIXCertPathResult.b("Validation completed successfully.");
                return true;
            }
            return this.a(certPathCtx, certPathState, x509Certificate, n, vector4, pKIXCertPathResult);
        }

        private boolean a(CertPathCtx certPathCtx, CertPathState certPathState, X509Certificate x509Certificate, int n, PKIXCertPathResult pKIXCertPathResult) throws CertPathException {
            if (!this.a(certPathState, x509Certificate, n)) {
                pKIXCertPathResult.setValidationResult(false);
                pKIXCertPathResult.b("Policy mapping check error!");
                return false;
            }
            this.d(certPathState, x509Certificate);
            this.b(certPathCtx, certPathState, x509Certificate);
            if (!this.a(x509Certificate)) {
                this.a(certPathState);
            }
            this.c(certPathState, x509Certificate);
            this.a(certPathState, x509Certificate);
            if (!this.a(certPathCtx, x509Certificate)) {
                pKIXCertPathResult.setValidationResult(false);
                pKIXCertPathResult.b("Basic constraints error!");
                return false;
            }
            if (!this.a(certPathCtx, certPathState, x509Certificate)) {
                pKIXCertPathResult.setValidationResult(false);
                pKIXCertPathResult.b("Max path length error!");
                return false;
            }
            if (!this.b(certPathCtx, x509Certificate)) {
                pKIXCertPathResult.setValidationResult(false);
                pKIXCertPathResult.b("Key usage error!");
                return false;
            }
            if (!this.b(certPathCtx, x509Certificate, n)) {
                pKIXCertPathResult.setValidationResult(false);
                pKIXCertPathResult.b("Other critical extensions error!");
                return false;
            }
            return true;
        }

        private boolean a(CertPathCtx certPathCtx, CertPathState certPathState, X509Certificate x509Certificate) {
            int n;
            BasicConstraints basicConstraints;
            if (certPathCtx.isFlagRaised(32)) {
                return true;
            }
            if (!this.a(x509Certificate)) {
                if (certPathState.maxPathLen <= 0) {
                    return false;
                }
                --certPathState.maxPathLen;
            }
            if ((basicConstraints = (BasicConstraints)this.a(x509Certificate, 19)) != null && (n = basicConstraints.getPathLen()) != -1 && n < certPathState.maxPathLen) {
                certPathState.maxPathLen = n;
            }
            return true;
        }

        private boolean a(CertPathCtx certPathCtx, CertPathState certPathState, X509Certificate x509Certificate, int n, Vector vector, PKIXCertPathResult pKIXCertPathResult) throws CertPathException {
            if (!this.a(x509Certificate) && certPathState.explicitPolicy > 0) {
                --certPathState.explicitPolicy;
            }
            this.c(certPathState, x509Certificate);
            this.d(certPathState, x509Certificate);
            if (!this.b(certPathCtx, x509Certificate, n - 1)) {
                pKIXCertPathResult.setValidationResult(false);
                pKIXCertPathResult.b("Other critical extensions error!");
                return false;
            }
            this.a(certPathState.validPolicyTree, certPathCtx, n - 1);
            if (certPathState.validPolicyTree != null && !certPathState.validPolicyTree.a().d()) {
                certPathState.validPolicyTree = null;
            }
            Vector vector2 = new Vector();
            this.a(certPathState.validPolicyTree, vector2);
            if (vector != null) {
                vector.addAll(vector2);
            }
            if (certPathState.explicitPolicy == 0 && certPathState.validPolicyTree == null) {
                pKIXCertPathResult.setValidationResult(false);
                pKIXCertPathResult.b("Policy info check error!");
                return false;
            }
            pKIXCertPathResult.setValidationResult(true);
            pKIXCertPathResult.b("Validation completed successfully!");
            pKIXCertPathResult.a(vector2);
            pKIXCertPathResult.a(certPathState.workingPubKey);
            pKIXCertPathResult.a(certPathState.workingPubKeyAlg);
            pKIXCertPathResult.a(certPathState.workingPubKeyParams);
            return true;
        }

        private void a(CertPathState certPathState) {
            if (certPathState.inhibitAnyPolicy > 0) {
                --certPathState.inhibitAnyPolicy;
            }
            if (certPathState.explicitPolicy > 0) {
                --certPathState.explicitPolicy;
            }
            if (certPathState.policyMapping > 0) {
                --certPathState.policyMapping;
            }
        }

        private boolean a(CertPathState certPathState, X509Certificate x509Certificate, int n) throws CertPathException {
            PolicyMappings policyMappings = (PolicyMappings)this.a(x509Certificate, 33);
            if (policyMappings == null) {
                return true;
            }
            if (!this.a(policyMappings)) {
                return false;
            }
            this.a(certPathState, policyMappings, n);
            return true;
        }

        private boolean a(PolicyMappings policyMappings) throws CertPathException {
            int n = policyMappings.getPolicyCount();
            try {
                for (int i = 0; i < n; ++i) {
                    if (!CertJUtils.byteArraysEqual(X509V3Extension.ANY_POLICY_OID, policyMappings.getIssuerDomainPolicy(i)) && !CertJUtils.byteArraysEqual(X509V3Extension.ANY_POLICY_OID, policyMappings.getSubjectDomainPolicy(i))) continue;
                    return false;
                }
            }
            catch (CertificateException certificateException) {
                throw new CertPathException(certificateException.getMessage());
            }
            return true;
        }

        private void a(CertPathState certPathState, PolicyMappings policyMappings, int n) throws CertPathException {
            int n2 = policyMappings.getPolicyCount();
            byte[] byArray = null;
            try {
                if (certPathState.policyMapping > 0) {
                    for (int i = 0; i < n2; ++i) {
                        byArray = policyMappings.getIssuerDomainPolicy(i);
                        this.a(byArray, policyMappings, certPathState, n);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        byArray = policyMappings.getIssuerDomainPolicy(i);
                        this.a(byArray, certPathState, n);
                    }
                }
            }
            catch (CertificateException certificateException) {
                throw new CertPathException(certificateException.getMessage());
            }
        }

        private void a(byte[] byArray, PolicyMappings policyMappings, CertPathState certPathState, int n) throws CertPathException {
            Object object;
            Co co;
            Vector vector = policyMappings.getSubjectDomainPolicies(byArray);
            Vector vector2 = new Vector(certPathState.validPolicyTree.b(n));
            Iterator iterator = ((AbstractList)vector2).iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                co = (Co)iterator.next();
                if (!co.b(byArray)) continue;
                object = co.f();
                ((Vector)object).clear();
                ((Vector)object).addAll(vector);
                bl = true;
            }
            if (bl) {
                return;
            }
            co = Cp.a(X509V3Extension.ANY_POLICY_OID, vector2);
            if (co != null) {
                object = co.a();
                Co co2 = Co.a(byArray, co.g(), policyMappings.getCriticality(), vector);
                ((Co)object).a(co2);
            }
        }

        private void a(byte[] byArray, CertPathState certPathState, int n) {
            Vector vector = new Vector(certPathState.validPolicyTree.b(n));
            Iterator iterator = ((AbstractList)vector).iterator();
            while (iterator.hasNext()) {
                Co co = (Co)iterator.next();
                if (!co.b(byArray)) continue;
                co.a().b(co);
            }
            certPathState.validPolicyTree.a(n - 1);
        }

        private boolean a(X509Certificate x509Certificate) {
            return x509Certificate.getIssuerName().equals(x509Certificate.getSubjectName());
        }

        private void a(CertPathState certPathState, X509Certificate x509Certificate) {
            InhibitAnyPolicy inhibitAnyPolicy = (InhibitAnyPolicy)this.a(x509Certificate, 54);
            if (inhibitAnyPolicy == null) {
                return;
            }
            if (inhibitAnyPolicy.getSkipCerts() < certPathState.inhibitAnyPolicy) {
                certPathState.inhibitAnyPolicy = inhibitAnyPolicy.getSkipCerts();
            }
        }

        private void a(Cn cn, CertPathCtx certPathCtx, int n) throws CertPathException {
            Co co;
            Object object;
            if (cn == null) {
                return;
            }
            Vector vector = new Vector(Arrays.asList(certPathCtx.getPolicies()));
            if (CertJUtils.containsByteArray(vector, X509V3Extension.ANY_POLICY_OID)) {
                return;
            }
            Vector vector2 = this.a(cn);
            Iterator iterator = ((AbstractList)vector2).iterator();
            while (iterator.hasNext()) {
                object = (Co)iterator.next();
                if (((Co)object).j() || CertJUtils.containsByteArray(vector, ((Co)object).e()) || (co = ((Co)object).a()) == null) continue;
                co.b((Co)object);
            }
            object = cn.b(n);
            co = Cp.a(X509V3Extension.ANY_POLICY_OID, (Vector)object);
            if (co == null) {
                cn.a(n - 1);
                return;
            }
            Co co2 = co.a();
            PolicyQualifiers policyQualifiers = co.g();
            Iterator iterator2 = ((AbstractList)vector).iterator();
            while (iterator2.hasNext()) {
                byte[] byArray = (byte[])iterator2.next();
                if (Cp.a(byArray, vector2) != null) continue;
                Vector<byte[]> vector3 = new Vector<byte[]>();
                vector3.add(byArray);
                Co co3 = Co.a(byArray, policyQualifiers, co.h(), vector3);
                co2.a(co3);
            }
            co2.b(co);
            cn.a(n - 1);
        }

        private Vector a(Cn cn) {
            Vector vector = new Vector();
            this.a(cn.a(), vector);
            return vector;
        }

        private void a(Co co, Vector vector) {
            Co co2 = co.a();
            if (co2 != null && co2.j()) {
                vector.add(co);
            }
            if (!co.d()) {
                return;
            }
            Iterator iterator = ((AbstractList)co.c()).iterator();
            while (iterator.hasNext()) {
                Co co3 = (Co)iterator.next();
                this.a(co3, vector);
            }
        }

        private void a(Cn cn, Vector vector) throws CertPathException {
            if (cn == null) {
                return;
            }
            if (vector == null) {
                return;
            }
            Co co = cn.a();
            this.a(co, vector, new boolean[]{false});
        }

        private void a(Co co, Vector vector, boolean[] blArray) throws CertPathException {
            if (co.j()) {
                if (!co.d()) {
                    vector.clear();
                    vector.add(co.i());
                    blArray[0] = true;
                    return;
                }
            } else if (co.a().j()) {
                vector.add(co.i());
            }
            if (!co.d()) {
                return;
            }
            Vector vector2 = co.c();
            Iterator iterator = ((AbstractList)vector2).iterator();
            while (iterator.hasNext() && !blArray[0]) {
                this.a((Co)iterator.next(), vector, blArray);
            }
        }

        private boolean b(CertPathState certPathState, X509Certificate x509Certificate) {
            X500Name x500Name = x509Certificate.getSubjectName();
            SubjectAltName subjectAltName = (SubjectAltName)this.a(x509Certificate, 17);
            if (x500Name != null && x500Name.getRDNCount() > 0) {
                GeneralName generalName = new GeneralName();
                try {
                    generalName.setGeneralName(x500Name, 5);
                }
                catch (NameException nameException) {
                    return false;
                }
                if (!this.a(certPathState, generalName)) {
                    return false;
                }
                if (!this.a(certPathState, x500Name)) {
                    return false;
                }
            } else if (subjectAltName == null) {
                return false;
            }
            if (subjectAltName != null) {
                return this.a(certPathState, subjectAltName.getGeneralNames());
            }
            return true;
        }

        private boolean a(CertPathState certPathState, X509Certificate x509Certificate, int n, int n2) throws CertPathException {
            if (certPathState.validPolicyTree == null) {
                return true;
            }
            CertPolicies certPolicies = (CertPolicies)this.a(x509Certificate, 32);
            if (certPolicies == null) {
                certPathState.validPolicyTree = null;
                return certPathState.explicitPolicy > 0;
            }
            Vector vector = certPathState.validPolicyTree.b(n - 1);
            for (int i = 0; i < certPolicies.getPoliciesCount(); ++i) {
                boolean bl;
                byte[] byArray = null;
                try {
                    byArray = certPolicies.getCertPolicyId(i);
                }
                catch (CertificateException certificateException) {
                    throw new CertPathException(certificateException.getMessage());
                }
                if (CertJUtils.byteArraysEqual(X509V3Extension.ANY_POLICY_OID, byArray) || (bl = this.a(byArray, certPolicies, i, vector))) continue;
                this.b(byArray, certPolicies, i, vector);
            }
            this.a(certPathState, certPolicies, vector, n, n2, this.a(x509Certificate));
            Vector vector2 = certPathState.validPolicyTree.b(n);
            if (vector2.size() == 0) {
                certPathState.validPolicyTree = null;
            } else {
                certPathState.validPolicyTree.a(n - 1);
            }
            return certPathState.validPolicyTree != null || certPathState.explicitPolicy != 0;
        }

        private boolean a(byte[] byArray, CertPolicies certPolicies, int n, Vector vector) throws CertPathException {
            Iterator iterator = ((AbstractList)vector).iterator();
            boolean bl = certPolicies.getCriticality();
            while (iterator.hasNext()) {
                Co co = (Co)iterator.next();
                if (!CertJUtils.containsByteArray(co.f(), byArray)) continue;
                Vector<byte[]> vector2 = new Vector<byte[]>();
                vector2.add(byArray);
                try {
                    Co co2 = Co.a(byArray, certPolicies.getPolicyQualifiers(n), bl, vector2);
                    co.a(co2);
                }
                catch (CertificateException certificateException) {
                    throw new CertPathException(certificateException.getMessage());
                }
                return true;
            }
            return false;
        }

        private void b(byte[] byArray, CertPolicies certPolicies, int n, Vector vector) throws CertPathException {
            Iterator iterator = ((AbstractList)vector).iterator();
            while (iterator.hasNext()) {
                Co co = (Co)iterator.next();
                if (!co.j()) continue;
                Vector<byte[]> vector2 = new Vector<byte[]>();
                vector2.add(byArray);
                try {
                    Co co2 = Co.a(byArray, certPolicies.getPolicyQualifiers(n), certPolicies.getCriticality(), vector2);
                    co.a(co2);
                    break;
                }
                catch (CertificateException certificateException) {
                    throw new CertPathException(certificateException.getMessage());
                }
            }
        }

        private void a(CertPathState certPathState, CertPolicies certPolicies, Vector vector, int n, int n2, boolean bl) throws CertPathException {
            Object object;
            int n3 = -1;
            try {
                for (int i = 0; i < certPolicies.getPoliciesCount(); ++i) {
                    object = certPolicies.getCertPolicyId(i);
                    if (!CertJUtils.byteArraysEqual(object, X509V3Extension.ANY_POLICY_OID)) continue;
                    n3 = i;
                    break;
                }
            }
            catch (CertificateException certificateException) {
                throw new CertPathException(certificateException.getMessage());
            }
            if (n3 >= 0 && (certPathState.inhibitAnyPolicy > 0 || bl && n < n2)) {
                PolicyQualifiers policyQualifiers = null;
                try {
                    policyQualifiers = certPolicies.getPolicyQualifiers(n3);
                }
                catch (CertificateException certificateException) {
                    throw new CertPathException(certificateException.getMessage());
                }
                object = ((AbstractList)vector).iterator();
                boolean bl2 = certPolicies.getCriticality();
                while (object.hasNext()) {
                    Co co = (Co)object.next();
                    Iterator iterator = ((AbstractList)co.f()).iterator();
                    while (iterator.hasNext()) {
                        byte[] byArray = (byte[])iterator.next();
                        if (co.a(byArray) != null) continue;
                        Vector<byte[]> vector2 = new Vector<byte[]>();
                        vector2.add(byArray);
                        Co co2 = Co.a(byArray, policyQualifiers, bl2, vector2);
                        co.a(co2);
                    }
                }
            }
        }

        private X509V3Extension a(X509Certificate x509Certificate, int n) {
            X509V3Extension x509V3Extension = null;
            X509V3Extensions x509V3Extensions = x509Certificate.getExtensions();
            if (x509V3Extensions != null) {
                try {
                    x509V3Extension = x509V3Extensions.getExtensionByType(n);
                }
                catch (CertificateException certificateException) {
                    // empty catch block
                }
            }
            return x509V3Extension;
        }

        private boolean b(CertPathCtx certPathCtx, X509Certificate x509Certificate, int n) {
            X509V3Extensions x509V3Extensions = x509Certificate.getExtensions();
            if (x509V3Extensions == null) {
                return true;
            }
            if (certPathCtx.isFlagRaised(128)) {
                return true;
            }
            block5: for (int i = 0; i < x509V3Extensions.getExtensionCount(); ++i) {
                X509V3Extension x509V3Extension = null;
                try {
                    x509V3Extension = x509V3Extensions.getExtensionByIndex(i);
                }
                catch (CertificateException certificateException) {
                    return false;
                }
                if (!x509V3Extension.getCriticality()) break;
                switch (x509V3Extension.getExtensionType()) {
                    case 9: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 35: 
                    case 36: 
                    case 37: {
                        continue block5;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return true;
        }

        private boolean a(CertPathCtx certPathCtx, X509Certificate x509Certificate) {
            if (certPathCtx.isFlagRaised(32)) {
                return true;
            }
            BasicConstraints basicConstraints = (BasicConstraints)this.a(x509Certificate, 19);
            if (basicConstraints == null) {
                return false;
            }
            return basicConstraints.getCA();
        }

        private void b(CertPathCtx certPathCtx, CertPathState certPathState, X509Certificate x509Certificate) {
            if (certPathCtx.isFlagRaised(16)) {
                return;
            }
            NameConstraints nameConstraints = (NameConstraints)this.a(x509Certificate, 30);
            if (nameConstraints == null) {
                return;
            }
            GeneralSubtrees generalSubtrees = nameConstraints.getPermittedSubtrees();
            this.a(certPathState.constrainedSubtrees, generalSubtrees);
            this.a(certPathState.excludedSubtrees, nameConstraints.getExcludedSubtrees());
        }

        private void c(CertPathState certPathState, X509Certificate x509Certificate) {
            PolicyConstraints policyConstraints = (PolicyConstraints)this.a(x509Certificate, 36);
            if (policyConstraints == null) {
                return;
            }
            int n = policyConstraints.getExplicitPolicy();
            int n2 = policyConstraints.getPolicyMapping();
            if (n != -1 && n < certPathState.explicitPolicy) {
                certPathState.explicitPolicy = n;
            }
            if (n2 != -1 && n2 < certPathState.policyMapping) {
                certPathState.policyMapping = n2;
            }
        }

        private boolean b(CertPathCtx certPathCtx, X509Certificate x509Certificate) {
            if (certPathCtx.isFlagRaised(64)) {
                return true;
            }
            KeyUsage keyUsage = (KeyUsage)this.a(x509Certificate, 15);
            if (keyUsage == null) {
                return true;
            }
            return (keyUsage.getKeyUsage() & 0x4000000) != 0;
        }

        private boolean a(CertPathState certPathState, GeneralNames generalNames) {
            try {
                for (int i = 0; i < generalNames.getNameCount(); ++i) {
                    if (this.a(certPathState, generalNames.getGeneralName(i))) continue;
                    return false;
                }
                return true;
            }
            catch (NameException nameException) {
                return false;
            }
        }

        private boolean a(CertPathState certPathState, GeneralName generalName) {
            try {
                if (generalName.getDERLen(0) == 0) {
                    return true;
                }
            }
            catch (NameException nameException) {
                throw new IllegalStateException("Internal errror!");
            }
            int n = generalName.getGeneralNameType();
            try {
                int n2;
                GeneralNames generalNames = (GeneralNames)certPathState.constrainedSubtrees.get(new Integer(n));
                if (generalNames != null) {
                    n2 = 0;
                    for (int i = 0; i < generalNames.getNameCount(); ++i) {
                        GeneralName generalName2 = generalNames.getGeneralName(i);
                        if (!NameMatcher.matchGeneralNames(generalName, generalName2, n)) continue;
                        n2 = 1;
                        break;
                    }
                    if (n2 == 0) {
                        return false;
                    }
                }
                for (n2 = 0; n2 < certPathState.excludedSubtrees.getNameCount(); ++n2) {
                    GeneralName generalName3 = certPathState.excludedSubtrees.getGeneralName(n2);
                    if (n != generalName3.getGeneralNameType() || !NameMatcher.matchGeneralNames(generalName, generalName3, n)) continue;
                    return false;
                }
                return true;
            }
            catch (NameException nameException) {
                return false;
            }
        }

        private boolean a(CertPathState certPathState, X500Name x500Name) {
            for (int i = 0; i < x500Name.getRDNCount(); ++i) {
                try {
                    int n;
                    RDN rDN = x500Name.getRDN(i);
                    AttributeValueAssertion attributeValueAssertion = rDN.getAttribute(7);
                    if (attributeValueAssertion == null) continue;
                    String string = attributeValueAssertion.getStringAttribute();
                    GeneralNames generalNames = (GeneralNames)certPathState.constrainedSubtrees.get(new Integer(2));
                    if (generalNames != null) {
                        n = 0;
                        for (int j = 0; j < generalNames.getNameCount(); ++j) {
                            GeneralName generalName = generalNames.getGeneralName(j);
                            if (!NameMatcher.matchRfc822Names(string, (String)generalName.getGeneralName())) continue;
                            n = 1;
                            break;
                        }
                        if (n == 0) {
                            return false;
                        }
                    }
                    for (n = 0; n < certPathState.excludedSubtrees.getNameCount(); ++n) {
                        GeneralName generalName = certPathState.excludedSubtrees.getGeneralName(n);
                        if (generalName.getGeneralNameType() != 2 || !NameMatcher.matchRfc822Names(string, (String)generalName.getGeneralName())) continue;
                        return false;
                    }
                    continue;
                }
                catch (NameException nameException) {
                    // empty catch block
                }
            }
            return true;
        }

        private void a(Map map, GeneralSubtrees generalSubtrees) {
            HashMap hashMap = new HashMap(map);
            Object object = hashMap.keySet().iterator();
            while (object.hasNext()) {
                map.put(object.next(), new GeneralNames());
            }
            object = new HashSet();
            try {
                for (int i = 0; i < generalSubtrees.getSubtreeCount(); ++i) {
                    GeneralName generalName = generalSubtrees.getBase(i);
                    Integer n = new Integer(generalName.getGeneralNameType());
                    GeneralNames generalNames = (GeneralNames)hashMap.get(n);
                    GeneralNames generalNames2 = (GeneralNames)map.get(n);
                    if (generalNames == null) {
                        if (generalNames2 == null) {
                            generalNames2 = new GeneralNames();
                            map.put(n, generalNames2);
                        }
                        generalNames2.addGeneralName(generalName);
                        continue;
                    }
                    object.add(n);
                    block9: for (int j = generalNames.getNameCount() - 1; j >= 0; --j) {
                        GeneralName generalName2 = generalNames.getGeneralName(j);
                        switch (NameMatcher.compareAltNames(generalName2, generalName)) {
                            case 1: 
                            case 2: {
                                generalNames2.addGeneralName(generalName2);
                                continue block9;
                            }
                            case 3: {
                                generalNames2.addGeneralName(generalName);
                                continue block9;
                            }
                            case 0: {
                                continue block9;
                            }
                        }
                    }
                }
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    hashMap.remove(iterator.next());
                }
                map.putAll(hashMap);
            }
            catch (NameException nameException) {
                throw new IllegalStateException("Internal error!");
            }
        }

        private void a(GeneralNames generalNames, GeneralSubtrees generalSubtrees) {
            try {
                for (int i = 0; i < generalSubtrees.getSubtreeCount(); ++i) {
                    GeneralName generalName = null;
                    try {
                        generalName = generalSubtrees.getBase(i);
                    }
                    catch (NameException nameException) {
                        return;
                    }
                    boolean bl = false;
                    block10: for (int j = generalNames.getNameCount() - 1; j >= 0; --j) {
                        GeneralName generalName2 = generalNames.getGeneralName(j);
                        if (generalName.getGeneralNameType() != generalName2.getGeneralNameType()) continue;
                        switch (NameMatcher.compareAltNames(generalName2, generalName)) {
                            case 1: 
                            case 3: {
                                bl = true;
                                continue block10;
                            }
                            case 2: {
                                bl = true;
                                Vector vector = generalNames.getGeneralNames();
                                vector.setElementAt(generalName, j);
                                continue block10;
                            }
                            case 0: {
                                continue block10;
                            }
                        }
                    }
                    if (bl) continue;
                    generalNames.addGeneralName(generalName);
                }
            }
            catch (NameException nameException) {
                // empty catch block
            }
        }

        private void a(CertPathCtx certPathCtx, X500Name x500Name, X509V3Extensions x509V3Extensions, Vector vector) throws CertPathException {
            if ((certPathCtx.getPathOptions() & 0x200) != 0) {
                this.findCertBySubject(certPathCtx, x500Name, vector);
                return;
            }
            AuthorityKeyID authorityKeyID = null;
            try {
                if (x509V3Extensions != null) {
                    authorityKeyID = (AuthorityKeyID)x509V3Extensions.getExtensionByType(35);
                }
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
            if (authorityKeyID != null) {
                this.a(certPathCtx, x500Name, authorityKeyID, vector);
            } else {
                this.findCertBySubject(certPathCtx, x500Name, vector);
            }
        }

        private void a(CertPathCtx certPathCtx, X500Name x500Name, AuthorityKeyID authorityKeyID, Vector vector) throws CertPathException {
            byte[] byArray = authorityKeyID.getKeyID();
            if (byArray != null) {
                this.a(certPathCtx, x500Name, byArray, vector);
            } else {
                this.a(certPathCtx, authorityKeyID, vector);
            }
        }

        private void a(CertPathCtx certPathCtx, X500Name x500Name, byte[] byArray, Vector vector) throws CertPathException {
            Vector vector2 = new Vector();
            this.findCertBySubject(certPathCtx, x500Name, vector2);
            X509V3Extensions x509V3Extensions = null;
            int n = vector2.size();
            while (n > 0) {
                X509Certificate x509Certificate;
                if ((x509V3Extensions = (x509Certificate = (X509Certificate)vector2.elementAt(--n)).getExtensions()) == null) {
                    vector2.removeElementAt(n);
                    continue;
                }
                SubjectKeyID subjectKeyID = null;
                try {
                    subjectKeyID = (SubjectKeyID)x509V3Extensions.getExtensionByType(14);
                }
                catch (CertificateException certificateException) {
                    // empty catch block
                }
                if (subjectKeyID == null) {
                    vector2.removeElementAt(n);
                    continue;
                }
                if (CertJUtils.byteArraysEqual(byArray, subjectKeyID.getKeyID())) continue;
                vector2.removeElementAt(n);
            }
            CertJUtils.mergeLists(vector, vector2);
        }

        private void a(CertPathCtx certPathCtx, AuthorityKeyID authorityKeyID, Vector vector) throws CertPathException {
            byte[] byArray = authorityKeyID.getSerialNumber();
            if (byArray.length == 0) {
                return;
            }
            GeneralNames generalNames = authorityKeyID.getAuthorityCertIssuer();
            if (generalNames == null) {
                return;
            }
            try {
                for (int i = 0; i < generalNames.getNameCount(); ++i) {
                    GeneralName generalName = generalNames.getGeneralName(i);
                    if (generalName.getGeneralNameType() == 5) {
                        this.b(certPathCtx, (X500Name)generalName.getGeneralName(), byArray, vector);
                        continue;
                    }
                    this.a(certPathCtx, generalName, byArray, vector);
                }
            }
            catch (NameException nameException) {
                // empty catch block
            }
        }

        private void a(CertPathCtx certPathCtx, GeneralName generalName, byte[] byArray, Vector vector) throws CertPathException {
            X509V3Extensions x509V3Extensions;
            Cloneable cloneable;
            GeneralNames generalNames = new GeneralNames();
            generalNames.addGeneralName(generalName);
            try {
                cloneable = new IssuerAltName(generalNames, false);
                x509V3Extensions = new X509V3Extensions(1);
                x509V3Extensions.addV3Extension((X509V3Extension)cloneable);
            }
            catch (CertificateException certificateException) {
                return;
            }
            cloneable = new Vector();
            this.b(certPathCtx, null, x509V3Extensions, (Vector)cloneable);
            int n = ((Vector)cloneable).size();
            while (n > 0) {
                X509Certificate x509Certificate;
                if (CertJUtils.byteArraysEqual(byArray, (x509Certificate = (X509Certificate)((Vector)cloneable).elementAt(--n)).getSerialNumber())) continue;
                ((Vector)cloneable).removeElementAt(n);
            }
            CertJUtils.mergeLists(vector, (Vector)cloneable);
        }

        private void b(CertPathCtx certPathCtx, X500Name x500Name, byte[] byArray, Vector vector) throws CertPathException {
            Certificate[] certificateArray = certPathCtx.getTrustedCerts();
            if (certificateArray != null) {
                for (int i = 0; i < certificateArray.length; ++i) {
                    X509Certificate x509Certificate;
                    Certificate certificate = certificateArray[i];
                    if (!(certificate instanceof X509Certificate) || !x500Name.equals((x509Certificate = (X509Certificate)certificate).getIssuerName()) || !CertJUtils.byteArraysEqual(byArray, x509Certificate.getSerialNumber())) continue;
                    if (!vector.contains(x509Certificate)) {
                        vector.addElement(x509Certificate);
                    }
                    return;
                }
            }
            try {
                certPathCtx.getDatabase().selectCertificateByIssuerAndSerialNumber(x500Name, byArray, vector);
            }
            catch (NoServiceException noServiceException) {
                throw new CertPathException("PKIXCertPath$Implementation.findCertByIssuerAndSerial: " + noServiceException.getMessage());
            }
            catch (DatabaseException databaseException) {
                throw new CertPathException("PKIXCertPath$Implementation.findCertByIssuerAndSerial: " + databaseException.getMessage());
            }
        }

        private void b(CertPathCtx certPathCtx, X500Name x500Name, X509V3Extensions x509V3Extensions, Vector vector) throws CertPathException {
            Certificate[] certificateArray = certPathCtx.getTrustedCerts();
            if (certificateArray != null) {
                for (int i = 0; i < certificateArray.length; ++i) {
                    Certificate certificate = certificateArray[i];
                    if (!(certificate instanceof X509Certificate)) continue;
                    X509Certificate x509Certificate = (X509Certificate)certificate;
                    if (x500Name != null && !x509Certificate.getSubjectName().contains(x500Name) || !CertJUtils.compareExtensions(x509V3Extensions, x509Certificate.getExtensions()) || vector.contains(x509Certificate)) continue;
                    vector.addElement(x509Certificate);
                }
            }
            try {
                certPathCtx.getDatabase().selectCertificateByExtensions(x500Name, x509V3Extensions, vector);
            }
            catch (NoServiceException noServiceException) {
                throw new CertPathException("PKIXCertPath$Implementation.findCertByExtension: " + noServiceException.getMessage());
            }
            catch (DatabaseException databaseException) {
                throw new CertPathException("PKIXCertPath$Implementation.findCertByExtension: " + databaseException.getMessage());
            }
        }

        private Vector a(byte[][] byArray) {
            Vector<byte[]> vector = new Vector<byte[]>();
            if (byArray == null) {
                return vector;
            }
            for (int i = 0; i < byArray.length; ++i) {
                byte[] byArray2 = byArray[i];
                if (CertJUtils.containsByteArray(vector, byArray2)) continue;
                vector.addElement(byArray2);
            }
            return vector;
        }

        public String toString() {
            return "PKIX Certification Path provider named: " + super.getName();
        }

        private JSAFE_PublicKey a(Object object, X509Certificate x509Certificate) throws CertificateException {
            CertPathState certPathState = (CertPathState)object;
            if (!"DSA".equals(certPathState.workingPubKeyAlg) || certPathState.workingPubKeyParams == null) {
                return x509Certificate.getSubjectPublicKey(this.certJ.getDevice());
            }
            JSAFE_PublicKey jSAFE_PublicKey = null;
            try {
                jSAFE_PublicKey = JSAFE_PublicKey.getInstance((String)certPathState.workingPubKeyAlg, (String)this.certJ.getDevice());
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                throw new CertificateException(jSAFE_Exception.getMessage());
            }
            int n = certPathState.workingPubKeyParams.length;
            byte[][] byArrayArray = new byte[n + 1][];
            System.arraycopy(certPathState.workingPubKeyParams, 0, byArrayArray, 0, n);
            byArrayArray[n] = certPathState.workingPubKey;
            try {
                jSAFE_PublicKey.setKeyData((byte[][])byArrayArray);
            }
            catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
                throw new CertificateException(jSAFE_InvalidKeyException.getMessage());
            }
            return jSAFE_PublicKey;
        }

        protected void getNextCertInPathInternal(CertPathCtx certPathCtx, Object object, Vector vector) throws CertPathException {
            Vector vector2 = new Vector();
            this.getNextCertCandidates(certPathCtx, object, vector2);
            CertJUtils.mergeLists(vector, vector2);
        }

        private void d(CertPathState certPathState, X509Certificate x509Certificate) throws CertPathException {
            JSAFE_PublicKey jSAFE_PublicKey = null;
            try {
                jSAFE_PublicKey = x509Certificate.getSubjectPublicKey(this.certJ.getDevice());
            }
            catch (CertificateException certificateException) {
                throw new CertPathException(certificateException.getMessage());
            }
            if (!"DSA".equals(jSAFE_PublicKey.getAlgorithm())) {
                certPathState.workingPubKeyAlg = jSAFE_PublicKey.getAlgorithm();
                certPathState.workingPubKey = null;
                certPathState.workingPubKeyParams = null;
                return;
            }
            byte[][] byArray = null;
            try {
                byArray = jSAFE_PublicKey.getKeyData("DSAPublicValue");
            }
            catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
                throw new CertPathException(jSAFE_UnimplementedException.getMessage());
            }
            if (byArray.length == 0) {
                throw new CertPathException("Could not retrieve DSA public key form certificate!");
            }
            certPathState.workingPubKey = byArray[0];
            byArray = jSAFE_PublicKey.getKeyData();
            if (byArray.length == 0) {
                if (!"DSA".equals(certPathState.workingPubKeyAlg)) {
                    certPathState.workingPubKeyAlg = "DSA";
                    certPathState.workingPubKeyParams = null;
                }
                return;
            }
            if (certPathState.workingPubKeyParams == null) {
                certPathState.workingPubKeyParams = new byte[byArray.length - 1][];
            }
            System.arraycopy(byArray, 0, certPathState.workingPubKeyParams, 0, byArray.length - 1);
            certPathState.workingPubKeyAlg = "DSA";
        }

        private boolean a(CertPathCtx certPathCtx, CertPathState certPathState, X509Certificate x509Certificate, X509Certificate x509Certificate2) throws CertPathException {
            if (certPathCtx.isFlagRaised(1)) {
                return true;
            }
            try {
                JSAFE_PublicKey jSAFE_PublicKey = this.a((Object)certPathState, x509Certificate2);
                return x509Certificate.verifyCertificateSignature(this.certJ.getDevice(), jSAFE_PublicKey, (SecureRandom)this.certJ.getRandomObject());
            }
            catch (NoServiceException noServiceException) {
                throw new CertPathException("CertPathCommon.verifyCertSignature:" + noServiceException.getMessage());
            }
            catch (Exception exception) {
                return false;
            }
        }

        CertPathState a(CertPathCtx certPathCtx, X509Certificate x509Certificate, int n) throws CertPathException {
            Object object;
            byte[][] byArray = certPathCtx.getPolicies();
            Vector vector = null;
            int n2 = n + 1;
            int n3 = n + 1;
            int n4 = n + 1;
            String string = null;
            byte[] byArray2 = null;
            Object object2 = null;
            if (byArray != null) {
                vector = this.a(byArray);
            }
            if (certPathCtx.isFlagRaised(65536)) {
                n2 = 0;
            }
            if (certPathCtx.isFlagRaised(32768)) {
                n3 = 0;
            }
            if (certPathCtx.isFlagRaised(131072)) {
                n4 = 0;
            }
            JSAFE_PublicKey jSAFE_PublicKey = null;
            try {
                jSAFE_PublicKey = x509Certificate.getSubjectPublicKey(this.certJ.getDevice());
            }
            catch (CertificateException certificateException) {
                throw new CertPathException(certificateException.getMessage());
            }
            string = jSAFE_PublicKey.getAlgorithm();
            if ("DSA".equals(string)) {
                object = jSAFE_PublicKey.getKeyData();
                if (((byte[][])object).length == 0) {
                    throw new CertPathException("Anchor certificate must have valid public key parameters in subjectPublicKeyInfo!");
                }
                object2 = new byte[((byte[][])object).length - 1][];
                System.arraycopy(object, 0, object2, 0, ((byte[][])object).length - 1);
                byArray2 = object[((byte[][])object).length - 1];
            }
            object = new Cn();
            GeneralNames generalNames = new GeneralNames();
            HashMap hashMap = new HashMap();
            return new CertPathState(vector, (Cn)object, hashMap, generalNames, n3, n2, n4, n, string, byArray2, (byte[][])object2);
        }

        protected CertPathResult createCertPathResult() {
            return new PKIXCertPathResult();
        }

        /* synthetic */ Implementation(CertJ certJ, String string, Cm cm) throws InvalidParameterException {
            this(certJ, string);
        }
    }
}

