/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.path;

import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.provider.revocation.CRLEvidence;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.path.CertPathException;
import com.rsa.certj.spi.path.CertPathInterface;
import com.rsa.certj.spi.path.CertPathResult;
import com.rsa.certj.spi.revocation.CertRevocationInfo;
import com.rsa.certj.spi.revocation.CertStatusException;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Vector;

public abstract class CertPathCommonImplementation
extends ProviderImplementation
implements CertPathInterface {
    private CertPathCtx a;
    private int b;
    protected Vector trustedCerts;
    private Vector c;
    private Date d;
    private DatabaseService e;

    public CertPathCommonImplementation(CertJ certJ, String string) throws InvalidParameterException {
        super(certJ, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean buildCertPath(CertPathCtx certPathCtx, Object object, Vector vector, Vector vector2, Vector vector3, Vector vector4) throws NotSupportedException, CertPathException {
        this.a(certPathCtx);
        if (vector2 == null && vector3 != null) {
            vector3 = null;
        }
        Vector vector5 = new Vector();
        if (object instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)object;
            if (!this.a(x509Certificate)) {
                if (!this.trustedCerts.contains(x509Certificate)) return false;
                if (vector == null) return true;
                if (!vector.contains(x509Certificate)) {
                    vector.addElement(x509Certificate);
                    return true;
                }
            }
            if (!this.a(x509Certificate, vector5, vector2, vector3, vector4)) {
                return false;
            }
        } else {
            if (!(object instanceof X509CRL)) throw new NotSupportedException("CertPathCommonImplementation.buildCertPath: does not support startObjects other than X509Certificate or X509CRL.");
            if (!this.a((X509CRL)object, vector5, vector2, vector3, vector4)) {
                return false;
            }
        }
        CertJUtils.mergeLists(vector, vector5);
        CertJUtils.subtractLists(vector3, vector);
        return true;
    }

    public void getNextCertInPath(CertPathCtx certPathCtx, Object object, Vector vector) throws NotSupportedException, CertPathException {
        if (!(object instanceof X509Certificate) && !(object instanceof X509CRL)) {
            throw new NotSupportedException("CertPathCommonImplementation.getNextCertInPath: does not support startObjects other than X509Certificate or X509CRL.");
        }
        this.a(certPathCtx);
        this.a(object, vector);
    }

    private void a(Object object, Vector vector) throws CertPathException {
        Vector vector2 = new Vector();
        this.getNextCertCandidates(object, vector2);
        this.b(object, vector2);
        CertJUtils.mergeLists(vector, vector2);
    }

    public boolean validateCertificate(CertPathCtx certPathCtx, Certificate certificate, JSAFE_PublicKey jSAFE_PublicKey) throws NotSupportedException, CertPathException {
        this.a(certPathCtx);
        if (!(certificate instanceof X509Certificate)) {
            throw new NotSupportedException("CertPathCommonImplementation.validateCertificate: does not support certificate types other than X509Certificate.");
        }
        if (!this.a((X509Certificate)certificate)) {
            return false;
        }
        if ((this.b & 1) != 0) {
            return true;
        }
        try {
            return certificate.verifyCertificateSignature(this.certJ.getDevice(), jSAFE_PublicKey, (SecureRandom)this.certJ.getRandomObject());
        }
        catch (NoServiceException noServiceException) {
            throw new CertPathException("CertPathCommonImplementation.validateCertificate: (no random service is registerd)" + noServiceException.getMessage());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int getPathOptions() {
        return this.b;
    }

    public Vector getPolicies() {
        return this.c;
    }

    public DatabaseService getDatabase() {
        return this.e;
    }

    private boolean a(X509Certificate x509Certificate, Vector vector, Vector vector2, Vector vector3, Vector vector4) throws CertPathException {
        if (vector.contains(x509Certificate)) {
            return false;
        }
        vector.addElement(x509Certificate);
        if (this.trustedCerts.contains(x509Certificate)) {
            if (this.verifyPath(vector, vector2, vector3, vector4)) {
                return true;
            }
            vector.removeElement(x509Certificate);
            return false;
        }
        Vector vector5 = new Vector();
        this.a((Object)x509Certificate, vector5);
        for (int i = 0; i < vector5.size(); ++i) {
            X509Certificate x509Certificate2 = (X509Certificate)vector5.elementAt(i);
            if (!this.a(x509Certificate2, vector, vector2, vector3, vector4)) continue;
            return true;
        }
        vector.removeElement(x509Certificate);
        return false;
    }

    private boolean a(X509CRL x509CRL, Vector vector, Vector vector2, Vector vector3, Vector vector4) throws CertPathException {
        Vector vector5 = new Vector();
        this.a((Object)x509CRL, vector5);
        for (int i = 0; i < vector5.size(); ++i) {
            X509Certificate x509Certificate = (X509Certificate)vector5.elementAt(i);
            if (!this.a(x509Certificate, vector, vector2, vector3, vector4)) continue;
            return true;
        }
        return false;
    }

    public void getNextCertCandidates(Object object, Vector vector) throws CertPathException {
        throw new CertPathException("CertPathCommonImplementatin.getNextCertCandidates: subclass should override this method.");
    }

    public boolean verifyPath(Vector vector, Vector vector2, Vector vector3, Vector vector4) throws CertPathException {
        throw new CertPathException("CertPathCommonImplementation.verifyPath: subclass should overrides this method.");
    }

    public boolean verifyRevocation(X509Certificate x509Certificate, Vector vector, Vector vector2) throws CertPathException {
        CRL cRL;
        if ((this.b & 4) != 0) {
            return true;
        }
        CertRevocationInfo certRevocationInfo = null;
        try {
            certRevocationInfo = this.certJ.checkCertRevocation(this.a, x509Certificate);
        }
        catch (NoServiceException noServiceException) {
            throw new CertPathException("CertPathCommonImplementation.verifyRevocation: (no Certificate Status Service is registered)" + noServiceException.getMessage());
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new CertPathException("CertPathCommonImplementation.verifyRevocation: (checkCertRevocation parameters)" + invalidParameterException.getMessage());
        }
        catch (CertStatusException certStatusException) {
            throw new CertPathException("CertPathCommonImplementation.verifyRevocation: " + certStatusException.getMessage());
        }
        if (certRevocationInfo.getStatus() != 0) {
            return false;
        }
        if (certRevocationInfo.getType() != 1) {
            return true;
        }
        CRLEvidence cRLEvidence = (CRLEvidence)certRevocationInfo.getEvidence();
        if (vector != null && !vector.contains(cRL = cRLEvidence.getCRL())) {
            vector.addElement(cRL);
        }
        CertJUtils.mergeLists(vector, cRLEvidence.getCRLList());
        CertJUtils.mergeLists(vector2, cRLEvidence.getCertList());
        return true;
    }

    private void b(Object object, Vector vector) throws CertPathException {
        int n = vector.size();
        while (n > 0) {
            X509Certificate x509Certificate = (X509Certificate)vector.elementAt(--n);
            if (object instanceof X509Certificate) {
                if (!this.a((X509Certificate)object, x509Certificate)) {
                    vector.removeElementAt(n);
                }
            } else if (!this.a((X509CRL)object, x509Certificate)) {
                vector.removeElementAt(n);
            }
            if (this.a(x509Certificate)) continue;
            vector.removeElementAt(n);
        }
    }

    private boolean a(X509Certificate x509Certificate, X509Certificate x509Certificate2) throws CertPathException {
        if ((this.b & 1) != 0) {
            return true;
        }
        try {
            JSAFE_PublicKey jSAFE_PublicKey = x509Certificate2.getSubjectPublicKey(this.certJ.getDevice());
            return x509Certificate.verifyCertificateSignature(this.certJ.getDevice(), jSAFE_PublicKey, (SecureRandom)this.certJ.getRandomObject());
        }
        catch (NoServiceException noServiceException) {
            throw new CertPathException("CertPathCommonImplementation.verifyCertSignature:" + noServiceException.getMessage());
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean a(X509CRL x509CRL, X509Certificate x509Certificate) throws CertPathException {
        if ((this.b & 1) != 0) {
            return true;
        }
        String string = this.certJ.getDevice();
        try {
            JSAFE_PublicKey jSAFE_PublicKey = x509Certificate.getSubjectPublicKey(string);
            return x509CRL.verifyCRLSignature(string, jSAFE_PublicKey, (SecureRandom)this.certJ.getRandomObject());
        }
        catch (NoServiceException noServiceException) {
            throw new CertPathException("CertPathCommonImplementation.verifyCrlSignature:" + noServiceException.getMessage());
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean a(X509Certificate x509Certificate) {
        if ((this.b & 2) != 0) {
            return true;
        }
        return !this.d.before(x509Certificate.getStartDate()) && !this.d.after(x509Certificate.getEndDate());
    }

    private void a(CertPathCtx certPathCtx) {
        byte[][] byArray;
        this.a = certPathCtx;
        this.b = certPathCtx.getPathOptions();
        this.trustedCerts = new Vector();
        Certificate[] certificateArray = certPathCtx.getTrustedCerts();
        if (certificateArray != null) {
            for (int i = 0; i < certificateArray.length; ++i) {
                this.trustedCerts.addElement(certificateArray[i]);
            }
        }
        if ((byArray = certPathCtx.getPolicies()) == null) {
            this.c = null;
        } else {
            this.c = new Vector();
            for (int i = 0; i < byArray.length; ++i) {
                this.c.addElement(byArray[i]);
            }
        }
        this.d = certPathCtx.getValidationTime();
        if (this.d == null) {
            this.d = new Date();
        }
        this.e = certPathCtx.getDatabase();
    }

    public abstract /* synthetic */ CertPathResult buildCertPath(CertPathCtx var1, Object var2, Vector var3, Vector var4, Vector var5) throws NotSupportedException, CertPathException;
}

