/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.db;

import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.AttributeValueAssertion;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.RDN;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.provider.db.Ck;
import com.rsa.certj.provider.db.LDAPConfiguration;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.db.DatabaseInterface;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public final class LDAPDatabase
extends Provider {
    private static final int a = 0;
    private static final int b = 1;
    private LDAPConfiguration c;
    private String d;
    private String e;
    private String[] f;
    private String[] g;
    private String h;
    private String i;

    public LDAPDatabase(String string, LDAPConfiguration lDAPConfiguration, String string2, String string3) throws InvalidParameterException {
        super(1, string);
        if (lDAPConfiguration == null) {
            throw new InvalidParameterException("LDAPDatabase.LDAPDatabase: configuration should not be null.");
        }
        if (lDAPConfiguration.getAuthType() == 1 && (string2 == null || string3 == null)) {
            throw new InvalidParameterException("LDAPDatabase.LDAPDatabase: neither userDN nor password can be null if configuration.authType is LDAP_AUTH_SIMPLE.");
        }
        this.c = lDAPConfiguration;
        this.d = string2;
        this.e = string3;
        this.f = this.a(lDAPConfiguration.getCertificateAttrs());
        this.g = this.a(lDAPConfiguration.getCertificateRevocationAttrs());
        this.h = this.a(this.f);
        this.i = this.a(this.g);
    }

    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            return new Implementation(certJ, this.getName(), null);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new ProviderManagementException("LDAPDatabase.instantiate: " + invalidParameterException.getMessage());
        }
    }

    private String[] a(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        for (int i = 0; i <= stringTokenizer.countTokens(); ++i) {
            String string2 = (String)stringTokenizer.nextElement();
            int n = 0;
            int n2 = string2.length();
            while (string2.charAt(n) == ' ') {
                ++n;
            }
            while (string2.charAt(n2 - 1) == ' ') {
                --n2;
            }
            vector.addElement(string2.substring(n, n2));
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    private Vector a(LDAPConnection lDAPConnection, X500Name x500Name, boolean bl, String string, String[] stringArray, int n) throws DatabaseException {
        Vector vector;
        Object object;
        DatabaseException databaseException = null;
        LDAPSearchResults lDAPSearchResults = null;
        if (bl) {
            try {
                object = this.a(lDAPConnection, x500Name.toString(true), 0, string, stringArray, n);
                if (object != null && ((Vector)object).size() != 0) {
                    return object;
                }
            }
            catch (DatabaseException databaseException2) {
                databaseException = databaseException2;
            }
        }
        object = this.a(this.c.getBaseDNAttrs(), x500Name);
        String string2 = this.b(this.c.getSearchFilterAttrs(), x500Name);
        if (!((String)object).equals("") && !string2.equals("")) {
            try {
                lDAPSearchResults = lDAPConnection.search((String)object, 2, string2, stringArray, false);
            }
            catch (LDAPException lDAPException) {
                databaseException = new DatabaseException("LDAPDatabase.retrieve: baseDN filter search failed(" + lDAPException.getMessage() + ").");
            }
            if (lDAPSearchResults != null) {
                try {
                    vector = this.a(lDAPSearchResults, stringArray, n);
                    databaseException = null;
                    if (vector != null && vector.size() != 0) {
                        return vector;
                    }
                }
                catch (DatabaseException databaseException3) {
                    databaseException = databaseException3;
                }
            }
        }
        if (this.c.getSearchRoot() != null && !string2.equals("")) {
            try {
                lDAPSearchResults = lDAPConnection.search(this.c.getSearchRoot(), 2, string2, stringArray, false);
            }
            catch (LDAPException lDAPException) {
                databaseException = new DatabaseException("LDAPDatabase.retrieve: subtree filter search failed(" + lDAPException.getMessage() + ").");
            }
            if (lDAPSearchResults != null) {
                try {
                    vector = this.a(lDAPSearchResults, stringArray, n);
                    databaseException = null;
                    if (vector != null && vector.size() != 0) {
                        return vector;
                    }
                }
                catch (DatabaseException databaseException4) {
                    databaseException = databaseException4;
                }
            }
        }
        if (this.c.getSearchRoot() != null) {
            return this.a(lDAPConnection, string, stringArray, n);
        }
        if (databaseException != null) {
            throw databaseException;
        }
        return null;
    }

    private Vector a(LDAPConnection lDAPConnection, String string, String[] stringArray, int n) throws DatabaseException {
        return this.a(lDAPConnection, this.c.getSearchRoot(), 2, string, stringArray, n);
    }

    private Vector a(LDAPConnection lDAPConnection, String string, int n, String string2, String[] stringArray, int n2) throws DatabaseException {
        LDAPSearchResults lDAPSearchResults = null;
        try {
            lDAPSearchResults = lDAPConnection.search(string, n, string2, stringArray, false);
        }
        catch (LDAPException lDAPException) {
            throw new DatabaseException("LDAPDatabase.attributeSearch: " + lDAPException.getMessage());
        }
        return this.a(lDAPSearchResults, stringArray, n2);
    }

    private String a(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(|");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append('(');
            stringBuffer.append(stringArray[i]);
            stringBuffer.append("=*)");
        }
        stringBuffer.append(')');
        return new String(stringBuffer);
    }

    private String a(String string, X500Name x500Name) throws DatabaseException {
        X500Name x500Name2 = new X500Name();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        for (int i = 0; i <= stringTokenizer.countTokens(); ++i) {
            String string2 = (String)stringTokenizer.nextElement();
            int n = 0;
            int n2 = string2.length();
            while (string2.charAt(n) == ' ') {
                ++n;
            }
            while (string2.charAt(n2 - 1) == ' ') {
                --n2;
            }
            this.a(string2.substring(n, n2), x500Name, x500Name2);
        }
        return x500Name2.toString(true);
    }

    private String b(String string, X500Name x500Name) throws DatabaseException {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        for (int i = 0; i <= stringTokenizer.countTokens(); ++i) {
            String string2 = (String)stringTokenizer.nextElement();
            int n = 0;
            int n2 = string2.length();
            while (string2.charAt(n) == ' ') {
                ++n;
            }
            while (string2.charAt(n2 - 1) == ' ') {
                --n2;
            }
            X500Name x500Name2 = new X500Name();
            this.a(string2.substring(n, n2), x500Name, x500Name2);
            String string3 = x500Name2.toString(true);
            if (string3.equals("")) continue;
            vector.addElement(string3);
        }
        if (vector.size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (vector.size() == 1) {
            stringBuffer.append('(');
            stringBuffer.append(vector.elementAt(0));
            stringBuffer.append(')');
        } else {
            stringBuffer.append("(&");
            for (int i = 0; i < vector.size(); ++i) {
                stringBuffer.append('(');
                stringBuffer.append(vector.elementAt(i));
                stringBuffer.append(')');
            }
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    private void a(String string, X500Name x500Name, X500Name x500Name2) throws DatabaseException {
        AttributeValueAssertion attributeValueAssertion = x500Name.getAttribute(this.b(string));
        if (attributeValueAssertion == null) {
            return;
        }
        RDN rDN = new RDN();
        try {
            rDN.addNameAVA(attributeValueAssertion);
            x500Name2.addRDN(rDN);
        }
        catch (NameException nameException) {
            throw new DatabaseException("LDAPDatabase$Implementation.addCertCRLAttrIfMatch: Failed to add AVA and RDN.");
        }
    }

    private int b(String string) throws DatabaseException {
        if (string.equals("cn")) {
            return 0;
        }
        if (string.equals("l")) {
            return 2;
        }
        if (string.equals("st")) {
            return 3;
        }
        if (string.equals("o")) {
            return 4;
        }
        if (string.equals("ou")) {
            return 5;
        }
        if (string.equals("c")) {
            return 1;
        }
        if (string.equals("street")) {
            return 9;
        }
        if (string.equals("title")) {
            return 8;
        }
        if (string.equals("postalCode")) {
            return 11;
        }
        if (string.equals("e")) {
            return 7;
        }
        if (string.equals("mail")) {
            return 7;
        }
        throw new DatabaseException("LDAPDatabase$Implementation.getAttributeType: attribute type string " + string + " not recognized.");
    }

    private Vector a(LDAPSearchResults lDAPSearchResults, String[] stringArray, int n) throws DatabaseException {
        if (lDAPSearchResults == null) {
            return null;
        }
        Vector<X509Certificate> vector = new Vector<X509Certificate>();
        Object object = null;
        while (lDAPSearchResults.hasMoreElements()) {
            LDAPException lDAPException;
            object = lDAPSearchResults.nextElement();
            if (object instanceof LDAPException) {
                lDAPException = (LDAPException)((Object)object);
                switch (lDAPException.getLDAPResultCode()) {
                    case 3: {
                        throw new DatabaseException("LDAPDatabase.processResults: time limit exceeded(" + lDAPException.getMessage() + ").");
                    }
                    case 4: {
                        throw new DatabaseException("LDAPDatabase.processResults: size limit exceeded(" + lDAPException.getMessage() + ").");
                    }
                    case 11: {
                        throw new DatabaseException("LDAPDatabase.processResults: admin limit exceeded(" + lDAPException.getMessage() + ").");
                    }
                }
                continue;
            }
            if (!(object instanceof LDAPEntry)) continue;
            lDAPException = (LDAPEntry)object;
            for (int i = 0; i < stringArray.length; ++i) {
                Enumeration enumeration;
                LDAPAttribute lDAPAttribute = lDAPException.getAttribute(stringArray[i]);
                if (lDAPAttribute == null || (enumeration = lDAPAttribute.getByteValues()) == null) continue;
                while (enumeration.hasMoreElements()) {
                    Cloneable cloneable;
                    byte[] byArray = (byte[])enumeration.nextElement();
                    if (byArray == null) continue;
                    if (n == 0) {
                        try {
                            cloneable = new X509Certificate(byArray, 0, 0);
                            vector.addElement((X509Certificate)cloneable);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (n != 1) continue;
                    try {
                        cloneable = new X509CRL(byArray, 0, 0);
                        vector.addElement((X509Certificate)cloneable);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return vector;
    }

    private final class Implementation
    extends ProviderImplementation
    implements DatabaseInterface {
        private LDAPConnection a;
        private Iterator b = null;
        private Iterator c = null;
        private Object d = new Object();
        private Object e = new Object();

        private Implementation(CertJ certJ, String string) throws InvalidParameterException {
            super(certJ, string);
            this.a = new LDAPConnection();
        }

        public void unregister() {
            try {
                this.b();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void insertCertificate(Certificate certificate) throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.insertCertificate: LDAP database is read-only.");
        }

        public void insertCRL(CRL cRL) throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.insertCRL: LDAP database is read-only.");
        }

        public void insertPrivateKeyByCertificate(Certificate certificate, JSAFE_PrivateKey jSAFE_PrivateKey) throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.insertPrivateKeyByCertificate: LDAP database does not store privateKeys.");
        }

        public void insertPrivateKeyByPublicKey(JSAFE_PublicKey jSAFE_PublicKey, JSAFE_PrivateKey jSAFE_PrivateKey) throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.insertPrivateKeyByPublicKey: LDAP database does not store privateKeys.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int selectCertificateByIssuerAndSerialNumber(X500Name x500Name, byte[] byArray, Vector vector) throws DatabaseException {
            if (x500Name == null || byArray == null) {
                throw new DatabaseException("LDAPDatabase$Implementation.selectCertificateByIssuerAndSerialNumber: neither issuerName nor serialNumber should be null.");
            }
            this.a();
            try {
                int n;
                if (LDAPDatabase.this.c.getSearchRoot() == null) {
                    throw new DatabaseException("LDAPDatabase$Implementation.selectCertificateByIssuerAndSerialNumber: searchRoot can not be null to perform this search.");
                }
                Vector vector2 = LDAPDatabase.this.a(this.a, LDAPDatabase.this.h, LDAPDatabase.this.f, 0);
                int n2 = 0;
                for (n = 0; n < vector2.size(); ++n) {
                    X509Certificate x509Certificate = (X509Certificate)vector2.elementAt(n);
                    if (!x500Name.equals(x509Certificate.getIssuerName()) || !CertJUtils.byteArraysEqual(byArray, x509Certificate.getSerialNumber())) continue;
                    ++n2;
                    if (vector.contains(x509Certificate)) continue;
                    vector.addElement(x509Certificate);
                }
                n = n2;
                return n;
            }
            finally {
                if (LDAPDatabase.this.c.getDisconnectBeforeConnect()) {
                    this.b();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int selectCertificateBySubject(X500Name x500Name, Vector vector) throws DatabaseException {
            if (x500Name == null) {
                throw new DatabaseException("LDAPDatabase$Implementation.selectCertificateBySubject: subjectName should not be null.");
            }
            this.a();
            try {
                int n;
                Vector vector2 = LDAPDatabase.this.a(this.a, x500Name, true, LDAPDatabase.this.h, LDAPDatabase.this.f, 0);
                if (vector2 == null) {
                    int n2 = 0;
                    return n2;
                }
                int n3 = 0;
                for (n = 0; n < vector2.size(); ++n) {
                    X509Certificate x509Certificate = (X509Certificate)vector2.elementAt(n);
                    if (!x500Name.equals(x509Certificate.getSubjectName())) continue;
                    if (!vector.contains(x509Certificate)) {
                        vector.addElement(x509Certificate);
                    }
                    ++n3;
                }
                n = n3;
                return n;
            }
            finally {
                if (LDAPDatabase.this.c.getDisconnectBeforeConnect()) {
                    this.b();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int selectCertificateByExtensions(X500Name x500Name, X509V3Extensions x509V3Extensions, Vector vector) throws DatabaseException {
            if (x500Name == null) {
                throw new DatabaseException("LDAPDatabase.selectCertificateByExtensions: baseName should not be null.");
            }
            this.a();
            try {
                int n;
                Vector vector2 = LDAPDatabase.this.a(this.a, x500Name, false, LDAPDatabase.this.h, LDAPDatabase.this.f, 0);
                if (vector2 == null) {
                    int n2 = 0;
                    return n2;
                }
                int n3 = 0;
                for (n = 0; n < vector2.size(); ++n) {
                    X509V3Extensions x509V3Extensions2;
                    X509Certificate x509Certificate = (X509Certificate)vector2.elementAt(n);
                    if (!x509Certificate.getSubjectName().contains(x500Name) || !CertJUtils.compareExtensions(x509V3Extensions, x509V3Extensions2 = x509Certificate.getExtensions())) continue;
                    if (!vector.contains(x509Certificate)) {
                        vector.addElement(x509Certificate);
                    }
                    ++n3;
                }
                n = n3;
                return n;
            }
            finally {
                if (LDAPDatabase.this.c.getDisconnectBeforeConnect()) {
                    this.b();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCertificateIteratorSetup() throws DatabaseException {
            Object object = this.d;
            synchronized (object) {
                return this.b != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setupCertificateIterator() throws DatabaseException {
            this.a();
            try {
                Object object = this.d;
                synchronized (object) {
                    this.b = new Iterator(LDAPDatabase.this.c.getSearchRoot(), LDAPDatabase.this.h, LDAPDatabase.this.f, 0, null);
                }
            }
            finally {
                if (LDAPDatabase.this.c.getDisconnectBeforeConnect()) {
                    this.b();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Certificate firstCertificate() throws DatabaseException {
            Object object = this.d;
            synchronized (object) {
                this.setupCertificateIterator();
                return this.nextCertificate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Certificate nextCertificate() throws DatabaseException {
            Object object = this.d;
            synchronized (object) {
                if (!this.isCertificateIteratorSetup()) {
                    this.setupCertificateIterator();
                }
                if (this.hasMoreCertificates()) {
                    return (Certificate)this.b.nextElement();
                }
                this.b = null;
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasMoreCertificates() throws DatabaseException {
            Object object = this.d;
            synchronized (object) {
                if (!this.isCertificateIteratorSetup()) {
                    this.setupCertificateIterator();
                }
                return this.b.hasMoreElements();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int selectCRLByIssuerAndTime(X500Name x500Name, Date date, Vector vector) throws DatabaseException {
            if (x500Name == null || date == null) {
                throw new DatabaseException("LDAPDatabase$Implementation.selectCRLByIssuerAndTime: neither issuerName nor time should be null.");
            }
            this.a();
            try {
                int n;
                Vector vector2 = LDAPDatabase.this.a(this.a, x500Name, true, LDAPDatabase.this.i, LDAPDatabase.this.g, 1);
                if (vector2 == null) {
                    int n2 = 0;
                    return n2;
                }
                Date date2 = new Date(0L);
                X509CRL x509CRL = null;
                int n3 = 0;
                for (n = 0; n < vector2.size(); ++n) {
                    Date date3;
                    X509CRL x509CRL2 = (X509CRL)vector2.elementAt(n);
                    X500Name x500Name2 = x509CRL2.getIssuerName();
                    if (!x500Name.equals(x500Name2) || (date3 = x509CRL2.getThisUpdate()).after(date) || !date3.after(date2)) continue;
                    date2 = date3;
                    x509CRL = x509CRL2;
                }
                if (x509CRL != null) {
                    if (!vector.contains(x509CRL)) {
                        vector.addElement(x509CRL);
                    }
                    n3 = 1;
                }
                n = n3;
                return n;
            }
            finally {
                if (LDAPDatabase.this.c.getDisconnectBeforeConnect()) {
                    this.b();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCRLIteratorSetup() throws DatabaseException {
            Object object = this.e;
            synchronized (object) {
                return this.c != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setupCRLIterator() throws DatabaseException {
            this.a();
            try {
                Object object = this.e;
                synchronized (object) {
                    this.c = new Iterator(LDAPDatabase.this.c.getSearchRoot(), LDAPDatabase.this.i, LDAPDatabase.this.g, 1, null);
                }
            }
            finally {
                if (LDAPDatabase.this.c.getDisconnectBeforeConnect()) {
                    this.b();
                }
            }
        }

        public CRL firstCRL() throws DatabaseException {
            this.setupCRLIterator();
            return this.nextCRL();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CRL nextCRL() throws DatabaseException {
            Object object = this.e;
            synchronized (object) {
                if (!this.isCRLIteratorSetup()) {
                    this.setupCRLIterator();
                }
                if (this.hasMoreCRLs()) {
                    return (CRL)this.c.nextElement();
                }
                this.c = null;
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasMoreCRLs() throws DatabaseException {
            Object object = this.e;
            synchronized (object) {
                if (!this.isCRLIteratorSetup()) {
                    this.setupCRLIterator();
                }
                return this.c.hasMoreElements();
            }
        }

        public JSAFE_PrivateKey selectPrivateKeyByCertificate(Certificate certificate) throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.selectPrivateKeyByCertificate:  LDAP database does not store keys.");
        }

        public JSAFE_PrivateKey selectPrivateKeyByPublicKey(JSAFE_PublicKey jSAFE_PublicKey) throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.selectPrivateKeyByPublicKey:  LDAP database does not store keys.");
        }

        public boolean isPrivateKeyIteratorSetup() throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.isPrivateKeyIteratorSetup: LDAP database does not store keys.");
        }

        public void setupPrivateKeyIterator() throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.setupPrivateKeyIterator: LDAP database does not store keys.");
        }

        public JSAFE_PrivateKey firstPrivateKey() throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.firstPrivateKey: LDAP database does not store keys.");
        }

        public JSAFE_PrivateKey nextPrivateKey() throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.nextPrivateKey: LDAP database does not store keys.");
        }

        public boolean hasMorePrivateKeys() throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.hasMorePrivateKeys: LDAP database does not store keys.");
        }

        public void deleteCertificate(X500Name x500Name, byte[] byArray) throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.deleteCertificate: LDAP database is read-only.");
        }

        public void deleteCRL(X500Name x500Name, Date date) throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.deleteCRL: LDAP database is read-only.");
        }

        public void deletePrivateKeyByCertificate(Certificate certificate) throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.deletePrivateKeyByCertificate: LDAP database does not store keys.");
        }

        public void deletePrivateKeyByPublicKey(JSAFE_PublicKey jSAFE_PublicKey) throws NotSupportedException {
            throw new NotSupportedException("LDAPDatabase$Implementation.deletePrivateKeyByPublicKey: LDAP database does not store keys.");
        }

        private void a() throws DatabaseException {
            if (this.a.isConnected()) {
                return;
            }
            try {
                this.a.connect(LDAPDatabase.this.c.getNetworkAddress().getHostName(), LDAPDatabase.this.c.getPortNumber());
            }
            catch (LDAPException lDAPException) {
                throw new DatabaseException("LDAPDatabase$Implementation.connect: LDAP connect call failed(" + lDAPException.getMessage() + ").");
            }
            try {
                this.a.setOption(3, (Object)new Integer(LDAPDatabase.this.c.getSizeLimit()));
            }
            catch (LDAPException lDAPException) {
                throw new DatabaseException("LDAPDatabase$Implementation.connect: LDAP setOption call for size limit failed(" + lDAPException.getMessage() + ").");
            }
            try {
                this.a.setOption(4, (Object)new Integer(LDAPDatabase.this.c.getTimeLimit()));
            }
            catch (LDAPException lDAPException) {
                throw new DatabaseException("LDAPDatabase$Implementation.connect: LDAP setOption call for time limit failed(" + lDAPException.getMessage() + ").");
            }
            try {
                if (LDAPDatabase.this.c.getAuthType() == 1) {
                    this.a.authenticate(LDAPDatabase.this.d, LDAPDatabase.this.e);
                }
            }
            catch (LDAPException lDAPException) {
                throw new DatabaseException("LDAPDatabase$Implementation.connect: LDAP authenticate call failed(" + lDAPException.getMessage() + ").");
            }
        }

        private void b() throws DatabaseException {
            if (!this.a.isConnected()) {
                return;
            }
            try {
                this.a.disconnect();
            }
            catch (LDAPException lDAPException) {
                throw new DatabaseException("LDAPDatabase$Implementation.disconnect: LDAP disconnect call failed(" + lDAPException.getMessage() + ").");
            }
        }

        public String toString() {
            return "LDAP database provider named: " + super.getName();
        }

        /* synthetic */ Implementation(CertJ certJ, String string, Ck ck) throws InvalidParameterException {
            this(certJ, string);
        }

        final class Iterator
        implements Enumeration {
            private int a;
            private Vector b;

            private Iterator(String string, String string2, String[] stringArray, int n) throws DatabaseException {
                if (string == null) {
                    throw new DatabaseException("LDAPDatabase$Iterator.Iterator: searchRoot can not be null to perform iteration operations.");
                }
                this.b = LDAPDatabase.this.a(Implementation.this.a, string2, stringArray, n);
                this.a = 0;
            }

            public boolean hasMoreElements() {
                return this.a < this.b.size();
            }

            public Object nextElement() {
                if (this.hasMoreElements()) {
                    return this.b.elementAt(this.a++);
                }
                return null;
            }

            /* synthetic */ Iterator(String string, String string2, String[] stringArray, int n, Ck ck) throws DatabaseException {
                this(string, string2, stringArray, n);
            }
        }
    }
}

