/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.db;

import com.rsa.certj.CertJ;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.provider.db.Ci;
import com.rsa.certj.provider.db.Cj;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.db.DatabaseInterface;
import com.rsa.certj.spi.random.RandomException;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public final class FlatFileDB
extends Provider {
    public static final int DEFAULT_BASE_NAME_LEN = 6;
    public static final int DEFAULT_PREFIX_LEN = 2;
    private static final String a = "certs";
    private static final String b = "crls";
    private static final String c = "privs";
    private static final String d = "pubs";
    private static final String e = "cer";
    private static final String f = "crl";
    private static final String g = "prv";
    private static final String h = "pub";
    private static final String i = "PBE/SHA1/RC4/PKCS12V1PBE-5-128";
    private static final String j = "MD5";
    private static Hashtable k = new Hashtable();
    private int l = 0;
    private int m = 0;
    private File n;
    private char[] o;
    private File p;
    private File q;
    private File r;
    private File s;

    public static boolean create(String string) throws InvalidParameterException {
        if (string == null) {
            throw new InvalidParameterException("FlatFileDB.create: pathString should not be null.");
        }
        return FlatFileDB.create(new File(string));
    }

    public static boolean create(File file) throws InvalidParameterException {
        if (file == null) {
            throw new InvalidParameterException("FlatFileDB.create: path should not be null.");
        }
        if (file.exists()) {
            return false;
        }
        file.mkdirs();
        FlatFileDB.b(file, a);
        FlatFileDB.b(file, b);
        FlatFileDB.b(file, c);
        FlatFileDB.b(file, d);
        return true;
    }

    public static boolean delete(String string) throws InvalidParameterException {
        if (string == null) {
            throw new InvalidParameterException("FlatFileDB.delete: pathString should not be null.");
        }
        return FlatFileDB.delete(new File(string));
    }

    public static boolean delete(File file) throws InvalidParameterException {
        if (file == null) {
            throw new InvalidParameterException("FlatFileDB.delete: path should not be null.");
        }
        if (!file.exists()) {
            return false;
        }
        FlatFileDB.c(new File(file, a), e);
        FlatFileDB.c(new File(file, b), f);
        FlatFileDB.c(new File(file, c), g);
        FlatFileDB.c(new File(file, d), h);
        boolean bl = file.delete();
        if (bl) {
            while (file.exists()) {
            }
            k.remove(file);
        }
        return bl;
    }

    public FlatFileDB(String string, String string2, char[] cArray) throws InvalidParameterException {
        super(1, string);
        if (string2 == null) {
            throw new InvalidParameterException("FlatFileDB.FlatFileDB: pathString should not be null.");
        }
        if (cArray == null) {
            throw new InvalidParameterException("FlatFileDB.FlatFileDB: passphrase should not be null.");
        }
        this.n = new File(string2);
        this.o = cArray;
        this.l = 6;
        this.m = 2;
        this.b();
    }

    public FlatFileDB(String string, File file, char[] cArray) throws InvalidParameterException {
        super(1, string);
        if (file == null) {
            throw new InvalidParameterException("FlatFileDB.FlatFileDB: path should not be null.");
        }
        if (cArray == null) {
            throw new InvalidParameterException("FlatFileDB.FlatFileDB: passphrase should not be null.");
        }
        this.n = file;
        this.o = cArray;
        this.l = 6;
        this.m = 2;
        this.b();
    }

    public FlatFileDB(String string, String string2, char[] cArray, int n, int n2) throws InvalidParameterException {
        super(1, string);
        if (string2 == null) {
            throw new InvalidParameterException("FlatFileDB.FlatFileDB: pathString should not be null.");
        }
        if (cArray == null) {
            throw new InvalidParameterException("FlatFileDB.FlatFileDB: passphrase should not be null.");
        }
        this.n = new File(string2);
        this.o = cArray;
        this.l = n > 0 ? n : 6;
        this.m = n2 > 0 ? n2 : 2;
        this.b();
    }

    public FlatFileDB(String string, File file, char[] cArray, int n, int n2) throws InvalidParameterException {
        super(1, string);
        if (file == null) {
            throw new InvalidParameterException("FlatFileDB.FlatFileDB: path should not be null.");
        }
        if (cArray == null) {
            throw new InvalidParameterException("FlatFileDB.FlatFileDB: passphrase should not be null.");
        }
        this.n = file;
        this.o = cArray;
        this.l = n > 0 ? n : 6;
        this.m = n2 > 0 ? n2 : 2;
        this.b();
    }

    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            return new Implementation(certJ, this.getName(), null);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new ProviderManagementException("FlatFileDB.instantiate: " + invalidParameterException.getMessage());
        }
    }

    private void b() {
        if (!this.n.exists()) {
            this.n.mkdirs();
        }
        this.p = FlatFileDB.b(this.n, a);
        this.q = FlatFileDB.b(this.n, b);
        this.r = FlatFileDB.b(this.n, c);
        this.s = FlatFileDB.b(this.n, d);
    }

    private static File b(File file, String string) {
        File file2 = new File(file, string);
        if (file2.exists()) {
            if (!file2.isDirectory()) {
                file2.delete();
                file2.mkdir();
            }
        } else {
            file2.mkdir();
        }
        return file2;
    }

    private static void c(File file, String string) {
        if (!file.exists()) {
            return;
        }
        Vector vector = FlatFileDB.d(file, string);
        for (int i = 0; i < vector.size(); ++i) {
            ((File)vector.elementAt(i)).delete();
        }
        file.delete();
    }

    private static String b(byte by) {
        int n;
        char[] cArray = new char[2];
        int n2 = by & 0xF;
        if (n2 < 0) {
            n2 += 16;
        }
        if ((n = by >> 4) < 0) {
            n += 16;
        }
        cArray[1] = n2 < 10 ? (char)(48 + n2) : (char)(65 + (n2 - 10));
        cArray[0] = n < 10 ? (char)(48 + n) : (char)(65 + (n - 10));
        return new String(cArray);
    }

    private static Vector d(File file, String string) {
        Vector<File> vector = new Vector<File>();
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.length() <= string.length() + 1 || !string2.endsWith("." + string)) continue;
            vector.addElement(new File(file, string2));
        }
        return vector;
    }

    private static X509Certificate c(File file) throws DatabaseException {
        try {
            byte[] byArray = FlatFileDB.e(file);
            X509Certificate x509Certificate = new X509Certificate(byArray, 0, 0);
            return x509Certificate;
        }
        catch (CertificateException certificateException) {
            throw new DatabaseException("FlatFileDB.loadCertFromFile: unable to instantiate an X509Certificate object (" + certificateException.getMessage() + ").");
        }
    }

    private static X509CRL d(File file) throws DatabaseException {
        try {
            byte[] byArray = FlatFileDB.e(file);
            X509CRL x509CRL = new X509CRL(byArray, 0, 0);
            return x509CRL;
        }
        catch (CertificateException certificateException) {
            throw new DatabaseException("FlatFileDB.loadCRLFromFile: unable to instantiate an X509CRL object (" + certificateException.getMessage() + ").");
        }
    }

    private static JSAFE_PublicKey b(File file, CertJ certJ) throws DatabaseException {
        try {
            byte[] byArray = FlatFileDB.e(file);
            return JSAFE_PublicKey.getInstance((byte[])byArray, (int)0, (String)certJ.getDevice());
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new DatabaseException("FlatFileDB.loadPublicKeyFromFile: unable to instantiate a publie key object (" + jSAFE_Exception.getMessage() + ").");
        }
    }

    private static JSAFE_PrivateKey b(File file, char[] cArray, CertJ certJ) throws DatabaseException {
        return FlatFileDB.a(FlatFileDB.e(file), cArray, certJ);
    }

    private static byte[] e(File file) throws DatabaseException {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            int n = (int)file.length();
            byte[] byArray = new byte[n];
            int n2 = fileInputStream.read(byArray);
            fileInputStream.close();
            if (n2 != n) {
                throw new DatabaseException("FlatFileDB.loadBinaryFromFile: contents read from " + file + " are of wrong length.");
            }
            return byArray;
        }
        catch (IOException iOException) {
            throw new DatabaseException("FlatFileDB.loadBinaryFromFile: IO operation failed (" + iOException.getMessage() + ").");
        }
    }

    private static byte[] b(JSAFE_PrivateKey jSAFE_PrivateKey, char[] cArray, CertJ certJ) throws DatabaseException {
        JSAFE_SymmetricCipher jSAFE_SymmetricCipher = null;
        try {
            jSAFE_SymmetricCipher = JSAFE_SymmetricCipher.getInstance((String)i, (String)certJ.getDevice());
            JSAFE_SecureRandom jSAFE_SecureRandom = certJ.getRandomObject();
            jSAFE_SymmetricCipher.generateSalt((SecureRandom)jSAFE_SecureRandom);
            JSAFE_SecretKey jSAFE_SecretKey = jSAFE_SymmetricCipher.getBlankKey();
            jSAFE_SecretKey.setPassword(cArray, 0, cArray.length);
            jSAFE_SymmetricCipher.encryptInit(jSAFE_SecretKey, (SecureRandom)jSAFE_SecureRandom);
            byte[] byArray = jSAFE_SymmetricCipher.wrapPrivateKey(jSAFE_PrivateKey, true);
            return byArray;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new DatabaseException("FlatFileDB.encryptPrivateKey: symmetric chiper operation failed(" + jSAFE_Exception.getMessage() + ").");
        }
        catch (NoServiceException noServiceException) {
            throw new DatabaseException("FlatFileDB.encryptPrivateKey: random provider is not available in certJ(" + noServiceException.getMessage() + ").");
        }
        catch (RandomException randomException) {
            throw new DatabaseException("FlatFileDB.encryptPrivateKey: random number generation failed(" + randomException.getMessage() + ").");
        }
        finally {
            if (jSAFE_SymmetricCipher != null) {
                jSAFE_SymmetricCipher.clearSensitiveData();
            }
        }
    }

    private static JSAFE_PrivateKey a(byte[] byArray, char[] cArray, CertJ certJ) throws DatabaseException {
        JSAFE_SymmetricCipher jSAFE_SymmetricCipher = null;
        try {
            jSAFE_SymmetricCipher = JSAFE_SymmetricCipher.getInstance((byte[])byArray, (int)0, (String)certJ.getDevice());
            JSAFE_SecretKey jSAFE_SecretKey = jSAFE_SymmetricCipher.getBlankKey();
            jSAFE_SecretKey.setPassword(cArray, 0, cArray.length);
            jSAFE_SymmetricCipher.decryptInit(jSAFE_SecretKey);
            JSAFE_PrivateKey jSAFE_PrivateKey = jSAFE_SymmetricCipher.unwrapPrivateKey(byArray, 0, byArray.length, true);
            return jSAFE_PrivateKey;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new DatabaseException("FlatFileDB.decryptPrivateKey: symmetric chiper operation failed(" + jSAFE_Exception.getMessage() + ").");
        }
        finally {
            if (jSAFE_SymmetricCipher != null) {
                jSAFE_SymmetricCipher.clearSensitiveData();
            }
        }
    }

    static /* synthetic */ File c(FlatFileDB flatFileDB) {
        return flatFileDB.p;
    }

    static /* synthetic */ File d(FlatFileDB flatFileDB) {
        return flatFileDB.q;
    }

    static /* synthetic */ byte[] a(JSAFE_PrivateKey jSAFE_PrivateKey, char[] cArray, CertJ certJ) throws DatabaseException {
        return FlatFileDB.b(jSAFE_PrivateKey, cArray, certJ);
    }

    static /* synthetic */ File e(FlatFileDB flatFileDB) {
        return flatFileDB.r;
    }

    static /* synthetic */ File f(FlatFileDB flatFileDB) {
        return flatFileDB.s;
    }

    static /* synthetic */ Vector a(File file, String string) {
        return FlatFileDB.d(file, string);
    }

    static /* synthetic */ JSAFE_PublicKey a(File file, CertJ certJ) throws DatabaseException {
        return FlatFileDB.b(file, certJ);
    }

    static /* synthetic */ int g(FlatFileDB flatFileDB) {
        return flatFileDB.l;
    }

    static /* synthetic */ int h(FlatFileDB flatFileDB) {
        return flatFileDB.m;
    }

    static /* synthetic */ String a(byte by) {
        return FlatFileDB.b(by);
    }

    private final class Implementation
    extends ProviderImplementation
    implements DatabaseInterface {
        private Vector a = null;
        private Vector b = null;
        private Vector c = null;
        private int d;
        private int e;
        private int f;
        private Object g = new Object();
        private Object h = new Object();
        private Object i = new Object();
        private Cj j;

        private Implementation(CertJ certJ, String string) throws InvalidParameterException {
            super(certJ, string);
            this.j = (Cj)k.get(FlatFileDB.this.n);
            if (this.j == null) {
                this.j = new Cj(FlatFileDB.this, null);
            }
            k.put(FlatFileDB.this.n, this.j);
        }

        public void insertCertificate(Certificate certificate) throws DatabaseException {
            if (certificate == null) {
                throw new DatabaseException("FlatFileDB$Implementation.insertCertificate: cert should not be null.");
            }
            if (!(certificate instanceof X509Certificate)) {
                throw new DatabaseException("FlatFileDB$Implementation.insertCertificate: cert should be an instance of X509Certificate.");
            }
            Cj.a(this.j, (X509Certificate)certificate, this.certJ);
        }

        public void insertCRL(CRL cRL) throws DatabaseException {
            if (cRL == null) {
                throw new DatabaseException("FlatFileDB$Implementation.insertCRL: crl should not be null.");
            }
            if (!(cRL instanceof X509CRL)) {
                throw new DatabaseException("FlatFileDB$Implementation.insertCRL: crl should be an instance of X509CRL.");
            }
            Cj.a(this.j, (X509CRL)cRL, this.certJ);
        }

        public void insertPrivateKeyByCertificate(Certificate certificate, JSAFE_PrivateKey jSAFE_PrivateKey) throws DatabaseException {
            if (certificate == null) {
                throw new DatabaseException("FlatFileDB$Implementation.insertPrivateKeyByCertificate: cert should not be null.");
            }
            try {
                this.insertPrivateKeyByPublicKey(certificate.getSubjectPublicKey(this.certJ.getDevice()), jSAFE_PrivateKey);
            }
            catch (CertificateException certificateException) {
                throw new DatabaseException("FlatFileDB$Implementation.insertPrivateKeyByCertificate: " + certificateException.getMessage());
            }
        }

        public void insertPrivateKeyByPublicKey(JSAFE_PublicKey jSAFE_PublicKey, JSAFE_PrivateKey jSAFE_PrivateKey) throws DatabaseException {
            if (jSAFE_PublicKey == null || jSAFE_PrivateKey == null) {
                throw new DatabaseException("FlatFileDB$Implementation.insertPrivateKeyByPublicKey: neither publicKey nor privateKey should be null.");
            }
            Cj.a(this.j, jSAFE_PublicKey, jSAFE_PrivateKey, FlatFileDB.this.o, this.certJ);
        }

        public int selectCertificateByIssuerAndSerialNumber(X500Name x500Name, byte[] byArray, Vector vector) throws DatabaseException {
            if (x500Name == null || byArray == null) {
                throw new DatabaseException("FlatFileDB$Implementation.selectCertificateByIssuerAndSerialNumber: neither issuerName nor serialNumber should be null.");
            }
            return Cj.a(this.j, x500Name, byArray, vector, this.certJ);
        }

        public int selectCertificateBySubject(X500Name x500Name, Vector vector) throws DatabaseException {
            if (x500Name == null) {
                throw new DatabaseException("FlatFileDB$Implementation.selectCertificateBySubject: subjectName should not be null.");
            }
            return Cj.a(this.j, x500Name, vector);
        }

        public int selectCertificateByExtensions(X500Name x500Name, X509V3Extensions x509V3Extensions, Vector vector) throws DatabaseException {
            if (x500Name == null && x509V3Extensions == null) {
                throw new DatabaseException("FlatFileDB$Implementation.selectCertificateByExtensions: Either baseName or extensions should have a non-null value.");
            }
            return Cj.a(this.j, x500Name, x509V3Extensions, vector);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCertificateIteratorSetup() {
            Object object = this.g;
            synchronized (object) {
                return this.a != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setupCertificateIterator() {
            Object object = this.g;
            synchronized (object) {
                this.a = Cj.a(this.j);
                this.d = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Certificate firstCertificate() throws DatabaseException {
            Object object = this.g;
            synchronized (object) {
                this.setupCertificateIterator();
                return this.nextCertificate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Certificate nextCertificate() throws DatabaseException {
            Object object = this.g;
            synchronized (object) {
                if (!this.isCertificateIteratorSetup()) {
                    this.setupCertificateIterator();
                }
                if (this.hasMoreCertificates()) {
                    return FlatFileDB.c((File)this.a.elementAt(this.d++));
                }
                this.a = null;
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasMoreCertificates() throws DatabaseException {
            Object object = this.g;
            synchronized (object) {
                if (!this.isCertificateIteratorSetup()) {
                    this.setupCertificateIterator();
                }
                return this.d < this.a.size();
            }
        }

        public int selectCRLByIssuerAndTime(X500Name x500Name, Date date, Vector vector) throws DatabaseException {
            if (x500Name == null || date == null) {
                throw new DatabaseException("FlatFileDB$Implementation.selectCRLByIssuerAndTime: neither issuerName nor time should be null.");
            }
            return Cj.a(this.j, x500Name, date, vector, this.certJ);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCRLIteratorSetup() {
            Object object = this.h;
            synchronized (object) {
                return this.b != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setupCRLIterator() {
            Object object = this.h;
            synchronized (object) {
                this.b = Cj.b(this.j);
                this.e = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CRL firstCRL() throws DatabaseException {
            Object object = this.h;
            synchronized (object) {
                this.setupCRLIterator();
                return this.nextCRL();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CRL nextCRL() throws DatabaseException {
            Object object = this.h;
            synchronized (object) {
                if (!this.isCRLIteratorSetup()) {
                    this.setupCRLIterator();
                }
                if (this.hasMoreCRLs()) {
                    return FlatFileDB.d((File)this.b.elementAt(this.e++));
                }
                this.b = null;
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasMoreCRLs() throws DatabaseException {
            Object object = this.h;
            synchronized (object) {
                if (!this.isCRLIteratorSetup()) {
                    this.setupCRLIterator();
                }
                return this.e < this.b.size();
            }
        }

        public JSAFE_PrivateKey selectPrivateKeyByCertificate(Certificate certificate) throws NotSupportedException, DatabaseException {
            if (certificate == null) {
                throw new DatabaseException("FlatFileDB$Implementation.selectPrivateKeyByCertificate: cert should not be null.");
            }
            try {
                return this.selectPrivateKeyByPublicKey(certificate.getSubjectPublicKey(this.certJ.getDevice()));
            }
            catch (CertificateException certificateException) {
                throw new DatabaseException("FlatFileDB$Implementation.selectPrivateKeyByCertificate: " + certificateException.getMessage());
            }
        }

        public JSAFE_PrivateKey selectPrivateKeyByPublicKey(JSAFE_PublicKey jSAFE_PublicKey) throws DatabaseException {
            if (jSAFE_PublicKey == null) {
                throw new DatabaseException("FlatFileDB$Implementation.selectPrivateKeyByPublicKey: publicKey should not be null.");
            }
            return Cj.a(this.j, jSAFE_PublicKey, FlatFileDB.this.o, this.certJ);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isPrivateKeyIteratorSetup() {
            Object object = this.i;
            synchronized (object) {
                return this.c != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setupPrivateKeyIterator() {
            Object object = this.i;
            synchronized (object) {
                this.c = Cj.c(this.j);
                this.f = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JSAFE_PrivateKey firstPrivateKey() throws DatabaseException {
            Object object = this.i;
            synchronized (object) {
                this.setupPrivateKeyIterator();
                return this.nextPrivateKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JSAFE_PrivateKey nextPrivateKey() throws DatabaseException {
            Object object = this.i;
            synchronized (object) {
                if (!this.isPrivateKeyIteratorSetup()) {
                    this.setupPrivateKeyIterator();
                }
                if (this.hasMorePrivateKeys()) {
                    return FlatFileDB.b((File)this.c.elementAt(this.f++), FlatFileDB.this.o, this.certJ);
                }
                this.c = null;
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasMorePrivateKeys() throws DatabaseException {
            Object object = this.i;
            synchronized (object) {
                if (!this.isPrivateKeyIteratorSetup()) {
                    this.setupPrivateKeyIterator();
                }
                return this.f < this.c.size();
            }
        }

        public void deleteCertificate(X500Name x500Name, byte[] byArray) throws DatabaseException {
            if (x500Name == null || byArray == null) {
                throw new DatabaseException("FlatFileDB$Implementation.deleteCertificate: neither issuerName nor serialNumber is null.");
            }
            Cj.a(this.j, x500Name, byArray, this.certJ);
        }

        public void deleteCRL(X500Name x500Name, Date date) throws DatabaseException {
            if (x500Name == null || date == null) {
                throw new DatabaseException("FlatFileDB$Implementation.deleteCRL: neither issuerName nor lastUpdate should be null.");
            }
            Cj.a(this.j, x500Name, date, this.certJ);
        }

        public void deletePrivateKeyByCertificate(Certificate certificate) throws DatabaseException {
            if (certificate == null) {
                throw new DatabaseException("FlatFileDB$Implementation.deletePrivateKeyByCertificate: cert should not be null.");
            }
            try {
                this.deletePrivateKeyByPublicKey(certificate.getSubjectPublicKey(this.certJ.getDevice()));
            }
            catch (CertificateException certificateException) {
                throw new DatabaseException("FlatFileDB$Implementation.deletePrivateKeyByCertificate: " + certificateException.getMessage());
            }
        }

        public void deletePrivateKeyByPublicKey(JSAFE_PublicKey jSAFE_PublicKey) throws DatabaseException {
            if (jSAFE_PublicKey == null) {
                throw new DatabaseException("FlatFileDB$Implementation.deletePrivateKeyByPublicKey: publicKey should not be null.");
            }
            Cj.b(this.j, jSAFE_PublicKey, FlatFileDB.this.o, this.certJ);
        }

        public String toString() {
            return "Flat File database provider named: " + super.getName();
        }

        /* synthetic */ Implementation(CertJ certJ, String string, Ci ci) throws InvalidParameterException {
            this(certJ, string);
        }
    }
}

