/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs7;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OIDList;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJException;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.attributes.ContentType;
import com.rsa.certj.cert.attributes.MessageDigest;
import com.rsa.certj.cert.attributes.X501Attribute;
import com.rsa.certj.pkcs7.ContentInfo;
import com.rsa.certj.pkcs7.DigestedData;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.pkcs7.SignerInfo;
import com.rsa.certj.provider.db.MemoryDB;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.path.CertPathException;
import com.rsa.certj.spi.random.RandomException;
import com.rsa.jsafe.JSAFE_AsymmetricCipher;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_MessageDigest;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_Signature;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class SignedData
extends ContentInfo
implements Cloneable,
Serializable {
    private static final byte[] a = new byte[]{6, 7, 42, -122, 72, -50, 56, 4, 1};
    private static final byte[] b = new byte[]{6, 7, 42, -122, 72, -50, 56, 4, 3};
    protected static final int CONTENT_INFO_PREFIX_LEN = 4;
    private static final int c = 20;
    protected int version = -1;
    protected Vector digestIDs = new Vector();
    protected Vector digests = new Vector();
    protected Vector digestLengths = new Vector();
    protected Vector digestNames = new Vector();
    protected Vector certs = new Vector();
    protected Vector crls = new Vector();
    protected Vector signers = new Vector();
    private boolean d = false;
    protected boolean preDigestFlag = false;
    private Vector e = new Vector();
    private Vector f = new Vector();
    private Vector g = new Vector();

    public SignedData(CertJ certJ, CertPathCtx certPathCtx) {
        this.contentType = 2;
        this.theCertJ = certJ;
        this.theCertPathCtx = certPathCtx;
    }

    public void setContentInfo(ContentInfo contentInfo) throws PKCS7Exception {
        if (contentInfo == null) {
            throw new PKCS7Exception("Unable to set: content is null.");
        }
        try {
            this.content = (ContentInfo)contentInfo.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new PKCS7Exception("Unable to clone content " + cloneNotSupportedException.getMessage());
        }
    }

    public void setVersionNumber(int n) {
        this.version = n;
    }

    public void setDigest(byte[] byArray, String string) throws PKCS7Exception {
        int n = this.digestNames.indexOf(string);
        if (n == -1) {
            byte[] byArray2 = DigestedData.a(string);
            this.digestIDs.addElement(byArray2);
            this.digestNames.addElement(string);
            this.digests.addElement(byArray);
            this.digestLengths.addElement(new Integer(byArray.length));
        } else {
            this.digests.setElementAt(byArray, n);
            this.digestLengths.setElementAt(new Integer(byArray.length), n);
        }
        this.preDigestFlag = true;
    }

    public int getVersionNumber() {
        return this.version;
    }

    public void addCertificate(X509Certificate x509Certificate) throws PKCS7Exception {
        if (x509Certificate == null) {
            throw new PKCS7Exception("Certificate is null.");
        }
        this.certs.addElement(x509Certificate);
    }

    public Vector getCertificates() throws PKCS7Exception {
        return (Vector)this.certs.clone();
    }

    public Vector getCRLs() throws PKCS7Exception {
        return (Vector)this.crls.clone();
    }

    public void addCRL(X509CRL x509CRL) throws PKCS7Exception {
        if (x509CRL == null) {
            throw new PKCS7Exception("CRL is null.");
        }
        this.crls.addElement(x509CRL);
    }

    public void addSignerInfo(SignerInfo signerInfo) throws PKCS7Exception {
        if (signerInfo == null) {
            throw new PKCS7Exception("Cannot add this Signer Information: it is null.");
        }
        try {
            this.signers.addElement(signerInfo.clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new PKCS7Exception("Cannot add this Signer Information: " + cloneNotSupportedException.getMessage());
        }
    }

    public void createDetachedSignature() {
        this.d = true;
    }

    public Vector getSignerInfos() {
        return (Vector)this.signers.clone();
    }

    protected int getContentDERLen() throws PKCS7Exception {
        return this.a();
    }

    protected int writeContent(byte[] byArray, int n) throws PKCS7Exception {
        if (byArray == null) {
            throw new PKCS7Exception("Specified array is null.");
        }
        try {
            if (this.contentASN1Template == null) {
                this.getContentDERLen();
            }
            int n2 = this.contentASN1Template.derEncode(byArray, n);
            this.contentASN1Template = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            this.contentASN1Template = null;
            throw new PKCS7Exception("Unable to DER encode SignedData message: " + aSN_Exception.getMessage());
        }
    }

    public int estimateContentInfoDERLen() throws PKCS7Exception {
        SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
        EndContainer endContainer = new EndContainer();
        try {
            OIDContainer oIDContainer = new OIDContainer(0x1000000, true, 0, null, 0, 9);
            EncodedContainer encodedContainer = new EncodedContainer(10616576, true, 0, this.maxBufferSize, null, 0, this.estimateContentDERLen());
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
            return new ASN1Template(aSN1ContainerArray).derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("ContentInfo.getASN1Containers: " + aSN_Exception.getMessage());
        }
    }

    protected int estimateContentDERLen() throws PKCS7Exception {
        try {
            int n;
            Object object;
            Object object2;
            Object object3;
            OfContainer ofContainer;
            OfContainer ofContainer2;
            EncodedContainer encodedContainer;
            Vector<Object> vector = new Vector<Object>();
            Iterator iterator = ((AbstractList)this.signers).iterator();
            try {
                while (iterator.hasNext()) {
                    vector.add(((SignerInfo)iterator.next()).clone());
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new PKCS7Exception(cloneNotSupportedException.getMessage());
            }
            if (this.flag == 0) {
                this.a(vector);
            }
            EncodedContainer encodedContainer2 = null;
            EncodedContainer encodedContainer3 = null;
            if (this.digestIDs.size() > 0) {
                encodedContainer = new EncodedContainer(12288, true, 0, null, 0, 0);
                ofContainer2 = new OfContainer(0, true, 0, 12544, (ASN1Container)encodedContainer);
                ofContainer = new Vector();
                ofContainer.addElement(ofContainer2);
                object3 = null;
                for (int i = 0; i < this.digestIDs.size(); ++i) {
                    try {
                        object2 = (byte[])this.digestIDs.elementAt(i);
                        object3 = new EncodedContainer(12288, true, 0, null, 0, ((byte[])object2).length);
                        ofContainer2.addContainer((ASN1Container)object3);
                        continue;
                    }
                    catch (ASN_Exception aSN_Exception) {
                        throw new PKCS7Exception("Unable to encode digest Alg IDs: " + aSN_Exception.getMessage());
                    }
                }
                object = new ASN1Container[ofContainer.size()];
                ofContainer.copyInto((Object[])object);
                object2 = new ASN1Template((ASN1Container[])object);
                n = object2.derEncodeInit();
                object2 = null;
                encodedContainer3 = new EncodedContainer(0, true, 0, null, 0, n);
            } else {
                encodedContainer3 = new EncodedContainer(0, true, 0, null, 0, 2);
            }
            encodedContainer = null;
            if (vector.size() > 0) {
                ofContainer2 = new OfContainer(0, true, 0, 12544, (ASN1Container)new EncodedContainer(12288));
                ofContainer = new Vector();
                ofContainer.addElement(ofContainer2);
                object3 = this.theCertPathCtx.getDatabase();
                if (object3 == null) {
                    throw new PKCS7Exception("database field of theCertPathCtx object cannot be null.");
                }
                for (int i = 0; i < vector.size(); ++i) {
                    try {
                        object2 = (SignerInfo)vector.elementAt(i);
                        n = ((SignerInfo)object2).getDERLen(0);
                        encodedContainer2 = new EncodedContainer(0, true, 0, null, 0, n);
                        ofContainer2.addContainer((ASN1Container)encodedContainer2);
                        continue;
                    }
                    catch (ASN_Exception aSN_Exception) {
                        throw new PKCS7Exception("Unable to encode SignerInfos: " + aSN_Exception.getMessage());
                    }
                }
                object = new ASN1Container[ofContainer.size()];
                ofContainer.copyInto((Object[])object);
                object2 = new ASN1Template((ASN1Container[])object);
                n = object2.derEncodeInit();
                object2 = null;
                encodedContainer = new EncodedContainer(0, true, 0, null, 0, n);
            } else {
                encodedContainer = new EncodedContainer(0, true, 0, null, 0, 2);
            }
            ofContainer2 = null;
            if (this.certs.size() > 0) {
                ofContainer = new OfContainer(0x810000, true, 0, 12544, (ASN1Container)new EncodedContainer(12288));
                object3 = new Vector();
                ((Vector)object3).addElement(ofContainer);
                for (int i = 0; i < this.certs.size(); ++i) {
                    try {
                        object2 = (X509Certificate)this.certs.elementAt(i);
                        n = ((X509Certificate)object2).getDERLen(0);
                        encodedContainer2 = new EncodedContainer(0, true, 0, null, 0, n);
                        ofContainer.addContainer((ASN1Container)encodedContainer2);
                        continue;
                    }
                    catch (ASN_Exception aSN_Exception) {
                        throw new PKCS7Exception("Unable to encode Certificates: " + aSN_Exception.getMessage());
                    }
                }
                object = new ASN1Container[((Vector)object3).size()];
                ((Vector)object3).copyInto((Object[])object);
                object2 = new ASN1Template((ASN1Container[])object);
                n = object2.derEncodeInit();
                object2 = null;
                ofContainer2 = new EncodedContainer(0, true, 0, null, 0, n);
            }
            ofContainer = null;
            if (this.crls.size() > 0) {
                int n2;
                object3 = new OfContainer(0x810001, true, 0, 12544, (ASN1Container)new EncodedContainer(12288));
                object = new Vector();
                ((Vector)object).addElement(object3);
                for (int i = 0; i < this.crls.size(); ++i) {
                    try {
                        X509CRL x509CRL = (X509CRL)this.crls.elementAt(i);
                        n2 = x509CRL.getDERLen(0);
                        encodedContainer2 = new EncodedContainer(0, true, 0, null, 0, n2);
                        object3.addContainer((ASN1Container)encodedContainer2);
                        continue;
                    }
                    catch (ASN_Exception aSN_Exception) {
                        throw new PKCS7Exception("Unable to encode CRLs: " + aSN_Exception.getMessage());
                    }
                }
                object2 = new ASN1Container[((Vector)object).size()];
                ((Vector)object).copyInto((Object[])object2);
                ASN1Template aSN1Template = new ASN1Template((ASN1Container[])object2);
                n2 = aSN1Template.derEncodeInit();
                aSN1Template = null;
                ofContainer = new EncodedContainer(0, true, 0, null, 0, n2);
            }
            object3 = null;
            if (this.content == null && !this.preDigestFlag) {
                throw new PKCS7Exception("Content is NULL.");
            }
            int n3 = 0;
            n3 = this.d ? (this.oid == null ? 13 : this.oid.length + 4) : (this.contentEncoding == null ? this.content.estimateContentInfoDERLen() : this.contentEncoding.length);
            object3 = new EncodedContainer(0, true, 0, null, 0, n3);
            if (this.version == -1) {
                this.version = 1;
            }
            object2 = new SequenceContainer(0xA10000, true, 0);
            EndContainer endContainer = new EndContainer();
            IntegerContainer integerContainer = new IntegerContainer(0, true, 0, this.version);
            if (this.crls.size() > 0) {
                if (this.certs.size() > 0) {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{object2, integerContainer, encodedContainer3, object3, ofContainer2, ofContainer, encodedContainer, endContainer};
                    this.contentASN1Template = new ASN1Template(aSN1ContainerArray);
                } else {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{object2, integerContainer, encodedContainer3, object3, ofContainer, encodedContainer, endContainer};
                    this.contentASN1Template = new ASN1Template(aSN1ContainerArray);
                }
            } else if (this.certs.size() > 0) {
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{object2, integerContainer, encodedContainer3, object3, ofContainer2, encodedContainer, endContainer};
                this.contentASN1Template = new ASN1Template(aSN1ContainerArray);
            } else {
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{object2, integerContainer, encodedContainer3, object3, encodedContainer, endContainer};
                this.contentASN1Template = new ASN1Template(aSN1ContainerArray);
            }
            return this.contentASN1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Could not DER encode SignedData: " + aSN_Exception.getMessage());
        }
    }

    private int a() throws PKCS7Exception {
        try {
            byte[] byArray;
            Object object;
            OfContainer ofContainer;
            OfContainer ofContainer2;
            Object object2;
            Object object3;
            if (this.flag == 0) {
                this.b();
            }
            EncodedContainer encodedContainer = null;
            EncodedContainer encodedContainer2 = null;
            if (this.digestIDs.size() > 0) {
                Object object4;
                object3 = new EncodedContainer(12288, true, 0, null, 0, 0);
                object2 = new OfContainer(0, true, 0, 12544, (ASN1Container)object3);
                ofContainer2 = new Vector();
                ofContainer2.addElement(object2);
                ofContainer = null;
                for (int i = 0; i < this.digestIDs.size(); ++i) {
                    try {
                        object4 = (byte[])this.digestIDs.elementAt(i);
                        ofContainer = new EncodedContainer(12288, true, 0, object4, 0, ((byte[])object4).length);
                        object2.addContainer((ASN1Container)ofContainer);
                        continue;
                    }
                    catch (ASN_Exception aSN_Exception) {
                        throw new PKCS7Exception("Unable to encode digest Alg IDs: " + aSN_Exception.getMessage());
                    }
                }
                object = new ASN1Container[ofContainer2.size()];
                ofContainer2.copyInto((Object[])object);
                object4 = new ASN1Template((ASN1Container[])object);
                int n = object4.derEncodeInit();
                byArray = new byte[n];
                n = object4.derEncode(byArray, 0);
                object4 = null;
                encodedContainer2 = new EncodedContainer(0, true, 0, byArray, 0, n);
            } else {
                object3 = new byte[]{49, 0};
                encodedContainer2 = new EncodedContainer(0, true, 0, (byte[])object3, 0, 2);
            }
            object3 = null;
            if (this.signers.size() > 0) {
                object2 = new OfContainer(0, true, 0, 12544, (ASN1Container)new EncodedContainer(12288));
                ofContainer2 = new Vector();
                ofContainer2.addElement(object2);
                for (int i = 0; i < this.signers.size(); ++i) {
                    try {
                        object = (SignerInfo)this.signers.elementAt(i);
                        int n = ((SignerInfo)object).getDERLen(0);
                        byte[] byArray2 = new byte[n];
                        n = ((SignerInfo)object).getDEREncoding(byArray2, 0, 0);
                        encodedContainer = new EncodedContainer(0, true, 0, byArray2, 0, n);
                        object2.addContainer((ASN1Container)encodedContainer);
                        continue;
                    }
                    catch (ASN_Exception aSN_Exception) {
                        throw new PKCS7Exception("Unable to encode SignerInfos: " + aSN_Exception.getMessage());
                    }
                }
                ofContainer = new ASN1Container[ofContainer2.size()];
                ofContainer2.copyInto((Object[])ofContainer);
                object = new ASN1Template((ASN1Container[])ofContainer);
                int n = object.derEncodeInit();
                byte[] byArray3 = new byte[n];
                n = object.derEncode(byArray3, 0);
                object = null;
                object3 = new EncodedContainer(0, true, 0, byArray3, 0, n);
            } else {
                object2 = new byte[]{49, 0};
                object3 = new EncodedContainer(0, true, 0, (byte[])object2, 0, 2);
            }
            object2 = null;
            if (this.certs.size() > 0) {
                ofContainer2 = new OfContainer(0x810000, true, 0, 12544, (ASN1Container)new EncodedContainer(12288));
                ofContainer = new Vector();
                ofContainer.addElement(ofContainer2);
                for (int i = 0; i < this.certs.size(); ++i) {
                    try {
                        X509Certificate x509Certificate = (X509Certificate)this.certs.elementAt(i);
                        int n = x509Certificate.getDERLen(0);
                        byArray = new byte[n];
                        n = x509Certificate.getDEREncoding(byArray, 0, 0);
                        encodedContainer = new EncodedContainer(0, true, 0, byArray, 0, n);
                        ofContainer2.addContainer((ASN1Container)encodedContainer);
                        continue;
                    }
                    catch (ASN_Exception aSN_Exception) {
                        throw new PKCS7Exception("Unable to encode Certificates: " + aSN_Exception.getMessage());
                    }
                    catch (CertificateException certificateException) {
                        throw new PKCS7Exception("Unable to encode Certificates: " + certificateException.getMessage());
                    }
                }
                object = new ASN1Container[ofContainer.size()];
                ofContainer.copyInto((Object[])object);
                ASN1Template aSN1Template = new ASN1Template((ASN1Container[])object);
                int n = aSN1Template.derEncodeInit();
                byArray = new byte[n];
                n = aSN1Template.derEncode(byArray, 0);
                aSN1Template = null;
                object2 = new EncodedContainer(0, true, 0, byArray, 0, n);
            }
            ofContainer2 = null;
            if (this.crls.size() > 0) {
                byte[] byArray4;
                ofContainer = new OfContainer(0x810001, true, 0, 12544, (ASN1Container)new EncodedContainer(12288));
                object = new Vector();
                ((Vector)object).addElement(ofContainer);
                for (int i = 0; i < this.crls.size(); ++i) {
                    try {
                        X509CRL x509CRL = (X509CRL)this.crls.elementAt(i);
                        int n = x509CRL.getDERLen(0);
                        byArray4 = new byte[n];
                        n = x509CRL.getDEREncoding(byArray4, 0, 0);
                        encodedContainer = new EncodedContainer(0, true, 0, byArray4, 0, n);
                        ofContainer.addContainer((ASN1Container)encodedContainer);
                        continue;
                    }
                    catch (ASN_Exception aSN_Exception) {
                        throw new PKCS7Exception("Unable to encode CRLs: " + aSN_Exception.getMessage());
                    }
                    catch (CertificateException certificateException) {
                        throw new PKCS7Exception("Unable to encode CRLs: " + certificateException.getMessage());
                    }
                }
                Object[] objectArray = new ASN1Container[((Vector)object).size()];
                ((Vector)object).copyInto(objectArray);
                ASN1Template aSN1Template = new ASN1Template((ASN1Container[])objectArray);
                int n = aSN1Template.derEncodeInit();
                byArray4 = new byte[n];
                n = aSN1Template.derEncode(byArray4, 0);
                aSN1Template = null;
                ofContainer2 = new EncodedContainer(0, true, 0, byArray4, 0, n);
            }
            ofContainer = null;
            if (this.content == null && !this.preDigestFlag) {
                throw new PKCS7Exception("Content is NULL.");
            }
            if (this.d) {
                this.assignDetachedMessageContentInfoSeq();
            } else if (this.contentEncoding == null) {
                int n = this.content.getContentInfoDERLen();
                this.contentEncoding = new byte[n];
                n = this.content.writeMessage(this.contentEncoding, 0);
            }
            ofContainer = new EncodedContainer(0, true, 0, this.contentEncoding, 0, this.contentEncoding.length);
            if (this.version == -1) {
                this.version = 1;
            }
            SequenceContainer sequenceContainer = new SequenceContainer(0xA10000, true, 0);
            EndContainer endContainer = new EndContainer();
            IntegerContainer integerContainer = new IntegerContainer(0, true, 0, this.version);
            if (this.crls.size() > 0) {
                if (this.certs.size() > 0) {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer2, ofContainer, object2, ofContainer2, object3, endContainer};
                    this.contentASN1Template = new ASN1Template(aSN1ContainerArray);
                } else {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer2, ofContainer, ofContainer2, object3, endContainer};
                    this.contentASN1Template = new ASN1Template(aSN1ContainerArray);
                }
            } else if (this.certs.size() > 0) {
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer2, ofContainer, object2, object3, endContainer};
                this.contentASN1Template = new ASN1Template(aSN1ContainerArray);
            } else {
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer2, ofContainer, object3, endContainer};
                this.contentASN1Template = new ASN1Template(aSN1ContainerArray);
            }
            return this.contentASN1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Could not DER encode SignedData: " + aSN_Exception.getMessage());
        }
    }

    protected void assignDetachedMessageContentInfoSeq() {
        this.contentEncoding = new byte[13];
        this.contentEncoding[0] = 48;
        this.contentEncoding[1] = 11;
        this.contentEncoding[2] = 6;
        this.contentEncoding[3] = 9;
        System.arraycopy(ContentInfo.a, 0, this.contentEncoding, 4, 9);
        this.contentEncoding[12] = this.preDigestFlag ? (byte)1 : (byte)this.content.getContentType();
    }

    protected void digestContentData(int n) throws PKCS7Exception {
        Object[] objectArray;
        String string;
        Object object;
        EndContainer endContainer;
        Object object2;
        byte[] byArray = null;
        try {
            if (!this.preDigestFlag) {
                if (this.contentEncoding == null) {
                    if (this.content == null) {
                        throw new PKCS7Exception("There is no content to sign.");
                    }
                    int n2 = this.content.getContentInfoDERLen();
                    this.contentEncoding = new byte[n2];
                    n2 = this.content.writeMessage(this.contentEncoding, 0);
                }
                object2 = new SequenceContainer(0);
                endContainer = new EndContainer();
                object = new OIDContainer(0x1000000);
                string = new EncodedContainer(10616576);
                objectArray = new ASN1Container[]{object2, object, string, endContainer};
                ASN1.berDecode((byte[])this.contentEncoding, (int)0, (ASN1Container[])objectArray);
                byArray = ((ASN1Container)string).dataPresent ? this.initOctets((ASN1Container)object, (ASN1Container)string) : new byte[]{};
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Could not DER encode ContentInfo: " + aSN_Exception.getMessage());
        }
        object2 = null;
        try {
            if (n == 0) {
                endContainer = this.signers.elements();
                while (endContainer.hasMoreElements()) {
                    object = (SignerInfo)endContainer.nextElement();
                    string = object.getDigestAlgorithmName();
                    if (string == null) {
                        throw new PKCS7Exception("Could not DER encode ContentInfo: Signer's digest algorithm is not set.");
                    }
                    this.a(object.getDigestAlgorithmOID(), string);
                }
            }
            if (byArray == null) {
                return;
            }
            if (!this.preDigestFlag) {
                for (int i = 0; i < this.digestIDs.size(); ++i) {
                    object = (byte[])this.digestIDs.elementAt(i);
                    string = JSAFE_MessageDigest.getInstance((byte[])object, (int)0, (String)this.getDeviceOrJava());
                    objectArray = (byte[])this.digests.elementAt(i);
                    if (objectArray != null) continue;
                    int n3 = string.getDigestSize();
                    object2 = new byte[n3];
                    string.digestInit();
                    string.digestUpdate(byArray, 0, byArray.length);
                    object2 = string.digestFinal();
                    string.clearSensitiveData();
                    this.digests.setElementAt(object2, i);
                    this.digestLengths.setElementAt(new Integer(((SequenceContainer)object2).length), i);
                }
            }
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new PKCS7Exception("Could not digest ContentInfo: " + jSAFE_Exception.getMessage());
        }
    }

    protected byte[] initOctets(ASN1Container aSN1Container, ASN1Container aSN1Container2) throws ASN_Exception {
        byte[] byArray = null;
        if (CertJUtils.byteArraysEqual(aSN1Container.data, aSN1Container.dataOffset, aSN1Container.dataLen - 1, ContentInfo.a, 0, ContentInfo.a.length - 1)) {
            switch (aSN1Container.data[aSN1Container.dataOffset + aSN1Container.dataLen - 1]) {
                case 1: {
                    byArray = this.initDataOctets(aSN1Container, aSN1Container2);
                    break;
                }
                default: {
                    int n = 1;
                    n += ASN1Lengths.determineLengthLen((byte[])aSN1Container2.data, (int)(aSN1Container2.dataOffset + 1));
                    ++n;
                    n += ASN1Lengths.determineLengthLen((byte[])aSN1Container2.data, (int)(aSN1Container2.dataOffset + n));
                    byArray = new byte[aSN1Container2.dataLen - n];
                    System.arraycopy(aSN1Container2.data, aSN1Container2.dataOffset + n, byArray, 0, aSN1Container2.dataLen - n);
                }
            }
        }
        return byArray;
    }

    protected byte[] initDataOctets(ASN1Container aSN1Container, ASN1Container aSN1Container2) throws ASN_Exception {
        byte[] byArray = null;
        OctetStringContainer octetStringContainer = new OctetStringContainer(0xA10000, true, 0, aSN1Container2.data, aSN1Container2.dataOffset, aSN1Container2.dataLen);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{octetStringContainer};
        ASN1.berDecode((byte[])aSN1Container2.data, (int)aSN1Container2.dataOffset, (ASN1Container[])aSN1ContainerArray);
        if (octetStringContainer.data == null || octetStringContainer.dataLen == 0) {
            byArray = new byte[]{};
            return byArray;
        }
        byArray = new byte[octetStringContainer.dataLen];
        System.arraycopy(octetStringContainer.data, octetStringContainer.dataOffset, byArray, 0, octetStringContainer.dataLen);
        return byArray;
    }

    protected void estimateDigestLens() throws PKCS7Exception {
        Object object;
        Enumeration enumeration = this.signers.elements();
        while (enumeration.hasMoreElements()) {
            object = (SignerInfo)enumeration.nextElement();
            this.a(((SignerInfo)object).getDigestAlgorithmOID(), ((SignerInfo)object).getDigestAlgorithmName());
        }
        if (!this.preDigestFlag) {
            for (int i = 0; i < this.digestIDs.size(); ++i) {
                object = (byte[])this.digestIDs.elementAt(i);
                JSAFE_MessageDigest jSAFE_MessageDigest = null;
                try {
                    jSAFE_MessageDigest = JSAFE_MessageDigest.getInstance((byte[])object, (int)0, (String)this.getDeviceOrJava());
                }
                catch (JSAFE_Exception jSAFE_Exception) {
                    throw new PKCS7Exception("Could not digest ContentInfo: " + jSAFE_Exception.getMessage());
                }
                int n = jSAFE_MessageDigest.getDigestSize();
                this.digestLengths.setElementAt(new Integer(n), i);
            }
        }
    }

    private void a(byte[] byArray, String string) throws PKCS7Exception {
        if (byArray == null) {
            throw new PKCS7Exception("Cannot add digest algorithm. Digest OID is null.");
        }
        if (string == null) {
            string = DigestedData.a(byArray, null);
        }
        if (!this.digestNames.contains(string)) {
            this.digestNames.addElement(string);
            this.digestIDs.addElement(byArray);
            this.digests.addElement(null);
            this.digestLengths.addElement(null);
        }
    }

    private void a(Vector vector) throws PKCS7Exception {
        this.estimateDigestLens();
        if (vector.size() == 0) {
            return;
        }
        if (this.theCertJ == null) {
            throw new PKCS7Exception("CertJ object cannot be null.");
        }
        if (this.theCertPathCtx == null) {
            throw new PKCS7Exception("CertPathCtx object cannot be null.");
        }
        DatabaseService databaseService = this.theCertPathCtx.getDatabase();
        if (databaseService == null) {
            throw new PKCS7Exception("database field of theCertPathCtx object cannot be null.");
        }
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            int n = 0;
            SignerInfo signerInfo = (SignerInfo)vector.elementAt(i);
            this.a(signerInfo);
            String string = signerInfo.getEncryptionAlgorithmName();
            if ("DSA".equals(string)) {
                n = 48;
            }
            if (n == 0) {
                Cloneable cloneable;
                object = null;
                Enumeration enumeration = this.certs.elements();
                while (enumeration.hasMoreElements()) {
                    cloneable = (X509Certificate)enumeration.nextElement();
                    if (!((X509Certificate)cloneable).getIssuerName().equals(signerInfo.getIssuerName()) || !CertJUtils.byteArraysEqual(((X509Certificate)cloneable).getSerialNumber(), signerInfo.getSerialNumber())) continue;
                    object = cloneable;
                    break;
                }
                if (object == null) {
                    int n2;
                    cloneable = new Vector();
                    try {
                        n2 = databaseService.selectCertificateByIssuerAndSerialNumber(signerInfo.getIssuerName(), signerInfo.getSerialNumber(), (Vector)cloneable);
                    }
                    catch (NoServiceException noServiceException) {
                        throw new PKCS7Exception("Could not estimate SignedData length: " + noServiceException.getMessage());
                    }
                    catch (DatabaseException databaseException) {
                        throw new PKCS7Exception("Cannot get Cert from DB: " + databaseException.getMessage());
                    }
                    if (n2 == 0) {
                        throw new PKCS7Exception("Certificate is missing.");
                    }
                    object = (X509Certificate)((Vector)cloneable).elementAt(0);
                }
                try {
                    cloneable = object.getSubjectPublicKey("Java");
                    n = cloneable.getKeyData()[0].length;
                }
                catch (CertificateException certificateException) {
                    throw new PKCS7Exception("Cannot estimate signature lenght: " + certificateException.getMessage());
                }
            }
            object = new byte[n];
            signerInfo.setEncryptedDigest((byte[])object, 0, ((byte[])object).length);
        }
    }

    private void a(SignerInfo signerInfo) throws PKCS7Exception {
        if (signerInfo == null) {
            throw new PKCS7Exception("Cannot set SignerDigest: SignerInfo is null");
        }
        String string = signerInfo.getDigestAlgorithmName();
        if (string == null) {
            throw new PKCS7Exception("Signer's digest algorithm is not set.");
        }
        int n = this.digestNames.indexOf(string);
        Integer n2 = (Integer)this.digestLengths.elementAt(n);
        if (n2 == null) {
            throw new PKCS7Exception("Cannot determine digest length");
        }
        X501Attributes x501Attributes = signerInfo.getAuthenticatedAttrs();
        if (x501Attributes != null || this.content != null && this.content.getContentType() != 1) {
            ContentType contentType;
            if (x501Attributes == null) {
                x501Attributes = new X501Attributes();
            }
            if ((contentType = (ContentType)x501Attributes.getAttributeByType(14)) == null) {
                contentType = new ContentType();
            }
            int n3 = this.preDigestFlag ? 1 : this.content.getContentType();
            byte[] byArray = new byte[9];
            System.arraycopy(ContentInfo.a, 0, byArray, 0, 9);
            byArray[8] = (byte)n3;
            contentType.setContentType(byArray, 0, 9);
            x501Attributes.addAttribute(contentType);
            MessageDigest messageDigest = (MessageDigest)x501Attributes.getAttributeByType(15);
            if (messageDigest == null) {
                messageDigest = new MessageDigest();
            }
            byte[] byArray2 = new byte[n2.intValue()];
            messageDigest.setMessageDigest(byArray2, 0, byArray2.length);
            x501Attributes.addAttribute(messageDigest);
            signerInfo.setAuthenticatedAttrs(x501Attributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void b() throws PKCS7Exception {
        this.digestContentData(0);
        if (this.signers.size() == 0) {
            return;
        }
        if (this.theCertJ == null) {
            throw new PKCS7Exception("CertJ object cannot be null.");
        }
        if (this.theCertPathCtx == null) {
            throw new PKCS7Exception("CertPathCtx object cannot be null.");
        }
        DatabaseService databaseService = this.theCertPathCtx.getDatabase();
        if (databaseService == null) {
            throw new PKCS7Exception("database field of theCertPathCtx object cannot be null.");
        }
        DatabaseService databaseService2 = null;
        MemoryDB memoryDB = null;
        String string = null;
        try {
            if (this.certs.size() > 0) {
                memoryDB = this.a("Temp Memory DB", this.certs, null);
                string = memoryDB.getName();
                databaseService2 = this.a(databaseService, string);
            }
            DatabaseService databaseService3 = databaseService2 == null ? databaseService : databaseService2;
            for (int i = 0; i < this.signers.size(); ++i) {
                try {
                    X509Certificate x509Certificate;
                    Object object;
                    SignerInfo signerInfo = (SignerInfo)this.signers.elementAt(i);
                    byte[] byArray = this.getSignerDigest(signerInfo, 0);
                    byte[] byArray2 = signerInfo.getDigestAlgorithmOID();
                    if (byArray2 == null) {
                        throw new PKCS7Exception("Signer's digest algorithm is missing.");
                    }
                    byte[] byArray3 = this.a(byArray2, byArray);
                    byte[] byArray4 = signerInfo.getEncryptionAlgorithmOID();
                    if (byArray4 == null) {
                        throw new PKCS7Exception("Signer's encryption algorithm is missing.");
                    }
                    String string2 = null;
                    try {
                        object = JSAFE_AsymmetricCipher.getInstance((byte[])byArray4, (int)0, (String)"Java");
                        string2 = object.getEncryptionAlgorithm();
                        string2 = "NoDigest/" + string2 + "/PKCS1Block01Pad";
                    }
                    catch (JSAFE_Exception jSAFE_Exception) {
                        JSAFE_Signature jSAFE_Signature = JSAFE_Signature.getInstance((byte[])byArray4, (int)0, (String)"Java");
                        string2 = jSAFE_Signature.getSignatureAlgorithm();
                        if ("DSA".equals(string2)) {
                            string2 = "NoDigest/" + string2 + "/NoPad";
                            byArray3 = new byte[byArray.length];
                            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                        }
                        string2 = "NoDigest/" + string2 + "/PKCS1Block01Pad";
                    }
                    object = new Vector();
                    int n = databaseService3.selectCertificateByIssuerAndSerialNumber(signerInfo.getIssuerName(), signerInfo.getSerialNumber(), (Vector)object);
                    if (n == 0) {
                        throw new PKCS7Exception("Certificate is missing.");
                    }
                    JSAFE_PrivateKey jSAFE_PrivateKey = null;
                    for (int j = 0; j < n && (jSAFE_PrivateKey = databaseService3.selectPrivateKeyByCertificate(x509Certificate = (X509Certificate)((Vector)object).elementAt(j))) == null; ++j) {
                    }
                    if (jSAFE_PrivateKey == null) {
                        throw new PKCS7Exception("Private key is missing.");
                    }
                    JSAFE_Signature jSAFE_Signature = JSAFE_Signature.getInstance((String)string2, (String)this.getDeviceOrJava());
                    x509Certificate = this.theCertJ.getRandomObject();
                    jSAFE_Signature.signInit(jSAFE_PrivateKey, null, (SecureRandom)((Object)x509Certificate), this.theCertJ.getPKCS11Sessions());
                    int n2 = jSAFE_Signature.getMaxInputLen();
                    if (byArray3.length > n2) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("Signer key too small for digest info being signed. Digest info length: ");
                        stringBuffer.append(byArray3.length);
                        stringBuffer.append(". Max length given key size: ");
                        stringBuffer.append(n2);
                        throw new PKCS7Exception(stringBuffer.toString());
                    }
                    int n3 = jSAFE_Signature.getSignatureSize();
                    byte[] byArray5 = new byte[n3];
                    jSAFE_Signature.signUpdate(byArray3, 0, byArray3.length);
                    n3 = jSAFE_Signature.signFinal(byArray5, 0);
                    if (jSAFE_Signature.getSignatureAlgorithm().equals("DSA")) {
                        byArray5 = this.f(byArray5, 0, n3);
                    }
                    signerInfo.setEncryptedDigest(byArray5, 0, byArray5.length);
                    ((Vector)object).removeAllElements();
                    jSAFE_Signature.clearSensitiveData();
                    jSAFE_PrivateKey.clearSensitiveData();
                    continue;
                }
                catch (JSAFE_Exception jSAFE_Exception) {
                    throw new PKCS7Exception("Could not sign ContentInfo: " + jSAFE_Exception.getMessage());
                }
                catch (RandomException randomException) {
                    throw new PKCS7Exception("Could not sign ContentInfo: " + randomException.getMessage());
                }
                catch (NoServiceException noServiceException) {
                    throw new PKCS7Exception("Could not sign ContentInfo: " + noServiceException.getMessage());
                }
                catch (DatabaseException databaseException) {
                    throw new PKCS7Exception("Cannot get Cert from DB: " + databaseException.getMessage());
                }
            }
            Object var22_29 = null;
            if (databaseService2 != null) {
                this.theCertJ.unbindService(databaseService2);
            }
            if (memoryDB == null) return;
        }
        catch (Throwable throwable) {
            Object var22_30 = null;
            if (databaseService2 != null) {
                this.theCertJ.unbindService(databaseService2);
            }
            if (memoryDB == null) throw throwable;
            try {
                this.theCertJ.unregisterService(1, string);
                throw throwable;
            }
            catch (InvalidParameterException invalidParameterException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.theCertJ.unregisterService(1, string);
            return;
        }
        catch (InvalidParameterException invalidParameterException) {}
    }

    protected byte[] getSignerDigest(SignerInfo signerInfo, int n) throws PKCS7Exception {
        if (signerInfo == null) {
            throw new PKCS7Exception("Cannot set SignerDigest: SignerInfo is null");
        }
        byte[] byArray = null;
        try {
            String string = signerInfo.getDigestAlgorithmName();
            if (string == null) {
                throw new PKCS7Exception("Signer's digest algorithm is not set.");
            }
            int n2 = this.digestNames.indexOf(string);
            byArray = (byte[])this.digests.elementAt(n2);
            byte[] byArray2 = (byte[])this.digestIDs.elementAt(n2);
            JSAFE_MessageDigest jSAFE_MessageDigest = JSAFE_MessageDigest.getInstance((byte[])byArray2, (int)0, (String)"Java");
            X501Attributes x501Attributes = signerInfo.getAuthenticatedAttrs();
            if (x501Attributes != null || this.content != null && this.content.getContentType() != 1) {
                int n3;
                Object object;
                X501Attribute x501Attribute;
                if (x501Attributes == null) {
                    x501Attributes = new X501Attributes();
                }
                if ((x501Attribute = x501Attributes.getAttributeByType(14)) == null) {
                    if (n == 1) {
                        throw new PKCS7Exception("While decoding, ContentType attribute is missing");
                    }
                    x501Attribute = new ContentType();
                }
                if (n == 0) {
                    object = this.getOidType();
                    ((ContentType)x501Attribute).setContentType((byte[])object, 0, ((byte[])object).length);
                    x501Attributes.addAttribute(x501Attribute);
                }
                if ((object = (Object)x501Attributes.getAttributeByType(15)) == null) {
                    if (n == 1) {
                        throw new PKCS7Exception("While decoding, MessageDigest attribute is missing");
                    }
                    object = new MessageDigest();
                }
                if (n == 0) {
                    if (byArray != null) {
                        ((MessageDigest)object).setMessageDigest(byArray, 0, byArray.length);
                    }
                    x501Attributes.addAttribute((X501Attribute)object);
                    signerInfo.setAuthenticatedAttrs(x501Attributes);
                } else {
                    byte[] byArray3 = ((MessageDigest)object).getMessageDigest();
                    if (!CertJUtils.byteArraysEqual(byArray3, byArray)) {
                        throw new PKCS7Exception("Value in MessageDigest attribute does not contain the right digest.");
                    }
                }
                byte[] byArray4 = signerInfo.getAuthenticatedAttrsBer();
                if (byArray4 == null) {
                    byArray4 = new byte[x501Attributes.getDERLen(0)];
                    n3 = x501Attributes.getDEREncoding(byArray4, 0, 0);
                } else {
                    n3 = byArray4.length;
                }
                int n4 = jSAFE_MessageDigest.getDigestSize();
                byArray = new byte[n4];
                jSAFE_MessageDigest.digestInit();
                jSAFE_MessageDigest.digestUpdate(byArray4, 0, n3);
                byArray = jSAFE_MessageDigest.digestFinal();
                jSAFE_MessageDigest.clearSensitiveData();
            }
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new PKCS7Exception("Could not digest ContentInfo: " + jSAFE_Exception.getMessage());
        }
        catch (AttributeException attributeException) {
            throw new PKCS7Exception("Could not DER encode Attributes: " + attributeException.getMessage());
        }
        return byArray;
    }

    protected byte[] getOidType() {
        int n = this.preDigestFlag ? 1 : this.content.getContentType();
        byte[] byArray = new byte[9];
        System.arraycopy(ContentInfo.a, 0, byArray, 0, 9);
        byArray[8] = (byte)n;
        return byArray;
    }

    private byte[] a(byte[] byArray) throws PKCS7Exception {
        byte[] byArray2;
        SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
        EndContainer endContainer = new EndContainer();
        EncodedContainer encodedContainer = new EncodedContainer(65536);
        OIDContainer oIDContainer = new OIDContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
        OIDList.getTrans((byte[])byArray, (int)0, (int)byArray.length, (int)-1);
        try {
            ASN1.berDecode((byte[])byArray, (int)0, (ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Cannot decode algorithm OID: " + aSN_Exception.getMessage());
        }
        if (encodedContainer.data == null) {
            byte[] byArray3 = new byte[]{5, 0};
            try {
                encodedContainer.addData(byArray3, 0, byArray3.length, true, true);
                byArray2 = ASN1.derEncode((ASN1Container[])aSN1ContainerArray);
            }
            catch (ASN_Exception aSN_Exception) {
                throw new PKCS7Exception("Cannot encode algorithm OID: " + aSN_Exception.getMessage());
            }
        } else {
            byArray2 = byArray;
        }
        return byArray2;
    }

    private byte[] a(byte[] byArray, byte[] byArray2) throws PKCS7Exception {
        if (byArray == null) {
            throw new PKCS7Exception("DigestAlgorithm OID is null.");
        }
        try {
            byte[] byArray3 = this.a(byArray);
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            EndContainer endContainer = new EndContainer();
            EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, byArray3, 0, byArray3.length);
            int n = 0;
            if (byArray2 != null) {
                n = byArray2.length;
            }
            OctetStringContainer octetStringContainer = new OctetStringContainer(0, true, 0, byArray2, 0, n);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, octetStringContainer, endContainer};
            ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray);
            int n2 = aSN1Template.derEncodeInit();
            byte[] byArray4 = new byte[n2];
            aSN1Template.derEncode(byArray4, 0);
            return byArray4;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Cannot encode digestInfo: " + aSN_Exception.getMessage());
        }
    }

    protected boolean contentReadInit(byte[] byArray, int n, int n2) throws PKCS7Exception {
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0xA10000);
            EndContainer endContainer = new EndContainer();
            IntegerContainer integerContainer = new IntegerContainer(0);
            EncodedContainer encodedContainer = new EncodedContainer(12544);
            EncodedContainer encodedContainer2 = new EncodedContainer(12288, true, 0, this.maxBufferSize, null, 0, 0);
            EncodedContainer encodedContainer3 = new EncodedContainer(8466688);
            EncodedContainer encodedContainer4 = new EncodedContainer(8466689);
            EncodedContainer encodedContainer5 = new EncodedContainer(12544);
            this.contentASN1Def = new ASN1Container[8];
            this.contentASN1Def[0] = sequenceContainer;
            this.contentASN1Def[1] = integerContainer;
            this.contentASN1Def[2] = encodedContainer;
            this.contentASN1Def[3] = encodedContainer2;
            this.contentASN1Def[4] = encodedContainer3;
            this.contentASN1Def[5] = encodedContainer4;
            this.contentASN1Def[6] = encodedContainer5;
            this.contentASN1Def[7] = endContainer;
            this.contentASN1Template = new ASN1Template(this.contentASN1Def);
            this.contentASN1Template.berDecodeInit();
            this.contentASN1Template.berDecodeUpdate(byArray, n, n2);
            if (this.contentASN1Def[0].checkTag()) {
                return false;
            }
            this.c();
            this.flag = 1;
            return true;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Could not decode message: " + aSN_Exception.getMessage());
        }
    }

    private void c() throws PKCS7Exception {
        try {
            byte[] byArray;
            if (this.version == -1) {
                if (this.contentASN1Def[1].isComplete()) {
                    if (this.incompleteContainer == 1) {
                        byArray = this.copyToOutput(this.contentASN1Def[1]);
                        IntegerContainer integerContainer = new IntegerContainer(0, true, 0, byArray, 0, byArray.length, true);
                        this.version = integerContainer.getValueAsInt();
                    } else {
                        this.version = ((IntegerContainer)this.contentASN1Def[1]).getValueAsInt();
                    }
                } else {
                    if (this.contentASN1Def[1].data == null) {
                        return;
                    }
                    this.incompleteContainer = 1;
                    this.copyNewData(this.contentASN1Def[1].data, this.contentASN1Def[1].dataOffset, this.contentASN1Def[1].dataLen, 0);
                    return;
                }
            }
            if (this.digestIDs.size() == 0) {
                if (!this.contentASN1Def[2].isComplete()) {
                    if (this.contentASN1Def[2].data == null) {
                        return;
                    }
                    this.incompleteContainer = 2;
                    this.copyNewData(this.contentASN1Def[2].data, this.contentASN1Def[2].dataOffset, this.contentASN1Def[2].dataLen, 0);
                    return;
                }
                if (this.incompleteContainer == 2) {
                    byArray = this.copyToOutput(this.contentASN1Def[2]);
                    this.a(byArray, 0, byArray.length);
                } else {
                    this.a(this.contentASN1Def[2].data, this.contentASN1Def[2].dataOffset, this.contentASN1Def[2].dataLen);
                }
            }
            if (this.content == null) {
                if (this.contentASN1Def[3].isComplete()) {
                    if (this.incompleteContainer == 3) {
                        byArray = this.copyToOutput(this.contentASN1Def[3]);
                        this.decodeContent(byArray, 0, byArray.length);
                    } else {
                        this.decodeContent(this.contentASN1Def[3].data, this.contentASN1Def[3].dataOffset, this.contentASN1Def[3].dataLen);
                    }
                } else {
                    if (this.contentASN1Def[3].data == null) {
                        return;
                    }
                    this.incompleteContainer = 3;
                    this.copyNewData(this.contentASN1Def[3].data, this.contentASN1Def[3].dataOffset, this.contentASN1Def[3].dataLen, this.maxBufferSize);
                    return;
                }
            }
            if (this.f()) {
                this.digestContentData(1);
            }
            if (this.certs.size() == 0) {
                if (this.contentASN1Def[4].isComplete()) {
                    if (this.contentASN1Def[4].dataPresent) {
                        if (this.incompleteContainer == 4) {
                            byArray = this.copyToOutput(this.contentASN1Def[4]);
                            this.b(byArray, 0, byArray.length);
                        } else {
                            this.b(this.contentASN1Def[4].data, this.contentASN1Def[4].dataOffset, this.contentASN1Def[4].dataLen);
                        }
                    }
                } else {
                    if (this.contentASN1Def[4].data == null) {
                        return;
                    }
                    this.incompleteContainer = 4;
                    this.copyNewData(this.contentASN1Def[4].data, this.contentASN1Def[4].dataOffset, this.contentASN1Def[4].dataLen, 0);
                    return;
                }
            }
            if (this.crls.size() == 0) {
                if (this.contentASN1Def[5].isComplete()) {
                    if (this.contentASN1Def[5].dataPresent) {
                        if (this.incompleteContainer == 5) {
                            byArray = this.copyToOutput(this.contentASN1Def[5]);
                            this.c(byArray, 0, byArray.length);
                        } else {
                            this.c(this.contentASN1Def[5].data, this.contentASN1Def[5].dataOffset, this.contentASN1Def[5].dataLen);
                        }
                    }
                } else {
                    if (this.contentASN1Def[5].data == null) {
                        return;
                    }
                    this.incompleteContainer = 5;
                    this.copyNewData(this.contentASN1Def[5].data, this.contentASN1Def[5].dataOffset, this.contentASN1Def[5].dataLen, 0);
                    return;
                }
            }
            if (this.signers.size() == 0) {
                if (this.contentASN1Def[6].isComplete()) {
                    if (this.incompleteContainer == 6) {
                        byArray = this.copyToOutput(this.contentASN1Def[6]);
                        this.d(byArray, 0, byArray.length);
                    } else {
                        this.d(this.contentASN1Def[6].data, this.contentASN1Def[6].dataOffset, this.contentASN1Def[6].dataLen);
                    }
                } else {
                    if (this.contentASN1Def[6].data == null) {
                        return;
                    }
                    this.incompleteContainer = 6;
                    this.copyNewData(this.contentASN1Def[6].data, this.contentASN1Def[6].dataOffset, this.contentASN1Def[6].dataLen, 0);
                    return;
                }
            }
            if (this.signers.size() > 0) {
                this.d();
            }
        }
        catch (Exception exception) {
            throw new PKCS7Exception("Cannot set decoded values: " + exception.getMessage());
        }
    }

    private void a(byte[] byArray, int n, int n2) throws PKCS7Exception {
        if (byArray == null) {
            throw new PKCS7Exception("Digest OIDs data is null.");
        }
        try {
            OfContainer ofContainer = new OfContainer(0, 12544, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            int n3 = ofContainer.getContainerCount();
            for (int i = 0; i < n3; ++i) {
                ASN1Container aSN1Container = ofContainer.containerAt(i);
                EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, null, 0, 0);
                ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{encodedContainer};
                ASN1.berDecode((byte[])aSN1Container.data, (int)aSN1Container.dataOffset, (ASN1Container[])aSN1ContainerArray2);
                byte[] byArray2 = new byte[encodedContainer.dataLen];
                System.arraycopy(encodedContainer.data, encodedContainer.dataOffset, byArray2, 0, encodedContainer.dataLen);
                this.a(byArray2, (String)null);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Cannot decode digest OIDs: " + aSN_Exception.getMessage());
        }
    }

    protected void decodeContent(byte[] byArray, int n, int n2) throws PKCS7Exception {
        if (byArray == null) {
            throw new PKCS7Exception("Content data is null.");
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0);
            EndContainer endContainer = new EndContainer();
            OIDContainer oIDContainer = new OIDContainer(0x1000000);
            EncodedContainer encodedContainer = new EncodedContainer(10616576, true, 0, this.maxBufferSize, null, 0, 0);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            this.content = this.buildContentContainer(oIDContainer.data, oIDContainer.dataOffset, oIDContainer.dataLen);
            if (this.content.readInit(byArray, n, n2, this.maxBufferSize) && this.content.readFinal()) {
                return;
            }
        }
        catch (Exception exception) {
            throw new PKCS7Exception("Cannot decode content: " + exception.getMessage());
        }
        throw new PKCS7Exception("Cannot decode content.");
    }

    protected ContentInfo buildContentContainer(byte[] byArray, int n, int n2) throws PKCS7Exception {
        return ContentInfo.getInstance(byArray, n, n2, this.theCertJ, this.theCertPathCtx);
    }

    private void b(byte[] byArray, int n, int n2) throws PKCS7Exception {
        if (byArray == null) {
            throw new PKCS7Exception("Certs data is null.");
        }
        try {
            OfContainer ofContainer = new OfContainer(0x810000, 12544, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            int n3 = ofContainer.getContainerCount();
            for (int i = 0; i < n3; ++i) {
                ASN1Container aSN1Container = ofContainer.containerAt(i);
                X509Certificate x509Certificate = new X509Certificate(aSN1Container.data, aSN1Container.dataOffset, 0);
                this.addCertificate(x509Certificate);
            }
        }
        catch (Exception exception) {
            throw new PKCS7Exception("Cannot decode certs: " + exception.getMessage());
        }
    }

    private void c(byte[] byArray, int n, int n2) throws PKCS7Exception {
        if (byArray == null) {
            throw new PKCS7Exception("CRLs data is null.");
        }
        try {
            OfContainer ofContainer = new OfContainer(0x810001, 12544, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            int n3 = ofContainer.getContainerCount();
            for (int i = 0; i < n3; ++i) {
                ASN1Container aSN1Container = ofContainer.containerAt(i);
                X509CRL x509CRL = new X509CRL(aSN1Container.data, aSN1Container.dataOffset, 0);
                this.addCRL(x509CRL);
            }
        }
        catch (Exception exception) {
            throw new PKCS7Exception("Cannot decode crls: " + exception.getMessage());
        }
    }

    private void d(byte[] byArray, int n, int n2) throws PKCS7Exception {
        if (byArray == null) {
            throw new PKCS7Exception("SignerInfo data is null.");
        }
        try {
            OfContainer ofContainer = new OfContainer(0, 12544, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            int n3 = ofContainer.getContainerCount();
            for (int i = 0; i < n3; ++i) {
                ASN1Container aSN1Container = ofContainer.containerAt(i);
                SignerInfo signerInfo = new SignerInfo(aSN1Container.data, aSN1Container.dataOffset, 0);
                this.addSignerInfo(signerInfo);
            }
        }
        catch (Exception exception) {
            throw new PKCS7Exception("Cannot decode signerInfo: " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void d() throws PKCS7Exception {
        block41: {
            if (this.signers.size() == 0) {
                return;
            }
            if (this.theCertJ == null) {
                throw new PKCS7Exception("CertJ context object is null.");
            }
            DatabaseService databaseService = null;
            if (this.theCertPathCtx != null) {
                databaseService = this.theCertPathCtx.getDatabase();
            }
            DatabaseService databaseService2 = null;
            MemoryDB memoryDB = null;
            String string = null;
            try {
                DatabaseService databaseService3;
                if (this.theCertPathCtx != null && (this.certs.size() > 0 || this.crls.size() > 0)) {
                    memoryDB = this.a("Temp Memory DB", this.certs, this.crls);
                    string = memoryDB.getName();
                    databaseService2 = this.a(databaseService, string);
                }
                DatabaseService databaseService4 = databaseService3 = databaseService2 == null ? databaseService : databaseService2;
                if (this.certs.size() == 0 && databaseService3 == null) {
                    throw new PKCS7Exception("Cannot get a certificate for all signers.");
                }
                for (int i = 0; i < this.signers.size(); ++i) {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    SignerInfo signerInfo = (SignerInfo)this.signers.elementAt(i);
                    JSAFE_PublicKey jSAFE_PublicKey = null;
                    CertPathCtx certPathCtx = null;
                    try {
                        int n;
                        object4 = new Vector();
                        object3 = null;
                        if (databaseService3 != null) {
                            n = databaseService3.selectCertificateByIssuerAndSerialNumber(signerInfo.getIssuerName(), signerInfo.getSerialNumber(), (Vector)object4);
                            if (n == 0) {
                                this.g.addElement(signerInfo);
                                continue;
                            }
                            object3 = (X509Certificate)((Vector)object4).elementAt(0);
                            if (databaseService2 != null) {
                                certPathCtx = new CertPathCtx(this.theCertPathCtx.getPathOptions(), this.theCertPathCtx.getTrustedCerts(), this.theCertPathCtx.getPolicies(), this.theCertPathCtx.getValidationTime(), databaseService2);
                            }
                            Object object5 = object2 = certPathCtx == null ? this.theCertPathCtx : certPathCtx;
                            if (!this.theCertJ.buildCertPath((CertPathCtx)object2, object3, null, null, null, null)) {
                                this.f.addElement(signerInfo);
                            }
                        } else {
                            for (n = 0; n < this.certs.size(); ++n) {
                                if (signerInfo.getIssuerName() == null) throw new PKCS7Exception("Signer's name or serial number is not set.");
                                if (signerInfo.getSerialNumber() == null) {
                                    throw new PKCS7Exception("Signer's name or serial number is not set.");
                                }
                                object2 = ((X509Certificate)this.certs.elementAt(n)).getIssuerName();
                                object = signerInfo.getIssuerName();
                                byte[] byArray = ((X509Certificate)this.certs.elementAt(n)).getSerialNumber();
                                if (!((X500Name)object).equals(object2) || !CertJUtils.byteArraysEqual(signerInfo.getSerialNumber(), byArray)) continue;
                                object3 = (X509Certificate)this.certs.elementAt(n);
                                break;
                            }
                            if (object3 == null) {
                                this.g.addElement(signerInfo);
                                continue;
                            }
                            this.f.addElement(signerInfo);
                        }
                        if (object3 == null) {
                            throw new PKCS7Exception("Cannot find signer's certificate.");
                        }
                        jSAFE_PublicKey = ((Certificate)object3).getSubjectPublicKey(this.getDeviceOrJava());
                    }
                    catch (NoServiceException noServiceException) {
                        throw new PKCS7Exception("Cannot get Cert from DB: " + noServiceException.getMessage());
                    }
                    catch (DatabaseException databaseException) {
                        throw new PKCS7Exception("Cannot get Cert from DB: " + databaseException.getMessage());
                    }
                    catch (CertificateException certificateException) {
                        throw new PKCS7Exception("Cannot get IssuerName and SerialNumber from cert: " + certificateException.getMessage());
                    }
                    catch (CertPathException certPathException) {
                        throw new PKCS7Exception("Cannot validate cert path: " + certPathException.getMessage());
                    }
                    catch (InvalidParameterException invalidParameterException) {
                        throw new PKCS7Exception("Cannot validate cert path: " + invalidParameterException.getMessage());
                    }
                    try {
                        void var15_32;
                        JSAFE_Signature jSAFE_Signature;
                        JSAFE_AsymmetricCipher jSAFE_AsymmetricCipher;
                        object4 = this.getSignerDigest(signerInfo, 1);
                        object3 = signerInfo.getDigestAlgorithmOID();
                        if (object3 == null) {
                            this.e.addElement(signerInfo);
                            jSAFE_PublicKey.clearSensitiveData();
                            certPathCtx = null;
                            continue;
                        }
                        byte[] byArray = this.a((byte[])object3, (byte[])object4);
                        object2 = signerInfo.getEncryptionAlgorithmOID();
                        if (object2 == null) {
                            throw new PKCS7Exception("Signer's signing algorithm is not set.");
                        }
                        this.b((byte[])object2);
                        object = signerInfo.getEncryptedDigest();
                        if (object == null) {
                            this.e.addElement(signerInfo);
                            jSAFE_PublicKey.clearSensitiveData();
                            certPathCtx = null;
                            continue;
                        }
                        Object var15_26 = null;
                        try {
                            jSAFE_AsymmetricCipher = JSAFE_AsymmetricCipher.getInstance((byte[])object2, (int)0, (String)"Java");
                            String string3 = jSAFE_AsymmetricCipher.getEncryptionAlgorithm();
                            string3 = "NoDigest/" + string3 + "/PKCS1Block01Pad";
                        }
                        catch (JSAFE_Exception jSAFE_Exception) {
                            jSAFE_Signature = JSAFE_Signature.getInstance((byte[])object2, (int)0, (String)"Java");
                            String string4 = jSAFE_Signature.getSignatureAlgorithm();
                            if ("DSA".equals(string4)) {
                                String string5 = "NoDigest/" + string4 + "/NoPad";
                                byArray = new byte[((Object)object4).length];
                                System.arraycopy(object4, 0, byArray, 0, ((Object)object4).length);
                            }
                            String string6 = "NoDigest/" + string4 + "/PKCS1Block01Pad";
                        }
                        jSAFE_AsymmetricCipher = JSAFE_Signature.getInstance((String)var15_32, (String)this.getDeviceOrJava());
                        jSAFE_Signature = this.theCertJ.getRandomObject();
                        jSAFE_AsymmetricCipher.verifyInit(jSAFE_PublicKey, null, (SecureRandom)jSAFE_Signature, this.theCertJ.getPKCS11Sessions());
                        jSAFE_AsymmetricCipher.verifyUpdate(byArray, 0, byArray.length);
                        if (jSAFE_AsymmetricCipher.getSignatureAlgorithm().equals("DSA")) {
                            object = this.d((byte[])object);
                        }
                        if (!jSAFE_AsymmetricCipher.verifyFinal((byte[])object, 0, ((Object)object).length)) {
                            this.e.addElement(signerInfo);
                        }
                        jSAFE_AsymmetricCipher.clearSensitiveData();
                        jSAFE_PublicKey.clearSensitiveData();
                        certPathCtx = null;
                        continue;
                    }
                    catch (JSAFE_Exception jSAFE_Exception) {
                        throw new PKCS7Exception("Could not sign ContentInfo: " + jSAFE_Exception.getMessage());
                    }
                    catch (RandomException randomException) {
                        throw new PKCS7Exception("Could not sign ContentInfo: " + randomException.getMessage());
                    }
                    catch (NoServiceException noServiceException) {
                        throw new PKCS7Exception("Could not sign ContentInfo: " + noServiceException.getMessage());
                    }
                }
                Object var19_36 = null;
                if (databaseService2 != null) {
                    this.theCertJ.unbindService(databaseService2);
                }
                if (memoryDB == null) break block41;
            }
            catch (Throwable throwable) {
                Object var19_37 = null;
                if (databaseService2 != null) {
                    this.theCertJ.unbindService(databaseService2);
                }
                if (memoryDB == null) throw throwable;
                try {
                    this.theCertJ.unregisterService(1, string);
                    throw throwable;
                }
                catch (InvalidParameterException invalidParameterException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (InvalidParameterException invalidParameterException) {}
            this.theCertJ.unregisterService(1, string);
        }
        if (this.e.size() > 0) throw new PKCS7Exception(this.e());
        if (this.f.size() > 0) {
            if (this.theCertPathCtx != null) throw new PKCS7Exception(this.e());
        }
        if (this.g.size() <= 0) return;
        throw new PKCS7Exception(this.e());
    }

    private void b(byte[] byArray) throws PKCS7Exception {
        int n = 0;
        if (byArray == null) {
            throw new PKCS7Exception("Algorithm ID is null");
        }
        try {
            n = ASN1Lengths.determineLengthLen((byte[])byArray, (int)1) + 1;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Could not DER decode algID: " + aSN_Exception.getMessage());
        }
        if (this.a(byArray, a, n)) {
            this.b(byArray, b, n);
        }
    }

    private boolean a(byte[] byArray, byte[] byArray2, int n) throws PKCS7Exception {
        boolean bl = true;
        if (byArray == null || byArray2 == null) {
            throw new PKCS7Exception("Input data is null");
        }
        if (byArray.length < byArray2.length + n) {
            bl = false;
        } else {
            for (int i = 0; i < byArray2.length; ++i) {
                if (byArray[i + n] == byArray2[i]) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private void b(byte[] byArray, byte[] byArray2, int n) throws PKCS7Exception {
        if (byArray == null || byArray2 == null) {
            throw new PKCS7Exception("Input data is null");
        }
        if (byArray.length < byArray2.length + n) {
            throw new PKCS7Exception("Input data is invalid");
        }
        for (int i = 0; i < byArray2.length; ++i) {
            byArray[i + n] = byArray2[i];
        }
    }

    private String e() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        SignerInfo signerInfo = null;
        if (this.g.size() > 0) {
            stringBuffer.append("Cannot find certificates for signers: ");
            for (n = 0; n < this.g.size(); ++n) {
                signerInfo = (SignerInfo)this.g.elementAt(n);
                try {
                    if (signerInfo.getIssuerName() == null || signerInfo.getSerialNumber() == null) continue;
                    stringBuffer.append("\nIssuer Name ");
                    stringBuffer.append(signerInfo.getIssuerName().toString());
                    stringBuffer.append(" , Serial Number ");
                    stringBuffer.append(this.c(signerInfo.getSerialNumber()));
                    continue;
                }
                catch (PKCS7Exception pKCS7Exception) {
                    // empty catch block
                }
            }
        }
        if (this.f.size() > 0) {
            stringBuffer.append("\nCannot build and verify certPath for signers: ");
            for (n = 0; n < this.f.size(); ++n) {
                signerInfo = (SignerInfo)this.f.elementAt(n);
                try {
                    if (signerInfo.getIssuerName() == null || signerInfo.getSerialNumber() == null) continue;
                    stringBuffer.append("\n Issuer Name ");
                    stringBuffer.append(signerInfo.getIssuerName().toString());
                    stringBuffer.append(" , Serial Number ");
                    stringBuffer.append(this.c(signerInfo.getSerialNumber()));
                    continue;
                }
                catch (PKCS7Exception pKCS7Exception) {
                    // empty catch block
                }
            }
        }
        if (this.e.size() > 0) {
            stringBuffer.append("\nCannot verify signature for signers: ");
            for (n = 0; n < this.e.size(); ++n) {
                signerInfo = (SignerInfo)this.e.elementAt(n);
                try {
                    if (signerInfo.getIssuerName() == null || signerInfo.getSerialNumber() == null) continue;
                    stringBuffer.append("\n Issuer Name ");
                    stringBuffer.append(signerInfo.getIssuerName().toString());
                    stringBuffer.append(" , Serial Number ");
                    stringBuffer.append(this.c(signerInfo.getSerialNumber()));
                    continue;
                }
                catch (PKCS7Exception pKCS7Exception) {
                    // empty catch block
                }
            }
        }
        return stringBuffer.toString();
    }

    private String c(byte[] byArray) {
        return this.e(byArray, 0, byArray.length);
    }

    private String e(byte[] byArray, int n, int n2) {
        int n3 = 0;
        String string = null;
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer();
        while (n2 > 0) {
            int n4 = 0;
            while (n4 < 8 && n2 != 0) {
                n3 = byArray[n] & 0xFF;
                string = Integer.toHexString(n3);
                if (string.length() == 1) {
                    stringBuffer.append(" 0");
                } else {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(string);
                --n2;
                ++n4;
                ++n;
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public Vector getFailedSigners() {
        if (this.e.size() == 0) {
            return null;
        }
        return (Vector)this.e.clone();
    }

    public Vector getFailedCertPathSigners() {
        if (this.f.size() == 0) {
            return null;
        }
        return (Vector)this.f.clone();
    }

    protected int contentReadUpdate(byte[] byArray, int n, int n2) throws PKCS7Exception {
        int n3 = 0;
        if (byArray == null) {
            return n3;
        }
        if (this.contentASN1Template == null) {
            throw new PKCS7Exception("Call readInit before readUpdate.");
        }
        try {
            if (this.contentASN1Template.isComplete()) {
                return n3;
            }
            n3 = this.contentASN1Template.berDecodeUpdate(byArray, n, n2);
            this.c();
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Could not decode message: " + aSN_Exception.getMessage());
        }
    }

    protected boolean contentReadFinal() throws PKCS7Exception {
        try {
            this.contentASN1Template.berDecodeFinal();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Cannot call readFinal: " + aSN_Exception.getMessage());
        }
        if (!this.contentASN1Template.isComplete()) {
            throw new PKCS7Exception("Cannot call readFinal, more message expected.");
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        SignedData signedData = (SignedData)super.clone();
        signedData.version = this.version;
        signedData.d = this.d;
        signedData.preDigestFlag = this.preDigestFlag;
        if (this.digestIDs != null) {
            signedData.digestIDs = (Vector)this.digestIDs.clone();
        }
        if (this.digestNames != null) {
            signedData.digestNames = (Vector)this.digestNames.clone();
        }
        if (this.digestIDs != null) {
            signedData.digests = (Vector)this.digests.clone();
        }
        if (this.certs != null) {
            signedData.certs = (Vector)this.certs.clone();
        }
        if (this.crls != null) {
            signedData.crls = (Vector)this.crls.clone();
        }
        if (this.signers != null) {
            signedData.signers = (Vector)this.signers.clone();
        }
        return signedData;
    }

    public boolean equals(Object object) {
        int n;
        int n2;
        int n3;
        if (object == null || !(object instanceof SignedData)) {
            return false;
        }
        SignedData signedData = (SignedData)object;
        if (signedData.version != this.version) {
            return false;
        }
        if (this.content != null && !this.content.equals(signedData.content)) {
            return false;
        }
        if (signedData.preDigestFlag != this.preDigestFlag) {
            return false;
        }
        int n4 = this.signers.size();
        if (n4 != (n3 = signedData.signers.size())) {
            return false;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (this.signers.elementAt(n2) == null) continue;
            n = 0;
            for (n = 0; n < n3 && !((SignerInfo)this.signers.elementAt(n2)).equals(signedData.signers.elementAt(n)); ++n) {
            }
            if (n != n3) continue;
            return false;
        }
        n4 = this.digestIDs.size();
        if (n4 != (n3 = signedData.digestIDs.size())) {
            return false;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            n = 0;
            if (this.digestIDs.elementAt(n2) != null) {
                for (n = 0; n < n3 && !CertJUtils.byteArraysEqual((byte[])this.digestIDs.elementAt(n2), (byte[])signedData.digestIDs.elementAt(n)); ++n) {
                }
                if (n == n3) {
                    return false;
                }
            }
            String string = (String)this.digestNames.elementAt(n2);
            byte[] byArray = (byte[])this.digests.elementAt(n2);
            String string2 = (String)signedData.digestNames.elementAt(n);
            byte[] byArray2 = (byte[])signedData.digests.elementAt(n);
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else {
                if (string2 == null) {
                    return false;
                }
                if (!string.equals(string2)) {
                    return false;
                }
            }
            if (byArray == null) {
                if (byArray2 == null) continue;
                return false;
            }
            if (byArray2 == null) {
                return false;
            }
            if (CertJUtils.byteArraysEqual(byArray, byArray2)) continue;
            return false;
        }
        n4 = this.e.size();
        if (n4 != (n3 = signedData.e.size())) {
            return false;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (!(this.e.elementAt(n2) != null ? !((SignerInfo)this.e.elementAt(n2)).equals(signedData.e.elementAt(n2)) : signedData.e.elementAt(n2) != null)) continue;
            return false;
        }
        n4 = this.certs.size();
        if (n4 != (n3 = signedData.certs.size())) {
            return false;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (this.certs.elementAt(n2) == null) continue;
            n = 0;
            for (n = 0; n < n3 && !((Certificate)this.certs.elementAt(n2)).equals(signedData.certs.elementAt(n)); ++n) {
            }
            if (n != n3) continue;
            return false;
        }
        n4 = this.crls.size();
        if (n4 != (n3 = signedData.crls.size())) {
            return false;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (this.crls.elementAt(n2) == null) continue;
            n = 0;
            for (n = 0; n < n3 && !((CRL)this.crls.elementAt(n2)).equals(signedData.crls.elementAt(n)); ++n) {
            }
            if (n != n3) continue;
            return false;
        }
        return true;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.version = -1;
        this.digestIDs = new Vector();
        this.digestNames = new Vector();
        this.digests = new Vector();
        this.digestLengths = new Vector();
        this.certs = new Vector();
        this.crls = new Vector();
        this.signers = new Vector();
    }

    protected void finalize() {
        this.clearSensitiveData();
    }

    private MemoryDB a(String string, Vector vector, Vector vector2) throws PKCS7Exception {
        if (!(vector != null && vector.size() != 0 || vector2 != null && vector2.size() != 0)) {
            return null;
        }
        if (this.theCertJ == null) {
            throw new PKCS7Exception("SignedData.storeIntoTempDB: theCertJ should not be null.");
        }
        DatabaseService databaseService = null;
        try {
            int n;
            String string2 = this.a("Temp Memory DB");
            MemoryDB memoryDB = new MemoryDB(string2);
            this.theCertJ.registerService(memoryDB);
            databaseService = (DatabaseService)this.theCertJ.bindService(1, string2);
            if (vector != null && vector.size() != 0) {
                for (n = 0; n < vector.size(); ++n) {
                    databaseService.insertCertificate((Certificate)vector.elementAt(n));
                }
            }
            if (vector2 != null && vector2.size() != 0) {
                for (n = 0; n < vector2.size(); ++n) {
                    databaseService.insertCRL((CRL)vector2.elementAt(n));
                }
            }
            MemoryDB memoryDB2 = memoryDB;
            Object var9_10 = null;
            if (databaseService != null) {
                this.theCertJ.unbindService(databaseService);
            }
            return memoryDB2;
        }
        catch (CertJException certJException) {
            try {
                throw new PKCS7Exception("SignedData.storeIntoTempDB: " + certJException.getMessage());
            }
            catch (Throwable throwable) {
                block11: {
                    Object var9_11 = null;
                    if (databaseService == null) break block11;
                    this.theCertJ.unbindService(databaseService);
                }
                throw throwable;
            }
        }
    }

    private DatabaseService a(DatabaseService databaseService, String string) throws PKCS7Exception {
        try {
            String[] stringArray = databaseService.listProviderNames();
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = string;
            return (DatabaseService)this.theCertJ.bindServices(1, stringArray2);
        }
        catch (CertJException certJException) {
            throw new PKCS7Exception("SignedData.addTempDB: " + certJException.getMessage());
        }
    }

    private String a(String string) {
        String[] stringArray = this.theCertJ.listProviderNames(1);
        if (!this.a(string, stringArray)) {
            return string;
        }
        int n = 0;
        String string2;
        while (this.a(string2 = string + n, stringArray)) {
            ++n;
        }
        return string2;
    }

    private boolean a(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private byte[] f(byte[] byArray, int n, int n2) throws PKCS7Exception {
        if (n2 != 40) {
            throw new PKCS7Exception("Wrong R S length: " + n2);
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            EndContainer endContainer = new EndContainer();
            IntegerContainer integerContainer = new IntegerContainer(0, true, 0, byArray, n, 20, true);
            IntegerContainer integerContainer2 = new IntegerContainer(0, true, 0, byArray, n + 20, 20, true);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, integerContainer2, endContainer};
            return ASN1.derEncode((ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Unable to encode R,S: " + aSN_Exception.getMessage());
        }
    }

    private byte[] d(byte[] byArray) throws PKCS7Exception {
        byte[] byArray2 = new byte[40];
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        EndContainer endContainer = new EndContainer();
        IntegerContainer integerContainer = new IntegerContainer(0);
        IntegerContainer integerContainer2 = new IntegerContainer(0);
        try {
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, integerContainer2, endContainer};
            ASN1.berDecode((byte[])byArray, (int)0, (ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Unable to encode R,S: " + aSN_Exception.getMessage());
        }
        int n = integerContainer.dataOffset + integerContainer.dataLen - 1;
        int n2 = 19;
        while (n2 >= 0) {
            byArray2[n2] = n >= integerContainer.dataOffset ? integerContainer.data[n] : (byte)0;
            --n2;
            --n;
        }
        n2 = integerContainer2.dataOffset + integerContainer2.dataLen - 1;
        int n3 = 39;
        while (n3 >= 20) {
            byArray2[n3] = n2 >= integerContainer2.dataOffset ? integerContainer2.data[n2] : (byte)0;
            --n3;
            --n2;
        }
        return byArray2;
    }

    private boolean f() {
        Enumeration enumeration = this.digests.elements();
        while (enumeration.hasMoreElements()) {
            if (enumeration.nextElement() == null) continue;
            return false;
        }
        return true;
    }
}

