/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs7;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.jsafe.JSAFE_AsymmetricCipher;
import com.rsa.jsafe.JSAFE_Exception;
import java.io.Serializable;

public class RecipientInfo
implements Cloneable,
Serializable {
    private int a = 0;
    private X500Name b = null;
    private byte[] c = null;
    private byte[] d = null;
    private byte[] e = null;
    private String f;
    protected static int special;
    private ASN1Template g = null;

    public RecipientInfo() {
    }

    protected RecipientInfo(byte[] byArray, int n, int n2) throws PKCS7Exception {
        if (byArray == null) {
            throw new PKCS7Exception("Cannot create RecipientInfo: encoding is null.");
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(n2);
            EndContainer endContainer = new EndContainer();
            IntegerContainer integerContainer = new IntegerContainer(0);
            EncodedContainer encodedContainer = new EncodedContainer(12288);
            EncodedContainer encodedContainer2 = new EncodedContainer(12288);
            OctetStringContainer octetStringContainer = new OctetStringContainer(0);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer, encodedContainer2, octetStringContainer, endContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            this.a = integerContainer.getValueAsInt();
            SequenceContainer sequenceContainer2 = new SequenceContainer(n2);
            EncodedContainer encodedContainer3 = new EncodedContainer(12288);
            IntegerContainer integerContainer2 = new IntegerContainer(0);
            ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer2, encodedContainer3, integerContainer2, endContainer};
            ASN1.berDecode((byte[])encodedContainer.data, (int)encodedContainer.dataOffset, (ASN1Container[])aSN1ContainerArray2);
            this.b = new X500Name(encodedContainer3.data, encodedContainer3.dataOffset, 0);
            this.c = new byte[integerContainer2.dataLen];
            System.arraycopy(integerContainer2.data, integerContainer2.dataOffset, this.c, 0, integerContainer2.dataLen);
            this.d = new byte[encodedContainer2.dataLen];
            System.arraycopy(encodedContainer2.data, encodedContainer2.dataOffset, this.d, 0, encodedContainer2.dataLen);
            this.e = new byte[octetStringContainer.dataLen];
            System.arraycopy(octetStringContainer.data, octetStringContainer.dataOffset, this.e, 0, octetStringContainer.dataLen);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Cannot decode the BER of the RecipientInfo.");
        }
        catch (NameException nameException) {
            throw new PKCS7Exception("Cannot decode the BER of the RecipientInfo.");
        }
    }

    public void setVersionNumber(int n) {
        this.a = n;
    }

    public int getVersionNumber() {
        return this.a;
    }

    public void setIssuerAndSerialNumber(X500Name x500Name, byte[] byArray, int n, int n2) throws PKCS7Exception {
        if (x500Name == null) {
            throw new PKCS7Exception("Issuer name is null.");
        }
        try {
            this.b = (X500Name)x500Name.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new PKCS7Exception("Invalid name.");
        }
        if (byArray == null || n2 <= 0) {
            throw new PKCS7Exception("SerialNumber is null.");
        }
        if (n < 0 || n + n2 > byArray.length) {
            throw new PKCS7Exception("Invalid SerialNumber");
        }
        this.c = new byte[n2];
        System.arraycopy(byArray, n, this.c, 0, n2);
    }

    public X500Name getIssuerName() throws PKCS7Exception {
        if (this.b == null) {
            return null;
        }
        try {
            return (X500Name)this.b.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new PKCS7Exception("Invalid attributes.");
        }
    }

    public byte[] getSerialNumber() {
        if (this.c == null) {
            return null;
        }
        return (byte[])this.c.clone();
    }

    public void setEncryptionAlgorithm(String string) throws PKCS7Exception {
        if (string == null) {
            throw new PKCS7Exception("Could not set algorithm OID: name is null.");
        }
        this.f = new String(string);
        try {
            JSAFE_AsymmetricCipher jSAFE_AsymmetricCipher = JSAFE_AsymmetricCipher.getInstance((String)string, (String)"Java");
            this.d = jSAFE_AsymmetricCipher.getDERAlgorithmID();
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new PKCS7Exception("Could not set algorithm OID: " + jSAFE_Exception.getMessage());
        }
    }

    public void setEncryptionAlgorithm(byte[] byArray, int n, int n2) throws PKCS7Exception {
        if (byArray == null || n2 <= 0) {
            throw new PKCS7Exception("Could not set algorithm OID: OID is null");
        }
        if (n < 0 || n + n2 > byArray.length) {
            throw new PKCS7Exception("Invalid Encryption Algorithm Identifier.");
        }
        this.d = new byte[n2];
        System.arraycopy(byArray, n, this.d, 0, n2);
    }

    public byte[] getEncryptionAlgorithmOID() {
        if (this.d == null) {
            return null;
        }
        return (byte[])this.d.clone();
    }

    public String getEncryptionAlgorithmName() throws PKCS7Exception {
        if (this.d == null) {
            return null;
        }
        if (this.f != null) {
            return new String(this.f);
        }
        try {
            JSAFE_AsymmetricCipher jSAFE_AsymmetricCipher = JSAFE_AsymmetricCipher.getInstance((byte[])this.d, (int)0, (String)"Java");
            return jSAFE_AsymmetricCipher.getEncryptionAlgorithm();
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new PKCS7Exception("Could not get algorithm OID: " + jSAFE_Exception.getMessage());
        }
    }

    protected void setEncryptedKey(byte[] byArray, int n, int n2) {
        this.e = new byte[n2];
        System.arraycopy(byArray, n, this.e, 0, n2);
    }

    public byte[] getEncryptedKey() {
        if (this.e == null) {
            return null;
        }
        return (byte[])this.e.clone();
    }

    protected static int getNextBEROffset(byte[] byArray, int n) throws PKCS7Exception {
        if (byArray == null) {
            throw new PKCS7Exception("Encoding is null.");
        }
        if (byArray[n] == 0 && byArray[n + 1] == 0) {
            return n + 2;
        }
        try {
            return n + 1 + ASN1Lengths.determineLengthLen((byte[])byArray, (int)(n + 1)) + ASN1Lengths.determineLength((byte[])byArray, (int)(n + 1));
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Unable to determine length of the BER: " + aSN_Exception.getMessage());
        }
    }

    protected int getDERLen(int n) throws PKCS7Exception {
        special = n;
        return this.a();
    }

    protected int getDEREncoding(byte[] byArray, int n, int n2) throws PKCS7Exception {
        if (byArray == null) {
            throw new PKCS7Exception("Specified array is null.");
        }
        try {
            int n3;
            if ((this.g == null || n2 != special) && (n3 = this.getDERLen(n2)) == 0) {
                throw new PKCS7Exception("Unable to encode RecipientInfo.");
            }
            n3 = this.g.derEncode(byArray, n);
            this.g = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.g = null;
            throw new PKCS7Exception("Unable to encode RecipientInfo: " + aSN_Exception.getMessage());
        }
    }

    private int a() {
        try {
            if (this.b == null) {
                return 0;
            }
            int n = this.b.getDERLen(0);
            if (n == 0) {
                return 0;
            }
            byte[] byArray = new byte[n];
            n = this.b.getDEREncoding(byArray, 0, 0);
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            EndContainer endContainer = new EndContainer();
            EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, byArray, 0, byArray.length);
            IntegerContainer integerContainer = null;
            if (this.c == null) {
                return 0;
            }
            integerContainer = (this.c[0] & 0x80) >> 7 == 0 ? new IntegerContainer(0, true, 0, this.c, 0, this.c.length, true) : new IntegerContainer(0, true, 0, this.c, 0, this.c.length, false);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, integerContainer, endContainer};
            ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray);
            n = aSN1Template.derEncodeInit();
            byte[] byArray2 = new byte[n];
            aSN1Template.derEncode(byArray2, 0);
            if (this.d == null) {
                return 0;
            }
            if (this.e == null) {
                return 0;
            }
            SequenceContainer sequenceContainer2 = new SequenceContainer(special, true, 0);
            IntegerContainer integerContainer2 = new IntegerContainer(0, true, 0, this.a);
            EncodedContainer encodedContainer2 = new EncodedContainer(12288, true, 0, byArray2, 0, byArray2.length);
            EncodedContainer encodedContainer3 = new EncodedContainer(12288, true, 0, this.d, 0, this.d.length);
            OctetStringContainer octetStringContainer = new OctetStringContainer(0, true, 0, this.e, 0, this.e.length);
            ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer2, integerContainer2, encodedContainer2, encodedContainer3, octetStringContainer, endContainer};
            this.g = new ASN1Template(aSN1ContainerArray2);
            return this.g.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
        catch (NameException nameException) {
            return 0;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RecipientInfo)) {
            return false;
        }
        RecipientInfo recipientInfo = (RecipientInfo)object;
        if (this.a != recipientInfo.a) {
            return false;
        }
        if (this.b != null ? !this.b.equals(recipientInfo.b) : recipientInfo.b != null) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.c, recipientInfo.c)) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.d, recipientInfo.d)) {
            return false;
        }
        return CertJUtils.byteArraysEqual(this.e, recipientInfo.e);
    }

    public Object clone() throws CloneNotSupportedException {
        RecipientInfo recipientInfo = new RecipientInfo();
        recipientInfo.a = this.a;
        if (this.b != null) {
            recipientInfo.b = (X500Name)this.b.clone();
        }
        if (this.c != null) {
            recipientInfo.c = new byte[this.c.length];
            System.arraycopy(this.c, 0, recipientInfo.c, 0, this.c.length);
        }
        if (this.d != null) {
            recipientInfo.d = new byte[this.d.length];
            System.arraycopy(this.d, 0, recipientInfo.d, 0, this.d.length);
        }
        if (this.e != null) {
            recipientInfo.e = new byte[this.e.length];
            System.arraycopy(this.e, 0, recipientInfo.e, 0, this.e.length);
        }
        if (this.g != null) {
            recipientInfo.a();
        }
        return recipientInfo;
    }
}

