/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs7;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OIDList;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.pkcs7.ContentInfo;
import com.rsa.certj.pkcs7.EncryptedContentInfo;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.pkcs7.RecipientInfo;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.random.RandomException;
import com.rsa.jsafe.JSAFE_AsymmetricCipher;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Vector;

public class EnvelopedData
extends ContentInfo
implements Cloneable,
Serializable {
    protected int version = -1;
    protected Vector recipients = new Vector();
    protected EncryptedContentInfo info = new EncryptedContentInfo();
    private JSAFE_SecretKey a;
    private int b;
    private String c;

    public EnvelopedData(CertJ certJ, CertPathCtx certPathCtx) {
        this.contentType = 3;
        this.theCertJ = certJ;
        this.theCertPathCtx = certPathCtx;
    }

    public void setVersionNumber(int n) {
        this.version = n;
    }

    public int getVersionNumber() {
        return this.version;
    }

    public void setEncryptionAlgorithm(String string, int n) throws PKCS7Exception {
        if (string == null) {
            throw new PKCS7Exception("Algorithm name is null.");
        }
        this.c = new String(string);
        try {
            Object object;
            if (this.theCertJ == null) {
                throw new PKCS7Exception("CertJ object is NULL; cannot get Random object.");
            }
            JSAFE_SymmetricCipher jSAFE_SymmetricCipher = JSAFE_SymmetricCipher.getInstance((String)string, (String)this.getDeviceOrJava());
            if (jSAFE_SymmetricCipher.getFeedbackMode() != null && !jSAFE_SymmetricCipher.getFeedbackMode().equals("ECB")) {
                object = this.theCertJ.getRandomObject();
                jSAFE_SymmetricCipher.generateIV((SecureRandom)object);
            }
            if ((object = jSAFE_SymmetricCipher.getDERAlgorithmID()) != null) {
                this.info.setEncryptionAlgorithm((byte[])object, 0, ((byte[])object).length);
            }
            this.b = n;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new PKCS7Exception("Could not get algorithm OID: " + jSAFE_Exception.getMessage());
        }
        catch (RandomException randomException) {
            throw new PKCS7Exception("Could not get algorithm OID" + randomException.getMessage());
        }
        catch (NoServiceException noServiceException) {
            throw new PKCS7Exception("Could not get algorithm OID" + noServiceException.getMessage());
        }
    }

    public void setEncryptionAlgorithm(byte[] byArray, int n, int n2, int n3) throws PKCS7Exception {
        if (byArray == null || n2 <= 0) {
            throw new PKCS7Exception("Could not set algorithm OID: OID is null");
        }
        if (n < 0 || n + n2 > byArray.length) {
            throw new PKCS7Exception("invalid data");
        }
        this.info.setEncryptionAlgorithm(byArray, n, n2);
        this.b = n3;
    }

    public String getEncryptionAlgorithmName() throws PKCS7Exception {
        if (this.c != null) {
            return new String(this.c);
        }
        if (this.info == null) {
            return null;
        }
        byte[] byArray = this.info.getEncryptionAlgorithm();
        if (byArray == null) {
            throw new PKCS7Exception("Encryption algorithm is not set.");
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            EndContainer endContainer = new EndContainer();
            OIDContainer oIDContainer = new OIDContainer(0);
            EncodedContainer encodedContainer = new EncodedContainer(130816);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
            ASN1.berDecode((byte[])byArray, (int)0, (ASN1Container[])aSN1ContainerArray);
            return OIDList.getTrans((byte[])oIDContainer.data, (int)oIDContainer.dataOffset, (int)oIDContainer.dataLen, (int)6);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Encryption algorithm is not valid." + aSN_Exception.getMessage());
        }
    }

    public byte[] getEncryptionAlgorithmOID() {
        if (this.info == null) {
            return null;
        }
        return this.info.getEncryptionAlgorithm();
    }

    public void setContentInfo(ContentInfo contentInfo) throws PKCS7Exception {
        if (contentInfo == null) {
            throw new PKCS7Exception("Null content");
        }
        try {
            this.content = (ContentInfo)contentInfo.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new PKCS7Exception("Unable to clone ContentInfo type");
        }
    }

    public void addRecipientInfo(RecipientInfo recipientInfo) throws PKCS7Exception {
        if (recipientInfo == null) {
            throw new PKCS7Exception("Null RecipientInfo");
        }
        try {
            this.recipients.addElement(recipientInfo.clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new PKCS7Exception("Cannot add this Recipient Information.");
        }
    }

    public Vector getRecipientInfos() {
        return (Vector)this.recipients.clone();
    }

    protected int getContentDERLen() throws PKCS7Exception {
        return this.a();
    }

    protected int writeContent(byte[] byArray, int n) throws PKCS7Exception {
        if (byArray == null) {
            throw new PKCS7Exception("Cannot write EnvelopedData: output array is null.");
        }
        try {
            if (this.contentASN1Template == null) {
                this.getContentDERLen();
            }
            int n2 = this.contentASN1Template.derEncode(byArray, n);
            this.contentASN1Template = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            this.contentASN1Template = null;
            throw new PKCS7Exception("Unable to DER encode EnvelopedData message: " + aSN_Exception.getMessage());
        }
    }

    private int a() throws PKCS7Exception {
        try {
            byte[] byArray;
            int n;
            RecipientInfo recipientInfo;
            if (this.flag == 0) {
                this.b();
            }
            if (this.recipients.size() == 0) {
                throw new PKCS7Exception("RecipientInfos are not set.");
            }
            EncodedContainer encodedContainer = null;
            OfContainer ofContainer = new OfContainer(0, 12544, (ASN1Container)new EncodedContainer(12288));
            Vector<OfContainer> vector = new Vector<OfContainer>();
            vector.addElement(ofContainer);
            for (int i = 0; i < this.recipients.size(); ++i) {
                try {
                    recipientInfo = (RecipientInfo)this.recipients.elementAt(i);
                    n = recipientInfo.getDERLen(0);
                    byArray = new byte[n];
                    n = recipientInfo.getDEREncoding(byArray, 0, 0);
                    encodedContainer = new EncodedContainer(0, true, 0, byArray, 0, n);
                    ofContainer.addContainer((ASN1Container)encodedContainer);
                    continue;
                }
                catch (ASN_Exception aSN_Exception) {
                    throw new PKCS7Exception("Unable to encode RecipientInfos: " + aSN_Exception.getMessage());
                }
            }
            Object[] objectArray = new ASN1Container[vector.size()];
            vector.copyInto(objectArray);
            recipientInfo = new ASN1Template((ASN1Container[])objectArray);
            n = recipientInfo.derEncodeInit();
            byArray = new byte[n];
            n = recipientInfo.derEncode(byArray, 0);
            recipientInfo = null;
            EncodedContainer encodedContainer2 = new EncodedContainer(0, true, 0, byArray, 0, n);
            int n2 = this.info.getDERLen(0);
            byte[] byArray2 = new byte[n2];
            n2 = this.info.getDEREncoding(byArray2, 0, 0);
            EncodedContainer encodedContainer3 = new EncodedContainer(0, true, 0, byArray2, 0, n2);
            SequenceContainer sequenceContainer = new SequenceContainer(0xA10000, true, 0);
            EndContainer endContainer = new EndContainer();
            IntegerContainer integerContainer = new IntegerContainer(0, true, 0, this.version);
            this.contentASN1Def = new ASN1Container[5];
            this.contentASN1Def[0] = sequenceContainer;
            this.contentASN1Def[1] = integerContainer;
            this.contentASN1Def[2] = encodedContainer2;
            this.contentASN1Def[3] = encodedContainer3;
            this.contentASN1Def[4] = endContainer;
            this.contentASN1Template = new ASN1Template(this.contentASN1Def);
            return this.contentASN1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Could not DER encode EnvelopedData: " + aSN_Exception.getMessage());
        }
    }

    private void b() throws PKCS7Exception {
        Object[] objectArray;
        Object object;
        OIDContainer oIDContainer;
        Object object2;
        Object object3;
        if (this.version == -1) {
            this.version = 0;
        }
        if (this.content == null) {
            throw new PKCS7Exception("There is no content to encrypt.");
        }
        int n = this.content.getContentType();
        byte[] byArray = new byte[9];
        System.arraycopy(ContentInfo.a, 0, byArray, 0, 8);
        byArray[8] = (byte)n;
        this.info.setContentType(byArray, 0, 9);
        byte[] byArray2 = null;
        try {
            if (this.contentEncoding == null) {
                int n2 = this.content.getContentInfoDERLen();
                this.contentEncoding = new byte[n2];
                n2 = this.content.writeMessage(this.contentEncoding, 0);
            }
            object3 = new SequenceContainer(0);
            object2 = new EndContainer();
            oIDContainer = new OIDContainer(0x1000000);
            object = new EncodedContainer(10616576);
            objectArray = new ASN1Container[]{object3, oIDContainer, object, object2};
            ASN1.berDecode((byte[])this.contentEncoding, (int)0, (ASN1Container[])objectArray);
            if (((ASN1Container)object).dataPresent) {
                int n3 = 1;
                n3 += ASN1Lengths.determineLengthLen((byte[])((ASN1Container)object).data, (int)(((ASN1Container)object).dataOffset + 1));
                ++n3;
                n3 += ASN1Lengths.determineLengthLen((byte[])((ASN1Container)object).data, (int)(((ASN1Container)object).dataOffset + n3));
                byArray2 = new byte[((ASN1Container)object).dataLen - n3];
                System.arraycopy(((ASN1Container)object).data, ((ASN1Container)object).dataOffset + n3, byArray2, 0, ((ASN1Container)object).dataLen - n3);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Could not DER encode ContentInfo: " + aSN_Exception.getMessage());
        }
        try {
            object3 = this.info.getEncryptionAlgorithm();
            if (object3 == null) {
                throw new PKCS7Exception("Encryption Algorithm is not set.");
            }
            if (this.theCertJ == null) {
                throw new PKCS7Exception("CertJ object is NULL; cannot get Random object.");
            }
            object2 = this.theCertJ.getRandomObject();
            oIDContainer = JSAFE_SymmetricCipher.getInstance((byte[])object3, (int)0, (String)this.getDeviceOrJava());
            object = oIDContainer.getEncryptionAlgorithm();
            this.a = JSAFE_SecretKey.getInstance((String)object, (String)this.getDeviceOrJava());
            if (this.b != 0) {
                objectArray = new int[]{this.b};
                this.a.generateInit((int[])objectArray, (SecureRandom)object2);
            } else {
                this.a.generateInit(null, (SecureRandom)object2);
            }
            this.a.generate();
            if (byArray2 != null) {
                int n4 = oIDContainer.getOutputBufferSize(byArray2.length);
                byte[] byArray3 = new byte[n4];
                oIDContainer.encryptInit(this.a);
                n4 = oIDContainer.encryptUpdate(byArray2, 0, byArray2.length, byArray3, 0);
                n4 += oIDContainer.encryptFinal(byArray3, n4);
                this.info.setEncryptedContent(byArray3, 0, n4);
            }
            oIDContainer.clearSensitiveData();
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new PKCS7Exception("Could not encrypt content: " + jSAFE_Exception.getMessage());
        }
        catch (RandomException randomException) {
            throw new PKCS7Exception("Could not encrypt content" + randomException.getMessage());
        }
        catch (NoServiceException noServiceException) {
            throw new PKCS7Exception("Could not encrypt content" + noServiceException.getMessage());
        }
        try {
            if (this.theCertPathCtx == null) {
                throw new PKCS7Exception("CertPathCtx object is null, cannot get Database.");
            }
            object3 = this.theCertPathCtx.getDatabase();
            object2 = new Vector();
            if (this.theCertJ == null) {
                throw new PKCS7Exception("CertJ object is NULL; cannot get Random object.");
            }
            for (int i = 0; i < this.recipients.size(); ++i) {
                object = (RecipientInfo)this.recipients.elementAt(i);
                int n5 = ((DatabaseService)object3).selectCertificateByIssuerAndSerialNumber(((RecipientInfo)object).getIssuerName(), ((RecipientInfo)object).getSerialNumber(), (Vector)object2);
                if (n5 == 0) {
                    throw new PKCS7Exception("Cannot find this Recipient cert.");
                }
                X509Certificate x509Certificate = (X509Certificate)((Vector)object2).elementAt(0);
                JSAFE_PublicKey jSAFE_PublicKey = x509Certificate.getSubjectPublicKey(this.getDeviceOrJava());
                JSAFE_SecureRandom jSAFE_SecureRandom = this.theCertJ.getRandomObject();
                byte[] byArray4 = ((RecipientInfo)object).getEncryptionAlgorithmOID();
                JSAFE_AsymmetricCipher jSAFE_AsymmetricCipher = JSAFE_AsymmetricCipher.getInstance((byte[])byArray4, (int)0, (String)this.getDeviceOrJava());
                jSAFE_AsymmetricCipher.encryptInit(jSAFE_PublicKey, (SecureRandom)jSAFE_SecureRandom, this.theCertJ.getPKCS11Sessions());
                byte[] byArray5 = jSAFE_AsymmetricCipher.wrapSecretKey(this.a, false);
                ((RecipientInfo)object).setEncryptedKey(byArray5, 0, byArray5.length);
                jSAFE_PublicKey.clearSensitiveData();
                jSAFE_AsymmetricCipher.clearSensitiveData();
                ((Vector)object2).removeAllElements();
            }
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new PKCS7Exception("Could not encrypt ContentInfo" + jSAFE_Exception.getMessage());
        }
        catch (RandomException randomException) {
            throw new PKCS7Exception("Could not encrypt ContentInfo" + randomException.getMessage());
        }
        catch (NoServiceException noServiceException) {
            throw new PKCS7Exception("Could not encrypt ContentInfo" + noServiceException.getMessage());
        }
        catch (DatabaseException databaseException) {
            throw new PKCS7Exception("Cannot get Cert from DB." + databaseException.getMessage());
        }
        catch (CertificateException certificateException) {
            throw new PKCS7Exception("Cannot get IssuerName and SerialNumber from cert." + certificateException.getMessage());
        }
    }

    protected boolean contentReadInit(byte[] byArray, int n, int n2) throws PKCS7Exception {
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0xA10000);
            EndContainer endContainer = new EndContainer();
            IntegerContainer integerContainer = new IntegerContainer(0);
            EncodedContainer encodedContainer = new EncodedContainer(12544);
            EncodedContainer encodedContainer2 = new EncodedContainer(12288, true, 0, this.maxBufferSize, null, 0, 0);
            this.contentASN1Def = new ASN1Container[5];
            this.contentASN1Def[0] = sequenceContainer;
            this.contentASN1Def[1] = integerContainer;
            this.contentASN1Def[2] = encodedContainer;
            this.contentASN1Def[3] = encodedContainer2;
            this.contentASN1Def[4] = endContainer;
            this.contentASN1Template = new ASN1Template(this.contentASN1Def);
            this.contentASN1Template.berDecodeInit();
            this.contentASN1Template.berDecodeUpdate(byArray, n, n2);
            if (this.contentASN1Def[0].checkTag()) {
                return false;
            }
            this.c();
            this.flag = 1;
            return true;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Could not decode message: " + aSN_Exception.getMessage());
        }
    }

    private void c() throws PKCS7Exception {
        try {
            byte[] byArray;
            if (this.version == -1) {
                if (this.contentASN1Def[1].isComplete()) {
                    if (this.incompleteContainer == 1) {
                        byArray = this.copyToOutput(this.contentASN1Def[1]);
                        IntegerContainer integerContainer = new IntegerContainer(0, true, 0, byArray, 0, byArray.length, true);
                        this.version = integerContainer.getValueAsInt();
                    } else {
                        this.version = ((IntegerContainer)this.contentASN1Def[1]).getValueAsInt();
                    }
                } else {
                    if (this.contentASN1Def[1].data == null) {
                        return;
                    }
                    this.incompleteContainer = 1;
                    this.copyNewData(this.contentASN1Def[1].data, this.contentASN1Def[1].dataOffset, this.contentASN1Def[1].dataLen, 0);
                    return;
                }
            }
            if (this.recipients.size() == 0) {
                if (this.contentASN1Def[2].isComplete()) {
                    if (this.incompleteContainer == 2) {
                        byArray = this.copyToOutput(this.contentASN1Def[2]);
                        this.a(byArray, 0, byArray.length);
                    } else {
                        this.a(this.contentASN1Def[2].data, this.contentASN1Def[2].dataOffset, this.contentASN1Def[2].dataLen);
                    }
                } else {
                    if (this.contentASN1Def[2].data == null) {
                        return;
                    }
                    this.incompleteContainer = 2;
                    this.copyNewData(this.contentASN1Def[2].data, this.contentASN1Def[2].dataOffset, this.contentASN1Def[2].dataLen, 0);
                    return;
                }
            }
            if (this.contentASN1Def[3].isComplete()) {
                if (this.incompleteContainer == 3) {
                    byArray = this.copyToOutput(this.contentASN1Def[3]);
                    this.info = new EncryptedContentInfo(byArray, 0, 0, this.maxBufferSize);
                } else {
                    this.info = new EncryptedContentInfo(this.contentASN1Def[3].data, this.contentASN1Def[3].dataOffset, 0, this.maxBufferSize);
                }
            } else {
                if (this.contentASN1Def[3].data == null) {
                    return;
                }
                this.incompleteContainer = 3;
                this.copyNewData(this.contentASN1Def[3].data, this.contentASN1Def[3].dataOffset, this.contentASN1Def[3].dataLen, this.maxBufferSize);
                return;
            }
            this.e();
            this.d();
        }
        catch (Exception exception) {
            throw new PKCS7Exception("Cannot set decoded values." + exception.getMessage());
        }
    }

    private void a(byte[] byArray, int n, int n2) throws PKCS7Exception {
        if (byArray == null || n2 == 0) {
            throw new PKCS7Exception("Cannot decode RecipientInfo: data is null.");
        }
        try {
            OfContainer ofContainer = new OfContainer(0, 12544, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            int n3 = ofContainer.getContainerCount();
            for (int i = 0; i < n3; ++i) {
                ASN1Container aSN1Container = ofContainer.containerAt(i);
                RecipientInfo recipientInfo = new RecipientInfo(aSN1Container.data, aSN1Container.dataOffset, 0);
                this.addRecipientInfo(recipientInfo);
            }
        }
        catch (Exception exception) {
            throw new PKCS7Exception("Cannot decode recipientInfo." + exception.getMessage());
        }
    }

    private void d() throws PKCS7Exception {
        try {
            byte[] byArray = this.info.getContentType();
            this.content = ContentInfo.getInstance(byArray, 0, 9, this.theCertJ, this.theCertPathCtx);
            byte[] byArray2 = this.info.getEncryptionAlgorithm();
            if (byArray2 == null) {
                throw new PKCS7Exception("Encryption Algorithm is not set.");
            }
            byte[] byArray3 = this.info.getEncryptedContent();
            if (byArray3 == null) {
                return;
            }
            JSAFE_SymmetricCipher jSAFE_SymmetricCipher = JSAFE_SymmetricCipher.getInstance((byte[])byArray2, (int)0, (String)this.getDeviceOrJava());
            int n = jSAFE_SymmetricCipher.getOutputBufferSize(byArray3.length);
            byte[] byArray4 = new byte[n];
            jSAFE_SymmetricCipher.decryptInit(this.a);
            n = jSAFE_SymmetricCipher.decryptUpdate(byArray3, 0, byArray3.length, byArray4, 0);
            n += jSAFE_SymmetricCipher.decryptFinal(byArray4, n);
            jSAFE_SymmetricCipher.clearSensitiveData();
            this.a.clearSensitiveData();
            int n2 = n + 1 + ASN1Lengths.getLengthLen((int)n);
            byte[] byArray5 = new byte[n2];
            byArray5[0] = byArray[8] == 1 ? 4 : 48;
            n2 = 1 + ASN1Lengths.writeLength((byte[])byArray5, (int)1, (int)n);
            System.arraycopy(byArray4, 0, byArray5, n2, n);
            int n3 = byArray5.length + 1 + ASN1Lengths.getLengthLen((int)byArray5.length);
            byte[] byArray6 = new byte[n3];
            byArray6[0] = -96;
            n3 = 1 + ASN1Lengths.writeLength((byte[])byArray6, (int)1, (int)byArray5.length);
            System.arraycopy(byArray5, 0, byArray6, n3, byArray5.length);
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            EndContainer endContainer = new EndContainer();
            OIDContainer oIDContainer = new OIDContainer(0x1000000, true, 0, byArray, 0, byArray.length);
            EncodedContainer encodedContainer = new EncodedContainer(10616576, true, 0, byArray6, 0, byArray6.length);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
            ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray);
            int n4 = aSN1Template.derEncodeInit();
            byte[] byArray7 = new byte[n4];
            aSN1Template.derEncode(byArray7, 0);
            if (this.content.readInit(byArray7, 0, n4, 0, this.maxBufferSize) && this.content.readFinal()) {
                return;
            }
        }
        catch (Exception exception) {
            throw new PKCS7Exception("Cannot decode content." + exception.getMessage());
        }
        throw new PKCS7Exception("Cannot decode content.");
    }

    private void e() throws PKCS7Exception {
        if (this.theCertPathCtx == null) {
            throw new PKCS7Exception("CertPathCtx object is null, cannot get Database.");
        }
        if (this.theCertJ == null) {
            throw new PKCS7Exception("CertJ object is NULL.");
        }
        DatabaseService databaseService = this.theCertPathCtx.getDatabase();
        int n = 0;
        Vector vector = new Vector();
        JSAFE_PrivateKey jSAFE_PrivateKey = null;
        try {
            for (n = 0; n < this.recipients.size(); ++n) {
                Object object;
                RecipientInfo recipientInfo = (RecipientInfo)this.recipients.elementAt(n);
                int n2 = databaseService.selectCertificateByIssuerAndSerialNumber(recipientInfo.getIssuerName(), recipientInfo.getSerialNumber(), vector);
                if (n2 == 0) continue;
                for (int i = 0; i < n2 && (jSAFE_PrivateKey = databaseService.selectPrivateKeyByCertificate((Certificate)(object = (X509Certificate)vector.elementAt(i)))) == null; ++i) {
                }
                if (jSAFE_PrivateKey == null) {
                    vector.removeAllElements();
                    continue;
                }
                byte[] byArray = recipientInfo.getEncryptedKey();
                if (byArray == null) {
                    throw new PKCS7Exception("Recipient's encrypted Secret key is not set.");
                }
                object = this.info.getEncryptionAlgorithm();
                if (object == null) {
                    throw new PKCS7Exception("Encryption Algorithm is not set.");
                }
                JSAFE_SymmetricCipher jSAFE_SymmetricCipher = JSAFE_SymmetricCipher.getInstance((byte[])object, (int)0, (String)"Java");
                String string = jSAFE_SymmetricCipher.getEncryptionAlgorithm();
                byte[] byArray2 = recipientInfo.getEncryptionAlgorithmOID();
                if (byArray2 == null) {
                    throw new PKCS7Exception("Recipient's Encryption Algorithm is not set.");
                }
                JSAFE_AsymmetricCipher jSAFE_AsymmetricCipher = JSAFE_AsymmetricCipher.getInstance((byte[])byArray2, (int)0, (String)this.getDeviceOrJava());
                jSAFE_AsymmetricCipher.decryptInit(jSAFE_PrivateKey, this.theCertJ.getPKCS11Sessions());
                this.a = jSAFE_AsymmetricCipher.unwrapSecretKey(byArray, 0, byArray.length, false, string);
                jSAFE_AsymmetricCipher.clearSensitiveData();
                jSAFE_PrivateKey.clearSensitiveData();
                vector.removeAllElements();
                break;
            }
            if (n == this.recipients.size()) {
                throw new PKCS7Exception("Private Key is not set");
            }
        }
        catch (NoServiceException noServiceException) {
            throw new PKCS7Exception("Cannot get Cert from DB." + noServiceException.getMessage());
        }
        catch (DatabaseException databaseException) {
            throw new PKCS7Exception("Cannot get Cert from DB." + databaseException.getMessage());
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new PKCS7Exception("Could not decode encrypted key" + jSAFE_Exception.getMessage());
        }
    }

    protected int contentReadUpdate(byte[] byArray, int n, int n2) throws PKCS7Exception {
        int n3 = 0;
        if (byArray == null) {
            return n3;
        }
        if (this.contentASN1Template == null) {
            throw new PKCS7Exception("Call readInit before readUpdate.");
        }
        try {
            if (this.contentASN1Template.isComplete()) {
                return n3;
            }
            n3 = this.contentASN1Template.berDecodeUpdate(byArray, n, n2);
            this.c();
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Could not decode message: " + aSN_Exception.getMessage());
        }
    }

    public boolean equals(Object object) {
        int n;
        if (object == null || !(object instanceof EnvelopedData)) {
            return false;
        }
        EnvelopedData envelopedData = (EnvelopedData)object;
        if (envelopedData.version != this.version) {
            return false;
        }
        if (this.content != null && !this.content.equals(envelopedData.content)) {
            return false;
        }
        int n2 = this.recipients.size();
        if (n2 != (n = envelopedData.recipients.size())) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (this.recipients.elementAt(i) == null) continue;
            int n3 = 0;
            for (n3 = 0; n3 < n && !this.recipients.elementAt(i).equals(envelopedData.recipients.elementAt(n3)); ++n3) {
            }
            if (n3 != n) continue;
            return false;
        }
        return !(this.info != null ? !this.info.equals(envelopedData.info) : envelopedData.info != null);
    }

    public Object clone() throws CloneNotSupportedException {
        EnvelopedData envelopedData = (EnvelopedData)super.clone();
        envelopedData.version = this.version;
        envelopedData.recipients = (Vector)this.recipients.clone();
        envelopedData.info = (EncryptedContentInfo)this.info.clone();
        return envelopedData;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.recipients = new Vector();
        this.version = -1;
        this.info = new EncryptedContentInfo();
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

