/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs7;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.pkcs7.ContentInfo;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_MessageDigest;
import java.io.Serializable;

public class DigestedData
extends ContentInfo
implements Cloneable,
Serializable {
    protected int version = -1;
    protected byte[] digestOID;
    private String a;
    private byte[] b = null;

    public DigestedData(CertJ certJ, CertPathCtx certPathCtx) {
        this.contentType = 5;
        this.theCertJ = certJ;
        this.theCertPathCtx = certPathCtx;
    }

    public void setContentInfo(ContentInfo contentInfo) throws PKCS7Exception {
        if (contentInfo == null) {
            throw new PKCS7Exception("Unable to set content: content is null.");
        }
        try {
            this.content = (ContentInfo)contentInfo.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new PKCS7Exception("Unable to clone ContentInfo type");
        }
    }

    public void setVersionNumber(int n) {
        this.version = n;
    }

    public int getVersionNumber() {
        return this.version;
    }

    public void setDigestAlgorithm(String string) throws PKCS7Exception {
        this.digestOID = DigestedData.a(string);
        this.a = string;
    }

    static byte[] a(String string) throws PKCS7Exception {
        if (string == null) {
            throw new PKCS7Exception("Could not set digest algorithm: algName is null");
        }
        try {
            JSAFE_MessageDigest jSAFE_MessageDigest = JSAFE_MessageDigest.getInstance((String)string, (String)"Java");
            return jSAFE_MessageDigest.getDERAlgorithmID();
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new PKCS7Exception("Could not set algorithm algorithm: algName is invalid");
        }
    }

    public void setDigestAlgorithm(byte[] byArray, int n, int n2) throws PKCS7Exception {
        this.digestOID = DigestedData.a(byArray, n, n2);
    }

    static byte[] a(byte[] byArray, int n, int n2) throws PKCS7Exception {
        if (byArray == null || n2 <= 0) {
            throw new PKCS7Exception("Could not set algorithm OID: oid is null.");
        }
        if (n < 0 || n + n2 > byArray.length) {
            throw new PKCS7Exception("Invalid digest algorithm identifier.");
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public byte[] getDigestAlgorithmOID() {
        return this.digestOID;
    }

    public String getDigestAlgorithmName() throws PKCS7Exception {
        return DigestedData.a(this.digestOID, this.a);
    }

    static String a(byte[] byArray, String string) throws PKCS7Exception {
        if (byArray == null) {
            return null;
        }
        if (string != null) {
            return string;
        }
        try {
            JSAFE_MessageDigest jSAFE_MessageDigest = JSAFE_MessageDigest.getInstance((byte[])byArray, (int)0, (String)"Java");
            return jSAFE_MessageDigest.getAlgorithm();
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new PKCS7Exception("Could not set algorithm OID: " + jSAFE_Exception.getMessage());
        }
    }

    protected int getContentDERLen() throws PKCS7Exception {
        return this.a();
    }

    protected int writeContent(byte[] byArray, int n) throws PKCS7Exception {
        if (byArray == null) {
            throw new PKCS7Exception("Cannot write DigestedData: output array is null.");
        }
        try {
            if (this.contentASN1Template == null) {
                this.getContentDERLen();
            }
            int n2 = this.contentASN1Template.derEncode(byArray, n);
            this.contentASN1Template = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            this.contentASN1Template = null;
            throw new PKCS7Exception("Unable to DER encode DigestedData message: " + aSN_Exception.getMessage());
        }
    }

    private int a() throws PKCS7Exception {
        if (this.content == null) {
            throw new PKCS7Exception("content is not set.");
        }
        if (this.flag == 0) {
            this.b = this.b();
        }
        if (this.version == -1) {
            this.version = 0;
        }
        if (this.contentEncoding == null) {
            int n = this.content.getContentInfoDERLen();
            this.contentEncoding = new byte[n];
            n = this.content.writeMessage(this.contentEncoding, 0);
        }
        try {
            EncodedContainer encodedContainer = new EncodedContainer(0, true, 0, this.contentEncoding, 0, this.contentEncoding.length);
            SequenceContainer sequenceContainer = new SequenceContainer(0xA10000, true, 0);
            EndContainer endContainer = new EndContainer();
            IntegerContainer integerContainer = new IntegerContainer(0, true, 0, this.version);
            EncodedContainer encodedContainer2 = new EncodedContainer(12288, true, 0, this.digestOID, 0, this.digestOID.length);
            int n = 0;
            if (this.b != null) {
                n = this.b.length;
            }
            OctetStringContainer octetStringContainer = new OctetStringContainer(0, true, 0, this.b, 0, n);
            this.contentASN1Def = new ASN1Container[6];
            this.contentASN1Def[0] = sequenceContainer;
            this.contentASN1Def[1] = integerContainer;
            this.contentASN1Def[2] = encodedContainer2;
            this.contentASN1Def[3] = encodedContainer;
            this.contentASN1Def[4] = octetStringContainer;
            this.contentASN1Def[5] = endContainer;
            this.contentASN1Template = new ASN1Template(this.contentASN1Def);
            return this.contentASN1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception(aSN_Exception.getMessage());
        }
    }

    public byte[] getMessageDigest() {
        if (this.b == null) {
            return null;
        }
        byte[] byArray = new byte[this.b.length];
        System.arraycopy(this.b, 0, byArray, 0, this.b.length);
        return byArray;
    }

    private byte[] b() throws PKCS7Exception {
        Object object;
        SequenceContainer sequenceContainer;
        byte[] byArray = null;
        try {
            if (this.contentEncoding == null) {
                int n = this.content.getContentInfoDERLen();
                this.contentEncoding = new byte[n];
                n = this.content.writeMessage(this.contentEncoding, 0);
            }
            sequenceContainer = new SequenceContainer(0);
            EndContainer endContainer = new EndContainer();
            object = new OIDContainer(0x1000000);
            EncodedContainer encodedContainer = new EncodedContainer(10616576);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, object, encodedContainer, endContainer};
            ASN1.berDecode((byte[])this.contentEncoding, (int)0, (ASN1Container[])aSN1ContainerArray);
            if (encodedContainer.dataPresent) {
                int n = 1;
                n += ASN1Lengths.determineLengthLen((byte[])encodedContainer.data, (int)(encodedContainer.dataOffset + 1));
                ++n;
                n += ASN1Lengths.determineLengthLen((byte[])encodedContainer.data, (int)(encodedContainer.dataOffset + n));
                byArray = new byte[encodedContainer.dataLen - n];
                System.arraycopy(encodedContainer.data, encodedContainer.dataOffset + n, byArray, 0, encodedContainer.dataLen - n);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Could not DER encode ContentInfo: " + aSN_Exception.getMessage());
        }
        try {
            if (byArray == null) {
                return null;
            }
            sequenceContainer = JSAFE_MessageDigest.getInstance((byte[])this.digestOID, (int)0, (String)this.getDeviceOrJava());
            int n = sequenceContainer.getDigestSize();
            object = new byte[n];
            sequenceContainer.digestInit();
            sequenceContainer.digestUpdate(byArray, 0, byArray.length);
            object = sequenceContainer.digestFinal();
            sequenceContainer.clearSensitiveData();
            return object;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new PKCS7Exception("Could not digest ContentInfo: " + jSAFE_Exception.getMessage());
        }
    }

    protected boolean contentReadInit(byte[] byArray, int n, int n2) throws PKCS7Exception {
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0xA10000);
            EndContainer endContainer = new EndContainer();
            IntegerContainer integerContainer = new IntegerContainer(0);
            EncodedContainer encodedContainer = new EncodedContainer(12288);
            EncodedContainer encodedContainer2 = new EncodedContainer(12288, true, 0, this.maxBufferSize, null, 0, 0);
            OctetStringContainer octetStringContainer = new OctetStringContainer(0);
            this.contentASN1Def = new ASN1Container[6];
            this.contentASN1Def[0] = sequenceContainer;
            this.contentASN1Def[1] = integerContainer;
            this.contentASN1Def[2] = encodedContainer;
            this.contentASN1Def[3] = encodedContainer2;
            this.contentASN1Def[4] = octetStringContainer;
            this.contentASN1Def[5] = endContainer;
            this.contentASN1Template = new ASN1Template(this.contentASN1Def);
            this.contentASN1Template.berDecodeInit();
            this.contentASN1Template.berDecodeUpdate(byArray, n, n2);
            if (this.contentASN1Def[0].checkTag()) {
                return false;
            }
            this.c();
            this.flag = 1;
            return true;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Could not decode message: " + aSN_Exception.getMessage());
        }
    }

    private void c() throws PKCS7Exception {
        block27: {
            try {
                byte[] byArray;
                if (this.version == -1) {
                    if (this.contentASN1Def[1].isComplete()) {
                        if (this.incompleteContainer == 1) {
                            byArray = this.copyToOutput(this.contentASN1Def[1]);
                            IntegerContainer integerContainer = new IntegerContainer(0, true, 0, byArray, 0, byArray.length, true);
                            this.version = integerContainer.getValueAsInt();
                        } else {
                            this.version = ((IntegerContainer)this.contentASN1Def[1]).getValueAsInt();
                        }
                    } else {
                        if (this.contentASN1Def[1].data == null) {
                            return;
                        }
                        this.incompleteContainer = 1;
                        this.copyNewData(this.contentASN1Def[1].data, this.contentASN1Def[1].dataOffset, this.contentASN1Def[1].dataLen, 0);
                        return;
                    }
                }
                if (this.digestOID == null) {
                    if (this.contentASN1Def[2].isComplete()) {
                        if (this.incompleteContainer == 2) {
                            this.digestOID = this.copyToOutput(this.contentASN1Def[2]);
                        } else {
                            this.digestOID = new byte[this.contentASN1Def[2].dataLen];
                            System.arraycopy(this.contentASN1Def[2].data, this.contentASN1Def[2].dataOffset, this.digestOID, 0, this.contentASN1Def[2].dataLen);
                        }
                    } else {
                        if (this.contentASN1Def[2].data == null) {
                            return;
                        }
                        this.incompleteContainer = 2;
                        this.copyNewData(this.contentASN1Def[2].data, this.contentASN1Def[2].dataOffset, this.contentASN1Def[2].dataLen, 0);
                        return;
                    }
                }
                if (this.content == null) {
                    if (this.contentASN1Def[3].isComplete()) {
                        if (this.incompleteContainer == 3) {
                            byArray = this.copyToOutput(this.contentASN1Def[3]);
                            this.b(byArray, 0, byArray.length);
                        } else {
                            this.b(this.contentASN1Def[3].data, this.contentASN1Def[3].dataOffset, this.contentASN1Def[3].dataLen);
                        }
                    } else {
                        if (this.contentASN1Def[3].data == null) {
                            return;
                        }
                        this.incompleteContainer = 3;
                        this.copyNewData(this.contentASN1Def[3].data, this.contentASN1Def[3].dataOffset, this.contentASN1Def[3].dataLen, this.maxBufferSize);
                        return;
                    }
                }
                byArray = this.b();
                if (this.b != null) break block27;
                if (this.contentASN1Def[4].isComplete()) {
                    if (this.contentASN1Def[4].data == null && byArray == null) {
                        return;
                    }
                    if (this.incompleteContainer == 4) {
                        this.b = this.copyToOutput(this.contentASN1Def[4]);
                    } else if (this.contentASN1Def[4].data != null) {
                        this.b = new byte[this.contentASN1Def[4].dataLen];
                        System.arraycopy(this.contentASN1Def[4].data, this.contentASN1Def[4].dataOffset, this.b, 0, this.contentASN1Def[4].dataLen);
                    }
                    if (!CertJUtils.byteArraysEqual(this.b, byArray)) {
                        throw new PKCS7Exception("Invalid digest.");
                    }
                    break block27;
                }
                if (this.contentASN1Def[4].data == null) {
                    return;
                }
                this.incompleteContainer = 4;
                this.copyNewData(this.contentASN1Def[4].data, this.contentASN1Def[4].dataOffset, this.contentASN1Def[4].dataLen, 0);
                return;
            }
            catch (Exception exception) {
                throw new PKCS7Exception("Cannot set decoded values." + exception.getMessage());
            }
        }
    }

    private void b(byte[] byArray, int n, int n2) throws PKCS7Exception {
        if (byArray == null || n2 == 0) {
            throw new PKCS7Exception("Cannot decode DigestedData: data is null.");
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0);
            EndContainer endContainer = new EndContainer();
            OIDContainer oIDContainer = new OIDContainer(0x1000000);
            EncodedContainer encodedContainer = new EncodedContainer(10616576, true, 0, this.maxBufferSize, null, 0, 0);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            this.content = ContentInfo.getInstance(oIDContainer.data, oIDContainer.dataOffset, oIDContainer.dataLen, this.theCertJ, this.theCertPathCtx);
            if (this.content.readInit(byArray, n, n2, this.maxBufferSize) && this.content.readFinal()) {
                return;
            }
        }
        catch (Exception exception) {
            throw new PKCS7Exception("Cannot decode content." + exception.getMessage());
        }
        throw new PKCS7Exception("Cannot decode content.");
    }

    protected int contentReadUpdate(byte[] byArray, int n, int n2) throws PKCS7Exception {
        int n3 = 0;
        if (byArray == null) {
            return n3;
        }
        if (this.contentASN1Template == null) {
            throw new PKCS7Exception("Call readInit before readUpdate.");
        }
        try {
            if (this.contentASN1Template.isComplete()) {
                return n3;
            }
            n3 = this.contentASN1Template.berDecodeUpdate(byArray, n, n2);
            this.c();
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Could not decode message: " + aSN_Exception.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DigestedData digestedData = (DigestedData)super.clone();
        digestedData.version = this.version;
        if (this.b != null) {
            digestedData.b = (byte[])this.b.clone();
        }
        if (this.digestOID != null) {
            digestedData.digestOID = (byte[])this.digestOID.clone();
        }
        return digestedData;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DigestedData)) {
            return false;
        }
        DigestedData digestedData = (DigestedData)object;
        if (this.version != digestedData.version) {
            return false;
        }
        if (this.content != null && !this.content.equals(digestedData.content)) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.b, digestedData.b)) {
            return false;
        }
        return CertJUtils.byteArraysEqual(this.digestOID, digestedData.digestOID);
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.version = -1;
        this.digestOID = null;
        this.b = null;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

