/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs7;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.pkcs7.ContentInfo;
import com.rsa.certj.pkcs7.PKCS7Exception;
import java.io.Serializable;

public class Data
extends ContentInfo
implements Cloneable,
Serializable {
    protected byte[] data;
    protected int dataLen;

    public Data() {
        this.contentType = 1;
        OctetStringContainer octetStringContainer = null;
        try {
            octetStringContainer = new OctetStringContainer(0xA10000, true, 0, null, 0, 0);
        }
        catch (ASN_Exception aSN_Exception) {
            // empty catch block
        }
        this.contentASN1Def = new ASN1Container[1];
        this.contentASN1Def[0] = octetStringContainer;
    }

    public void setContent(byte[] byArray, int n, int n2) throws PKCS7Exception {
        if (byArray == null || n2 <= 0) {
            throw new PKCS7Exception("content is null");
        }
        if (n < 0 || n + n2 > byArray.length) {
            throw new PKCS7Exception("Invalid Content data");
        }
        this.data = new byte[n2];
        System.arraycopy(byArray, n, this.data, 0, n2);
        this.dataLen = n2;
    }

    public byte[] getData() {
        if (this.data != null) {
            byte[] byArray = new byte[this.dataLen];
            System.arraycopy(this.data, 0, byArray, 0, this.dataLen);
            return byArray;
        }
        return null;
    }

    protected int getContentDERLen() throws PKCS7Exception {
        this.contentASN1Def[0].data = null;
        this.contentASN1Def[0].dataLen = this.dataLen;
        this.contentASN1Def[0].dataPresent = this.data != null;
        this.contentASN1Template = new ASN1Template(this.contentASN1Def);
        try {
            return this.contentASN1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception(aSN_Exception.getMessage());
        }
    }

    protected int writeContent(byte[] byArray, int n) throws PKCS7Exception {
        if (byArray == null) {
            throw new PKCS7Exception("Cannot write Data: output array is null.");
        }
        try {
            this.contentASN1Def[0].data = this.data;
            this.contentASN1Def[0].dataOffset = 0;
            this.contentASN1Def[0].dataLen = this.dataLen;
            return this.contentASN1Template.derEncode(byArray, n);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Could not DER encode Data: " + aSN_Exception.getMessage());
        }
    }

    protected boolean contentReadInit(byte[] byArray, int n, int n2) throws PKCS7Exception {
        try {
            if (this.maxBufferSize != 0) {
                OctetStringContainer octetStringContainer = new OctetStringContainer(0xA10000, true, 0, this.maxBufferSize, null, 0, 0);
                this.contentASN1Def = new ASN1Container[1];
                this.contentASN1Def[0] = octetStringContainer;
            }
            this.contentASN1Template = new ASN1Template(this.contentASN1Def);
            this.contentASN1Template.berDecodeInit();
            this.numberOfBytesRead = this.contentASN1Template.berDecodeUpdate(byArray, n, n2);
            this.a();
            return true;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Could not decode message: " + aSN_Exception.getMessage());
        }
    }

    protected int contentReadUpdate(byte[] byArray, int n, int n2) throws PKCS7Exception {
        this.numberOfBytesRead = 0;
        int n3 = 0;
        if (byArray == null) {
            return n3;
        }
        if (this.contentASN1Template == null) {
            this.contentASN1Template = new ASN1Template(this.contentASN1Def);
            this.contentASN1Template.berDecodeInit();
        }
        try {
            if (this.contentASN1Template.isComplete()) {
                return n3;
            }
            this.numberOfBytesRead = this.contentASN1Template.berDecodeUpdate(byArray, n, n2);
            return n3 += this.a();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Could not decode message: " + aSN_Exception.getMessage());
        }
    }

    private int a() {
        int n;
        if (this.contentASN1Def[0].data == null || this.contentASN1Def[0].dataLen == 0) {
            return 0;
        }
        int n2 = 0;
        if (this.data == null) {
            this.data = this.maxBufferSize != 0 ? new byte[this.maxBufferSize] : new byte[this.contentASN1Def[0].dataLen];
        }
        if ((n2 = this.data.length - this.dataLen) < this.contentASN1Def[0].dataLen) {
            byte[] byArray = new byte[this.dataLen];
            System.arraycopy(this.data, 0, byArray, 0, this.dataLen);
            this.clearInternalBuffer(this.data);
            this.data = new byte[this.contentASN1Def[0].dataLen + this.dataLen];
            System.arraycopy(byArray, 0, this.data, 0, this.dataLen);
            this.clearInternalBuffer(byArray);
        }
        if ((n = this.contentASN1Def[0].dataLen) != 0) {
            System.arraycopy(this.contentASN1Def[0].data, this.contentASN1Def[0].dataOffset, this.data, this.dataLen, n);
        }
        this.dataLen += n;
        return n;
    }

    public int getUnprocessedDataLen() {
        return this.dataLen;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Data)) {
            return false;
        }
        Data data = (Data)object;
        if (this.dataLen != data.dataLen) {
            return false;
        }
        return CertJUtils.byteArraysEqual(this.data, 0, this.dataLen, data.data, 0, data.dataLen);
    }

    public Object clone() throws CloneNotSupportedException {
        Data data = (Data)super.clone();
        if (this.data != null) {
            data.data = new byte[this.data.length];
            System.arraycopy(this.data, 0, data.data, 0, this.dataLen);
            data.dataLen = this.dataLen;
        }
        return data;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.clearInternalBuffer(this.data);
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

