/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs7;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.certj.CertJ;
import com.rsa.certj.pkcs7.CMSData;
import com.rsa.certj.pkcs7.Ch;
import com.rsa.certj.pkcs7.ContentInfo;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.pkcs7.SignedData;
import com.rsa.certj.spi.path.CertPathCtx;
import java.io.Serializable;
import java.util.Vector;

public class CMSSignedData
extends SignedData
implements Cloneable,
Serializable {
    public CMSSignedData(String string, CertJ certJ, CertPathCtx certPathCtx) throws PKCS7Exception {
        super(certJ, certPathCtx);
        this.oid = Ch.a(string);
        this.version = 3;
    }

    protected ContentInfo buildContentContainer(byte[] byArray, int n, int n2) throws PKCS7Exception {
        return new CMSData(this.oid);
    }

    protected byte[] initOctets(ASN1Container aSN1Container, ASN1Container aSN1Container2) throws ASN_Exception {
        return this.initDataOctets(aSN1Container, aSN1Container2);
    }

    public void setVersionNumber(int n) {
        this.version = n == 3 ? n : 3;
    }

    protected byte[] getOidType() {
        return this.oid;
    }

    protected void assignDetachedMessageContentInfoSeq() {
        int n = this.oid.length;
        this.contentEncoding = new byte[n + 4];
        this.contentEncoding[0] = 48;
        this.contentEncoding[1] = (byte)(n + 2);
        this.contentEncoding[2] = 6;
        this.contentEncoding[3] = (byte)n;
        System.arraycopy(this.oid, 0, this.contentEncoding, 4, n);
    }

    public Object clone() throws CloneNotSupportedException {
        CMSSignedData cMSSignedData = (CMSSignedData)super.clone();
        cMSSignedData.oid = this.oid;
        return cMSSignedData;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CMSSignedData)) {
            return false;
        }
        CMSSignedData cMSSignedData = (CMSSignedData)object;
        if (this.oid.length != cMSSignedData.oid.length) {
            return false;
        }
        for (int i = 0; i < this.oid.length; ++i) {
            if (this.oid[i] == cMSSignedData.oid[i]) continue;
            return false;
        }
        return true;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.version = 3;
        this.digestIDs = new Vector();
        this.digestNames = new Vector();
        this.digests = new Vector();
        this.certs = new Vector();
        this.crls = new Vector();
        this.signers = new Vector();
    }
}

