/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.UTF8StringContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.crmf.CRMFException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Vector;

public class RegInfo
implements Cloneable,
Serializable {
    public static final byte[] REG_INFO_OID = new byte[]{43, 6, 1, 5, 5, 7, 5, 2, 1};
    private String a = null;
    private Vector b = new Vector();
    protected int special;
    protected ASN1Template asn1Template = null;

    public RegInfo() {
    }

    public RegInfo(String string, String string2) throws CRMFException {
        this.addNameValuePair(string, string2, false);
    }

    public RegInfo(byte[] byArray, int n, int n2) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("RegInfo Encoding is null.");
        }
        this.special = n2;
        try {
            OfContainer ofContainer = new OfContainer(n2, 12288, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            int n3 = ofContainer.getContainerCount();
            for (int i = 0; i < n3; ++i) {
                ASN1Container aSN1Container = ofContainer.containerAt(i);
                SequenceContainer sequenceContainer = new SequenceContainer(0);
                EndContainer endContainer = new EndContainer();
                OIDContainer oIDContainer = new OIDContainer(0x1000000);
                UTF8StringContainer uTF8StringContainer = new UTF8StringContainer(0);
                ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer, oIDContainer, uTF8StringContainer, endContainer};
                ASN1.berDecode((byte[])aSN1Container.data, (int)aSN1Container.dataOffset, (ASN1Container[])aSN1ContainerArray2);
                byte[] byArray2 = new byte[oIDContainer.dataLen];
                System.arraycopy(oIDContainer.data, oIDContainer.dataOffset, byArray2, 0, oIDContainer.dataLen);
                if (!CertJUtils.byteArraysEqual(byArray2, REG_INFO_OID)) {
                    throw new CRMFException("Wrong OID");
                }
                if (uTF8StringContainer.data == null) continue;
                this.a = new String(uTF8StringContainer.data, uTF8StringContainer.dataOffset, uTF8StringContainer.dataLen);
                this.b.addElement(this.a);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Cannot read the BER of the regInfo." + aSN_Exception.getMessage());
        }
    }

    public void addNameValuePair(String string, String string2, boolean bl) throws CRMFException {
        if (string == null || string2 == null) {
            throw new CRMFException("Passed in RegInfo values are null.");
        }
        this.a = new String(this.a(string));
        this.a = this.a.concat("?");
        this.a = this.a.concat(this.a(string2));
        this.a = this.a.concat("%");
        if (!bl && this.b.size() != 0) {
            String string3 = (String)this.b.lastElement();
            this.b.removeElement(string3);
            this.a = string3 = string3.concat(this.a);
        }
        this.b.addElement(this.a);
        this.a = null;
    }

    public String getAttribute(int n) throws CRMFException {
        if (this.getRegInfoCount() > n) {
            return (String)this.b.elementAt(n);
        }
        throw new CRMFException("The specified RegInfo index is invalid.");
    }

    public int getRegInfoCount() {
        return this.b.size();
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("RegInfo Encoding is null.");
        }
        if (byArray[n] == 0 && byArray[n + 1] == 0) {
            return n + 2;
        }
        try {
            return n + 1 + ASN1Lengths.determineLengthLen((byte[])byArray, (int)(n + 1)) + ASN1Lengths.determineLength((byte[])byArray, (int)(n + 1));
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Unable to determine length of the RegInfo BER" + aSN_Exception.getMessage());
        }
    }

    public int getDERLen(int n) throws CRMFException {
        return this.a(n);
    }

    public int getDEREncoding(byte[] byArray, int n, int n2) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("Specified RegInfo array is null.");
        }
        int n3 = 0;
        try {
            if (this.asn1Template == null || this.special != n2) {
                this.getDERLen(n2);
            }
            n3 = this.asn1Template.derEncode(byArray, n);
            this.asn1Template = null;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            throw new CRMFException("Unable to encode RegInfo." + aSN_Exception.getMessage());
        }
        return n3;
    }

    private int a(int n) throws CRMFException {
        this.special = n;
        Vector<OfContainer> vector = new Vector<OfContainer>();
        try {
            OfContainer ofContainer = new OfContainer(n, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
            vector.addElement(ofContainer);
            int n2 = 0;
            if (this.b != null) {
                n2 = this.b.size();
            }
            for (int i = 0; i < n2; ++i) {
                this.a = (String)this.b.elementAt(i);
                byte[] byArray = this.a.getBytes();
                SequenceContainer sequenceContainer = new SequenceContainer(n, true, 0);
                EndContainer endContainer = new EndContainer();
                OIDContainer oIDContainer = new OIDContainer(0x1000000, true, 0, REG_INFO_OID, 0, REG_INFO_OID.length);
                UTF8StringContainer uTF8StringContainer = new UTF8StringContainer(0, true, 0, byArray, 0, byArray.length);
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, uTF8StringContainer, endContainer};
                this.asn1Template = new ASN1Template(aSN1ContainerArray);
                int n3 = this.asn1Template.derEncodeInit();
                byte[] byArray2 = new byte[n3];
                n3 = this.asn1Template.derEncode(byArray2, 0);
                EncodedContainer encodedContainer = new EncodedContainer(0, true, 0, byArray2, 0, n3);
                ofContainer.addContainer((ASN1Container)encodedContainer);
            }
            Object[] objectArray = new ASN1Container[vector.size()];
            vector.copyInto(objectArray);
            this.asn1Template = new ASN1Template((ASN1Container[])objectArray);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException(aSN_Exception.getMessage());
        }
    }

    public boolean equals(Object object) {
        int n;
        if (object == null || !(object instanceof RegInfo)) {
            return false;
        }
        RegInfo regInfo = (RegInfo)object;
        int n2 = this.b.size();
        if (n2 != (n = regInfo.b.size())) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (this.b.elementAt(i).equals(regInfo.b.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        RegInfo regInfo = new RegInfo();
        regInfo.b = (Vector)this.b.clone();
        try {
            if (this.asn1Template != null) {
                regInfo.a(this.special);
            }
        }
        catch (CRMFException cRMFException) {
            throw new CloneNotSupportedException(cRMFException.getMessage());
        }
        return regInfo;
    }

    private String a(String string) {
        return URLEncoder.encode(string);
    }
}

