/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.CertRequest;
import com.rsa.certj.crmf.CertTemplate;
import com.rsa.certj.crmf.POPOPrivKey;
import com.rsa.certj.crmf.POPOSigningKeyInput;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_Signature;
import java.io.Serializable;
import java.security.SecureRandom;

public class ProofOfPossession
implements Cloneable,
Serializable {
    public static final int RA_VERIFIED_POP = 0;
    public static final int SIGNATURE_POP = 1;
    public static final int ENCIPHERMENT_POP = 2;
    public static final int AGREEMENT_POP = 3;
    private static final int a = 0x800500;
    private static final int b = 8400897;
    private int c;
    private POPOSigningKeyInput d = null;
    private POPOPrivKey e = new POPOPrivKey();
    private byte[] f = null;
    private byte[] g = null;
    String h = new String();
    CertRequest i = null;
    private CertJ j;
    protected JSAFE_PublicKey pubKey = null;
    protected JSAFE_PrivateKey privKey = null;
    private ASN1Template k = null;
    private int l = 0;

    public ProofOfPossession() {
    }

    public ProofOfPossession(CertJ certJ) {
        this.j = certJ;
    }

    public ProofOfPossession(int n) throws CRMFException {
        this(n, null);
    }

    public ProofOfPossession(int n, CertJ certJ) throws CRMFException {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new CRMFException("This POP is not supported.");
        }
        this.c = n;
        this.j = certJ;
    }

    public void decodeProofOfPossession(byte[] byArray, int n, int n2) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("ProofOfPossession Encoding is null.");
        }
        ChoiceContainer choiceContainer = new ChoiceContainer(n2);
        EndContainer endContainer = new EndContainer();
        EncodedContainer encodedContainer = new EncodedContainer(0x800500);
        EncodedContainer encodedContainer2 = new EncodedContainer(8400897);
        EncodedContainer encodedContainer3 = new EncodedContainer(10551042);
        EncodedContainer encodedContainer4 = new EncodedContainer(10551043);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{choiceContainer, encodedContainer, encodedContainer2, encodedContainer3, encodedContainer4, endContainer};
        try {
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException(aSN_Exception.getMessage());
        }
        if (encodedContainer.dataPresent) {
            this.c = 0;
        } else if (encodedContainer2.dataPresent) {
            this.c = 1;
            this.a(encodedContainer2.data, encodedContainer2.dataOffset);
        } else if (encodedContainer3.dataPresent) {
            this.c = 2;
            this.e.setEnvironment(this.j, this.pubKey, this.privKey);
            this.e.decodePOPOPrivKey(encodedContainer3.data, encodedContainer3.dataOffset, 0xA00002);
        } else if (encodedContainer4.dataPresent) {
            this.c = 3;
            this.e.setEnvironment(this.j, this.pubKey, this.privKey);
            this.e.decodePOPOPrivKey(encodedContainer4.data, encodedContainer4.dataOffset, 0xA00003);
        }
    }

    private void a(byte[] byArray, int n) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("Signature Proof Of Possession is NULL.");
        }
        SequenceContainer sequenceContainer = new SequenceContainer(8400897);
        EndContainer endContainer = new EndContainer();
        EncodedContainer encodedContainer = new EncodedContainer(8466432);
        EncodedContainer encodedContainer2 = new EncodedContainer(12288);
        BitStringContainer bitStringContainer = new BitStringContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, encodedContainer2, bitStringContainer, endContainer};
        try {
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Could not BER decode the POP." + aSN_Exception.getMessage());
        }
        if (encodedContainer.dataPresent) {
            this.d = new POPOSigningKeyInput(encodedContainer.data, encodedContainer.dataOffset);
        }
        this.f = new byte[bitStringContainer.dataLen];
        System.arraycopy(bitStringContainer.data, bitStringContainer.dataOffset, this.f, 0, bitStringContainer.dataLen);
        this.setSignatureAlgorithm(encodedContainer2.data, encodedContainer2.dataOffset, encodedContainer2.dataLen);
    }

    public boolean verifySignature(String string, SecureRandom secureRandom) throws CRMFException {
        JSAFE_PublicKey jSAFE_PublicKey = null;
        JSAFE_Signature jSAFE_Signature = null;
        int n = 0;
        byte[] byArray = null;
        if (this.f == null) {
            throw new CRMFException("Signature is null, cannot verify it.");
        }
        if (this.d != null) {
            n = this.d.getDERLen();
            if (n == 0) {
                throw new CRMFException("Cannot DER-encode poposkInput.");
            }
            byArray = new byte[n];
            n = this.d.getDEREncoding(byArray, 0);
            jSAFE_PublicKey = this.d.getSubjectPublicKey();
        } else {
            if (this.i == null) {
                throw new CRMFException("CertRequest is not set.");
            }
            CertTemplate certTemplate = this.i.getCertTemplate();
            jSAFE_PublicKey = certTemplate.getSubjectPublicKey();
            if (jSAFE_PublicKey == null) {
                throw new CRMFException("Public key is not set in CertRequest; Cannot verify the signature.");
            }
            n = this.i.getDERLen(0);
            if (n == 0) {
                throw new CRMFException("Cannot DER-encode CertRequest.");
            }
            byArray = new byte[n];
            n = this.i.getDEREncoding(byArray, 0, 0);
        }
        try {
            boolean bl;
            jSAFE_Signature = JSAFE_Signature.getInstance((String)this.h, (String)string);
            if (this.j == null) {
                jSAFE_Signature.verifyInit(jSAFE_PublicKey, secureRandom);
            } else {
                jSAFE_Signature.verifyInit(jSAFE_PublicKey, null, secureRandom, this.j.getPKCS11Sessions());
            }
            jSAFE_Signature.verifyUpdate(byArray, 0, byArray.length);
            boolean bl2 = bl = jSAFE_Signature.verifyFinal(this.f, 0, this.f.length);
            return bl2;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CRMFException("Could not verify the POP's signature: " + jSAFE_Exception.getMessage());
        }
        finally {
            if (jSAFE_Signature != null) {
                jSAFE_Signature.clearSensitiveData();
            }
        }
    }

    public int getPOPType() {
        return this.c;
    }

    public POPOSigningKeyInput getPOPOSigningKeyInput() {
        if (this.c != 1) {
            return null;
        }
        return this.d;
    }

    public void setPOPOSigningKeyInput(POPOSigningKeyInput pOPOSigningKeyInput) throws CRMFException {
        if (this.c != 1) {
            throw new CRMFException("This POP is NOT POPOSigningKey type.");
        }
        if (pOPOSigningKeyInput == null) {
            throw new CRMFException("POPOSigningKeyInput object is null.");
        }
        this.d = pOPOSigningKeyInput;
    }

    public String getAlgTransformation() {
        if (this.c != 1) {
            return null;
        }
        return this.h;
    }

    public byte[] getAlgBER() {
        if (this.c != 1 || this.g == null) {
            return null;
        }
        byte[] byArray = new byte[this.g.length];
        System.arraycopy(this.g, 0, byArray, 0, this.g.length);
        return byArray;
    }

    public void setSignatureAlgorithm(String string) throws CRMFException {
        if (this.c != 1) {
            throw new CRMFException("This POP is NOT POPOSigningKey type.");
        }
        if (string == null) {
            throw new CRMFException("POP Transformation is null.");
        }
        this.h = new String(string);
        try {
            this.g = AlgorithmID.derEncodeAlgID((String)string, (int)1, null, (int)0, (int)0);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("POP Transformation is invalid. " + aSN_Exception.getMessage());
        }
    }

    public void setSignatureAlgorithm(byte[] byArray, int n, int n2) throws CRMFException {
        if (this.c != 1) {
            throw new CRMFException("This POP is NOT POPOSigningKey type.");
        }
        if (byArray == null || n2 == 0) {
            throw new CRMFException("POP Algorithm ID is null.");
        }
        try {
            this.g = new byte[n2];
            System.arraycopy(byArray, n, this.g, 0, n2);
            this.h = AlgorithmID.berDecodeAlgID((byte[])byArray, (int)n, (int)1, null);
            if (this.h == null) {
                throw new CRMFException("Unknown Signature Algorithm in POP.");
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Cannot set Signature Algorithm in POP." + aSN_Exception.getMessage());
        }
    }

    public byte[] getSignature() {
        if (this.c != 1 || this.f == null) {
            return null;
        }
        byte[] byArray = new byte[this.f.length];
        System.arraycopy(this.f, 0, byArray, 0, this.f.length);
        return byArray;
    }

    public void setCertRequest(CertRequest certRequest) throws CRMFException {
        if (this.c != 1) {
            throw new CRMFException("This POP is NOT POPOSigningKey type.");
        }
        if (certRequest == null) {
            throw new CRMFException("The request in POP is NULL.");
        }
        CertTemplate certTemplate = certRequest.getCertTemplate();
        if (certTemplate == null) {
            throw new CRMFException("Invalid CertRequest: CertTemplate is missing.");
        }
        if (certTemplate.getSubjectName() == null || certTemplate.getSubjectPublicKey() == null) {
            throw new CRMFException("Subject Name and / or Public Key values are missing.");
        }
        this.i = certRequest;
    }

    public void signPOP(String string, JSAFE_PrivateKey jSAFE_PrivateKey, SecureRandom secureRandom) throws CRMFException {
        if (this.c != 1) {
            throw new CRMFException("This POP is NOT POPOSigningKey type.");
        }
        int n = 0;
        byte[] byArray = null;
        if (this.i != null) {
            this.d = null;
            n = this.i.getDERLen(0);
            if (n == 0) {
                throw new CRMFException("Cannot DER-encode CertRequest in POP.");
            }
            byArray = new byte[n];
            n = this.i.getDEREncoding(byArray, 0, 0);
        } else {
            if (this.d == null) {
                throw new CRMFException("Data is not set in poposkInput.");
            }
            n = this.d.getDERLen();
            if (n == 0) {
                throw new CRMFException("Cannot DER-encode poposkInput.");
            }
            byArray = new byte[n];
            n = this.d.getDEREncoding(byArray, 0);
            byArray[0] = 48;
        }
        JSAFE_Signature jSAFE_Signature = null;
        try {
            jSAFE_Signature = JSAFE_Signature.getInstance((String)this.h, (String)string);
            if (this.j == null) {
                jSAFE_Signature.signInit(jSAFE_PrivateKey, secureRandom);
            } else {
                jSAFE_Signature.signInit(jSAFE_PrivateKey, null, secureRandom, this.j.getPKCS11Sessions());
            }
            jSAFE_Signature.signUpdate(byArray, 0, byArray.length);
            this.f = jSAFE_Signature.signFinal();
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CRMFException("Could not sign the POP: " + jSAFE_Exception.getMessage());
        }
        finally {
            if (jSAFE_Signature != null) {
                jSAFE_Signature.clearSensitiveData();
            }
        }
    }

    public void setEnvironment(CertJ certJ, JSAFE_PublicKey jSAFE_PublicKey, JSAFE_PrivateKey jSAFE_PrivateKey) {
        this.j = certJ;
        if (jSAFE_PublicKey != null) {
            this.pubKey = jSAFE_PublicKey;
        }
        if (jSAFE_PrivateKey != null) {
            this.privKey = jSAFE_PrivateKey;
        }
    }

    public void setCertJ(CertJ certJ) {
        this.j = certJ;
    }

    public CertJ getCertJ() {
        return this.j;
    }

    public void setKeys(JSAFE_PublicKey jSAFE_PublicKey, JSAFE_PrivateKey jSAFE_PrivateKey) {
        if (jSAFE_PublicKey != null) {
            this.pubKey = jSAFE_PublicKey;
        }
        if (jSAFE_PrivateKey != null) {
            this.privKey = jSAFE_PrivateKey;
        }
    }

    public void setPOPOPrivKey(POPOPrivKey pOPOPrivKey) throws CRMFException {
        if (this.c != 2 && this.c != 3) {
            throw new CRMFException("Wrong POP type.");
        }
        if (pOPOPrivKey == null) {
            throw new CRMFException("POPOPrivateKey object is null.");
        }
        this.e = pOPOPrivKey;
    }

    public POPOPrivKey getPOPOPrivKey() throws CRMFException {
        return this.e;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            ProofOfPossession proofOfPossession = new ProofOfPossession(this.c);
            if (this.d != null) {
                proofOfPossession.d = (POPOSigningKeyInput)this.d.clone();
            }
            if (this.f != null) {
                proofOfPossession.f = new byte[this.f.length];
                System.arraycopy(this.f, 0, proofOfPossession.f, 0, this.f.length);
            }
            if (this.g != null) {
                proofOfPossession.g = new byte[this.g.length];
                System.arraycopy(this.g, 0, proofOfPossession.g, 0, this.g.length);
            }
            proofOfPossession.h = this.h;
            if (this.i != null) {
                proofOfPossession.i = (CertRequest)this.i.clone();
            }
            if (this.e != null) {
                proofOfPossession.e = (POPOPrivKey)this.e.clone();
            }
            proofOfPossession.setEnvironment(this.j, this.pubKey, this.privKey);
            return proofOfPossession;
        }
        catch (CRMFException cRMFException) {
            throw new CloneNotSupportedException(cRMFException.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ProofOfPossession)) {
            return false;
        }
        ProofOfPossession proofOfPossession = (ProofOfPossession)object;
        if (this.c != proofOfPossession.c) {
            return false;
        }
        if (this.i != null ? !this.i.equals(proofOfPossession.i) : proofOfPossession.i != null) {
            return false;
        }
        if (this.d != null ? !this.d.equals(proofOfPossession.d) : proofOfPossession.d != null) {
            return false;
        }
        if (this.h != null ? !this.h.equals(proofOfPossession.h) : proofOfPossession.h != null) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.g, proofOfPossession.g)) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.f, proofOfPossession.f)) {
            return false;
        }
        return !(this.e != null ? !this.e.equals(proofOfPossession.e) : proofOfPossession.e != null);
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("Encoding is null.");
        }
        try {
            return n + 1 + ASN1Lengths.determineLengthLen((byte[])byArray, (int)(n + 1)) + ASN1Lengths.determineLength((byte[])byArray, (int)(n + 1));
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Could not read the BER encoding of ProofOfPossession." + aSN_Exception.getMessage());
        }
    }

    public int getDERLen(int n) throws CRMFException {
        this.l = n;
        return this.a();
    }

    public int getDEREncoding(byte[] byArray, int n, int n2) throws CRMFException {
        this.l = n2;
        if (byArray == null) {
            throw new CRMFException("Specified array in ProofOfPossession is null.");
        }
        if (this.c == 0) {
            byArray[0] = -128;
            byArray[1] = 0;
            return 2;
        }
        int n3 = 0;
        try {
            if (this.k == null) {
                this.getDERLen(n2);
            }
            n3 = this.k.derEncode(byArray, n);
            this.k = null;
        }
        catch (ASN_Exception aSN_Exception) {
            this.k = null;
            throw new CRMFException("Unable to encode ProofOfPossession." + aSN_Exception.getMessage());
        }
        return n3;
    }

    private int a() throws CRMFException {
        if (this.c == 0) {
            return 2;
        }
        try {
            ASN1Container[] aSN1ContainerArray;
            Object object;
            SequenceContainer sequenceContainer;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            int n = 0;
            byte[] byArray = null;
            EndContainer endContainer = new EndContainer();
            if (this.c == 1) {
                bl = true;
                sequenceContainer = new SequenceContainer(8400897, true, 0);
                boolean bl4 = true;
                int n2 = 0;
                object = null;
                if (this.d == null) {
                    bl4 = false;
                } else {
                    n2 = this.d.getDERLen();
                    object = new byte[n2];
                    n2 = this.d.getDEREncoding((byte[])object, 0);
                }
                aSN1ContainerArray = new EncodedContainer(8466432, bl4, 0, object, 0, n2);
                if (this.g == null) {
                    throw new CRMFException("Signature Algorithm ID is not set.");
                }
                EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, this.g, 0, this.g.length);
                if (this.f == null) {
                    throw new CRMFException("Signature is not set.");
                }
                BitStringContainer bitStringContainer = new BitStringContainer(0, true, 0, this.f, 0, this.f.length);
                ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer, aSN1ContainerArray, encodedContainer, bitStringContainer, endContainer};
                ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray2);
                n = aSN1Template.derEncodeInit();
                byArray = new byte[n];
                n = aSN1Template.derEncode(byArray, 0);
            } else if (this.c == 2) {
                if (this.e == null) {
                    throw new CRMFException("POPOPrivKey is not set.");
                }
                bl2 = true;
                n = this.e.getDERLen(0xA00002);
                byArray = new byte[n];
                n = this.e.getDEREncoding(byArray, 0, 0xA00002);
            } else if (this.c == 3) {
                if (this.e == null) {
                    throw new CRMFException("POPOPrivKey is not set.");
                }
                bl3 = true;
                n = this.e.getDERLen(0xA00003);
                byArray = new byte[n];
                n = this.e.getDEREncoding(byArray, 0, 0xA00003);
            }
            sequenceContainer = new ChoiceContainer(this.l, 0);
            EncodedContainer encodedContainer = new EncodedContainer(8400897, bl, 0, byArray, 0, n);
            EncodedContainer encodedContainer2 = new EncodedContainer(10551042, bl2, 0, byArray, 0, n);
            object = new EncodedContainer(10551043, bl3, 0, byArray, 0, n);
            aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, encodedContainer2, (ASN1Container)object, endContainer};
            this.k = new ASN1Template(aSN1ContainerArray);
            return this.k.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException(aSN_Exception.getMessage());
        }
    }
}

