/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.Control;
import java.io.Serializable;

public class OldCertID
extends Control
implements Cloneable,
Serializable {
    private GeneralName a = null;
    private byte[] b = null;
    ASN1Template c;
    private int d = 0;

    public OldCertID() {
        this.controlTypeFlag = 4;
        ((Control)this).a = new byte[Control.OID_LIST[4].length];
        System.arraycopy(Control.OID_LIST[4], 0, ((Control)this).a, 0, ((Control)this).a.length);
        this.controlTypeString = "OldCertID";
    }

    public void decodeValue(byte[] byArray, int n) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("OldCertID Encoding is null.");
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(this.d);
            EndContainer endContainer = new EndContainer();
            EncodedContainer encodedContainer = new EncodedContainer(65280);
            IntegerContainer integerContainer = new IntegerContainer(0);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, integerContainer, endContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            this.b = new byte[integerContainer.dataLen];
            System.arraycopy(integerContainer.data, integerContainer.dataOffset, this.b, 0, integerContainer.dataLen);
            this.a = new GeneralName(encodedContainer.data, encodedContainer.dataOffset, 0);
        }
        catch (Exception exception) {
            throw new CRMFException("Cannot decode OldCertID control." + exception.getMessage());
        }
    }

    public void setCertIssuerName(GeneralName generalName) throws CRMFException {
        if (generalName == null) {
            throw new CRMFException("Issuer Name in OldCertID control cannot be null.");
        }
        try {
            this.a = (GeneralName)generalName.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CRMFException("Invalid Issuer Name." + cloneNotSupportedException.getMessage());
        }
    }

    public void setSerialNumber(byte[] byArray, int n, int n2) throws CRMFException {
        if (byArray == null || n2 <= 0 || n < 0) {
            throw new CRMFException("Passed in SerialNumber value is null in OldCertID control.");
        }
        this.b = new byte[n2];
        System.arraycopy(byArray, n, this.b, 0, n2);
    }

    public byte[] getSerialNumber() {
        if (this.b == null) {
            return null;
        }
        return (byte[])this.b.clone();
    }

    public GeneralName getCertIssuerName() {
        if (this.a == null) {
            return null;
        }
        try {
            return (GeneralName)this.a.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected int derEncodeValue(byte[] byArray, int n) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("Passed in array is null in OldCertID control.");
        }
        if (this.c == null && this.derEncodeValueInit() == 0) {
            throw new CRMFException("Cannot encode OldCertID control.");
        }
        int n2 = 0;
        try {
            n2 = this.c.derEncode(byArray, n);
            this.asn1Template = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Cannot encode OldCertID control." + aSN_Exception.getMessage());
        }
    }

    protected int derEncodeValueInit() throws CRMFException {
        this.c = null;
        SequenceContainer sequenceContainer = new SequenceContainer(this.d, true, 0);
        EndContainer endContainer = new EndContainer();
        if (this.a == null) {
            throw new CRMFException("Issuer Name is not set in OldCertID control.");
        }
        EncodedContainer encodedContainer = null;
        byte[] byArray = null;
        int n = 0;
        try {
            n = this.a.getDERLen(0);
            byArray = new byte[n];
            n = this.a.getDEREncoding(byArray, 0, 0);
        }
        catch (NameException nameException) {
            throw new CRMFException("Cannot encode IssuerName. " + nameException.getMessage());
        }
        try {
            encodedContainer = new EncodedContainer(12288, true, 0, byArray, 0, n);
            if (this.b == null) {
                throw new CRMFException("Serial Number is not set in OldCertID control.");
            }
            IntegerContainer integerContainer = null;
            integerContainer = (this.b[0] & 0x80) >> 7 == 0 ? new IntegerContainer(0, true, 0, this.b, 0, this.b.length, true) : new IntegerContainer(0, true, 0, this.b, 0, this.b.length, false);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, integerContainer, endContainer};
            this.c = new ASN1Template(aSN1ContainerArray);
            return this.c.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException(aSN_Exception.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        OldCertID oldCertID = new OldCertID();
        if (this.a != null) {
            oldCertID.a = (GeneralName)this.a.clone();
        }
        if (this.b != null) {
            oldCertID.b = (byte[])this.b.clone();
        }
        oldCertID.d = this.d;
        super.copyValues(oldCertID);
        return oldCertID;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof OldCertID)) {
            return false;
        }
        OldCertID oldCertID = (OldCertID)object;
        if (this.a != null ? !this.a.equals(oldCertID.a) : oldCertID.a != null) {
            return false;
        }
        return CertJUtils.byteArraysEqual(this.b, oldCertID.b);
    }
}

