/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.EncryptedValue;
import com.rsa.certj.pkcs7.EnvelopedData;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.Serializable;

public class EncryptedKey
implements Cloneable,
Serializable {
    public static final int ENCRYPTED_VALUE = 0;
    public static final int ENVELOPED_DATA = 1;
    private CertPathCtx a;
    private CertJ b;
    private JSAFE_PublicKey c = null;
    private JSAFE_PrivateKey d = null;
    private int e = -1;
    private EncryptedValue f = null;
    private EnvelopedData g = null;
    private int h = 0;
    private ASN1Template i = null;

    public EncryptedKey(CertJ certJ, CertPathCtx certPathCtx, JSAFE_PublicKey jSAFE_PublicKey, JSAFE_PrivateKey jSAFE_PrivateKey) throws CRMFException {
        if (certJ == null) {
            throw new CRMFException("Specified CertJ value is NULL.");
        }
        this.b = certJ;
        this.a = certPathCtx;
        if (jSAFE_PublicKey != null) {
            this.c = jSAFE_PublicKey;
        }
        if (jSAFE_PrivateKey != null) {
            this.d = jSAFE_PrivateKey;
        }
    }

    public void decodeEncryptedKey(byte[] byArray, int n, int n2) throws CRMFException {
        block8: {
            if (byArray == null) {
                throw new CRMFException("Encoding EncryptedKey is null.");
            }
            this.h = n2;
            try {
                ChoiceContainer choiceContainer = new ChoiceContainer(n2);
                EncodedContainer encodedContainer = new EncodedContainer(12288);
                EncodedContainer encodedContainer2 = new EncodedContainer(0x803000);
                EndContainer endContainer = new EndContainer();
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{choiceContainer, encodedContainer, encodedContainer2, endContainer};
                ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
                if (encodedContainer.dataPresent) {
                    this.f = new EncryptedValue(this.b, this.c, this.d);
                    this.f.decodeEncryptedValue(encodedContainer.data, encodedContainer.dataOffset, 0);
                    this.e = 0;
                    break block8;
                }
                if (!encodedContainer2.dataPresent) break block8;
                this.e = 1;
                this.g = new EnvelopedData(this.b, this.a);
                try {
                    boolean bl = this.g.readInit(encodedContainer2.data, encodedContainer2.dataOffset, encodedContainer2.dataLen, 0x803000);
                    if (!bl) {
                        throw new CRMFException("Not enough data in EnvelopedData.");
                    }
                    bl = this.g.readFinal();
                    if (!bl) {
                        throw new CRMFException("Invalid data in EnvelopedData.");
                    }
                }
                catch (PKCS7Exception pKCS7Exception) {
                    throw new CRMFException(pKCS7Exception.getMessage());
                }
            }
            catch (ASN_Exception aSN_Exception) {
                throw new CRMFException("Cannot decode the BER of the EncryptedKey." + aSN_Exception.getMessage());
            }
        }
    }

    public void setType(int n) throws CRMFException {
        if (n != 0 && n != 1) {
            throw new CRMFException("Invalid EncryptedKey type.");
        }
        this.e = n;
    }

    public int getType() {
        return this.e;
    }

    public void setEncryptedValue(EncryptedValue encryptedValue) throws CRMFException {
        if (this.e == 1) {
            throw new CRMFException("Wrong type: this EncryptedKey object is of ENVELOPED_DATA type");
        }
        if (encryptedValue == null) {
            throw new CRMFException("specified EncryptedValue object is null.");
        }
        try {
            this.f = (EncryptedValue)encryptedValue.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CRMFException("Invalid Encrypted Value." + cloneNotSupportedException.getMessage());
        }
    }

    public EncryptedValue getEncryptedValue() throws CRMFException {
        if (this.e == 1) {
            throw new CRMFException("Wrong type: this EncryptedKey object is of ENVELOPED_DATA type");
        }
        if (this.f == null) {
            return null;
        }
        try {
            return (EncryptedValue)this.f.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CRMFException("Invalid Encrypted Value." + cloneNotSupportedException.getMessage());
        }
    }

    public void setEnvelopedData(EnvelopedData envelopedData) throws CRMFException {
        if (this.e == 0) {
            throw new CRMFException("Wrong type: this EncryptedKey object is of ENCRYPTED_VALUE type");
        }
        if (envelopedData == null) {
            throw new CRMFException("Specified EnvelopedData object is NULL.");
        }
        try {
            this.g = (EnvelopedData)envelopedData.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CRMFException("Invalid Enveloped Data." + cloneNotSupportedException.getMessage());
        }
    }

    public EnvelopedData getEnvelopedData() throws CRMFException {
        if (this.e == 0) {
            throw new CRMFException("Wrong type: this EncryptedKey object is of ENCRYPTED_VALUE type");
        }
        if (this.g == null) {
            return null;
        }
        try {
            return (EnvelopedData)this.g.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CRMFException("Invalid Enveloped Data." + cloneNotSupportedException.getMessage());
        }
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("EncryptedKey Encoding is null.");
        }
        try {
            return n + 1 + ASN1Lengths.determineLengthLen((byte[])byArray, (int)(n + 1)) + ASN1Lengths.determineLength((byte[])byArray, (int)(n + 1));
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Could not read the BER encoding." + aSN_Exception.getMessage());
        }
    }

    public int getDERLen(int n) throws CRMFException {
        this.h = n;
        return this.a();
    }

    public int getDEREncoding(byte[] byArray, int n, int n2) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("Specified array is null in EncryptedKey.");
        }
        this.h = n2;
        int n3 = 0;
        try {
            if (this.i == null) {
                this.getDERLen(n2);
            }
            n3 = this.i.derEncode(byArray, n);
            this.i = null;
        }
        catch (ASN_Exception aSN_Exception) {
            this.i = null;
            throw new CRMFException("Unable to encode EncryptedKey." + aSN_Exception.getMessage());
        }
        return n3;
    }

    private int a() throws CRMFException {
        try {
            byte[] byArray = null;
            int n = 0;
            boolean bl = false;
            boolean bl2 = false;
            if (this.f != null) {
                n = this.f.getDERLen(0);
                byArray = new byte[n];
                n = this.f.getDEREncoding(byArray, 0, 0);
                bl = true;
            } else if (this.g != null) {
                n = this.g.getContentInfoDERLen(0x803000);
                byArray = new byte[n];
                n = this.g.writeMessage(byArray, 0, 0x800000);
                bl2 = true;
            } else {
                throw new CRMFException("EncryptedKey Data is not set.");
            }
            ChoiceContainer choiceContainer = new ChoiceContainer(this.h, 0);
            EndContainer endContainer = new EndContainer();
            EncodedContainer encodedContainer = new EncodedContainer(0x803000, bl2, 0, byArray, 0, n);
            EncodedContainer encodedContainer2 = new EncodedContainer(12288, bl, 0, byArray, 0, n);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{choiceContainer, encodedContainer2, encodedContainer, endContainer};
            this.i = new ASN1Template(aSN1ContainerArray);
            return this.i.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException(aSN_Exception.getMessage());
        }
        catch (PKCS7Exception pKCS7Exception) {
            throw new CRMFException(pKCS7Exception.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            EncryptedKey encryptedKey = new EncryptedKey(this.b, this.a, this.c, this.d);
            if (this.g != null) {
                encryptedKey.g = (EnvelopedData)this.g.clone();
            }
            if (this.f != null) {
                encryptedKey.f = (EncryptedValue)this.f.clone();
            }
            encryptedKey.e = this.e;
            encryptedKey.h = this.h;
            if (this.i != null) {
                encryptedKey.a();
            }
            return encryptedKey;
        }
        catch (CRMFException cRMFException) {
            throw new CloneNotSupportedException(cRMFException.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof EncryptedKey)) {
            return false;
        }
        EncryptedKey encryptedKey = (EncryptedKey)object;
        if (this.e != encryptedKey.e) {
            return false;
        }
        if (this.g != null ? !this.g.equals(encryptedKey.g) : encryptedKey.g != null) {
            return false;
        }
        return !(this.f != null ? !this.f.equals(encryptedKey.f) : encryptedKey.f != null);
    }
}

