/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.CertTemplate;
import com.rsa.certj.crmf.Controls;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.Serializable;

public class CertRequest
implements Cloneable,
Serializable {
    private int a;
    private CertTemplate b;
    private Controls c;
    protected int special;
    private ASN1Template d;
    private CertPathCtx e;
    private CertJ f;
    private JSAFE_PublicKey g = null;
    private JSAFE_PrivateKey h = null;

    public CertRequest() {
    }

    public void decodeCertRequest(byte[] byArray, int n, int n2) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("CertRequest Encoding is null.");
        }
        this.special = n2;
        SequenceContainer sequenceContainer = new SequenceContainer(n2);
        EndContainer endContainer = new EndContainer();
        IntegerContainer integerContainer = new IntegerContainer(0);
        EncodedContainer encodedContainer = new EncodedContainer(12288);
        EncodedContainer encodedContainer2 = new EncodedContainer(77824);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer, encodedContainer2, endContainer};
        try {
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            this.a = integerContainer.getValueAsInt();
            this.b = new CertTemplate(encodedContainer.data, encodedContainer.dataOffset, 0);
            if (encodedContainer2.dataPresent) {
                this.c = new Controls();
                this.c.setEnvironment(this.f, this.e, this.g, this.h);
                this.c.decodeControls(encodedContainer2.data, encodedContainer2.dataOffset, 0);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Could not BER decode the cert request info." + aSN_Exception.getMessage());
        }
    }

    public CertRequest(int n, CertTemplate certTemplate, Controls controls) throws CRMFException {
        this.a = n;
        if (certTemplate == null) {
            throw new CRMFException("Cert Template is null.");
        }
        try {
            this.b = (CertTemplate)certTemplate.clone();
            if (controls != null) {
                this.c = (Controls)controls.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CRMFException("Unable to create CertRequest object" + cloneNotSupportedException.getMessage());
        }
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("Encoding is null.");
        }
        try {
            return n + 1 + ASN1Lengths.determineLengthLen((byte[])byArray, (int)(n + 1)) + ASN1Lengths.determineLength((byte[])byArray, (int)(n + 1));
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Could not read the BER encoding." + aSN_Exception.getMessage());
        }
    }

    public void setRequestID(int n) {
        this.a = n;
    }

    public int getRequestID() {
        return this.a;
    }

    public void setCertTemplate(CertTemplate certTemplate) throws CRMFException {
        if (certTemplate == null) {
            throw new CRMFException("Cert Template is NULL.");
        }
        try {
            this.b = (CertTemplate)certTemplate.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CRMFException("Unable to set CertTemplate" + cloneNotSupportedException.getMessage());
        }
    }

    public CertTemplate getCertTemplate() throws CRMFException {
        if (this.b == null) {
            return null;
        }
        try {
            return (CertTemplate)this.b.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CRMFException("Unable to get CertTemplate" + cloneNotSupportedException.getMessage());
        }
    }

    public void setControls(Controls controls) throws CRMFException {
        try {
            if (controls != null) {
                this.c = (Controls)controls.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CRMFException("Unable to set Controls" + cloneNotSupportedException.getMessage());
        }
    }

    public Controls getControls() throws CRMFException {
        if (this.c == null) {
            return null;
        }
        try {
            return (Controls)this.c.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CRMFException("Unable to get Controls" + cloneNotSupportedException.getMessage());
        }
    }

    public int getDERLen(int n) throws CRMFException {
        return this.a(n);
    }

    public int getDEREncoding(byte[] byArray, int n, int n2) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("Specified array is null.");
        }
        int n3 = 0;
        try {
            if (this.d == null || this.special != n2) {
                this.getDERLen(n2);
            }
            n3 = this.d.derEncode(byArray, n);
            this.d = null;
        }
        catch (ASN_Exception aSN_Exception) {
            this.d = null;
            throw new CRMFException("Unable to encode CertRequest." + aSN_Exception.getMessage());
        }
        return n3;
    }

    private int a(int n) throws CRMFException {
        try {
            this.special = n;
            SequenceContainer sequenceContainer = new SequenceContainer(n, true, 0);
            EndContainer endContainer = new EndContainer();
            IntegerContainer integerContainer = new IntegerContainer(0, true, 0, this.a);
            if (this.b == null) {
                throw new CRMFException("Cert Template is not set.");
            }
            int n2 = this.b.getDERLen(0);
            byte[] byArray = new byte[n2];
            n2 = this.b.getDEREncoding(byArray, 0, 0);
            EncodedContainer encodedContainer = new EncodedContainer(0, true, 0, byArray, 0, n2);
            boolean bl = false;
            int n3 = 0;
            byte[] byArray2 = null;
            if (this.c != null) {
                bl = true;
                n3 = this.c.getDERLen(65536);
                byArray2 = new byte[n3];
                n3 = this.c.getDEREncoding(byArray2, 0, 0);
            }
            EncodedContainer encodedContainer2 = new EncodedContainer(65536, bl, 0, byArray2, 0, n3);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer, encodedContainer2, endContainer};
            this.d = new ASN1Template(aSN1ContainerArray);
            return this.d.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException(aSN_Exception.getMessage());
        }
    }

    public void setEnvironment(CertJ certJ, CertPathCtx certPathCtx, JSAFE_PublicKey jSAFE_PublicKey, JSAFE_PrivateKey jSAFE_PrivateKey) {
        this.f = certJ;
        this.e = certPathCtx;
        if (jSAFE_PublicKey != null) {
            this.g = jSAFE_PublicKey;
        }
        if (jSAFE_PrivateKey != null) {
            this.h = jSAFE_PrivateKey;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CertRequest)) {
            return false;
        }
        CertRequest certRequest = (CertRequest)object;
        if (this.special != certRequest.special) {
            return false;
        }
        if (this.a != certRequest.a) {
            return false;
        }
        if (this.b != null ? !this.b.equals(certRequest.b) : certRequest.b != null) {
            return false;
        }
        return !(this.c != null ? !this.c.equals(certRequest.c) : certRequest.c != null);
    }

    public Object clone() throws CloneNotSupportedException {
        CertRequest certRequest = new CertRequest();
        certRequest.setEnvironment(this.f, this.e, this.g, this.h);
        certRequest.special = this.special;
        certRequest.a = this.a;
        if (this.b != null) {
            certRequest.b = (CertTemplate)this.b.clone();
        }
        if (this.c != null) {
            certRequest.c = (Controls)this.c.clone();
        }
        try {
            if (this.d != null) {
                certRequest.a(this.special);
            }
        }
        catch (CRMFException cRMFException) {
            throw new CloneNotSupportedException(cRMFException.getMessage());
        }
        return certRequest;
    }
}

