/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.attributes.X501Attribute;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;

public class VeriSignNonVerifiedElements
extends X509V3Extension
implements Cloneable,
Serializable,
CertExtension {
    private X501Attributes a = new X501Attributes();
    ASN1Template b;

    public VeriSignNonVerifiedElements() {
        this.extensionTypeFlag = 116;
        this.criticality = false;
        this.setSpecialOID(X509V3Extension.VERISIGN_NON_VERIFIED_OID);
        this.extensionTypeString = "VeriSignNonVerifiedElements";
    }

    public VeriSignNonVerifiedElements(X501Attributes x501Attributes, boolean bl) {
        this.extensionTypeFlag = 116;
        bl = false;
        this.setSpecialOID(X509V3Extension.VERISIGN_NON_VERIFIED_OID);
        this.extensionTypeString = "VeriSignNonVerifiedElements";
        this.criticality = bl;
        try {
            if (x501Attributes != null) {
                this.a = (X501Attributes)x501Attributes.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    public void addAttribute(X501Attribute x501Attribute) {
        if (x501Attribute != null) {
            this.a.addAttribute(x501Attribute);
        }
    }

    public void setAttributes(X501Attributes x501Attributes) {
        try {
            if (x501Attributes != null) {
                this.a = (X501Attributes)x501Attributes.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    public int getAttributeCount() {
        return this.a.getAttributeCount();
    }

    public X501Attribute getAttributeByIndex(int n) throws CertificateException {
        if (n < this.a.getAttributeCount()) {
            return this.a.getAttributeByIndex(n);
        }
        throw new CertificateException("Invalid Index");
    }

    public X501Attributes getAttributes() {
        try {
            return (X501Attributes)this.a.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void decodeValue(byte[] byArray, int n) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            this.a = new X501Attributes(byArray, n, 0);
        }
        catch (AttributeException attributeException) {
            throw new CertificateException("Could not decode VeriSignNonVerifiedElements extension.");
        }
    }

    public int derEncodeValueInit() {
        try {
            byte[] byArray = new byte[this.a.getDERLen(0)];
            int n = this.a.getDEREncoding(byArray, 0, 0);
            EncodedContainer encodedContainer = new EncodedContainer(12544, true, 0, byArray, 0, n);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{encodedContainer};
            this.b = new ASN1Template(aSN1ContainerArray);
            return this.b.derEncodeInit();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] byArray, int n) {
        if (byArray == null) {
            return 0;
        }
        try {
            if (this.b == null && this.derEncodeValueInit() == 0) {
                return 0;
            }
            int n2 = this.b.derEncode(byArray, n);
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        VeriSignNonVerifiedElements veriSignNonVerifiedElements = new VeriSignNonVerifiedElements();
        veriSignNonVerifiedElements.a = (X501Attributes)this.a.clone();
        super.copyValues(veriSignNonVerifiedElements);
        return veriSignNonVerifiedElements;
    }

    protected void reset() {
        super.reset();
        this.a = null;
    }
}

