/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.asn1.TeletexStringContainer;
import com.rsa.certj.cert.NameException;
import java.io.Serializable;

public class TeletexPersonalName
implements Cloneable,
Serializable {
    private String a;
    private String b;
    private String c;
    private String d;
    protected int special;
    protected ASN1Template asn1Template = null;
    private static final int e = 0x800000;
    private static final int f = 0x810001;
    private static final int g = 8454146;
    private static final int h = 8454147;

    public TeletexPersonalName(byte[] byArray, int n, int n2) throws NameException {
        this.special = n2;
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            SetContainer setContainer = new SetContainer(n2);
            TeletexStringContainer teletexStringContainer = new TeletexStringContainer(0x800000, 1, 40);
            TeletexStringContainer teletexStringContainer2 = new TeletexStringContainer(0x810001, 1, 16);
            TeletexStringContainer teletexStringContainer3 = new TeletexStringContainer(8454146, 1, 5);
            TeletexStringContainer teletexStringContainer4 = new TeletexStringContainer(8454147, 1, 3);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, teletexStringContainer, teletexStringContainer2, teletexStringContainer3, teletexStringContainer4, endContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            this.a = teletexStringContainer.getValueAsString();
            if (teletexStringContainer2.dataPresent) {
                this.b = teletexStringContainer2.getValueAsString();
            }
            if (teletexStringContainer3.dataPresent) {
                this.c = teletexStringContainer3.getValueAsString();
            }
            if (teletexStringContainer4.dataPresent) {
                this.d = teletexStringContainer4.getValueAsString();
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Cannot decode the BER of the Teletex Personal name.");
        }
    }

    public TeletexPersonalName() {
    }

    public void setSurname(String string) {
        if (string != null) {
            this.a = string;
        }
    }

    public void setGivenName(String string) {
        if (string != null) {
            this.b = string;
        }
    }

    public void setInitials(String string) {
        if (string != null) {
            this.c = string;
        }
    }

    public void setGenerationQualifier(String string) {
        if (string != null) {
            this.d = string;
        }
    }

    public String getSurname() {
        return this.a;
    }

    public String getGivenName() {
        return this.b;
    }

    public String getInitials() {
        return this.c;
    }

    public String getGenerationQualifier() {
        return this.d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            stringBuffer.append(this.a);
        }
        if (this.b != null) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.b);
        }
        if (this.c != null) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.c);
        }
        if (this.d != null) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.d);
        }
        return stringBuffer.toString();
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        if (byArray[n] == 0 && byArray[n + 1] == 0) {
            return n + 2;
        }
        try {
            return n + 1 + ASN1Lengths.determineLengthLen((byte[])byArray, (int)(n + 1)) + ASN1Lengths.determineLength((byte[])byArray, (int)(n + 1));
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int n) {
        this.special = n;
        return this.a();
    }

    public int getDEREncoding(byte[] byArray, int n, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            if (this.asn1Template == null || n2 != this.special) {
                this.getDERLen(n2);
            }
            int n3 = this.asn1Template.derEncode(byArray, n);
            this.asn1Template = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            throw new NameException("Unable to encode TeletexPersonalName.");
        }
    }

    private int a() {
        if (this.asn1Template != null && this.special == this.special) {
            return 0;
        }
        try {
            int n = 0;
            SetContainer setContainer = new SetContainer(this.special, true, 0);
            EndContainer endContainer = new EndContainer();
            TeletexStringContainer teletexStringContainer = new TeletexStringContainer(0x800000, true, 0, this.a, 1, 40);
            TeletexStringContainer teletexStringContainer2 = null;
            TeletexStringContainer teletexStringContainer3 = null;
            TeletexStringContainer teletexStringContainer4 = null;
            if (this.b != null) {
                teletexStringContainer4 = new TeletexStringContainer(0x810001, true, 0, this.b, 1, 16);
                n = 1;
            }
            if (this.c != null) {
                teletexStringContainer3 = new TeletexStringContainer(8454146, true, 0, this.c, 1, 5);
                n = n == 0 ? 2 : 3;
            }
            if (this.d != null) {
                teletexStringContainer2 = new TeletexStringContainer(8454147, true, 0, this.d, 1, 3);
                n = n == 0 ? 4 : (n == 1 ? 5 : (n == 2 ? 6 : 7));
            }
            switch (n) {
                case 0: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, teletexStringContainer, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 1: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, teletexStringContainer, teletexStringContainer4, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 2: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, teletexStringContainer, teletexStringContainer3, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 3: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, teletexStringContainer, teletexStringContainer4, teletexStringContainer3, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 4: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, teletexStringContainer, teletexStringContainer2, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 5: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, teletexStringContainer, teletexStringContainer4, teletexStringContainer2, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 6: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, teletexStringContainer, teletexStringContainer3, teletexStringContainer2, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 7: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, teletexStringContainer, teletexStringContainer4, teletexStringContainer3, teletexStringContainer2, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                default: {
                    return 0;
                }
            }
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TeletexPersonalName)) {
            return false;
        }
        TeletexPersonalName teletexPersonalName = (TeletexPersonalName)object;
        if (this.a != null ? !this.a.equals(teletexPersonalName.a) : teletexPersonalName.a != null) {
            return false;
        }
        if (this.b != null ? !this.b.equals(teletexPersonalName.b) : teletexPersonalName.b != null) {
            return false;
        }
        if (this.c != null ? !this.c.equals(teletexPersonalName.c) : teletexPersonalName.c != null) {
            return false;
        }
        return !(this.d != null ? !this.d.equals(teletexPersonalName.d) : teletexPersonalName.d != null);
    }

    public Object clone() throws CloneNotSupportedException {
        TeletexPersonalName teletexPersonalName = new TeletexPersonalName();
        if (this.a != null) {
            teletexPersonalName.a = new String(this.a);
        }
        if (this.b != null) {
            teletexPersonalName.b = new String(this.b);
        }
        if (this.c != null) {
            teletexPersonalName.c = new String(this.c);
        }
        if (this.d != null) {
            teletexPersonalName.d = new String(this.d);
        }
        teletexPersonalName.special = this.special;
        if (this.asn1Template != null) {
            teletexPersonalName.a();
        }
        return teletexPersonalName;
    }
}

