/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;

public class SubjectKeyID
extends X509V3Extension
implements Cloneable,
Serializable,
CertExtension {
    private byte[] a;
    private int b;
    private int c;

    public SubjectKeyID() {
        this.extensionTypeFlag = 14;
        this.criticality = false;
        this.setStandardOID(14);
        this.extensionTypeString = "SubjectKeyID";
    }

    public SubjectKeyID(byte[] byArray, int n, int n2, boolean bl) {
        this.extensionTypeFlag = 14;
        this.criticality = bl;
        if (byArray != null && n2 != 0) {
            this.setKeyID(byArray, n, n2);
        }
        this.setStandardOID(14);
        this.extensionTypeString = "SubjectKeyID";
    }

    public void decodeValue(byte[] byArray, int n) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        OctetStringContainer octetStringContainer = new OctetStringContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{octetStringContainer};
        try {
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            this.a = null;
            throw new CertificateException("Could not decode SubjectKeyID extension.");
        }
        this.setKeyID(octetStringContainer.data, octetStringContainer.dataOffset, octetStringContainer.dataLen);
    }

    public void setKeyID(byte[] byArray, int n, int n2) {
        if (byArray == null || n2 == 0) {
            return;
        }
        try {
            OctetStringContainer octetStringContainer = new OctetStringContainer(0, true, 0, byArray, n, n2);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{octetStringContainer};
            this.a = ASN1.derEncode((ASN1Container[])aSN1ContainerArray);
            this.b = 1 + ASN1Lengths.determineLengthLen((byte[])this.a, (int)1);
            this.c = this.a.length - this.b;
        }
        catch (ASN_Exception aSN_Exception) {
            this.a = null;
            this.b = 0;
            this.c = 0;
            return;
        }
    }

    public byte[] getKeyID() {
        if (this.a == null) {
            return null;
        }
        byte[] byArray = new byte[this.c];
        System.arraycopy(this.a, this.b, byArray, 0, this.c);
        return byArray;
    }

    public int derEncodeValueInit() {
        if (this.a != null) {
            return this.a.length;
        }
        return 0;
    }

    public int derEncodeValue(byte[] byArray, int n) {
        if (byArray == null) {
            return 0;
        }
        if (this.a == null) {
            return 0;
        }
        System.arraycopy(this.a, 0, byArray, n, this.a.length);
        return this.a.length;
    }

    public Object clone() throws CloneNotSupportedException {
        SubjectKeyID subjectKeyID = new SubjectKeyID();
        if (this.a != null) {
            subjectKeyID.a = (byte[])this.a.clone();
            subjectKeyID.b = this.b;
            subjectKeyID.c = this.c;
        }
        super.copyValues(subjectKeyID);
        return subjectKeyID;
    }

    protected void reset() {
        super.reset();
        this.a = null;
    }
}

