/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;
import java.util.Vector;

public class QCStatements
extends X509V3Extension
implements Cloneable,
Serializable,
CertExtension {
    private Vector[] a = this.a();
    ASN1Template b;

    public QCStatements() {
        this.extensionTypeFlag = 123;
        this.criticality = false;
        this.setSpecialOID(X509V3Extension.QC_STATEMENTS_OID);
        this.extensionTypeString = "QC_Statements";
    }

    public QCStatements(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, boolean bl) throws CertificateException {
        this.addQCStatement(byArray, n, n2, byArray2, n3, n4);
        this.extensionTypeFlag = 123;
        this.criticality = bl;
        this.setSpecialOID(X509V3Extension.QC_STATEMENTS_OID);
        this.extensionTypeString = "QC_Statements";
    }

    private Vector[] a() {
        Vector[] vectorArray = new Vector[3];
        for (int i = 0; i < 3; ++i) {
            vectorArray[i] = new Vector();
        }
        return vectorArray;
    }

    public void decodeValue(byte[] byArray, int n) throws CertificateException {
        if (byArray == null || n < 0) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            OfContainer ofContainer = new OfContainer(0, 12288, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            int n2 = ofContainer.getContainerCount();
            for (int i = 0; i < n2; ++i) {
                ASN1Container aSN1Container = ofContainer.containerAt(i);
                SequenceContainer sequenceContainer = new SequenceContainer(0);
                EndContainer endContainer = new EndContainer();
                OIDContainer oIDContainer = new OIDContainer(0x1000000);
                EncodedContainer encodedContainer = new EncodedContainer(130816);
                ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
                ASN1.berDecode((byte[])aSN1Container.data, (int)aSN1Container.dataOffset, (ASN1Container[])aSN1ContainerArray2);
                if (encodedContainer.dataPresent) {
                    this.addQCStatement(oIDContainer.data, oIDContainer.dataOffset, oIDContainer.dataLen, encodedContainer.data, encodedContainer.dataOffset, encodedContainer.dataLen);
                    continue;
                }
                this.addQCStatement(oIDContainer.data, oIDContainer.dataOffset, oIDContainer.dataLen, null, 0, 0);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not decode QCStatements extension. " + aSN_Exception.getMessage());
        }
    }

    public void addQCStatement(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws CertificateException {
        if (byArray != null && n2 > 0 && n >= 0 && byArray.length >= n2 + n) {
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray, n, byArray3, 0, n2);
            this.a[0].addElement(byArray3);
            if (byArray2 != null && n4 > 0 && n3 >= 0 && byArray2.length >= n4 + n3) {
                byte[] byArray4 = new byte[n4];
                System.arraycopy(byArray2, n3, byArray4, 0, n4);
                this.a[1].addElement(byArray4);
            } else {
                this.a[1].addElement(null);
            }
        } else {
            if (byArray == null) {
                throw new CertificateException("Statement ID cannot be null.");
            }
            throw new CertificateException("Invalid parameter");
        }
    }

    public byte[] getQCStatementID(int n) throws CertificateException {
        if (this.a[0].size() <= n) {
            throw new CertificateException("Specified index is invalid.");
        }
        return (byte[])this.a[0].elementAt(n);
    }

    public byte[] getQCStatementInfo(int n) throws CertificateException {
        if (this.a[1].size() <= n) {
            throw new CertificateException("Specified index is invalid.");
        }
        return (byte[])this.a[1].elementAt(n);
    }

    public int getQCStatementCount() {
        return this.a[0].size();
    }

    public int derEncodeValueInit() {
        Vector<OfContainer> vector = new Vector<OfContainer>();
        try {
            OfContainer ofContainer = new OfContainer(0, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
            vector.addElement(ofContainer);
            for (int i = 0; i < this.a[0].size(); ++i) {
                byte[] byArray = (byte[])this.a[0].elementAt(i);
                byte[] byArray2 = i < this.a[1].size() ? (byte[])this.a[1].elementAt(i) : null;
                try {
                    SequenceContainer sequenceContainer = new SequenceContainer(0);
                    EndContainer endContainer = new EndContainer();
                    OIDContainer oIDContainer = new OIDContainer(0x1000000, true, 0, byArray, 0, byArray.length);
                    EncodedContainer encodedContainer = null;
                    encodedContainer = byArray2 != null ? new EncodedContainer(130816, true, 0, byArray2, 0, byArray2.length) : new EncodedContainer(130816, false, 0, null, 0, 0);
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    int n = this.asn1Template.derEncodeInit();
                    byte[] byArray3 = new byte[n];
                    n = this.asn1Template.derEncode(byArray3, 0);
                    EncodedContainer encodedContainer2 = new EncodedContainer(12288, true, 0, byArray3, 0, n);
                    ofContainer.addContainer((ASN1Container)encodedContainer2);
                    continue;
                }
                catch (ASN_Exception aSN_Exception) {
                    return 0;
                }
            }
            Object[] objectArray = new ASN1Container[vector.size()];
            vector.copyInto(objectArray);
            this.b = new ASN1Template((ASN1Container[])objectArray);
            return this.b.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] byArray, int n) {
        if (byArray == null) {
            return 0;
        }
        if (this.b == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n2 = 0;
        try {
            n2 = this.b.derEncode(byArray, n);
            this.asn1Template = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        int n;
        QCStatements qCStatements = new QCStatements();
        for (n = 0; n < this.a[0].size(); ++n) {
            qCStatements.a[0].addElement(((byte[])this.a[0].elementAt(n)).clone());
        }
        for (n = 0; n < this.a[1].size(); ++n) {
            if (this.a[1].elementAt(n) == null) {
                qCStatements.a[1].addElement(null);
                continue;
            }
            qCStatements.a[1].addElement(((byte[])this.a[1].elementAt(n)).clone());
        }
        if (this.b != null) {
            qCStatements.derEncodeValueInit();
        }
        super.copyValues(qCStatements);
        return qCStatements;
    }

    protected void reset() {
        super.reset();
        this.a = this.a();
        this.b = null;
    }
}

