/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.NameException;
import java.io.Serializable;
import java.util.Vector;

public class PresentationAddress
implements Cloneable,
Serializable {
    private byte[] a;
    private int b;
    private int c;
    private byte[] d;
    private int e;
    private int f;
    private byte[] g;
    private int h;
    private int i;
    private Vector j = new Vector();
    protected int special;
    protected ASN1Template asn1Template = null;
    private static final int k = 0xA10000;
    private static final int l = 0xA10001;
    private static final int m = 10551298;
    private static final int n = 0xA00003;

    public PresentationAddress(byte[] byArray, int n, int n2) throws NameException {
        this.special = n2;
        if (byArray == null) {
            throw new NameException("NameBER is null.");
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(n2);
            EndContainer endContainer = new EndContainer();
            OctetStringContainer octetStringContainer = new OctetStringContainer(0xA10000);
            OctetStringContainer octetStringContainer2 = new OctetStringContainer(0xA10001);
            OctetStringContainer octetStringContainer3 = new OctetStringContainer(10551298);
            EncodedContainer encodedContainer = new EncodedContainer(10498307);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, octetStringContainer, octetStringContainer2, octetStringContainer3, encodedContainer, endContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            OfContainer ofContainer = new OfContainer(0xA00003, 12544, (ASN1Container)new OctetStringContainer(0));
            ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{ofContainer};
            ASN1.berDecode((byte[])encodedContainer.data, (int)encodedContainer.dataOffset, (ASN1Container[])aSN1ContainerArray2);
            int n3 = ofContainer.getContainerCount();
            for (int i = 0; i < n3; ++i) {
                ASN1Container aSN1Container = ofContainer.containerAt(i);
                byte[] byArray2 = new byte[aSN1Container.dataLen];
                System.arraycopy(aSN1Container.data, aSN1Container.dataOffset, byArray2, 0, aSN1Container.dataLen);
                this.j.addElement(byArray2);
            }
            if (octetStringContainer.dataPresent) {
                this.a = new byte[octetStringContainer.dataLen];
                System.arraycopy(octetStringContainer.data, octetStringContainer.dataOffset, this.a, 0, octetStringContainer.dataLen);
                this.b = 0;
                this.c = octetStringContainer.dataLen;
            }
            if (octetStringContainer2.dataPresent) {
                this.d = new byte[octetStringContainer2.dataLen];
                System.arraycopy(octetStringContainer2.data, octetStringContainer2.dataOffset, this.d, 0, octetStringContainer2.dataLen);
                this.e = 0;
                this.f = octetStringContainer2.dataLen;
            }
            if (octetStringContainer3.dataPresent) {
                this.g = new byte[octetStringContainer3.dataLen];
                System.arraycopy(octetStringContainer3.data, octetStringContainer3.dataOffset, this.g, 0, octetStringContainer3.dataLen);
                this.h = 0;
                this.i = octetStringContainer3.dataLen;
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Cannot decode the BER of the PresentationAddress.");
        }
    }

    public PresentationAddress() {
    }

    public void setPSelector(byte[] byArray, int n, int n2) throws NameException {
        if (byArray == null || n2 == 0) {
            throw new NameException("Data is null.");
        }
        this.a = new byte[n2];
        System.arraycopy(byArray, n, this.a, 0, n2);
        this.b = 0;
        this.c = n2;
    }

    public void setSSelector(byte[] byArray, int n, int n2) throws NameException {
        if (byArray == null || n2 == 0) {
            throw new NameException("Data is null.");
        }
        this.d = new byte[n2];
        System.arraycopy(byArray, n, this.d, 0, n2);
        this.e = 0;
        this.f = n2;
    }

    public void setTSelector(byte[] byArray, int n, int n2) throws NameException {
        if (byArray == null || n2 == 0) {
            throw new NameException("Data is null.");
        }
        this.g = new byte[n2];
        System.arraycopy(byArray, n, this.g, 0, n2);
        this.h = 0;
        this.i = n2;
    }

    public void setNAddress(byte[] byArray, int n, int n2) throws NameException {
        if (byArray == null || n2 == 0) {
            throw new NameException("Data is null.");
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.j.addElement(byArray2);
    }

    public byte[] getPSelector() {
        if (this.a == null) {
            return null;
        }
        byte[] byArray = new byte[this.c];
        System.arraycopy(this.a, this.b, byArray, 0, this.c);
        return byArray;
    }

    public byte[] getSSelector() {
        if (this.d == null) {
            return null;
        }
        byte[] byArray = new byte[this.f];
        System.arraycopy(this.d, this.e, byArray, 0, this.f);
        return byArray;
    }

    public byte[] getTSelector() {
        if (this.g == null) {
            return null;
        }
        byte[] byArray = new byte[this.i];
        System.arraycopy(this.g, this.h, byArray, 0, this.i);
        return byArray;
    }

    public byte[][] getNAddresses() {
        int n = this.j.size();
        byte[][] byArrayArray = new byte[n][];
        for (int i = 0; i < n; ++i) {
            byte[] byArray = (byte[])this.j.elementAt(i);
            byArrayArray[i] = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArrayArray[i], 0, byArray.length);
        }
        return byArrayArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            stringBuffer.append(new String(this.a, this.b, this.c));
        }
        if (this.d != null) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(new String(this.d, this.e, this.f));
        }
        if (this.g != null) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(new String(this.g, this.h, this.i));
        }
        for (int i = 0; i < this.j.size(); ++i) {
            byte[] byArray = (byte[])this.j.elementAt(i);
            if (stringBuffer.length() != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(new String(byArray, 0, byArray.length));
        }
        return stringBuffer.toString();
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        if (byArray[n] == 0 && byArray[n + 1] == 0) {
            return n + 2;
        }
        try {
            return n + 1 + ASN1Lengths.determineLengthLen((byte[])byArray, (int)(n + 1)) + ASN1Lengths.determineLength((byte[])byArray, (int)(n + 1));
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int n) {
        this.special = n;
        return this.a();
    }

    public int getDEREncoding(byte[] byArray, int n, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int n3 = 0;
            if ((this.asn1Template == null || n2 != this.special) && (n3 = this.getDERLen(n2)) == 0) {
                throw new NameException("Unable to encode PresentationAddress");
            }
            int n4 = this.asn1Template.derEncode(byArray, n);
            this.asn1Template = null;
            return n4;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            throw new NameException("Unable to encode PresentationAddress");
        }
    }

    private int a() {
        if (this.asn1Template != null && this.special == this.special) {
            return 0;
        }
        try {
            Object object;
            Vector<OfContainer> vector = new Vector<OfContainer>();
            OfContainer ofContainer = new OfContainer(0xA00003, true, 0, 12544, (ASN1Container)new OctetStringContainer(0));
            vector.addElement(ofContainer);
            for (int i = 0; i < this.j.size(); ++i) {
                object = (byte[])this.j.elementAt(i);
                OctetStringContainer octetStringContainer = new OctetStringContainer(0, true, 0, object, 0, ((byte[])object).length);
                ofContainer.addContainer((ASN1Container)octetStringContainer);
            }
            Object[] objectArray = new ASN1Container[vector.size()];
            vector.copyInto(objectArray);
            object = new ASN1Template((ASN1Container[])objectArray);
            int n = object.derEncodeInit();
            byte[] byArray = new byte[n];
            n = object.derEncode(byArray, 0);
            EncodedContainer encodedContainer = new EncodedContainer(10498307, true, 0, byArray, 0, n);
            SequenceContainer sequenceContainer = new SequenceContainer(this.special, true, 0);
            EndContainer endContainer = new EndContainer();
            OctetStringContainer octetStringContainer = null;
            OctetStringContainer octetStringContainer2 = null;
            OctetStringContainer octetStringContainer3 = null;
            octetStringContainer = this.a != null ? new OctetStringContainer(0xA10000, true, 0, this.a, this.b, this.c) : new OctetStringContainer(0xA10000, false, 0, this.a, this.b, this.c);
            octetStringContainer2 = this.d != null ? new OctetStringContainer(0xA10001, true, 0, this.d, this.e, this.f) : new OctetStringContainer(0xA10001, false, 0, this.d, this.e, this.f);
            octetStringContainer3 = this.g != null ? new OctetStringContainer(10551298, true, 0, this.g, this.h, this.i) : new OctetStringContainer(10551298, false, 0, this.g, this.h, this.i);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, octetStringContainer, octetStringContainer2, octetStringContainer3, encodedContainer, endContainer};
            this.asn1Template = new ASN1Template(aSN1ContainerArray);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public boolean equals(Object object) {
        int n;
        if (object == null || !(object instanceof PresentationAddress)) {
            return false;
        }
        PresentationAddress presentationAddress = (PresentationAddress)object;
        if (this.a != null) {
            if (this.c != presentationAddress.c || this.b != presentationAddress.b) {
                return false;
            }
            for (n = 0; n < this.c; ++n) {
                if (this.a[n] == presentationAddress.a[n]) continue;
                return false;
            }
        } else if (presentationAddress.a != null) {
            return false;
        }
        if (this.d != null) {
            if (this.f != presentationAddress.f || this.e != presentationAddress.e) {
                return false;
            }
            for (n = 0; n < this.f; ++n) {
                if (this.d[n] == presentationAddress.d[n]) continue;
                return false;
            }
        } else if (presentationAddress.d != null) {
            return false;
        }
        if (this.g != null) {
            if (this.i != presentationAddress.i || this.h != presentationAddress.h) {
                return false;
            }
            for (n = 0; n < this.i; ++n) {
                if (this.g[n] == presentationAddress.g[n]) continue;
                return false;
            }
        } else if (presentationAddress.g != null) {
            return false;
        }
        if (this.j.size() != presentationAddress.j.size()) {
            return false;
        }
        for (n = 0; n < this.j.size(); ++n) {
            if (this.j.elementAt(n).equals(presentationAddress.j.elementAt(n))) continue;
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        PresentationAddress presentationAddress = new PresentationAddress();
        if (this.a != null) {
            presentationAddress.b = this.b;
            presentationAddress.c = this.c;
            presentationAddress.a = new byte[this.c];
            System.arraycopy(this.a, this.b, presentationAddress.a, presentationAddress.b, this.c);
        }
        if (this.d != null) {
            presentationAddress.e = this.e;
            presentationAddress.f = this.f;
            presentationAddress.d = new byte[this.f];
            System.arraycopy(this.d, this.e, presentationAddress.d, presentationAddress.e, this.f);
        }
        if (this.g != null) {
            presentationAddress.h = this.h;
            presentationAddress.i = this.i;
            presentationAddress.g = new byte[this.i];
            System.arraycopy(this.g, this.h, presentationAddress.g, presentationAddress.h, this.i);
        }
        presentationAddress.j = (Vector)this.j.clone();
        presentationAddress.special = this.special;
        if (this.asn1Template != null) {
            presentationAddress.a();
        }
        return presentationAddress;
    }
}

