/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;
import java.util.Vector;

public class PolicyMappings
extends X509V3Extension
implements Cloneable,
Serializable,
CertExtension {
    private Vector[] a = this.a(3);
    private Vector[] b = this.a(3);
    ASN1Template c;

    public PolicyMappings() {
        this.extensionTypeFlag = 33;
        this.criticality = false;
        this.setStandardOID(33);
        this.extensionTypeString = "PolicyMappings";
    }

    public PolicyMappings(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, boolean bl) {
        this.extensionTypeFlag = 33;
        this.criticality = bl;
        this.setStandardOID(33);
        if (byArray != null && n2 != 0) {
            this.a[0].addElement(byArray);
            this.a[1].addElement(new Integer(n));
            this.a[2].addElement(new Integer(n2));
        }
        if (byArray2 != null && n4 != 0) {
            this.b[0].addElement(byArray2);
            this.b[1].addElement(new Integer(n3));
            this.b[2].addElement(new Integer(n4));
        }
        this.extensionTypeString = "PolicyMappings";
    }

    private Vector[] a(int n) {
        Vector[] vectorArray = new Vector[n];
        for (int i = 0; i < n; ++i) {
            vectorArray[i] = new Vector();
        }
        return vectorArray;
    }

    public void decodeValue(byte[] byArray, int n) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            OfContainer ofContainer = new OfContainer(this.special, 12288, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            int n2 = ofContainer.getContainerCount();
            for (int i = 0; i < n2; ++i) {
                ASN1Container aSN1Container = ofContainer.containerAt(i);
                SequenceContainer sequenceContainer = new SequenceContainer(0);
                EndContainer endContainer = new EndContainer();
                OIDContainer oIDContainer = new OIDContainer(0);
                OIDContainer oIDContainer2 = new OIDContainer(0);
                ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer, oIDContainer, oIDContainer2, endContainer};
                ASN1.berDecode((byte[])aSN1Container.data, (int)aSN1Container.dataOffset, (ASN1Container[])aSN1ContainerArray2);
                this.a[0].addElement(oIDContainer.data);
                this.a[1].addElement(new Integer(oIDContainer.dataOffset));
                this.a[2].addElement(new Integer(oIDContainer.dataLen));
                this.b[0].addElement(oIDContainer2.data);
                this.b[1].addElement(new Integer(oIDContainer2.dataOffset));
                this.b[2].addElement(new Integer(oIDContainer2.dataLen));
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not decode PolicyMappings extension.");
        }
    }

    public void setDomainPolicy(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (byArray != null && n2 != 0) {
            this.a[0].addElement(byArray);
            this.a[1].addElement(new Integer(n));
            this.a[2].addElement(new Integer(n2));
        }
        if (byArray2 != null && n4 != 0) {
            this.b[0].addElement(byArray2);
            this.b[1].addElement(new Integer(n3));
            this.b[2].addElement(new Integer(n4));
        }
    }

    public byte[] getIssuerDomainPolicy(int n) throws CertificateException {
        if (this.a[0].size() <= n) {
            throw new CertificateException("Specified index is invalid.");
        }
        if (this.a[0].elementAt(n) != null) {
            Integer n2 = (Integer)this.a[1].elementAt(n);
            Integer n3 = (Integer)this.a[2].elementAt(n);
            byte[] byArray = new byte[n3.intValue()];
            System.arraycopy(this.a[0].elementAt(n), n2, byArray, 0, n3);
            return byArray;
        }
        return null;
    }

    public byte[] getSubjectDomainPolicy(int n) throws CertificateException {
        if (this.b[0].size() <= n) {
            throw new CertificateException("Specified index is invalid.");
        }
        if (this.b[0].elementAt(n) != null) {
            Integer n2 = (Integer)this.b[1].elementAt(n);
            Integer n3 = (Integer)this.b[2].elementAt(n);
            byte[] byArray = new byte[n3.intValue()];
            System.arraycopy(this.b[0].elementAt(n), n2, byArray, 0, n3);
            return byArray;
        }
        return null;
    }

    public int getPolicyCount() {
        return this.b[0].size();
    }

    public int derEncodeValueInit() {
        Vector<OfContainer> vector = new Vector<OfContainer>();
        try {
            OfContainer ofContainer = new OfContainer(this.special, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
            vector.addElement(ofContainer);
            for (int i = 0; i < this.a[0].size(); ++i) {
                try {
                    EncodedContainer encodedContainer = this.b(i);
                    ofContainer.addContainer((ASN1Container)encodedContainer);
                    continue;
                }
                catch (Exception exception) {
                    return 0;
                }
            }
            Object[] objectArray = new ASN1Container[vector.size()];
            vector.copyInto(objectArray);
            this.c = new ASN1Template((ASN1Container[])objectArray);
            return this.c.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    private EncodedContainer b(int n) throws CertificateException {
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            EndContainer endContainer = new EndContainer();
            int n2 = (Integer)this.a[1].elementAt(n);
            int n3 = (Integer)this.a[2].elementAt(n);
            OIDContainer oIDContainer = new OIDContainer(0x1000000, true, 0, (byte[])this.a[0].elementAt(n), n2, n3);
            n2 = (Integer)this.b[1].elementAt(n);
            n3 = (Integer)this.b[2].elementAt(n);
            OIDContainer oIDContainer2 = new OIDContainer(0x1000000, true, 0, (byte[])this.b[0].elementAt(n), n2, n3);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, oIDContainer2, endContainer};
            ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray);
            int n4 = aSN1Template.derEncodeInit();
            byte[] byArray = new byte[n4];
            n4 = aSN1Template.derEncode(byArray, 0);
            EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, byArray, 0, n4);
            return encodedContainer;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException(" Can't encode PolicyMappings");
        }
    }

    public int derEncodeValue(byte[] byArray, int n) {
        if (byArray == null) {
            return 0;
        }
        if (this.c == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n2 = 0;
        try {
            n2 = this.c.derEncode(byArray, n);
            this.asn1Template = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        int n;
        int n2;
        PolicyMappings policyMappings = new PolicyMappings();
        for (n2 = 0; n2 < this.a.length; ++n2) {
            for (n = 0; n < this.a[n2].size(); ++n) {
                policyMappings.a[n2].addElement(this.a[n2].elementAt(n));
            }
        }
        for (n2 = 0; n2 < this.b.length; ++n2) {
            for (n = 0; n < this.b[n2].size(); ++n) {
                policyMappings.b[n2].addElement(this.b[n2].elementAt(n));
            }
        }
        if (this.c != null) {
            policyMappings.derEncodeValueInit();
        }
        super.copyValues(policyMappings);
        return policyMappings;
    }

    protected void reset() {
        super.reset();
        this.a = null;
        this.b = null;
        this.c = null;
    }

    public Vector getSubjectDomainPolicies(byte[] byArray) {
        Vector<byte[]> vector = new Vector<byte[]>();
        int n = this.getPolicyCount();
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            byte[] byArray2 = (byte[])this.a[0].get(i);
            if (!CertJUtils.byteArraysEqual(byArray2, n3 = ((Integer)this.a[1].get(i)).intValue(), n2 = ((Integer)this.a[2].get(i)).intValue(), byArray)) continue;
            byte[] byArray3 = (byte[])this.b[0].get(i);
            int n4 = (Integer)this.b[1].get(i);
            int n5 = (Integer)this.b[2].get(i);
            byte[] byArray4 = new byte[n5];
            System.arraycopy(byArray3, n4, byArray4, 0, n5);
            vector.add(byArray4);
        }
        return vector;
    }
}

