/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.certj.cert.NameException;
import java.io.Serializable;

public class PersonalName
implements Cloneable,
Serializable {
    private String a;
    private String b;
    private String c;
    private String d;
    protected int special;
    protected ASN1Template asn1Template = null;
    private static final int e = 0x800000;
    private static final int f = 0x810001;
    private static final int g = 8454146;
    private static final int h = 8454147;

    public PersonalName(byte[] byArray, int n, int n2) throws NameException {
        this.special = n2;
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            SetContainer setContainer = new SetContainer(n2);
            PrintStringContainer printStringContainer = new PrintStringContainer(0x800000, 1, 40);
            PrintStringContainer printStringContainer2 = new PrintStringContainer(0x810001, 1, 16);
            PrintStringContainer printStringContainer3 = new PrintStringContainer(8454146, 1, 5);
            PrintStringContainer printStringContainer4 = new PrintStringContainer(8454147, 1, 3);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, printStringContainer, printStringContainer2, printStringContainer3, printStringContainer4, endContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            if (!printStringContainer.dataPresent) {
                throw new NameException("Surname is missing.");
            }
            this.a = printStringContainer.getValueAsString();
            if (printStringContainer2.dataPresent) {
                this.b = printStringContainer2.getValueAsString();
            }
            if (printStringContainer3.dataPresent) {
                this.c = printStringContainer3.getValueAsString();
            }
            if (printStringContainer4.dataPresent) {
                this.d = printStringContainer4.getValueAsString();
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Cannot decode the BER of the Personal name.");
        }
    }

    public PersonalName() {
    }

    public void setSurname(String string) {
        if (string != null) {
            this.a = string;
        }
    }

    public void setGivenName(String string) {
        if (string != null) {
            this.b = string;
        }
    }

    public void setInitials(String string) {
        if (string != null) {
            this.c = string;
        }
    }

    public void setGenerationQualifier(String string) {
        if (string != null) {
            this.d = string;
        }
    }

    public String getSurname() {
        return this.a;
    }

    public String getGivenName() {
        return this.b;
    }

    public String getInitials() {
        return this.c;
    }

    public String getGenerationQualifier() {
        return this.d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            stringBuffer.append(this.a);
        }
        if (this.b != null) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.b);
        }
        if (this.c != null) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.c);
        }
        if (this.d != null) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.d);
        }
        return stringBuffer.toString();
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        if (byArray[n] == 0 && byArray[n + 1] == 0) {
            return n + 2;
        }
        try {
            return n + 1 + ASN1Lengths.determineLengthLen((byte[])byArray, (int)(n + 1)) + ASN1Lengths.determineLength((byte[])byArray, (int)(n + 1));
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int n) {
        this.special = n;
        return this.a();
    }

    public int getDEREncoding(byte[] byArray, int n, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int n3 = 0;
            if ((this.asn1Template == null || n2 != this.special) && (n3 = this.getDERLen(n2)) == 0) {
                throw new NameException("Unable to encode PersonalName.");
            }
            int n4 = this.asn1Template.derEncode(byArray, n);
            this.asn1Template = null;
            return n4;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            throw new NameException("Unable to encode PersonalName.");
        }
    }

    private int a() {
        try {
            int n = 0;
            SetContainer setContainer = new SetContainer(this.special, true, 0);
            EndContainer endContainer = new EndContainer();
            if (this.a == null) {
                return 0;
            }
            PrintStringContainer printStringContainer = new PrintStringContainer(0x800000, true, 0, this.a, 1, 40);
            PrintStringContainer printStringContainer2 = null;
            PrintStringContainer printStringContainer3 = null;
            PrintStringContainer printStringContainer4 = null;
            if (this.b != null) {
                printStringContainer4 = new PrintStringContainer(0x810001, true, 0, this.b, 1, 16);
                n = 1;
            }
            if (this.c != null) {
                printStringContainer3 = new PrintStringContainer(8454146, true, 0, this.c, 1, 5);
                n = n == 0 ? 2 : 3;
            }
            if (this.d != null) {
                printStringContainer2 = new PrintStringContainer(8454147, true, 0, this.d, 1, 3);
                n = n == 0 ? 4 : (n == 1 ? 5 : (n == 2 ? 6 : 7));
            }
            switch (n) {
                case 0: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, printStringContainer, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 1: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, printStringContainer, printStringContainer4, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 2: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, printStringContainer, printStringContainer3, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 3: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, printStringContainer, printStringContainer4, printStringContainer3, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 4: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, printStringContainer, printStringContainer2, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 5: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, printStringContainer, printStringContainer4, printStringContainer2, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 6: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, printStringContainer, printStringContainer3, printStringContainer2, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 7: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, printStringContainer, printStringContainer4, printStringContainer3, printStringContainer2, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                default: {
                    return 0;
                }
            }
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PersonalName)) {
            return false;
        }
        PersonalName personalName = (PersonalName)object;
        if (this.a != null ? !this.a.equals(personalName.a) : personalName.a != null) {
            return false;
        }
        if (this.b != null ? !this.b.equals(personalName.b) : personalName.b != null) {
            return false;
        }
        if (this.c != null ? !this.c.equals(personalName.c) : personalName.c != null) {
            return false;
        }
        return !(this.d != null ? !this.d.equals(personalName.d) : personalName.d != null);
    }

    public Object clone() throws CloneNotSupportedException {
        PersonalName personalName = new PersonalName();
        if (this.a != null) {
            personalName.a = new String(this.a);
        }
        if (this.b != null) {
            personalName.b = new String(this.b);
        }
        if (this.c != null) {
            personalName.c = new String(this.c);
        }
        if (this.d != null) {
            personalName.d = new String(this.d);
        }
        personalName.special = this.special;
        if (this.asn1Template != null) {
            personalName.a();
        }
        return personalName;
    }
}

