/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.BuiltInDomainDefinedAttributes;
import com.rsa.certj.cert.extensions.BuiltInStandardAttributes;
import com.rsa.certj.cert.extensions.ExtensionAttributes;
import java.io.Serializable;

public class ORAddress
implements Cloneable,
Serializable {
    private BuiltInStandardAttributes a;
    private BuiltInDomainDefinedAttributes b;
    private ExtensionAttributes c;
    protected int special;
    protected ASN1Template asn1Template = null;

    public ORAddress(byte[] byArray, int n, int n2) throws NameException {
        this.special = n2;
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(n2);
            EndContainer endContainer = new EndContainer();
            EncodedContainer encodedContainer = new EncodedContainer(12288);
            EncodedContainer encodedContainer2 = new EncodedContainer(77824);
            EncodedContainer encodedContainer3 = new EncodedContainer(78080);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, encodedContainer2, encodedContainer3, endContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            this.a = new BuiltInStandardAttributes(encodedContainer.data, encodedContainer.dataOffset, 0);
            if (encodedContainer2.dataPresent) {
                this.b = new BuiltInDomainDefinedAttributes(encodedContainer2.data, encodedContainer2.dataOffset, 0);
            }
            if (encodedContainer3.dataPresent) {
                this.c = new ExtensionAttributes(encodedContainer3.data, encodedContainer3.dataOffset, 0);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Cannot decode the BER of the ORAddress." + aSN_Exception.getMessage());
        }
    }

    public ORAddress() {
    }

    public void setBuiltInStandardAttributes(BuiltInStandardAttributes builtInStandardAttributes) {
        if (builtInStandardAttributes != null) {
            this.a = builtInStandardAttributes;
        }
    }

    public void setBuiltInDomainDefinedAttributes(BuiltInDomainDefinedAttributes builtInDomainDefinedAttributes) {
        if (builtInDomainDefinedAttributes != null) {
            this.b = builtInDomainDefinedAttributes;
        }
    }

    public void setExtensionAttributes(ExtensionAttributes extensionAttributes) {
        if (extensionAttributes != null) {
            this.c = extensionAttributes;
        }
    }

    public BuiltInStandardAttributes getBuiltInStandardAttributes() {
        return this.a;
    }

    public BuiltInDomainDefinedAttributes getBuiltInDomainDefinedAttributes() {
        return this.b;
    }

    public ExtensionAttributes getExtensionAttributes() {
        return this.c;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            stringBuffer.append(this.a.toString());
        }
        if (this.b != null) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.b.toString());
        }
        if (this.c != null) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.c.toString());
        }
        return stringBuffer.toString();
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        if (byArray[n] == 0 && byArray[n + 1] == 0) {
            return n + 2;
        }
        try {
            return n + 1 + ASN1Lengths.determineLengthLen((byte[])byArray, (int)(n + 1)) + ASN1Lengths.determineLength((byte[])byArray, (int)(n + 1));
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Unable to determine length of the BER" + aSN_Exception.getMessage());
        }
    }

    public int getDERLen(int n) {
        this.special = n;
        return this.a();
    }

    public int getDEREncoding(byte[] byArray, int n, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int n3;
            if ((this.asn1Template == null || n2 != this.special) && (n3 = this.getDERLen(n2)) == 0) {
                throw new NameException("Unable to encode ORAddress");
            }
            n3 = this.asn1Template.derEncode(byArray, n);
            this.asn1Template = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            throw new NameException("Unable to encode ORAddress" + aSN_Exception.getMessage());
        }
    }

    private int a() {
        if (this.asn1Template != null && this.special == this.special) {
            return 0;
        }
        try {
            int n;
            Object[] objectArray;
            SequenceContainer sequenceContainer = new SequenceContainer(this.special, true, 0);
            EndContainer endContainer = new EndContainer();
            EncodedContainer encodedContainer = null;
            EncodedContainer encodedContainer2 = null;
            int n2 = 0;
            if (this.a == null) {
                return 0;
            }
            byte[] byArray = new byte[this.a.getDERLen(0)];
            int n3 = this.a.getDEREncoding(byArray, 0, 0);
            EncodedContainer encodedContainer3 = new EncodedContainer(12288, true, 0, byArray, 0, n3);
            if (this.b != null) {
                objectArray = new byte[this.b.getDERLen(65536)];
                n = this.b.getDEREncoding((byte[])objectArray, 0, 65536);
                encodedContainer = new EncodedContainer(77824, true, 0, objectArray, 0, n);
                n2 = 1;
            }
            if (this.c != null) {
                objectArray = new byte[this.c.getDERLen(65536)];
                n = this.c.getDEREncoding((byte[])objectArray, 0, 65536);
                encodedContainer2 = new EncodedContainer(78080, true, 0, objectArray, 0, n);
                n2 = n2 == 1 ? 2 : 3;
            }
            switch (n2) {
                case 0: {
                    objectArray = new ASN1Container[]{sequenceContainer, encodedContainer3, endContainer};
                    this.asn1Template = new ASN1Template((ASN1Container[])objectArray);
                    break;
                }
                case 1: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer3, encodedContainer, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 2: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer3, encodedContainer, encodedContainer2, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 3: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer3, encodedContainer2, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
            }
            return this.asn1Template.derEncodeInit();
        }
        catch (NameException nameException) {
            return 0;
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ORAddress)) {
            return false;
        }
        ORAddress oRAddress = (ORAddress)object;
        if (this.a != null ? !this.a.equals(oRAddress.a) : oRAddress.a != null) {
            return false;
        }
        if (this.b != null ? !this.b.equals(oRAddress.b) : oRAddress.b != null) {
            return false;
        }
        return !(this.c != null ? !this.c.equals(oRAddress.c) : oRAddress.c != null);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        ORAddress oRAddress = new ORAddress();
        if (this.a != null) {
            oRAddress.a = (BuiltInStandardAttributes)this.a.clone();
        }
        if (this.b != null) {
            oRAddress.b = (BuiltInDomainDefinedAttributes)this.b.clone();
        }
        if (this.c != null) {
            oRAddress.c = (ExtensionAttributes)this.c.clone();
        }
        oRAddress.special = this.special;
        if (this.asn1Template != null) {
            oRAddress.a();
        }
        return oRAddress;
    }
}

