/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.OCSPRequestExtension;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;

public class OCSPNonce
extends X509V3Extension
implements Cloneable,
Serializable,
OCSPRequestExtension {
    private byte[] a;
    private int b;
    ASN1Template c;

    public OCSPNonce() {
        this.extensionTypeFlag = 120;
        this.criticality = false;
        this.setSpecialOID(X509V3Extension.OCSP_NONCE_OID);
        this.extensionTypeString = "OCSPNonce";
        this.a = null;
        this.b = 0;
    }

    public OCSPNonce(byte[] byArray, int n, int n2) {
        this.extensionTypeFlag = 120;
        this.setSpecialOID(X509V3Extension.OCSP_NONCE_OID);
        this.extensionTypeString = "OCSPNonce";
        this.criticality = false;
        this.setNonceValue(byArray, n, n2);
    }

    public void setNonceValue(byte[] byArray, int n, int n2) {
        if (byArray == null || n2 == 0) {
            return;
        }
        this.a = new byte[n2];
        System.arraycopy(byArray, n, this.a, 0, n2);
        this.b = n2;
    }

    public byte[] getNonceValue() {
        if (this.a == null) {
            return null;
        }
        return this.a;
    }

    public void decodeValue(byte[] byArray, int n) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        OctetStringContainer octetStringContainer = new OctetStringContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{octetStringContainer};
        try {
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            this.a = null;
            this.b = 0;
            throw new CertificateException("Could not decode OCSPNonce extension.");
        }
        this.setNonceValue(octetStringContainer.data, octetStringContainer.dataOffset, octetStringContainer.dataLen);
    }

    public int derEncodeValueInit() {
        if (this.a == null || this.b == 0) {
            return 0;
        }
        try {
            OctetStringContainer octetStringContainer = new OctetStringContainer(0, true, 0, this.a, 0, this.b);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{octetStringContainer};
            this.c = new ASN1Template(aSN1ContainerArray);
            return this.c.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] byArray, int n) {
        if (byArray == null) {
            return 0;
        }
        if (this.c == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n2 = 0;
        try {
            n2 = this.c.derEncode(byArray, n);
            this.asn1Template = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        OCSPNonce oCSPNonce = new OCSPNonce();
        if (this.a != null) {
            oCSPNonce.b = this.b;
            oCSPNonce.a = new byte[oCSPNonce.b];
            System.arraycopy(this.a, 0, oCSPNonce.a, 0, oCSPNonce.b);
        }
        if (this.c != null) {
            oCSPNonce.derEncodeValueInit();
        }
        super.copyValues(oCSPNonce);
        return oCSPNonce;
    }

    protected void reset() {
        super.reset();
        this.c = null;
    }
}

