/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.certj.cert.NameException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

final class NameUtils {
    private NameUtils() {
    }

    public static void validateURLName(String string) throws NameException {
        try {
            new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new NameException(malformedURLException.getMessage());
        }
    }

    public static void validateRFC822Name(String string) throws NameException {
        if (string == null) {
            throw new NameException("Name is null!");
        }
        int n = string.indexOf(64);
        if (n == -1) {
            throw new NameException("An RFC822 name must contain the @ symbol.");
        }
        if (string.indexOf(64, n + 1) != -1) {
            throw new NameException("An RFC822 name can contain only one @ symbol.");
        }
        NameUtils.b(string.substring(0, n));
        NameUtils.a(string.substring(n + 1));
    }

    private static void a(String string) throws NameException {
        if (string.length() == 0) {
            throw new NameException("Illegal empty domain name!");
        }
        TokenizerWithEmptyStrings tokenizerWithEmptyStrings = new TokenizerWithEmptyStrings(string);
        while (tokenizerWithEmptyStrings.hasMoreTokens()) {
            String string2 = tokenizerWithEmptyStrings.nextToken();
            if (string2.startsWith("[")) {
                String[] stringArray = new String[4];
                stringArray[0] = string2.substring(1);
                for (int i = 1; i < stringArray.length; ++i) {
                    if (!tokenizerWithEmptyStrings.hasMoreTokens()) {
                        throw new NameException("Illegal domain name: " + string);
                    }
                    stringArray[i] = tokenizerWithEmptyStrings.nextToken();
                }
                if (!stringArray[3].endsWith("]")) {
                    throw new NameException("Illegal domain name: " + string);
                }
                String string3 = stringArray[3];
                stringArray[3] = string3.substring(0, string3.length() - 1);
                NameUtils.a(stringArray);
                continue;
            }
            NameUtils.d(string2);
        }
    }

    private static void a(String[] stringArray) throws NameException {
        for (int i = 0; i < stringArray.length; ++i) {
            int n = Integer.parseInt(stringArray[i]);
            if (n >= 0 && n <= 255) continue;
            throw new NameException("Invalid domain literal part: " + stringArray[i]);
        }
    }

    private static void b(String string) throws NameException {
        if (string.length() == 0) {
            throw new NameException("Empty local part is not allowed in an RFC822 name");
        }
        TokenizerWithEmptyStrings tokenizerWithEmptyStrings = new TokenizerWithEmptyStrings(string);
        while (tokenizerWithEmptyStrings.hasMoreTokens()) {
            String string2 = tokenizerWithEmptyStrings.nextToken();
            if (string2.startsWith("\"")) {
                while (tokenizerWithEmptyStrings.hasMoreTokens() && !string2.endsWith("\"")) {
                    string2 = string2 + tokenizerWithEmptyStrings.nextToken();
                }
            }
            NameUtils.c(string2);
        }
    }

    private static void c(String string) throws NameException {
        if (string.length() == 0) {
            throw new NameException("Invalid word in local part of RFC822 name: " + string);
        }
        if (string.startsWith("\"")) {
            NameUtils.e(string);
        } else {
            NameUtils.d(string);
        }
    }

    private static void d(String string) throws NameException {
        if (string.length() == 0) {
            throw new NameException("An atom must be at least 1 character long!");
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < ' ' || c == '\u007f') {
                throw new NameException("Illegal character in atom " + string);
            }
            if (" ()<>@,;:\\/\".[]".indexOf(c) == -1) continue;
            throw new NameException("Atom " + string + " contains the special character " + c);
        }
    }

    private static void e(String string) throws NameException {
        int n = string.length() - 1;
        if (string.length() < 2 || string.charAt(0) != '\"' || string.charAt(n) != '\"') {
            throw new NameException("Illegal quoted string: " + string);
        }
        for (int i = 1; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                if (++i != n) continue;
                throw new NameException("\\ escapes the closing quote in " + string);
            }
            if (c == '\"') {
                throw new NameException("Illegal character " + c + " in " + string);
            }
            if (c != '\r') continue;
            if ((c = string.charAt(++i)) != '\n') {
                throw new NameException("Illegal CR character in " + string);
            }
            if ((c = string.charAt(++i)) == ' ' || c == '\t') continue;
            throw new NameException("CRLF sequence in " + string + " must be followed by a space or a tab.");
        }
    }

    public static void validateDnsName(String string) throws NameException {
        if (string == null) {
            throw new NameException("Name is null!");
        }
        if (string.equals(" ")) {
            return;
        }
        TokenizerWithEmptyStrings tokenizerWithEmptyStrings = new TokenizerWithEmptyStrings(string);
        while (tokenizerWithEmptyStrings.hasMoreTokens()) {
            String string2 = tokenizerWithEmptyStrings.nextToken();
            NameUtils.f(string2);
        }
    }

    private static boolean a(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean b(char c) {
        return c >= '0' && c <= '9';
    }

    private static void f(String string) throws NameException {
        if (string.length() == 0) {
            throw new NameException("A subdomain cannot be an empty string!");
        }
        if (!NameUtils.a(string.charAt(0))) {
            throw new NameException("A subdomain must start with a letter!");
        }
        if (string.charAt(string.length() - 1) == '-') {
            throw new NameException("The last character in a subdomain cannot be a hyphen!");
        }
        for (int i = 0; i < string.length(); ++i) {
            if (NameUtils.c(string.charAt(i))) continue;
            throw new NameException("Invalid character in domain name: " + string.charAt(i));
        }
    }

    private static boolean c(char c) {
        return c == '-' || NameUtils.a(c) || NameUtils.b(c);
    }

    private static class TokenizerWithEmptyStrings {
        private static final String a = ".";
        private static final String b = "";
        private StringTokenizer c;
        private boolean d;

        public TokenizerWithEmptyStrings(String string) {
            this.c = new StringTokenizer(string, a, true);
            this.d = this.c.hasMoreTokens();
        }

        public String nextToken() {
            if (this.d && !this.c.hasMoreTokens()) {
                this.d = false;
                return b;
            }
            String string = this.c.nextToken();
            if (a.equals(string)) {
                return b;
            }
            if (!this.c.hasMoreTokens()) {
                this.d = false;
            } else {
                this.c.nextToken();
            }
            return string;
        }

        public boolean hasMoreTokens() {
            return this.d;
        }
    }
}

