/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.BooleanContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CRLExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.RDN;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;

public class IssuingDistributionPoint
extends X509V3Extension
implements Cloneable,
Serializable,
CRLExtension {
    public static final int REASON_FLAGS_BITS = 9;
    public static final int REASON_FLAGS_MASK = -8388608;
    public static final int UNUSED = Integer.MIN_VALUE;
    public static final int KEY_COMPROMISE = 0x40000000;
    public static final int CA_COMPROMISE = 0x20000000;
    public static final int AFFILIATION_CHANGED = 0x10000000;
    public static final int SUPERSEDED = 0x8000000;
    public static final int CESSATION_OF_OPERATION = 0x4000000;
    public static final int CERTIFICATE_HOLD = 0x2000000;
    public static final int PRIVILEGE_WITHDRAWN = 0x1000000;
    public static final int AA_COMPROMISE = 0x800000;
    private static final int a = 0x810000;
    private static final int b = 8519681;
    private static final int c = 0x820002;
    private static final int d = 8454147;
    private static final int e = 8519684;
    private static final int f = 8519685;
    private static final int g = 0x800000;
    private static final int h = 0x800001;
    ASN1Template i;
    private GeneralNames j = null;
    private RDN k = null;
    private int l = -1;
    private boolean m = false;
    private boolean n = false;
    private boolean o = false;
    private boolean p = false;

    public IssuingDistributionPoint() {
        this.extensionTypeFlag = 28;
        this.criticality = false;
        this.setStandardOID(28);
        this.extensionTypeString = "IssuingDistributionPoint";
    }

    public IssuingDistributionPoint(RDN rDN, boolean bl, boolean bl2, int n, boolean bl3, boolean bl4, boolean bl5) {
        this.extensionTypeFlag = 28;
        this.criticality = bl5;
        this.setStandardOID(28);
        this.k = rDN;
        this.m = bl;
        this.n = bl2;
        this.l = n;
        this.o = bl3;
        this.p = bl4;
        this.extensionTypeString = "IssuingDistributionPoint";
    }

    public IssuingDistributionPoint(GeneralNames generalNames, boolean bl, boolean bl2, int n, boolean bl3, boolean bl4, boolean bl5) {
        this.extensionTypeFlag = 28;
        this.criticality = bl5;
        this.setStandardOID(28);
        this.j = generalNames;
        this.m = bl;
        this.n = bl2;
        this.l = n;
        this.o = bl3;
        this.p = bl4;
        this.extensionTypeString = "IssuingDistributionPoint";
    }

    public void decodeValue(byte[] byArray, int n) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0);
            EndContainer endContainer = new EndContainer();
            ChoiceContainer choiceContainer = new ChoiceContainer(0x810000);
            EncodedContainer encodedContainer = new EncodedContainer(0x803000);
            EncodedContainer encodedContainer2 = new EncodedContainer(8401153);
            BooleanContainer booleanContainer = new BooleanContainer(8519681);
            BooleanContainer booleanContainer2 = new BooleanContainer(0x820002);
            BitStringContainer bitStringContainer = new BitStringContainer(8454147);
            BooleanContainer booleanContainer3 = new BooleanContainer(8519684);
            BooleanContainer booleanContainer4 = new BooleanContainer(8519685);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, choiceContainer, encodedContainer, encodedContainer2, endContainer, booleanContainer, booleanContainer2, bitStringContainer, booleanContainer3, booleanContainer4, endContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            if (encodedContainer.dataPresent) {
                this.j = new GeneralNames(encodedContainer.data, encodedContainer.dataOffset, 0x800000);
            } else if (encodedContainer2.dataPresent) {
                this.k = new RDN(encodedContainer2.data, encodedContainer2.dataOffset, 0x800001);
            } else {
                this.j = null;
                this.k = null;
            }
            this.m = booleanContainer.dataPresent ? booleanContainer.value : false;
            this.n = booleanContainer2.dataPresent ? booleanContainer2.value : false;
            if (bitStringContainer.dataPresent) {
                if (bitStringContainer.dataLen > 4) {
                    throw new CertificateException("Could not decode IssuingDistributionPoint extension.");
                }
                if (bitStringContainer.dataLen == 0) {
                    this.l = 0;
                } else {
                    int n2 = 0;
                    int n3 = bitStringContainer.dataOffset;
                    int n4 = 24;
                    while (n3 < bitStringContainer.dataOffset + bitStringContainer.dataLen) {
                        n2 |= (bitStringContainer.data[n3] & 0xFF) << n4;
                        ++n3;
                        n4 -= 8;
                    }
                    this.l = n2 &= 0xFF800000;
                }
            } else {
                this.l = -1;
            }
            this.o = booleanContainer3.dataPresent ? booleanContainer3.value : false;
            this.p = booleanContainer4.dataPresent ? booleanContainer4.value : false;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not decode IssuingDistributionPoint extension.");
        }
        catch (NameException nameException) {
            throw new CertificateException("Could not create new GeneralNames object.");
        }
    }

    public void setIssuingDistributionPointName(GeneralNames generalNames) {
        this.j = generalNames;
        this.k = null;
    }

    public void setIssuingDistributionPointName(RDN rDN) {
        this.k = rDN;
        this.j = null;
    }

    public void setUserCerts(boolean bl) {
        this.m = bl;
    }

    public void setCACerts(boolean bl) {
        this.n = bl;
    }

    public void setReasonFlags(int n) {
        this.l = n;
    }

    public void setIndirectCRL(boolean bl) {
        this.o = bl;
    }

    public void setAttributeCerts(boolean bl) {
        this.p = bl;
    }

    public Object getDistributionPointName() {
        if (this.k != null) {
            return this.k;
        }
        return this.j;
    }

    public boolean getUserCerts() {
        return this.m;
    }

    public boolean getCACerts() {
        return this.n;
    }

    public int getReasonFlags() {
        return this.l;
    }

    public boolean getIndirectCRL() {
        return this.o;
    }

    public boolean getAttributeCerts() {
        return this.p;
    }

    public int derEncodeValueInit() {
        int n = 0;
        SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
        ChoiceContainer choiceContainer = null;
        BitStringContainer bitStringContainer = null;
        EncodedContainer encodedContainer = null;
        BooleanContainer booleanContainer = null;
        BooleanContainer booleanContainer2 = null;
        BooleanContainer booleanContainer3 = null;
        BooleanContainer booleanContainer4 = null;
        EndContainer endContainer = new EndContainer();
        if (this.j != null || this.k != null) {
            choiceContainer = new ChoiceContainer(0x810000, 0);
            try {
                encodedContainer = this.a();
            }
            catch (CertificateException certificateException) {
                return 0;
            }
            n = 1;
        }
        if (this.l != -1) {
            bitStringContainer = new BitStringContainer(8454147, true, 0, this.l, 9, true);
            n = n == 0 ? 2 : 3;
        }
        booleanContainer = this.a(8519681, this.m);
        booleanContainer2 = this.a(0x820002, this.n);
        booleanContainer3 = this.a(8519684, this.o);
        booleanContainer4 = this.a(8519685, this.p);
        switch (n) {
            case 0: {
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, booleanContainer, booleanContainer2, booleanContainer3, booleanContainer4, endContainer};
                this.i = new ASN1Template(aSN1ContainerArray);
                break;
            }
            case 1: {
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, choiceContainer, encodedContainer, endContainer, booleanContainer, booleanContainer2, booleanContainer3, booleanContainer4, endContainer};
                this.i = new ASN1Template(aSN1ContainerArray);
                break;
            }
            case 2: {
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, booleanContainer, booleanContainer2, bitStringContainer, booleanContainer3, booleanContainer4, endContainer};
                this.i = new ASN1Template(aSN1ContainerArray);
                break;
            }
            case 3: {
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, choiceContainer, encodedContainer, endContainer, booleanContainer, booleanContainer2, bitStringContainer, booleanContainer3, booleanContainer4, endContainer};
                this.i = new ASN1Template(aSN1ContainerArray);
                break;
            }
        }
        try {
            return this.i.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    private BooleanContainer a(int n, boolean bl) {
        return new BooleanContainer(n, bl, 0, bl);
    }

    private EncodedContainer a() throws CertificateException {
        EncodedContainer encodedContainer = null;
        int n = 0;
        byte[] byArray = null;
        try {
            if (this.j != null) {
                n = this.j.getDERLen(0x800000);
                byArray = new byte[n];
                n = this.j.getDEREncoding(byArray, 0, 0x800000);
                encodedContainer = new EncodedContainer(12288, true, 0, byArray, 0, n);
            } else if (this.k != null) {
                n = this.k.getDERLen(0x800001);
                byArray = new byte[n];
                n = this.k.getDEREncoding(byArray, 0, 0x800001);
                encodedContainer = new EncodedContainer(12544, true, 0, byArray, 0, n);
            }
            return encodedContainer;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Can't encode DistributionPointNames" + aSN_Exception.getMessage());
        }
        catch (NameException nameException) {
            throw new CertificateException("Can't encode DistributionPointNames" + nameException.getMessage());
        }
    }

    public int derEncodeValue(byte[] byArray, int n) {
        if (byArray == null) {
            return 0;
        }
        if (this.i == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n2 = 0;
        try {
            n2 = this.i.derEncode(byArray, n);
            this.asn1Template = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        IssuingDistributionPoint issuingDistributionPoint = new IssuingDistributionPoint();
        if (this.j != null) {
            issuingDistributionPoint.j = (GeneralNames)this.j.clone();
        }
        if (this.k != null) {
            issuingDistributionPoint.k = (RDN)this.k.clone();
        }
        issuingDistributionPoint.l = this.l;
        issuingDistributionPoint.m = this.m;
        issuingDistributionPoint.n = this.n;
        issuingDistributionPoint.o = this.o;
        issuingDistributionPoint.p = this.p;
        if (this.i != null) {
            issuingDistributionPoint.derEncodeValueInit();
        }
        super.copyValues(issuingDistributionPoint);
        return issuingDistributionPoint;
    }

    protected void reset() {
        super.reset();
        this.j = null;
        this.k = null;
        this.l = 0;
        this.m = false;
        this.n = false;
        this.o = false;
        this.p = false;
        this.i = null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IssuingDistributionPoint)) {
            return false;
        }
        IssuingDistributionPoint issuingDistributionPoint = (IssuingDistributionPoint)object;
        if (this.j == null && issuingDistributionPoint.j != null || this.j != null && issuingDistributionPoint.j == null) {
            return false;
        }
        if (this.j != null && !this.j.equals(issuingDistributionPoint.j)) {
            return false;
        }
        if (this.k == null && issuingDistributionPoint.k != null || this.k != null && issuingDistributionPoint.k == null) {
            return false;
        }
        if (this.k != null && !this.k.equals(issuingDistributionPoint.k)) {
            return false;
        }
        return this.l == issuingDistributionPoint.l && this.m == issuingDistributionPoint.m && this.n == issuingDistributionPoint.n && this.o == issuingDistributionPoint.o && this.p == issuingDistributionPoint.p;
    }

    public int hashCode() {
        int n = 0;
        if (this.j != null) {
            n = this.j.hashCode();
        }
        if (this.k != null) {
            n ^= this.k.hashCode();
        }
        String string = String.valueOf(this.m) + String.valueOf(this.n) + String.valueOf(this.o) + String.valueOf(this.p);
        return n ^= string.hashCode();
    }
}

