/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.GeneralName;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class GeneralNames
implements Cloneable,
Serializable {
    private Vector a = new Vector();
    protected static int special;
    private ASN1Template b = null;

    public GeneralNames(byte[] byArray, int n, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            OfContainer ofContainer = new OfContainer(n2, 12288, (ASN1Container)new EncodedContainer(65280));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            int n3 = ofContainer.getContainerCount();
            for (int i = 0; i < n3; ++i) {
                ASN1Container aSN1Container = ofContainer.containerAt(i);
                GeneralName generalName = new GeneralName(aSN1Container.data, aSN1Container.dataOffset, 0);
                this.a.addElement(generalName);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Cannot decode the BER of the name.");
        }
        catch (NameException nameException) {
            throw new NameException("Cannot decode the BER of the name.");
        }
    }

    public GeneralNames() {
    }

    public void addGeneralName(GeneralName generalName) {
        if (generalName != null) {
            this.a.addElement(generalName);
        }
    }

    public Vector getGeneralNames() {
        return this.a;
    }

    public GeneralName getGeneralName(int n) throws NameException {
        if (n < this.a.size()) {
            return (GeneralName)this.a.elementAt(n);
        }
        throw new NameException("Invalid index.");
    }

    public void removeGeneralName(int n) throws NameException {
        if (n >= this.a.size()) {
            throw new NameException("Invalid Index.");
        }
        this.a.removeElementAt(n);
    }

    public void addGeneralName(GeneralName generalName, int n) throws NameException {
        if (generalName == null) {
            throw new NameException("Specified name is null.");
        }
        if (n >= this.a.size()) {
            throw new NameException("Invalid index.");
        }
        this.a.setElementAt(generalName, n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        for (int i = 0; i < this.a.size(); ++i) {
            string = ((GeneralName)this.a.elementAt(i)).toString();
            stringBuffer.append(string);
            stringBuffer.append(",");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public int getNameCount() {
        return this.a.size();
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        if (byArray[n] == 0 && byArray[n + 1] == 0) {
            return n + 2;
        }
        try {
            return n + 1 + ASN1Lengths.determineLengthLen((byte[])byArray, (int)(n + 1)) + ASN1Lengths.determineLength((byte[])byArray, (int)(n + 1));
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int n) throws NameException {
        special = n;
        return this.a();
    }

    public int getDEREncoding(byte[] byArray, int n, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int n3;
            if ((this.b == null || n2 != special) && (n3 = this.getDERLen(n2)) == 0) {
                throw new NameException("Cannot encode GeneralNames.");
            }
            n3 = this.b.derEncode(byArray, n);
            this.b = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.b = null;
            throw new NameException("Unable to encode GeneralNames.");
        }
    }

    private int a() {
        Vector<OfContainer> vector = new Vector<OfContainer>();
        try {
            OfContainer ofContainer = new OfContainer(special, true, 0, 12288, (ASN1Container)new EncodedContainer(65280));
            vector.addElement(ofContainer);
            EncodedContainer encodedContainer = null;
            for (int i = 0; i < this.a.size(); ++i) {
                try {
                    GeneralName generalName = (GeneralName)this.a.elementAt(i);
                    int n = generalName.getDERLen(0);
                    byte[] byArray = new byte[n];
                    n = generalName.getDEREncoding(byArray, 0, 0);
                    encodedContainer = new EncodedContainer(0, true, 0, byArray, 0, n);
                    ofContainer.addContainer((ASN1Container)encodedContainer);
                    continue;
                }
                catch (ASN_Exception aSN_Exception) {
                    return 0;
                }
                catch (NameException nameException) {
                    return 0;
                }
            }
            Object[] objectArray = new ASN1Container[vector.size()];
            vector.copyInto(objectArray);
            this.b = new ASN1Template((ASN1Container[])objectArray);
            return this.b.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public boolean equals(Object object) {
        int n;
        if (object == null || !(object instanceof GeneralNames)) {
            return false;
        }
        GeneralNames generalNames = (GeneralNames)object;
        int n2 = this.a.size();
        if (n2 != (n = generalNames.a.size())) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (this.a.elementAt(i).equals(generalNames.a.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        Iterator iterator = ((AbstractList)this.a).iterator();
        while (iterator.hasNext()) {
            n ^= iterator.next().hashCode();
        }
        return n;
    }

    public boolean contains(GeneralName generalName) {
        if (generalName == null) {
            return false;
        }
        try {
            for (int i = 0; i < this.getNameCount(); ++i) {
                if (!generalName.equals(this.getGeneralName(i))) continue;
                return true;
            }
            return false;
        }
        catch (NameException nameException) {
            return false;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        GeneralNames generalNames = new GeneralNames();
        generalNames.a = (Vector)this.a.clone();
        if (this.b != null) {
            generalNames.a();
        }
        return generalNames;
    }
}

