/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.ExtensionAttribute;
import java.io.Serializable;
import java.util.Vector;

public class ExtensionAttributes
implements Cloneable,
Serializable {
    private Vector a = new Vector();
    protected int special;
    protected ASN1Template asn1Template = null;

    public ExtensionAttributes(byte[] byArray, int n, int n2) throws NameException {
        this.special = n2;
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            OfContainer ofContainer = new OfContainer(n2, 12544, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            int n3 = ofContainer.getContainerCount();
            for (int i = 0; i < n3; ++i) {
                ASN1Container aSN1Container = ofContainer.containerAt(i);
                this.a.addElement(new ExtensionAttribute(aSN1Container.data, aSN1Container.dataOffset, 0));
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Cannot decode the BER of ExtensionAttributes.");
        }
    }

    public ExtensionAttributes() {
    }

    public void addAttribute(ExtensionAttribute extensionAttribute) {
        if (extensionAttribute != null) {
            this.a.addElement(extensionAttribute);
        }
    }

    public ExtensionAttribute getAttribute(int n) throws NameException {
        if (n >= this.a.size()) {
            throw new NameException(" Invalid index ");
        }
        return (ExtensionAttribute)this.a.elementAt(n);
    }

    public int getAttributeCount() {
        return this.a.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.a.size() - 1;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(((ExtensionAttribute)this.a.elementAt(i)).toString());
            stringBuffer.append(",");
        }
        stringBuffer.append(((ExtensionAttribute)this.a.elementAt(n)).toString());
        return stringBuffer.toString();
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        if (byArray[n] == 0 && byArray[n + 1] == 0) {
            return n + 2;
        }
        try {
            return n + 1 + ASN1Lengths.determineLengthLen((byte[])byArray, (int)(n + 1)) + ASN1Lengths.determineLength((byte[])byArray, (int)(n + 1));
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int n) throws NameException {
        this.special = n;
        return this.a();
    }

    public int getDEREncoding(byte[] byArray, int n, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            if (this.asn1Template == null || n2 != this.special) {
                this.getDERLen(n2);
            }
            int n3 = this.asn1Template.derEncode(byArray, n);
            this.asn1Template = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            throw new NameException("Unable to encode ExtensionAttributes");
        }
    }

    private int a() {
        if (this.asn1Template != null && this.special == this.special) {
            return 0;
        }
        try {
            Vector<OfContainer> vector = new Vector<OfContainer>();
            OfContainer ofContainer = new OfContainer(this.special, true, 0, 12544, (ASN1Container)new EncodedContainer(12288));
            vector.addElement(ofContainer);
            for (int i = 0; i < this.a.size(); ++i) {
                int n = ((ExtensionAttribute)this.a.elementAt(i)).getDERLen(0);
                byte[] byArray = new byte[n];
                int n2 = ((ExtensionAttribute)this.a.elementAt(i)).getDEREncoding(byArray, 0, 0);
                EncodedContainer encodedContainer = new EncodedContainer(0, true, 0, byArray, 0, n2);
                ofContainer.addContainer((ASN1Container)encodedContainer);
            }
            Object[] objectArray = new ASN1Container[vector.size()];
            vector.copyInto(objectArray);
            this.asn1Template = new ASN1Template((ASN1Container[])objectArray);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
        catch (NameException nameException) {
            return 0;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ExtensionAttributes)) {
            return false;
        }
        ExtensionAttributes extensionAttributes = (ExtensionAttributes)object;
        if (this.a.size() != extensionAttributes.a.size()) {
            return false;
        }
        for (int i = 0; i < this.a.size(); ++i) {
            if (((ExtensionAttribute)this.a.elementAt(i)).equals(extensionAttributes.a.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        ExtensionAttributes extensionAttributes = new ExtensionAttributes();
        for (int i = 0; i < this.a.size(); ++i) {
            extensionAttributes.a.addElement(this.a.elementAt(i));
        }
        extensionAttributes.special = this.special;
        if (this.asn1Template != null) {
            extensionAttributes.a();
        }
        return extensionAttributes;
    }
}

