/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.NumericStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.PresentationAddress;
import java.io.Serializable;

public class ExtendedNetworkAddress
implements Cloneable,
Serializable {
    private String a;
    private String b;
    private PresentationAddress c;
    protected int special;
    protected ASN1Template asn1Template = null;
    private static final int d = 0x800000;
    private static final int e = 0x810001;
    private static final int f = 0x800000;

    public ExtendedNetworkAddress(byte[] byArray, int n, int n2) throws NameException {
        this.special = n2;
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            ChoiceContainer choiceContainer = new ChoiceContainer(n2);
            SequenceContainer sequenceContainer = new SequenceContainer(0);
            NumericStringContainer numericStringContainer = new NumericStringContainer(0x800000, 1, 15);
            NumericStringContainer numericStringContainer2 = new NumericStringContainer(0x810001, 1, 40);
            EncodedContainer encodedContainer = new EncodedContainer(0x803000);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{choiceContainer, sequenceContainer, numericStringContainer, numericStringContainer2, endContainer, encodedContainer, endContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            if (encodedContainer.dataPresent) {
                byte[] byArray2 = new byte[encodedContainer.dataLen];
                System.arraycopy(encodedContainer.data, encodedContainer.dataOffset, byArray2, 0, encodedContainer.dataLen);
                this.c = new PresentationAddress(byArray2, 0, 0x800000);
            } else {
                this.a = new String(numericStringContainer.data, numericStringContainer.dataOffset, numericStringContainer.dataLen);
                if (numericStringContainer2.dataPresent) {
                    this.b = new String(numericStringContainer2.data, numericStringContainer2.dataOffset, numericStringContainer2.dataLen);
                }
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Cannot decode the BER of the ExtendedNetworkAddress.");
        }
    }

    public ExtendedNetworkAddress() {
    }

    public void setNumber(String string) throws NameException {
        if (string == null) {
            throw new NameException("Specified value is null.");
        }
        if (string.length() > 15) {
            throw new NameException("Specified value are too long.");
        }
        this.a = new String(string);
    }

    public void setSubAddress(String string) throws NameException {
        if (string == null) {
            throw new NameException("Specified value is null.");
        }
        if (string.length() > 40) {
            throw new NameException("Specified value are too long.");
        }
        this.b = new String(string);
    }

    public void setPsapAddress(PresentationAddress presentationAddress) throws NameException {
        if (presentationAddress == null) {
            throw new NameException("Specified value is null.");
        }
        this.c = presentationAddress;
    }

    public String getNumber() {
        return this.a;
    }

    public String getSubAddress() {
        return this.b;
    }

    public PresentationAddress getPsapAddress() {
        return this.c;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.c != null) {
            stringBuffer.append(this.c.toString());
        } else {
            if (this.a != null) {
                stringBuffer.append(new String(this.a));
            }
            if (this.b != null) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(new String(this.b));
            }
        }
        return stringBuffer.toString();
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        if (byArray[n] == 0 && byArray[n + 1] == 0) {
            return n + 2;
        }
        try {
            return n + 1 + ASN1Lengths.determineLengthLen((byte[])byArray, (int)(n + 1)) + ASN1Lengths.determineLength((byte[])byArray, (int)(n + 1));
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int n) {
        this.special = n;
        return this.a();
    }

    public int getDEREncoding(byte[] byArray, int n, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            if (this.asn1Template == null || n2 != this.special) {
                this.getDERLen(n2);
            }
            int n3 = this.asn1Template.derEncode(byArray, n);
            this.asn1Template = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            throw new NameException("Unable to encode ExtendedNetworkAddress");
        }
    }

    private int a() {
        if (this.asn1Template != null && this.special == this.special) {
            return 0;
        }
        try {
            ChoiceContainer choiceContainer = new ChoiceContainer(this.special, 0);
            EndContainer endContainer = new EndContainer();
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            if (this.c != null) {
                int n = this.c.getDERLen(0x800000);
                byte[] byArray = new byte[n];
                n = this.c.getDEREncoding(byArray, 0, 0x800000);
                EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, byArray, 0, n);
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{choiceContainer, encodedContainer, endContainer};
                this.asn1Template = new ASN1Template(aSN1ContainerArray);
            } else {
                NumericStringContainer numericStringContainer = new NumericStringContainer(0x800000, true, 0, this.a, 1, 15);
                if (this.b != null) {
                    NumericStringContainer numericStringContainer2 = new NumericStringContainer(0x810001, true, 0, this.b, 1, 40);
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{choiceContainer, sequenceContainer, numericStringContainer, numericStringContainer2, endContainer, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                } else {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{choiceContainer, sequenceContainer, numericStringContainer, endContainer, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                }
            }
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
        catch (NameException nameException) {
            return 0;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ExtendedNetworkAddress)) {
            return false;
        }
        ExtendedNetworkAddress extendedNetworkAddress = (ExtendedNetworkAddress)object;
        if (this.a != null ? !this.a.equals(extendedNetworkAddress.a) : extendedNetworkAddress.a != null) {
            return false;
        }
        if (this.b != null ? !this.b.equals(extendedNetworkAddress.b) : extendedNetworkAddress.b != null) {
            return false;
        }
        return !(this.c != null ? !this.c.equals(extendedNetworkAddress.c) : extendedNetworkAddress.c != null);
    }

    public Object clone() throws CloneNotSupportedException {
        ExtendedNetworkAddress extendedNetworkAddress = new ExtendedNetworkAddress();
        if (this.c != null) {
            extendedNetworkAddress.c = (PresentationAddress)this.c.clone();
        } else {
            if (this.a != null) {
                extendedNetworkAddress.a = new String(this.a);
            }
            if (this.b != null) {
                extendedNetworkAddress.b = new String(this.b);
            }
        }
        extendedNetworkAddress.special = this.special;
        if (this.asn1Template != null) {
            extendedNetworkAddress.a();
        }
        return extendedNetworkAddress;
    }
}

