/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.PolicyQualifiers;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;
import java.util.Vector;

public class CertPolicies
extends X509V3Extension
implements Cloneable,
Serializable,
CertExtension {
    private Vector[] a = this.a(2);
    private ASN1Template b = null;

    public CertPolicies() {
        this.extensionTypeFlag = 32;
        this.criticality = false;
        this.setStandardOID(32);
        this.extensionTypeString = "CertPolicies";
    }

    public CertPolicies(byte[] byArray, int n, int n2, PolicyQualifiers policyQualifiers, boolean bl) {
        this.extensionTypeFlag = 32;
        this.criticality = bl;
        this.setStandardOID(32);
        if (byArray != null && n2 != 0) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            this.a[0].addElement(byArray2);
            this.a[1].addElement(policyQualifiers);
        }
        this.extensionTypeString = "CertPolicies";
    }

    public void addCertPolicy(byte[] byArray, int n, int n2, PolicyQualifiers policyQualifiers) {
        if (byArray != null && n2 != 0) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            this.a[0].addElement(byArray2);
            this.a[1].addElement(policyQualifiers);
        }
    }

    public byte[] getCertPolicyId(int n) throws CertificateException {
        if (this.a[0].size() <= n) {
            throw new CertificateException("Specified index is invalid.");
        }
        return (byte[])this.a[0].elementAt(n);
    }

    public PolicyQualifiers getPolicyQualifiers(int n) throws CertificateException {
        if (this.a[1].size() <= n) {
            throw new CertificateException("Specified index is invalid.");
        }
        return (PolicyQualifiers)this.a[1].elementAt(n);
    }

    public int getPoliciesCount() {
        return this.a[0].size();
    }

    private Vector[] a(int n) {
        Vector[] vectorArray = new Vector[n];
        for (int i = 0; i < n; ++i) {
            vectorArray[i] = new Vector();
        }
        return vectorArray;
    }

    public void decodeValue(byte[] byArray, int n) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            OfContainer ofContainer = new OfContainer(0, 12288, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            int n2 = ofContainer.getContainerCount();
            for (int i = 0; i < n2; ++i) {
                ASN1Container aSN1Container = ofContainer.containerAt(i);
                SequenceContainer sequenceContainer = new SequenceContainer(0);
                EndContainer endContainer = new EndContainer();
                EncodedContainer encodedContainer = new EncodedContainer(77824);
                OIDContainer oIDContainer = new OIDContainer(0);
                ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
                ASN1.berDecode((byte[])aSN1Container.data, (int)aSN1Container.dataOffset, (ASN1Container[])aSN1ContainerArray2);
                byte[] byArray2 = new byte[oIDContainer.dataLen];
                System.arraycopy(oIDContainer.data, oIDContainer.dataOffset, byArray2, 0, oIDContainer.dataLen);
                this.a[0].addElement(byArray2);
                if (encodedContainer.dataPresent) {
                    this.a[1].addElement(new PolicyQualifiers(encodedContainer.data, encodedContainer.dataOffset, 65536));
                    continue;
                }
                this.a[1].addElement(null);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not decode Certificate Policies extension.");
        }
        catch (CertificateException certificateException) {
            throw new CertificateException("Could not decode Certificate Policies extension.");
        }
    }

    public int derEncodeValueInit() {
        if (this.a[0].size() == 0) {
            return 0;
        }
        try {
            Vector<OfContainer> vector = new Vector<OfContainer>();
            OfContainer ofContainer = new OfContainer(this.special, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
            vector.addElement(ofContainer);
            for (int i = 0; i < this.a[0].size(); ++i) {
                EncodedContainer encodedContainer = this.b(i);
                ofContainer.addContainer((ASN1Container)encodedContainer);
            }
            Object[] objectArray = new ASN1Container[vector.size()];
            vector.copyInto(objectArray);
            this.b = new ASN1Template((ASN1Container[])objectArray);
            return this.b.derEncodeInit();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private EncodedContainer b(int n) throws CertificateException {
        EncodedContainer encodedContainer = null;
        SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
        EndContainer endContainer = new EndContainer();
        ASN1Template aSN1Template = null;
        byte[] byArray = (byte[])this.a[0].elementAt(n);
        try {
            Object[] objectArray;
            OIDContainer oIDContainer = new OIDContainer(0x1000000, true, 0, byArray, 0, byArray.length);
            PolicyQualifiers policyQualifiers = (PolicyQualifiers)this.a[1].elementAt(n);
            if (policyQualifiers != null) {
                objectArray = new byte[policyQualifiers.getDERLen(65536)];
                int n2 = policyQualifiers.getDEREncoding((byte[])objectArray, 0, 65536);
                EncodedContainer encodedContainer2 = new EncodedContainer(77824, true, 0, objectArray, 0, n2);
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer2, endContainer};
                aSN1Template = new ASN1Template(aSN1ContainerArray);
            } else {
                objectArray = new ASN1Container[]{sequenceContainer, oIDContainer, endContainer};
                aSN1Template = new ASN1Template((ASN1Container[])objectArray);
            }
            int n3 = aSN1Template.derEncodeInit();
            byte[] byArray2 = new byte[n3];
            n3 = aSN1Template.derEncode(byArray2, 0);
            encodedContainer = new EncodedContainer(12288, true, 0, byArray2, 0, n3);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException(" Can't encode Certificate Policy");
        }
        return encodedContainer;
    }

    public int derEncodeValue(byte[] byArray, int n) {
        if (byArray == null) {
            return 0;
        }
        if (this.b == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int n2 = this.b.derEncode(byArray, n);
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        CertPolicies certPolicies = new CertPolicies();
        for (int i = 0; i < this.a.length; ++i) {
            for (int j = 0; j < this.a[i].size(); ++j) {
                certPolicies.a[i].addElement(this.a[i].elementAt(j));
            }
        }
        if (this.b != null) {
            certPolicies.derEncodeValueInit();
        }
        super.copyValues(certPolicies);
        return certPolicies;
    }

    protected void reset() {
        super.reset();
        this.a = this.a(2);
    }
}

