/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IA5StringContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.NameException;
import java.io.Serializable;

public class BiometricData
implements Cloneable,
Serializable {
    private byte[] a = null;
    private String b = null;
    private int c = -1;
    private byte[] d = null;
    private byte[] e = null;
    protected static int special;
    private ASN1Template f = null;

    public BiometricData(byte[] byArray, int n, int n2) throws NameException {
        if (byArray == null || n < 0) {
            throw new NameException("Encoding is null.");
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(n2);
            EncodedContainer encodedContainer = new EncodedContainer(12288);
            OctetStringContainer octetStringContainer = new OctetStringContainer(0);
            EndContainer endContainer = new EndContainer();
            ChoiceContainer choiceContainer = new ChoiceContainer(0);
            IntegerContainer integerContainer = new IntegerContainer(0);
            OIDContainer oIDContainer = new OIDContainer(0x1000000);
            IA5StringContainer iA5StringContainer = new IA5StringContainer(65536);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, choiceContainer, integerContainer, oIDContainer, endContainer, encodedContainer, octetStringContainer, iA5StringContainer, endContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            if (integerContainer.dataPresent) {
                this.c = integerContainer.getValueAsInt();
            } else {
                this.d = new byte[oIDContainer.dataLen];
                System.arraycopy(oIDContainer.data, oIDContainer.dataOffset, this.d, 0, oIDContainer.dataLen);
            }
            this.e = new byte[encodedContainer.dataLen];
            System.arraycopy(encodedContainer.data, encodedContainer.dataOffset, this.e, 0, encodedContainer.dataLen);
            if (AlgorithmID.berDecodeAlgID((byte[])this.e, (int)0, (int)10, null) == null) {
                throw new NameException("Unknown or invalid hash algorithm.");
            }
            this.a = new byte[octetStringContainer.dataLen];
            System.arraycopy(octetStringContainer.data, octetStringContainer.dataOffset, this.a, 0, octetStringContainer.dataLen);
            this.b = iA5StringContainer.getValueAsString();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Could not BER decode the Biometric Data info." + aSN_Exception.getMessage());
        }
    }

    public BiometricData() {
    }

    public void setDataHash(byte[] byArray, int n, int n2) {
        if (byArray != null && n2 > 0 && n >= 0 && byArray.length >= n2 + n) {
            this.a = new byte[n2];
            System.arraycopy(byArray, n, this.a, 0, n2);
        } else {
            this.a = null;
        }
    }

    public byte[] getDataHash() {
        if (this.a == null) {
            return null;
        }
        byte[] byArray = new byte[this.a.length];
        System.arraycopy(this.a, 0, byArray, 0, this.a.length);
        return byArray;
    }

    public void setDataURI(String string) {
        this.b = string;
    }

    public String getDataURI() {
        return this.b;
    }

    public void setBiometricType(int n) {
        this.c = n;
        this.d = null;
    }

    public int getBiometricType() {
        return this.c;
    }

    public void setDataID(byte[] byArray, int n, int n2) {
        if (byArray != null && n2 > 0 && n >= 0 && byArray.length >= n2 + n) {
            this.d = new byte[n2];
            System.arraycopy(byArray, n, this.d, 0, n2);
            this.c = -1;
        } else {
            this.d = null;
        }
    }

    public byte[] getDataID() {
        if (this.d == null) {
            return null;
        }
        byte[] byArray = new byte[this.d.length];
        System.arraycopy(this.d, 0, byArray, 0, this.d.length);
        return byArray;
    }

    public void setHashAlgorithm(String string) throws NameException {
        try {
            this.e = AlgorithmID.derEncodeAlgID((String)string, (int)10, null, (int)0, (int)0);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Invalid hash algorithm. " + aSN_Exception.getMessage());
        }
    }

    public String getHashAlgorithm() throws NameException {
        try {
            return AlgorithmID.berDecodeAlgID((byte[])this.e, (int)0, (int)10, null);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Invalid hash algorithm. " + aSN_Exception.getMessage());
        }
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        if (byArray[n] == 0 && byArray[n + 1] == 0) {
            return n + 2;
        }
        try {
            return n + 1 + ASN1Lengths.determineLengthLen((byte[])byArray, (int)(n + 1)) + ASN1Lengths.determineLength((byte[])byArray, (int)(n + 1));
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Unable to determine length of the BER. " + aSN_Exception.getMessage());
        }
    }

    public int getDERLen(int n) throws NameException {
        if (this.a == null || this.e == null || this.d == null && this.c == -1) {
            throw new NameException("Biometric data is not set.");
        }
        special = n;
        return this.a();
    }

    public int getDEREncoding(byte[] byArray, int n, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int n3;
            if ((this.f == null || n2 != special) && (n3 = this.getDERLen(n2)) == 0) {
                throw new NameException("Cannot encode BiometricData.");
            }
            n3 = this.f.derEncode(byArray, n);
            this.f = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.f = null;
            throw new NameException("Unable to encode BiometricData." + aSN_Exception.getMessage());
        }
    }

    private int a() throws NameException {
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(special);
            EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, this.e, 0, this.e.length);
            OctetStringContainer octetStringContainer = new OctetStringContainer(0, true, 0, this.a, 0, this.a.length);
            ChoiceContainer choiceContainer = new ChoiceContainer(0);
            EndContainer endContainer = new EndContainer();
            IntegerContainer integerContainer = null;
            IA5StringContainer iA5StringContainer = null;
            if (this.c != -1) {
                integerContainer = new IntegerContainer(0, true, 0, this.c);
            } else if (this.d != null) {
                integerContainer = new OIDContainer(0x1000000, true, 0, this.d, 0, this.d.length);
            } else {
                throw new NameException("Type of Biometric Data is not set.");
            }
            iA5StringContainer = this.b != null ? new IA5StringContainer(65536, true, 0, this.b) : new IA5StringContainer(65536, false, 0, null);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, choiceContainer, integerContainer, endContainer, encodedContainer, octetStringContainer, iA5StringContainer, endContainer};
            this.f = new ASN1Template(aSN1ContainerArray);
            return this.f.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("cannot create the DER encoding. " + aSN_Exception.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BiometricData)) {
            return false;
        }
        BiometricData biometricData = (BiometricData)object;
        if (this.b != null ? !this.b.equals(biometricData.b) : biometricData.b != null) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.a, biometricData.a)) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.d, biometricData.d)) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.e, biometricData.e)) {
            return false;
        }
        return this.c == biometricData.c;
    }

    public Object clone() throws CloneNotSupportedException {
        BiometricData biometricData = new BiometricData();
        if (this.a != null) {
            biometricData.a = new byte[this.a.length];
            System.arraycopy(this.a, 0, biometricData.a, 0, this.a.length);
        }
        if (this.d != null) {
            biometricData.d = new byte[this.d.length];
            System.arraycopy(this.d, 0, biometricData.d, 0, this.d.length);
        }
        if (this.e != null) {
            biometricData.e = new byte[this.e.length];
            System.arraycopy(this.e, 0, biometricData.e, 0, this.e.length);
        }
        biometricData.c = this.c;
        special = this.c;
        biometricData.b = new String(this.b);
        try {
            if (this.f != null) {
                biometricData.a();
            }
        }
        catch (NameException nameException) {
            throw new CloneNotSupportedException(nameException.getMessage());
        }
        return biometricData;
    }
}

