/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BooleanContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;

public class BasicConstraints
extends X509V3Extension
implements Cloneable,
Serializable,
CertExtension {
    private boolean a = false;
    private int b = -1;
    ASN1Template c;

    public BasicConstraints() {
        this.extensionTypeFlag = 19;
        this.criticality = false;
        this.setStandardOID(19);
        this.extensionTypeString = "BasicConstraints";
    }

    public BasicConstraints(boolean bl, int n, boolean bl2) throws CertificateException {
        this.extensionTypeString = "BasicConstraints";
        this.extensionTypeFlag = 19;
        this.criticality = bl2;
        this.setStandardOID(19);
        this.a = bl;
        if (!bl) {
            throw new CertificateException("The pathLenConstraint shall be present only if cA is set to true.");
        }
        this.b = n;
    }

    public void decodeValue(byte[] byArray, int n) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        EndContainer endContainer = new EndContainer();
        BooleanContainer booleanContainer = new BooleanContainer(131072);
        IntegerContainer integerContainer = new IntegerContainer(65536);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, booleanContainer, integerContainer, endContainer};
        try {
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            this.a = booleanContainer.dataPresent ? booleanContainer.value : false;
            if (integerContainer.dataPresent && this.a) {
                this.b = integerContainer.getValueAsInt();
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not decode BasicConstraints extension.");
        }
    }

    public void setCA(boolean bl) throws CertificateException {
        this.a = bl;
    }

    public boolean getCA() {
        return this.a;
    }

    public void setPathLen(int n) throws CertificateException {
        if (!this.a) {
            throw new CertificateException("The pathLenConstraint shall be present only if cA is set to true.");
        }
        this.b = n;
    }

    public int getPathLen() {
        return this.b;
    }

    public int derEncodeValueInit() {
        SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
        EndContainer endContainer = new EndContainer();
        BooleanContainer booleanContainer = null;
        booleanContainer = this.a ? new BooleanContainer(131072, true, 0, true) : new BooleanContainer(131072, false, 0, false);
        if (this.a) {
            IntegerContainer integerContainer = new IntegerContainer(65536, true, 0, this.b);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, booleanContainer, integerContainer, endContainer};
            this.c = new ASN1Template(aSN1ContainerArray);
        } else {
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, booleanContainer, endContainer};
            this.c = new ASN1Template(aSN1ContainerArray);
        }
        try {
            return this.c.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] byArray, int n) {
        if (this.c == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n2 = 0;
        try {
            n2 = this.c.derEncode(byArray, n);
            this.asn1Template = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        BasicConstraints basicConstraints = new BasicConstraints();
        basicConstraints.a = this.a;
        basicConstraints.b = this.b;
        if (this.c != null) {
            basicConstraints.derEncodeValueInit();
        }
        super.copyValues(basicConstraints);
        return basicConstraints;
    }

    protected void reset() {
        super.reset();
        this.a = false;
        this.b = -1;
        this.c = null;
    }
}

