/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CRLExtension;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;

public class AuthorityKeyID
extends X509V3Extension
implements Cloneable,
Serializable,
CertExtension,
CRLExtension {
    ASN1Template a;
    private byte[] b;
    private static final int c = 0x810000;
    private GeneralNames d;
    private static final int e = 0x810001;
    private byte[] f;
    private static final int g = 8454146;

    public AuthorityKeyID() {
        this.extensionTypeFlag = 35;
        this.criticality = false;
        this.d = new GeneralNames();
        this.setStandardOID(35);
        this.extensionTypeString = "AuthorityKeyID";
    }

    public AuthorityKeyID(GeneralNames generalNames, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, boolean bl) {
        this.extensionTypeFlag = 35;
        this.criticality = bl;
        this.setStandardOID(35);
        this.extensionTypeString = "AuthorityKeyID";
        if (byArray2 != null && n4 != 0) {
            this.b = new byte[n4];
            System.arraycopy(byArray2, n3, this.b, 0, n4);
        }
        if (generalNames != null) {
            this.d = generalNames;
        }
        if (byArray != null && n2 != 0) {
            this.f = new byte[n2];
            System.arraycopy(byArray, n, this.f, 0, n2);
        }
    }

    public void decodeValue(byte[] byArray, int n) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        OctetStringContainer octetStringContainer = null;
        IntegerContainer integerContainer = null;
        EncodedContainer encodedContainer = null;
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0);
            EndContainer endContainer = new EndContainer();
            octetStringContainer = new OctetStringContainer(0x810000);
            integerContainer = new IntegerContainer(8454146);
            encodedContainer = new EncodedContainer(8466433);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, octetStringContainer, encodedContainer, integerContainer, endContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not decode AuthorityKeyID extension.");
        }
        try {
            if (octetStringContainer.dataPresent && octetStringContainer.dataLen != 0 && octetStringContainer.data != null) {
                this.b = new byte[octetStringContainer.dataLen];
                System.arraycopy(octetStringContainer.data, octetStringContainer.dataOffset, this.b, 0, octetStringContainer.dataLen);
            }
            if (encodedContainer.dataPresent && integerContainer.dataPresent) {
                this.d = new GeneralNames(encodedContainer.data, encodedContainer.dataOffset, 0x810001);
                this.f = new byte[integerContainer.dataLen];
                System.arraycopy(integerContainer.data, integerContainer.dataOffset, this.f, 0, integerContainer.dataLen);
            }
        }
        catch (NameException nameException) {
            throw new CertificateException("Could not decode AuthorityKeyID extension!!!.");
        }
    }

    public void setKeyID(byte[] byArray, int n, int n2) {
        if (byArray != null && n2 != 0) {
            this.b = new byte[n2];
            System.arraycopy(byArray, n, this.b, 0, n2);
        }
    }

    public void setAuthorityCertIssuer(GeneralNames generalNames) {
        if (generalNames != null) {
            this.d = generalNames;
        }
    }

    public void setSerialNumber(byte[] byArray, int n, int n2) {
        if (byArray != null && n2 != 0) {
            this.f = new byte[n2];
            System.arraycopy(byArray, n, this.f, 0, n2);
        }
    }

    public byte[] getKeyID() {
        if (this.b == null) {
            return null;
        }
        byte[] byArray = new byte[this.b.length];
        System.arraycopy(this.b, 0, byArray, 0, this.b.length);
        return byArray;
    }

    public GeneralNames getAuthorityCertIssuer() {
        return this.d;
    }

    public byte[] getSerialNumber() {
        if (this.f == null) {
            return null;
        }
        byte[] byArray = new byte[this.f.length];
        System.arraycopy(this.f, 0, byArray, 0, this.f.length);
        return byArray;
    }

    public int derEncodeValueInit() {
        try {
            Object[] objectArray;
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            EndContainer endContainer = new EndContainer();
            OctetStringContainer octetStringContainer = null;
            IntegerContainer integerContainer = null;
            EncodedContainer encodedContainer = null;
            int n = 0;
            if (this.b != null) {
                octetStringContainer = new OctetStringContainer(0x810000, true, 0, this.b, 0, this.b.length);
                n = 1;
            }
            if (this.d != null && this.f != null) {
                integerContainer = new IntegerContainer(8454146, true, 0, this.f, 0, this.f.length, true);
                try {
                    int n2 = this.d.getDERLen(0x810001);
                    objectArray = new byte[n2];
                    int n3 = 0;
                    int n4 = this.d.getDEREncoding((byte[])objectArray, n3, 0x810001);
                    encodedContainer = new EncodedContainer(8466433, true, 0, (byte[])objectArray, n3, n4);
                }
                catch (NameException nameException) {
                    return 0;
                }
                n = n == 1 ? 3 : 2;
            }
            switch (n) {
                case 0: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, endContainer};
                    this.a = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 1: {
                    objectArray = new ASN1Container[]{sequenceContainer, octetStringContainer, endContainer};
                    this.a = new ASN1Template(objectArray);
                    break;
                }
                case 2: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, integerContainer, endContainer};
                    this.a = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 3: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, octetStringContainer, encodedContainer, integerContainer, endContainer};
                    this.a = new ASN1Template(aSN1ContainerArray);
                    break;
                }
            }
            return this.a.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] byArray, int n) {
        if (this.a == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n2 = 0;
        try {
            n2 = this.a.derEncode(byArray, n);
            this.asn1Template = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AuthorityKeyID authorityKeyID = new AuthorityKeyID();
        if (this.b != null) {
            authorityKeyID.b = (byte[])this.b.clone();
        }
        if (this.d != null) {
            authorityKeyID.d = (GeneralNames)this.d.clone();
        }
        if (this.f != null) {
            authorityKeyID.f = (byte[])this.f.clone();
        }
        if (this.a != null) {
            authorityKeyID.derEncodeValueInit();
        }
        super.copyValues(authorityKeyID);
        return authorityKeyID;
    }

    protected void reset() {
        super.reset();
        this.b = null;
        this.d = null;
        this.f = null;
        this.a = null;
    }
}

