/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;
import java.util.Vector;

public class AuthorityInfoAccess
extends X509V3Extension
implements Cloneable,
Serializable,
CertExtension {
    public static final byte[] ID_AD_OCSP = new byte[]{43, 6, 1, 5, 5, 7, 48, 1};
    private Vector a = new Vector();
    private Vector b = new Vector();
    ASN1Template c;

    public AuthorityInfoAccess() {
        this.extensionTypeFlag = 100;
        this.criticality = false;
        this.setSpecialOID(X509V3Extension.AUTHORITY_INFO_OID);
        this.extensionTypeString = "AuthorityInfoAccess";
    }

    public AuthorityInfoAccess(byte[] byArray, int n, int n2, GeneralName generalName, boolean bl) throws CertificateException {
        this.extensionTypeFlag = 100;
        this.criticality = bl;
        this.setSpecialOID(X509V3Extension.AUTHORITY_INFO_OID);
        if (byArray == null || n2 == 0 || generalName == null) {
            throw new CertificateException("Missing values");
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.b.addElement(byArray2);
        this.a.addElement(generalName);
        this.extensionTypeString = "AuthorityInfoAccess";
    }

    public void addAccessDescription(byte[] byArray, int n, int n2, GeneralName generalName) throws CertificateException {
        if (byArray == null || n2 == 0 || generalName == null) {
            throw new CertificateException("Missing values");
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.b.addElement(byArray2);
        this.a.addElement(generalName);
    }

    public GeneralName getAccessLocation(int n) throws CertificateException {
        if (n < this.a.size()) {
            return (GeneralName)this.a.elementAt(n);
        }
        throw new CertificateException("Index is invalid.");
    }

    public byte[] getAccessMethod(int n) throws CertificateException {
        if (n < this.b.size()) {
            return (byte[])this.b.elementAt(n);
        }
        throw new CertificateException("Index is invalid.");
    }

    public int getAccessDescriptionCount() {
        return this.b.size();
    }

    public void decodeValue(byte[] byArray, int n) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            OfContainer ofContainer = new OfContainer(0, 12288, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            int n2 = ofContainer.getContainerCount();
            for (int i = 0; i < n2; ++i) {
                ASN1Container aSN1Container = ofContainer.containerAt(i);
                SequenceContainer sequenceContainer = new SequenceContainer(0);
                EndContainer endContainer = new EndContainer();
                OIDContainer oIDContainer = new OIDContainer(0x1000000);
                EncodedContainer encodedContainer = new EncodedContainer(65280);
                ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
                ASN1.berDecode((byte[])aSN1Container.data, (int)aSN1Container.dataOffset, (ASN1Container[])aSN1ContainerArray2);
                if (oIDContainer.data != null && oIDContainer.dataLen != 0) {
                    byte[] byArray2 = new byte[oIDContainer.dataLen];
                    System.arraycopy(oIDContainer.data, oIDContainer.dataOffset, byArray2, 0, oIDContainer.dataLen);
                    this.b.addElement(byArray2);
                }
                this.a.addElement(new GeneralName(encodedContainer.data, encodedContainer.dataOffset, 0));
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not decode AuthorityInfoAccess extension.");
        }
        catch (NameException nameException) {
            throw new CertificateException("Could not decode AuthorityInfoAccess extension.");
        }
    }

    public int derEncodeValueInit() {
        if (this.a.size() == 0) {
            return 0;
        }
        try {
            Vector<OfContainer> vector = new Vector<OfContainer>();
            OfContainer ofContainer = new OfContainer(0, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
            vector.addElement(ofContainer);
            for (int i = 0; i < this.b.size(); ++i) {
                EncodedContainer encodedContainer = this.a(i);
                ofContainer.addContainer((ASN1Container)encodedContainer);
            }
            Object[] objectArray = new ASN1Container[vector.size()];
            vector.copyInto(objectArray);
            this.c = new ASN1Template((ASN1Container[])objectArray);
            return this.c.derEncodeInit();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private EncodedContainer a(int n) throws CertificateException {
        EncodedContainer encodedContainer = null;
        SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
        EndContainer endContainer = new EndContainer();
        byte[] byArray = (byte[])this.b.elementAt(n);
        try {
            OIDContainer oIDContainer = new OIDContainer(0x1000000, true, 0, byArray, 0, byArray.length);
            GeneralName generalName = (GeneralName)this.a.elementAt(n);
            byte[] byArray2 = new byte[generalName.getDERLen(0)];
            int n2 = generalName.getDEREncoding(byArray2, 0, 0);
            EncodedContainer encodedContainer2 = new EncodedContainer(0, true, 0, byArray2, 0, n2);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer2, endContainer};
            ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray);
            int n3 = aSN1Template.derEncodeInit();
            byte[] byArray3 = new byte[n3];
            n3 = aSN1Template.derEncode(byArray3, 0);
            encodedContainer = new EncodedContainer(12288, true, 0, byArray3, 0, n3);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException(" Can't encode Access Description");
        }
        catch (NameException nameException) {
            throw new CertificateException("Could not encode Access Description ");
        }
        return encodedContainer;
    }

    public int derEncodeValue(byte[] byArray, int n) {
        if (this.c == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int n2 = this.c.derEncode(byArray, n);
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AuthorityInfoAccess authorityInfoAccess = new AuthorityInfoAccess();
        for (int i = 0; i < this.b.size(); ++i) {
            authorityInfoAccess.b.addElement(this.b.elementAt(i));
            authorityInfoAccess.a.addElement(this.a.elementAt(i));
        }
        if (this.c != null) {
            authorityInfoAccess.derEncodeValueInit();
        }
        super.copyValues(authorityInfoAccess);
        return authorityInfoAccess;
    }

    protected void reset() {
        super.reset();
        this.b = new Vector();
        this.a = new Vector();
    }
}

