/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BMPStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IA5StringContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.asn1.TeletexStringContainer;
import com.rsa.asn1.UTF8StringContainer;
import com.rsa.asn1.UniversalStringContainer;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;
import java.io.Serializable;
import java.util.Vector;

public class PostalAddress
extends X501Attribute
implements Cloneable,
Serializable {
    private Vector a = new Vector();
    private Vector b = new Vector();
    ASN1Template c;

    public PostalAddress() {
        super(16, "postalAddress");
    }

    public PostalAddress(String string, int n) throws AttributeException {
        this();
        this.addPostalAddress(string, n);
    }

    protected void decodeValue(byte[] byArray, int n) throws AttributeException {
        if (byArray == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        try {
            SetContainer setContainer = new SetContainer(0);
            EndContainer endContainer = new EndContainer();
            EncodedContainer encodedContainer = new EncodedContainer(12288);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, encodedContainer, endContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            OfContainer ofContainer = new OfContainer(0, 12288, (ASN1Container)new EncodedContainer(65280));
            ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{ofContainer};
            ASN1.berDecode((byte[])encodedContainer.data, (int)encodedContainer.dataOffset, (ASN1Container[])aSN1ContainerArray2);
            EncodedContainer encodedContainer2 = null;
            for (int i = 0; i < ofContainer.getContainerCount(); ++i) {
                encodedContainer2 = (EncodedContainer)ofContainer.containerAt(i);
                ChoiceContainer choiceContainer = new ChoiceContainer(0);
                PrintStringContainer printStringContainer = new PrintStringContainer(0, 1, -1);
                TeletexStringContainer teletexStringContainer = new TeletexStringContainer(0, 1, -1);
                UniversalStringContainer universalStringContainer = new UniversalStringContainer(0, 1, -1);
                BMPStringContainer bMPStringContainer = new BMPStringContainer(0, 1, -1);
                UTF8StringContainer uTF8StringContainer = new UTF8StringContainer(0);
                IA5StringContainer iA5StringContainer = new IA5StringContainer(0, 1, -1);
                ASN1Container[] aSN1ContainerArray3 = new ASN1Container[]{choiceContainer, printStringContainer, teletexStringContainer, universalStringContainer, bMPStringContainer, uTF8StringContainer, iA5StringContainer, endContainer};
                ASN1.berDecode((byte[])encodedContainer2.data, (int)encodedContainer2.dataOffset, (ASN1Container[])aSN1ContainerArray3);
                if (printStringContainer.dataPresent) {
                    this.b.addElement(new Integer(4864));
                    this.a.addElement(printStringContainer.getValueAsString());
                    continue;
                }
                if (teletexStringContainer.dataPresent) {
                    this.b.addElement(new Integer(5120));
                    this.a.addElement(teletexStringContainer.getValueAsString());
                    continue;
                }
                if (universalStringContainer.dataPresent) {
                    this.b.addElement(new Integer(7168));
                    this.a.addElement(universalStringContainer.getValueAsString());
                    continue;
                }
                if (bMPStringContainer.dataPresent) {
                    this.b.addElement(new Integer(7680));
                    this.a.addElement(bMPStringContainer.getValueAsString());
                    continue;
                }
                if (uTF8StringContainer.dataPresent) {
                    this.b.addElement(new Integer(3072));
                    this.a.addElement(this.utf8Decode(uTF8StringContainer.data, uTF8StringContainer.dataOffset, uTF8StringContainer.dataLen));
                    continue;
                }
                if (iA5StringContainer.dataPresent) {
                    this.b.addElement(new Integer(5632));
                    this.a.addElement(iA5StringContainer.getValueAsString());
                    continue;
                }
                throw new AttributeException("DirectoryString expected.");
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new AttributeException("Could not BER decode postalAddress." + aSN_Exception.getMessage());
        }
    }

    public void addPostalAddress(String string, int n) throws AttributeException {
        if (string == null) {
            throw new AttributeException("PostalAddress is null.");
        }
        this.a.addElement(string);
        if (n != 4864 && n != 5120 && n != 7168 && n != 3072 && n != 7680 && n != 5632) {
            throw new AttributeException("Invalid String Type.");
        }
        this.b.addElement(new Integer(n));
    }

    public String[] getPostalAddress() {
        String[] stringArray = new String[this.a.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)this.a.elementAt(i);
        }
        return stringArray;
    }

    protected int derEncodeValueInit() {
        this.c = null;
        if (this.a == null) {
            return 0;
        }
        try {
            OfContainer ofContainer = new OfContainer(0, true, 0, 12288, (ASN1Container)new EncodedContainer(65280));
            EndContainer endContainer = new EndContainer();
            SetContainer setContainer = new SetContainer(0, true, 0);
            ChoiceContainer choiceContainer = new ChoiceContainer(0);
            TeletexStringContainer teletexStringContainer = null;
            ASN1Template aSN1Template = null;
            byte[] byArray = null;
            EncodedContainer encodedContainer = new EncodedContainer(65280);
            for (int i = 0; i < this.a.size(); ++i) {
                Object[] objectArray;
                int n = (Integer)this.b.elementAt(i);
                if (n == 0) {
                    n = 3072;
                }
                switch (n) {
                    case 5120: {
                        teletexStringContainer = new TeletexStringContainer(0, true, 0, (String)this.a.elementAt(i));
                        break;
                    }
                    case 4864: {
                        teletexStringContainer = new PrintStringContainer(0, true, 0, (String)this.a.elementAt(i));
                        break;
                    }
                    case 7168: {
                        teletexStringContainer = new UniversalStringContainer(0, true, 0, (String)this.a.elementAt(i));
                        break;
                    }
                    case 5632: {
                        teletexStringContainer = new IA5StringContainer(0, true, 0, (String)this.a.elementAt(i));
                        break;
                    }
                    case 3072: {
                        objectArray = this.utf8Encode((String)this.a.elementAt(i));
                        if (objectArray.length < 2) {
                            return 0;
                        }
                        teletexStringContainer = new UTF8StringContainer(0, true, 0, objectArray, 2, objectArray.length - 2);
                        break;
                    }
                    case 7680: {
                        teletexStringContainer = new BMPStringContainer(0, true, 0, (String)this.a.elementAt(i));
                        break;
                    }
                    default: {
                        return 0;
                    }
                }
                objectArray = new ASN1Container[]{choiceContainer, teletexStringContainer, endContainer};
                aSN1Template = new ASN1Template((ASN1Container[])objectArray);
                byArray = new byte[aSN1Template.derEncodeInit()];
                int n2 = aSN1Template.derEncode(byArray, 0);
                encodedContainer = new EncodedContainer(0, true, 0, byArray, 0, n2);
                ofContainer.addContainer((ASN1Container)encodedContainer);
            }
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, ofContainer, endContainer};
            this.c = new ASN1Template(aSN1ContainerArray);
            return this.c.derEncodeInit();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] byArray, int n) {
        if (byArray == null) {
            return 0;
        }
        if (this.c == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n2 = 0;
        try {
            n2 = this.c.derEncode(byArray, n);
            this.asn1Template = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PostalAddress postalAddress = new PostalAddress();
        for (int i = 0; i < this.a.size(); ++i) {
            postalAddress.a.addElement(this.a.elementAt(i));
            postalAddress.b.addElement(this.b.elementAt(i));
        }
        super.copyValues(postalAddress);
        return postalAddress;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PostalAddress)) {
            return false;
        }
        PostalAddress postalAddress = (PostalAddress)object;
        if (this.a.size() != postalAddress.a.size()) {
            return false;
        }
        for (int i = 0; i < this.a.size(); ++i) {
            if (!this.a.elementAt(i).equals(postalAddress.a.elementAt(i))) {
                return false;
            }
            if (this.b.elementAt(i).equals(postalAddress.b.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    protected void reset() {
        super.reset();
        this.a = new Vector();
        this.b = new Vector();
        this.c = null;
    }
}

