/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CompatibilityType;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;
import java.io.Serializable;

abstract class IntegerPrintableStringAttr
extends X501Attribute
implements Cloneable,
Serializable {
    protected int value = -1;
    private ASN1Template a;

    protected IntegerPrintableStringAttr(int n, String string) {
        super(n, string);
    }

    protected void decodeValue(byte[] byArray, int n) throws AttributeException {
        block5: {
            if (byArray == null) {
                throw new AttributeException("Encoding is null.");
            }
            this.reset();
            try {
                SetContainer setContainer = new SetContainer(0);
                EndContainer endContainer = new EndContainer();
                IntegerContainer integerContainer = new IntegerContainer(65536);
                PrintStringContainer printStringContainer = new PrintStringContainer(65536);
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, integerContainer, printStringContainer, endContainer};
                ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
                if (integerContainer.dataPresent) {
                    this.value = integerContainer.getValueAsInt();
                    break block5;
                }
                if (printStringContainer.dataPresent) {
                    String string = printStringContainer.getValueAsString();
                    this.value = Integer.parseInt(string);
                    break block5;
                }
                throw new AttributeException("Unexpected encoding.");
            }
            catch (Exception exception) {
                throw new AttributeException("Could not BER decode attribute.");
            }
        }
    }

    protected void setValue(int n) {
        this.reset();
        if (n >= 0) {
            this.value = n;
        }
    }

    protected int getValue() {
        return this.value;
    }

    protected int derEncodeValueInit() {
        this.a = null;
        if (this.value == -1) {
            return 0;
        }
        SetContainer setContainer = new SetContainer(0, true, 0);
        EndContainer endContainer = new EndContainer();
        ASN1Container[] aSN1ContainerArray = new ASN1Container[3];
        aSN1ContainerArray[0] = setContainer;
        aSN1ContainerArray[2] = endContainer;
        try {
            if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_SCEP)) {
                String string = Integer.toString(this.value);
                PrintStringContainer printStringContainer = new PrintStringContainer(0, true, 0, string);
                aSN1ContainerArray[1] = printStringContainer;
            } else {
                IntegerContainer integerContainer = new IntegerContainer(0, true, 0, this.value);
                aSN1ContainerArray[1] = integerContainer;
            }
            this.a = new ASN1Template(aSN1ContainerArray);
            return this.a.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int derEncodeValue(byte[] byArray, int n) {
        if (byArray == null) {
            return 0;
        }
        if (this.a == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n2 = 0;
        try {
            int n3 = n2 = this.a.derEncode(byArray, n);
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            int n4 = 0;
            return n4;
        }
        finally {
            this.asn1Template = null;
        }
    }

    protected void copyValues(IntegerPrintableStringAttr integerPrintableStringAttr) {
        integerPrintableStringAttr.value = this.value;
        super.copyValues(integerPrintableStringAttr);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof IntegerPrintableStringAttr)) {
            return false;
        }
        IntegerPrintableStringAttr integerPrintableStringAttr = (IntegerPrintableStringAttr)object;
        return integerPrintableStringAttr.value == this.value;
    }

    protected void reset() {
        super.reset();
        this.value = -1;
        this.a = null;
    }
}

