/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BMPStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IA5StringContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.asn1.TeletexStringContainer;
import com.rsa.asn1.UTF8StringContainer;
import com.rsa.asn1.UniversalStringContainer;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;
import java.io.Serializable;

public class ChallengePassword
extends X501Attribute
implements Cloneable,
Serializable {
    private char[] a;
    private int b;
    ASN1Template c;

    public ChallengePassword() {
        super(1, "ChallengePassword");
    }

    public ChallengePassword(char[] cArray, int n, int n2, int n3) throws AttributeException {
        this();
        this.setChallengePassword(cArray, n, n2, n3);
    }

    protected void decodeValue(byte[] byArray, int n) throws AttributeException {
        if (byArray == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        SetContainer setContainer = new SetContainer(0);
        EndContainer endContainer = new EndContainer();
        ChoiceContainer choiceContainer = new ChoiceContainer(0);
        try {
            PrintStringContainer printStringContainer = new PrintStringContainer(0);
            TeletexStringContainer teletexStringContainer = new TeletexStringContainer(0);
            UniversalStringContainer universalStringContainer = new UniversalStringContainer(0);
            BMPStringContainer bMPStringContainer = new BMPStringContainer(0);
            UTF8StringContainer uTF8StringContainer = new UTF8StringContainer(0);
            IA5StringContainer iA5StringContainer = new IA5StringContainer(0);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, choiceContainer, printStringContainer, teletexStringContainer, universalStringContainer, bMPStringContainer, uTF8StringContainer, iA5StringContainer, endContainer, endContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            if (printStringContainer.dataPresent) {
                this.b = 4864;
                this.a = printStringContainer.getValueAsString().toCharArray();
            } else if (teletexStringContainer.dataPresent) {
                this.b = 5120;
                this.a = teletexStringContainer.getValueAsString().toCharArray();
            } else if (universalStringContainer.dataPresent) {
                this.b = 7168;
                this.a = universalStringContainer.getValueAsString().toCharArray();
            } else if (bMPStringContainer.dataPresent) {
                this.b = 7680;
                this.a = bMPStringContainer.getValueAsString().toCharArray();
            } else if (uTF8StringContainer.dataPresent) {
                this.b = 3072;
                String string = this.utf8Decode(uTF8StringContainer.data, uTF8StringContainer.dataOffset, uTF8StringContainer.dataLen);
                this.a = string.toCharArray();
            } else if (iA5StringContainer.dataPresent) {
                this.b = 5632;
                this.a = iA5StringContainer.getValueAsString().toCharArray();
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new AttributeException("Could not BER decode ChallengePassword.");
        }
    }

    public void setChallengePassword(char[] cArray, int n, int n2, int n3) throws AttributeException {
        if (cArray == null || n2 == 0) {
            throw new AttributeException("Password is null.");
        }
        this.a = new char[n2];
        System.arraycopy(cArray, n, this.a, 0, n2);
        if (n3 != 4864 && n3 != 5120 && n3 != 7168 && n3 != 3072 && n3 != 7680 && n3 != 5632) {
            throw new AttributeException("Invalid String Type.");
        }
        this.b = n3;
    }

    public char[] getChallengePassword() {
        if (this.a == null) {
            return null;
        }
        char[] cArray = new char[this.a.length];
        for (int i = 0; i < this.a.length; ++i) {
            cArray[i] = (char)(this.a[i] & 0xFF);
        }
        return cArray;
    }

    protected int derEncodeValueInit() {
        this.c = null;
        if (this.a == null) {
            return 0;
        }
        if (this.b == 0) {
            this.b = 3072;
        }
        try {
            EndContainer endContainer = new EndContainer();
            SetContainer setContainer = new SetContainer(0, true, 0);
            ChoiceContainer choiceContainer = new ChoiceContainer(0, 0);
            TeletexStringContainer teletexStringContainer = null;
            byte[] byArray = new byte[this.a.length];
            for (int i = 0; i < this.a.length; ++i) {
                byArray[i] = (byte)this.a[i];
            }
            switch (this.b) {
                case 5120: {
                    teletexStringContainer = new TeletexStringContainer(0, true, 0, byArray, 0, byArray.length);
                    break;
                }
                case 4864: {
                    teletexStringContainer = new PrintStringContainer(0, true, 0, byArray, 0, byArray.length);
                    break;
                }
                case 7168: {
                    teletexStringContainer = new UniversalStringContainer(0, true, 0, byArray, 0, byArray.length, 1);
                    break;
                }
                case 5632: {
                    teletexStringContainer = new IA5StringContainer(0, true, 0, byArray, 0, byArray.length);
                    break;
                }
                case 3072: {
                    byte[] byArray2 = this.utf8Encode(new String(byArray));
                    if (byArray2.length < 2) {
                        return 0;
                    }
                    teletexStringContainer = new UTF8StringContainer(0, true, 0, byArray2, 2, byArray2.length - 2);
                    break;
                }
                case 7680: {
                    teletexStringContainer = new BMPStringContainer(0, true, 0, byArray, 0, byArray.length, 1);
                    break;
                }
                default: {
                    return 0;
                }
            }
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, choiceContainer, teletexStringContainer, endContainer, endContainer};
            this.c = new ASN1Template(aSN1ContainerArray);
            return this.c.derEncodeInit();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] byArray, int n) {
        if (byArray == null) {
            return 0;
        }
        if (this.c == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n2 = 0;
        try {
            n2 = this.c.derEncode(byArray, n);
            this.asn1Template = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ChallengePassword challengePassword = new ChallengePassword();
        if (this.a != null) {
            challengePassword.a = (char[])this.a.clone();
        }
        challengePassword.b = this.b;
        super.copyValues(challengePassword);
        return challengePassword;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == null || !(object instanceof ChallengePassword)) {
            return false;
        }
        ChallengePassword challengePassword = (ChallengePassword)object;
        if (this.a != null) {
            if (challengePassword.a == null) return false;
            if (this.a.length != challengePassword.a.length) {
                return false;
            }
            for (int i = 0; i < this.a.length; ++i) {
                if (this.a[i] == challengePassword.a[i]) continue;
                return false;
            }
            return true;
        } else {
            if (challengePassword.a == null) return true;
            return false;
        }
    }

    protected void reset() {
        super.reset();
        this.c = null;
        if (this.a != null) {
            for (int i = 0; i < this.a.length; ++i) {
                this.a[i] = '\u0000';
            }
            this.a = null;
        }
    }

    protected void finalize() {
        this.reset();
    }
}

