/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;
import java.io.Serializable;
import java.util.Vector;

public class X501Attributes
implements Cloneable,
Serializable {
    private Vector a;
    protected int special;
    private ASN1Template b;

    public X501Attributes() {
    }

    public X501Attributes(byte[] byArray, int n, int n2) throws AttributeException {
        if (byArray == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.a(byArray, n, n2);
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws AttributeException {
        if (byArray == null) {
            throw new AttributeException("Encoding is null.");
        }
        try {
            return n + 1 + ASN1Lengths.determineLengthLen((byte[])byArray, (int)(n + 1)) + ASN1Lengths.determineLength((byte[])byArray, (int)(n + 1));
        }
        catch (ASN_Exception aSN_Exception) {
            throw new AttributeException("Could not read the BER encoding.");
        }
    }

    private void a(byte[] byArray, int n, int n2) throws AttributeException {
        if (byArray == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        try {
            OfContainer ofContainer = new OfContainer(n2, 12544, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            int n3 = ofContainer.getContainerCount();
            if (n3 > 0) {
                this.a = new Vector();
            }
            for (int i = 0; i < n3; ++i) {
                ASN1Container aSN1Container = ofContainer.containerAt(i);
                X501Attribute x501Attribute = X501Attribute.getInstance(aSN1Container.data, aSN1Container.dataOffset, 0);
                this.a.addElement(x501Attribute);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new AttributeException("Could not read the BER of the Attributes.");
        }
    }

    public int getDERLen(int n) {
        return this.a(n);
    }

    private int a(int n) {
        this.special = n;
        try {
            OfContainer ofContainer = new OfContainer(n, true, 0, 12544, (ASN1Container)new EncodedContainer(12288));
            int n2 = 0;
            if (this.a != null) {
                n2 = this.a.size();
            }
            if (n2 == 0) {
                return 2;
            }
            for (int i = 0; i < n2; ++i) {
                X501Attribute x501Attribute = (X501Attribute)this.a.elementAt(i);
                int n3 = x501Attribute.getDERLen(0);
                byte[] byArray = new byte[n3];
                n3 = x501Attribute.getDEREncoding(byArray, 0, 0);
                EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, byArray, 0, n3);
                ofContainer.addContainer((ASN1Container)encodedContainer);
            }
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            this.b = new ASN1Template(aSN1ContainerArray);
            return this.b.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            this.b = null;
            return 0;
        }
        catch (AttributeException attributeException) {
            this.b = null;
            return 0;
        }
    }

    public int getDEREncoding(byte[] byArray, int n, int n2) throws AttributeException {
        if (byArray == null) {
            throw new AttributeException("Specified array is null.");
        }
        if ((this.b == null || n2 != this.special) && this.a(n2) == 0) {
            throw new AttributeException("Cannot compute the DER of the Attributes");
        }
        if (this.a == null) {
            byArray[n] = -96;
            byArray[n + 1] = 0;
            return 2;
        }
        try {
            return this.b.derEncode(byArray, n);
        }
        catch (ASN_Exception aSN_Exception) {
            this.b = null;
            return 0;
        }
    }

    public int addAttribute(X501Attribute x501Attribute) {
        if (x501Attribute == null) {
            return -1;
        }
        this.reset();
        if (this.a == null) {
            this.a = new Vector();
            this.a.addElement(x501Attribute);
            return 0;
        }
        X501Attribute x501Attribute2 = this.getAttributeByOID(x501Attribute.getOID());
        if (x501Attribute2 != null) {
            this.a.removeElement(x501Attribute2);
        }
        this.a.addElement(x501Attribute);
        return this.a.indexOf(x501Attribute);
    }

    public int getAttributeCount() {
        if (this.a != null) {
            return this.a.size();
        }
        return 0;
    }

    public X501Attribute getAttributeByIndex(int n) {
        try {
            if (this.a != null) {
                return (X501Attribute)this.a.elementAt(n);
            }
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public X501Attribute getAttributeByType(int n) {
        if (this.a == null) {
            return null;
        }
        int n2 = this.getAttributeCount();
        for (int i = 0; i < n2; ++i) {
            X501Attribute x501Attribute = this.getAttributeByIndex(i);
            if (x501Attribute.getAttributeType() != n) continue;
            return x501Attribute;
        }
        return null;
    }

    public X501Attribute getAttributeByOID(byte[] byArray) {
        if (this.a == null) {
            return null;
        }
        int n = this.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            X501Attribute x501Attribute = this.getAttributeByIndex(i);
            if (!x501Attribute.compareOID(byArray)) continue;
            return x501Attribute;
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        X501Attributes x501Attributes = new X501Attributes();
        if (this.a != null) {
            x501Attributes.a = new Vector();
            int n = this.a.size();
            for (int i = 0; i < n; ++i) {
                X501Attribute x501Attribute = (X501Attribute)this.getAttributeByIndex(i).clone();
                x501Attributes.addAttribute(x501Attribute);
            }
        }
        if (this.b != null) {
            x501Attributes.getDERLen(this.special);
        }
        return x501Attributes;
    }

    public boolean equals(Object object) {
        int n;
        if (object == null || !(object instanceof X501Attributes)) {
            return false;
        }
        X501Attributes x501Attributes = (X501Attributes)object;
        int n2 = this.a.size();
        if (n2 != (n = x501Attributes.a.size())) {
            return false;
        }
        try {
            int n3 = this.getDERLen(0);
            int n4 = x501Attributes.getDERLen(0);
            if (n3 != n4) {
                return false;
            }
            byte[] byArray = new byte[n3];
            byte[] byArray2 = new byte[n4];
            n3 = this.getDEREncoding(byArray, 0, 0);
            if (n3 != (n4 = x501Attributes.getDEREncoding(byArray2, 0, 0))) {
                return false;
            }
            for (int i = 0; i < n3; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                return false;
            }
        }
        catch (AttributeException attributeException) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.getDERLen(0);
        byte[] byArray = new byte[n];
        try {
            n = this.getDEREncoding(byArray, 0, 0);
        }
        catch (AttributeException attributeException) {
            return 0;
        }
        return CertJUtils.bytesToHashCode(byArray, 0, n);
    }

    protected void reset() {
        this.b = null;
    }
}

