/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.AttributeValueAssertion;
import com.rsa.certj.cert.NameException;
import java.io.Serializable;
import java.util.Vector;

public class RDN
implements Cloneable,
Serializable {
    private Vector a = new Vector();
    protected int special;
    protected ASN1Template asn1Template = null;

    public RDN(byte[] byArray, int n, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        this.special = n2;
        try {
            OfContainer ofContainer = new OfContainer(n2, 12544, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            int n3 = ofContainer.getContainerCount();
            for (int i = 0; i < n3; ++i) {
                ASN1Container aSN1Container = ofContainer.containerAt(i);
                SequenceContainer sequenceContainer = new SequenceContainer(0);
                OIDContainer oIDContainer = new OIDContainer(0x1000000);
                EncodedContainer encodedContainer = new EncodedContainer(65280);
                EndContainer endContainer = new EndContainer();
                ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
                ASN1.berDecode((byte[])aSN1Container.data, (int)aSN1Container.dataOffset, (ASN1Container[])aSN1ContainerArray2);
                int n4 = RDN.a(oIDContainer.data, oIDContainer.dataOffset, oIDContainer.dataLen);
                byte[] byArray2 = null;
                if (n4 == -1 && oIDContainer.data != null && oIDContainer.dataLen > 0) {
                    byArray2 = new byte[oIDContainer.dataLen];
                    System.arraycopy(oIDContainer.data, oIDContainer.dataOffset, byArray2, 0, oIDContainer.dataLen);
                }
                AttributeValueAssertion attributeValueAssertion = new AttributeValueAssertion(n4, byArray2, encodedContainer.data, encodedContainer.dataOffset, encodedContainer.dataLen);
                this.addNameAVA(attributeValueAssertion);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Cannot decode the BER of the RDN.");
        }
    }

    public RDN() {
    }

    public Object clone() throws CloneNotSupportedException {
        RDN rDN = new RDN();
        for (int i = 0; i < this.a.size(); ++i) {
            AttributeValueAssertion attributeValueAssertion = (AttributeValueAssertion)this.a.elementAt(i);
            rDN.a.addElement(attributeValueAssertion.clone());
        }
        rDN.special = this.special;
        if (this.asn1Template != null) {
            rDN.a();
        }
        return rDN;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a.size() == 0) {
            return "";
        }
        for (int i = 0; i < this.a.size(); ++i) {
            AttributeValueAssertion attributeValueAssertion = (AttributeValueAssertion)this.a.elementAt(i);
            String string = attributeValueAssertion.toString(bl);
            stringBuffer.append(string);
            if (i >= this.a.size() - 1) continue;
            stringBuffer.append("+");
        }
        return stringBuffer.toString();
    }

    public int getAttributeCount() {
        return this.a.size();
    }

    public AttributeValueAssertion getAttributeByIndex(int n) throws NameException {
        int n2 = this.a.size();
        if (n >= 0 && n2 > n) {
            return (AttributeValueAssertion)this.a.elementAt(n);
        }
        throw new NameException("Invalid Index.");
    }

    public void removeAVA(int n) throws NameException {
        if (n >= this.a.size()) {
            throw new NameException("Invalid Iidex.");
        }
        this.a.removeElementAt(n);
    }

    public void setAVA(AttributeValueAssertion attributeValueAssertion, int n) throws NameException {
        if (attributeValueAssertion == null) {
            throw new NameException("Specified AVA is null.");
        }
        if (n >= this.a.size()) {
            throw new NameException("Invalid index.");
        }
        this.a.setElementAt(attributeValueAssertion, n);
    }

    public AttributeValueAssertion getAttribute(int n) {
        int n2 = this.a.size();
        for (int i = 0; i < n2; ++i) {
            AttributeValueAssertion attributeValueAssertion = (AttributeValueAssertion)this.a.elementAt(i);
            if (attributeValueAssertion.getAttributeType() != n) continue;
            return attributeValueAssertion;
        }
        return null;
    }

    private static int a(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return -1;
        }
        for (int i = 0; i < AttributeValueAssertion.ALL_NAME_ATTRIBUTE_IDS.length; ++i) {
            int n3;
            if (n2 != AttributeValueAssertion.ALL_NAME_ATTRIBUTE_IDS[i].a.length) continue;
            for (n3 = 0; n3 < n2 && (byArray[n3 + n] & 0xFF) == (AttributeValueAssertion.ALL_NAME_ATTRIBUTE_IDS[i].a[n3] & 0xFF); ++n3) {
            }
            if (n3 < n2) continue;
            return i;
        }
        return -1;
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        if (byArray[n] == 0 && byArray[n + 1] == 0) {
            return n + 2;
        }
        try {
            return n + 1 + ASN1Lengths.determineLengthLen((byte[])byArray, (int)(n + 1)) + ASN1Lengths.determineLength((byte[])byArray, (int)(n + 1));
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int n) {
        this.special = n;
        return this.a();
    }

    public int getDEREncoding(byte[] byArray, int n, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            if (this.asn1Template == null || n2 != this.special) {
                this.getDERLen(n2);
                if (this.asn1Template == null) {
                    throw new NameException("Unable to encode RDN.");
                }
            }
            return this.asn1Template.derEncode(byArray, n);
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            throw new NameException("Unable to encode RDN.");
        }
    }

    private int a() {
        try {
            int n = this.a.size();
            OfContainer ofContainer = new OfContainer(this.special, true, 0, 12544, (ASN1Container)new EncodedContainer(12288));
            for (int i = 0; i < n; ++i) {
                AttributeValueAssertion attributeValueAssertion = (AttributeValueAssertion)this.a.elementAt(i);
                int n2 = attributeValueAssertion.getDERLen();
                byte[] byArray = new byte[n2];
                n2 = attributeValueAssertion.getDEREncoding(byArray, 0);
                EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, byArray, 0, n2);
                ofContainer.addContainer((ASN1Container)encodedContainer);
            }
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            this.asn1Template = new ASN1Template(aSN1ContainerArray);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
        catch (NameException nameException) {
            return 0;
        }
    }

    public void addNameAVA(AttributeValueAssertion attributeValueAssertion) {
        if (attributeValueAssertion != null) {
            this.a.addElement(attributeValueAssertion);
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RDN)) {
            return false;
        }
        RDN rDN = (RDN)object;
        if (this.a.size() != rDN.a.size()) {
            return false;
        }
        for (int i = 0; i < this.a.size(); ++i) {
            boolean bl = this.a((AttributeValueAssertion)this.a.elementAt(i), rDN.a);
            if (bl) continue;
            return false;
        }
        return true;
    }

    private boolean a(AttributeValueAssertion attributeValueAssertion, Vector vector) {
        if (attributeValueAssertion == null || vector == null) {
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (!attributeValueAssertion.equals(vector.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.a.size(); ++i) {
            n ^= this.a.elementAt(i).hashCode();
        }
        return n;
    }
}

