/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.certj.cert.AttributeValueAssertion;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.RDN;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.extensions.BuiltInDomainDefinedAttributes;
import com.rsa.certj.cert.extensions.BuiltInStandardAttributes;
import com.rsa.certj.cert.extensions.EDIPartyName;
import com.rsa.certj.cert.extensions.ExtendedNetworkAddress;
import com.rsa.certj.cert.extensions.ExtensionAttribute;
import com.rsa.certj.cert.extensions.ExtensionAttributes;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cert.extensions.ORAddress;
import com.rsa.certj.cert.extensions.ORName;
import com.rsa.certj.cert.extensions.OtherName;
import com.rsa.certj.cert.extensions.PDSParameter;
import com.rsa.certj.cert.extensions.PersonalName;
import com.rsa.certj.cert.extensions.UnformattedPostalAddress;
import java.util.Arrays;
import java.util.Vector;

public final class NameMatcher {
    public static final int CMP_DIFFERENT = 0;
    public static final int CMP_SAME = 1;
    public static final int CMP_SMALLER = 2;
    public static final int CMP_LARGER = 3;

    private NameMatcher() {
    }

    public static boolean isNameIncluded(String string, String string2) {
        return string2.toLowerCase().endsWith(string.toLowerCase());
    }

    public static boolean matchDefinedAttributeLists(BuiltInDomainDefinedAttributes builtInDomainDefinedAttributes, BuiltInDomainDefinedAttributes builtInDomainDefinedAttributes2) {
        if (builtInDomainDefinedAttributes == null || builtInDomainDefinedAttributes2 == null) {
            return false;
        }
        if (builtInDomainDefinedAttributes2.getAttributeCount() == 0) {
            return true;
        }
        if (builtInDomainDefinedAttributes.getAttributeCount() > builtInDomainDefinedAttributes2.getAttributeCount()) {
            return false;
        }
        try {
            for (int i = 0; i < builtInDomainDefinedAttributes.getAttributeCount(); ++i) {
                if (Arrays.equals(builtInDomainDefinedAttributes.getAttribute(i), builtInDomainDefinedAttributes2.getAttribute(i))) continue;
                return false;
            }
        }
        catch (NameException nameException) {
            return false;
        }
        return true;
    }

    public static boolean matchDirectoryNames(X500Name x500Name, X500Name x500Name2) {
        int n;
        if (x500Name == null || x500Name2 == null) {
            return false;
        }
        int n2 = x500Name.getRDNCount();
        if (n2 < (n = x500Name2.getRDNCount())) {
            return false;
        }
        try {
            for (int i = 0; i < n; ++i) {
                if (NameMatcher.matchNameAttributeSets(x500Name.getRDN(i), x500Name2.getRDN(i))) continue;
                return false;
            }
        }
        catch (NameException nameException) {
            return false;
        }
        return true;
    }

    public static boolean matchDnsNames(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (NameMatcher.isNameIncluded(string2, string)) {
            if (string.length() == string2.length()) {
                return true;
            }
            if (string.charAt(string.length() - 1 - string2.length()) == '.') {
                return true;
            }
        }
        return false;
    }

    public static boolean matchEdiPartyNames(EDIPartyName eDIPartyName, EDIPartyName eDIPartyName2) {
        if (eDIPartyName == null || eDIPartyName2 == null) {
            return false;
        }
        return eDIPartyName.equals(eDIPartyName2);
    }

    public static boolean matchExtensionAttributeLists(ExtensionAttributes extensionAttributes, ExtensionAttributes extensionAttributes2) {
        if (extensionAttributes == null || extensionAttributes2 == null) {
            return false;
        }
        int n = extensionAttributes.getAttributeCount();
        int n2 = extensionAttributes2.getAttributeCount();
        if (n2 == 0) {
            return true;
        }
        if (n > n2) {
            return false;
        }
        try {
            for (int i = 0; i < n; ++i) {
                boolean bl = false;
                for (int j = 0; j < n2; ++j) {
                    if (!NameMatcher.matchExtensionAttributes(extensionAttributes.getAttribute(i), extensionAttributes2.getAttribute(j))) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
        }
        catch (NameException nameException) {
            return false;
        }
        return true;
    }

    public static boolean matchExtensionAttributes(ExtensionAttribute extensionAttribute, ExtensionAttribute extensionAttribute2) {
        int n;
        if (extensionAttribute == null || extensionAttribute2 == null) {
            return false;
        }
        int n2 = extensionAttribute.getAttributeType();
        if (n2 != (n = extensionAttribute2.getAttributeType())) {
            return false;
        }
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                String string = (String)extensionAttribute.getAttribute();
                String string2 = (String)extensionAttribute2.getAttribute();
                if (string == null) {
                    return string2 == null;
                }
                return string.equals(string2);
            }
            case 8: 
            case 9: {
                return NameMatcher.matchOrNames((ORName)extensionAttribute.getAttribute(), (ORName)extensionAttribute2.getAttribute());
            }
            case 4: {
                return NameMatcher.matchPersonalNames((PersonalName)extensionAttribute.getAttribute(), (PersonalName)extensionAttribute2.getAttribute());
            }
            case 5: {
                return NameMatcher.matchOrgUnitNameLists((String[])extensionAttribute.getAttribute(), (String[])extensionAttribute2.getAttribute());
            }
            case 6: {
                return NameMatcher.matchDefinedAttributeLists((BuiltInDomainDefinedAttributes)extensionAttribute.getAttribute(), (BuiltInDomainDefinedAttributes)extensionAttribute2.getAttribute());
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                PDSParameter pDSParameter = (PDSParameter)extensionAttribute.getAttribute();
                PDSParameter pDSParameter2 = (PDSParameter)extensionAttribute2.getAttribute();
                if (pDSParameter == null) {
                    return pDSParameter2 == null;
                }
                return pDSParameter.equals(pDSParameter2);
            }
            case 16: {
                UnformattedPostalAddress unformattedPostalAddress = (UnformattedPostalAddress)extensionAttribute.getAttribute();
                UnformattedPostalAddress unformattedPostalAddress2 = (UnformattedPostalAddress)extensionAttribute2.getAttribute();
                if (unformattedPostalAddress == null) {
                    return unformattedPostalAddress2 == null;
                }
                return unformattedPostalAddress.equals(unformattedPostalAddress2);
            }
            case 22: {
                ExtendedNetworkAddress extendedNetworkAddress = (ExtendedNetworkAddress)extensionAttribute.getAttribute();
                ExtendedNetworkAddress extendedNetworkAddress2 = (ExtendedNetworkAddress)extensionAttribute2.getAttribute();
                if (extendedNetworkAddress == null) {
                    return extendedNetworkAddress2 == null;
                }
                return extendedNetworkAddress.equals(extendedNetworkAddress2);
            }
            case 23: {
                return extensionAttribute.getAttribute() == extensionAttribute2.getAttribute();
            }
        }
        return false;
    }

    public static boolean matchGeneralNames(GeneralName generalName, GeneralName generalName2, int n) {
        if (generalName.getGeneralNameType() != n || generalName2.getGeneralNameType() != n) {
            return false;
        }
        switch (n) {
            case 1: {
                return NameMatcher.matchOtherNames((OtherName)generalName.getGeneralName(), (OtherName)generalName2.getGeneralName());
            }
            case 2: {
                return NameMatcher.matchRfc822Names((String)generalName.getGeneralName(), (String)generalName2.getGeneralName());
            }
            case 3: {
                return NameMatcher.matchDnsNames((String)generalName.getGeneralName(), (String)generalName2.getGeneralName());
            }
            case 4: {
                return NameMatcher.matchX400Addresses((ORAddress)generalName.getGeneralName(), (ORAddress)generalName2.getGeneralName());
            }
            case 5: {
                return NameMatcher.matchDirectoryNames((X500Name)generalName.getGeneralName(), (X500Name)generalName2.getGeneralName());
            }
            case 6: {
                return NameMatcher.matchEdiPartyNames((EDIPartyName)generalName.getGeneralName(), (EDIPartyName)generalName2.getGeneralName());
            }
            case 7: {
                return NameMatcher.matchResourceLocators((String)generalName.getGeneralName(), (String)generalName2.getGeneralName());
            }
            case 8: {
                return NameMatcher.matchIpAddresses((byte[])generalName.getGeneralName(), (byte[])generalName2.getGeneralName());
            }
            case 9: {
                return NameMatcher.matchRegisteredIds((String)generalName.getGeneralName(), (String)generalName2.getGeneralName());
            }
        }
        return false;
    }

    public static boolean matchIpAddresses(byte[] byArray, byte[] byArray2) {
        int n;
        int n2;
        int n3;
        if (byArray == null || byArray2 == null) {
            return false;
        }
        int n4 = byArray.length;
        int n5 = byArray2.length;
        byte[] byArray3 = new byte[16];
        byte[] byArray4 = new byte[16];
        switch (n4) {
            case 4: 
            case 16: {
                n3 = n4;
                for (n2 = 0; n2 < n3; ++n2) {
                    byArray3[n2] = 0;
                }
                break;
            }
            case 8: 
            case 32: {
                n3 = n4 / 2;
                for (n2 = 0; n2 < n3; ++n2) {
                    byArray3[n2] = ~byArray[n2 + n3];
                }
                break;
            }
            default: {
                return false;
            }
        }
        switch (n5) {
            case 4: 
            case 16: {
                n = n5;
                for (n2 = 0; n2 < n; ++n2) {
                    byArray4[n2] = -1;
                }
                break;
            }
            case 8: 
            case 32: {
                n = n5 / 2;
                for (n2 = 0; n2 < n; ++n2) {
                    byArray4[n2] = byArray2[n + n2];
                }
                break;
            }
            default: {
                return false;
            }
        }
        if (n3 != n) {
            return false;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if ((byArray4[n2] & byArray[n2]) == byArray2[n2] && (byArray4[n2] & (byArray[n2] | byArray3[n2])) == byArray2[n2]) continue;
            return false;
        }
        return true;
    }

    public static boolean matchNameAttributes(AttributeValueAssertion attributeValueAssertion, AttributeValueAssertion attributeValueAssertion2) {
        String string;
        String string2;
        if (attributeValueAssertion == null || attributeValueAssertion2 == null) {
            return false;
        }
        if (attributeValueAssertion.getAttributeType() != attributeValueAssertion2.getAttributeType()) {
            return false;
        }
        try {
            string2 = attributeValueAssertion.getStringAttribute();
            string = attributeValueAssertion2.getStringAttribute();
        }
        catch (NameException nameException) {
            return false;
        }
        if (attributeValueAssertion.getAttributeType() == 7) {
            return NameMatcher.matchRfc822Names(string2, string);
        }
        if (attributeValueAssertion.getAttributeType() == 19) {
            return string2.equalsIgnoreCase(string);
        }
        switch (attributeValueAssertion.getValueType()) {
            case 4864: {
                return NameMatcher.a(string2, string);
            }
            case 3072: 
            case 5120: 
            case 7168: 
            case 7680: {
                return string2.equals(string);
            }
        }
        return false;
    }

    public static boolean matchNameAttributeSets(RDN rDN, RDN rDN2) {
        int n;
        if (rDN == null || rDN2 == null) {
            return false;
        }
        int n2 = rDN.getAttributeCount();
        if (n2 < (n = rDN2.getAttributeCount())) {
            return false;
        }
        Vector<AttributeValueAssertion> vector = new Vector<AttributeValueAssertion>();
        try {
            block2: for (int i = 0; i < n; ++i) {
                AttributeValueAssertion attributeValueAssertion = rDN2.getAttributeByIndex(i);
                for (int j = 0; j < n2; ++j) {
                    AttributeValueAssertion attributeValueAssertion2 = rDN.getAttributeByIndex(j);
                    if (!NameMatcher.matchNameAttributes(attributeValueAssertion2, attributeValueAssertion)) continue;
                    vector.addElement(attributeValueAssertion);
                    continue block2;
                }
            }
        }
        catch (NameException nameException) {
            return false;
        }
        return n2 == vector.size();
    }

    public static boolean matchOrgUnitNameLists(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null) {
            return false;
        }
        if (stringArray.length > stringArray2.length) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(stringArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean matchOrNames(ORName oRName, ORName oRName2) {
        if (oRName == null || oRName2 == null) {
            return false;
        }
        return oRName.equals(oRName2);
    }

    public static boolean matchOtherNames(OtherName otherName, OtherName otherName2) {
        if (otherName == null || otherName2 == null) {
            return false;
        }
        return otherName.equals(otherName2);
    }

    public static boolean matchPersonalNames(PersonalName personalName, PersonalName personalName2) {
        if (personalName == null || personalName2 == null) {
            return false;
        }
        return personalName.equals(personalName2);
    }

    public static boolean matchRegisteredIds(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    public static boolean matchResourceLocators(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        String string3 = NameMatcher.a(string);
        String string4 = NameMatcher.a(string2);
        if (string3 == null || string4 == null) {
            return false;
        }
        if (NameMatcher.isNameIncluded(string4, string3)) {
            if (string3.length() == string4.length()) {
                return true;
            }
            if (string4.charAt(0) == '.') {
                return true;
            }
        }
        return false;
    }

    public static boolean matchRfc822Names(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (NameMatcher.isNameIncluded(string2, string)) {
            if (string.length() == string2.length()) {
                return true;
            }
            if (string2.charAt(0) == '.') {
                return true;
            }
            if (string.charAt(string.length() - 1 - string2.length()) == '@') {
                return true;
            }
        }
        return false;
    }

    public static boolean matchStandardAttributeLists(BuiltInStandardAttributes builtInStandardAttributes, BuiltInStandardAttributes builtInStandardAttributes2) {
        if (builtInStandardAttributes == null || builtInStandardAttributes2 == null) {
            return false;
        }
        if (!NameMatcher.matchOrNames(builtInStandardAttributes.getCountryName(), builtInStandardAttributes2.getCountryName())) {
            return false;
        }
        if (!NameMatcher.matchOrNames(builtInStandardAttributes.getAdminDomainName(), builtInStandardAttributes2.getAdminDomainName())) {
            return false;
        }
        if (builtInStandardAttributes.getNetworkAddress() != null && !builtInStandardAttributes.getNetworkAddress().equals(builtInStandardAttributes2.getNetworkAddress())) {
            return false;
        }
        if (builtInStandardAttributes.getTerminalIdentifier() != null && !builtInStandardAttributes.getTerminalIdentifier().equals(builtInStandardAttributes2.getTerminalIdentifier())) {
            return false;
        }
        if (!NameMatcher.matchOrNames(builtInStandardAttributes.getPrivateDomainName(), builtInStandardAttributes2.getPrivateDomainName())) {
            return false;
        }
        if (builtInStandardAttributes.getOrganizationName() != null && !builtInStandardAttributes.getOrganizationName().equals(builtInStandardAttributes2.getOrganizationName())) {
            return false;
        }
        if (builtInStandardAttributes.getNumericUserIdentifier() != null && !builtInStandardAttributes.getNumericUserIdentifier().equals(builtInStandardAttributes2.getNumericUserIdentifier())) {
            return false;
        }
        if (!NameMatcher.matchPersonalNames(builtInStandardAttributes.getPersonalName(), builtInStandardAttributes2.getPersonalName())) {
            return false;
        }
        return builtInStandardAttributes.getOrganizationalUnitNames() == null || Arrays.equals(builtInStandardAttributes.getOrganizationalUnitNames(), builtInStandardAttributes2.getOrganizationalUnitNames());
    }

    public static boolean matchUnformattedPostalAddrs(UnformattedPostalAddress unformattedPostalAddress, UnformattedPostalAddress unformattedPostalAddress2) {
        if (unformattedPostalAddress == null || unformattedPostalAddress2 == null) {
            return false;
        }
        String[] stringArray = unformattedPostalAddress.getPrintableAddress();
        String[] stringArray2 = unformattedPostalAddress2.getPrintableAddress();
        if (stringArray == null) {
            if (stringArray2 != null) {
                return false;
            }
        } else {
            if (stringArray.length > stringArray2.length) {
                return false;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals(stringArray2[i])) continue;
                return false;
            }
        }
        String string = unformattedPostalAddress.getTeletexString();
        String string2 = unformattedPostalAddress2.getTeletexString();
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    public static boolean matchX400Addresses(ORAddress oRAddress, ORAddress oRAddress2) {
        if (oRAddress == null || oRAddress2 == null) {
            return false;
        }
        BuiltInDomainDefinedAttributes builtInDomainDefinedAttributes = oRAddress.getBuiltInDomainDefinedAttributes();
        BuiltInDomainDefinedAttributes builtInDomainDefinedAttributes2 = oRAddress2.getBuiltInDomainDefinedAttributes();
        ExtensionAttributes extensionAttributes = oRAddress.getExtensionAttributes();
        ExtensionAttributes extensionAttributes2 = oRAddress2.getExtensionAttributes();
        if (!NameMatcher.matchStandardAttributeLists(oRAddress.getBuiltInStandardAttributes(), oRAddress2.getBuiltInStandardAttributes())) {
            return false;
        }
        if (builtInDomainDefinedAttributes != null || builtInDomainDefinedAttributes2 != null) {
            if (builtInDomainDefinedAttributes == null || builtInDomainDefinedAttributes2 == null) {
                return false;
            }
            if (!NameMatcher.matchDefinedAttributeLists(builtInDomainDefinedAttributes, builtInDomainDefinedAttributes2)) {
                return false;
            }
        }
        if (extensionAttributes != null || extensionAttributes2 != null) {
            if (extensionAttributes == null || extensionAttributes2 == null) {
                return false;
            }
            if (!NameMatcher.matchExtensionAttributeLists(extensionAttributes, extensionAttributes2)) {
                return false;
            }
        }
        return true;
    }

    public static int compareAltNames(GeneralName generalName, GeneralName generalName2) {
        boolean bl;
        boolean bl2;
        switch (generalName.getGeneralNameType()) {
            case 1: {
                OtherName otherName = (OtherName)generalName.getGeneralName();
                OtherName otherName2 = (OtherName)generalName2.getGeneralName();
                bl2 = NameMatcher.matchOtherNames(otherName, otherName2);
                bl = NameMatcher.matchOtherNames(otherName2, otherName);
                break;
            }
            case 2: {
                String string = (String)generalName.getGeneralName();
                String string2 = (String)generalName2.getGeneralName();
                bl2 = NameMatcher.matchRfc822Names(string, string2);
                bl = NameMatcher.matchRfc822Names(string2, string);
                break;
            }
            case 3: {
                String string = (String)generalName.getGeneralName();
                String string3 = (String)generalName2.getGeneralName();
                bl2 = NameMatcher.matchDnsNames(string, string3);
                bl = NameMatcher.matchDnsNames(string3, string);
                break;
            }
            case 4: {
                ORAddress oRAddress = (ORAddress)generalName.getGeneralName();
                ORAddress oRAddress2 = (ORAddress)generalName2.getGeneralName();
                bl2 = NameMatcher.matchX400Addresses(oRAddress, oRAddress2);
                bl = NameMatcher.matchX400Addresses(oRAddress2, oRAddress);
                break;
            }
            case 5: {
                X500Name x500Name = (X500Name)generalName.getGeneralName();
                X500Name x500Name2 = (X500Name)generalName2.getGeneralName();
                bl2 = NameMatcher.matchDirectoryNames(x500Name, x500Name2);
                bl = NameMatcher.matchDirectoryNames(x500Name2, x500Name);
                break;
            }
            case 6: {
                EDIPartyName eDIPartyName = (EDIPartyName)generalName.getGeneralName();
                EDIPartyName eDIPartyName2 = (EDIPartyName)generalName2.getGeneralName();
                bl2 = NameMatcher.matchEdiPartyNames(eDIPartyName, eDIPartyName2);
                bl = NameMatcher.matchEdiPartyNames(eDIPartyName2, eDIPartyName);
                break;
            }
            case 7: {
                String string = (String)generalName.getGeneralName();
                String string4 = (String)generalName2.getGeneralName();
                bl2 = NameMatcher.matchResourceLocators(string, string4);
                bl = NameMatcher.matchResourceLocators(string4, string);
                break;
            }
            case 8: {
                byte[] byArray = (byte[])generalName.getGeneralName();
                byte[] byArray2 = (byte[])generalName2.getGeneralName();
                bl2 = NameMatcher.matchIpAddresses(byArray, byArray2);
                bl = NameMatcher.matchIpAddresses(byArray2, byArray);
                break;
            }
            case 9: {
                String string = (String)generalName.getGeneralName();
                String string5 = (String)generalName2.getGeneralName();
                bl2 = NameMatcher.matchRegisteredIds(string, string5);
                bl = NameMatcher.matchRegisteredIds(string5, string);
                break;
            }
            default: {
                return 0;
            }
        }
        if (bl2 && bl) {
            return 1;
        }
        if (bl2) {
            return 2;
        }
        if (bl) {
            return 3;
        }
        return 0;
    }

    public static String compressWhiteSpaces(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (" \t\n\f\r".indexOf(c) >= 0) {
                if (bl) continue;
                stringBuffer.append(" ");
                bl = true;
                continue;
            }
            stringBuffer.append(c);
            bl = false;
        }
        return stringBuffer.toString().trim();
    }

    private static boolean a(String string, String string2) {
        return NameMatcher.b(string).equals(NameMatcher.b(string2));
    }

    private static String a(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("://");
        n = n < 0 ? 0 : (n += "://".length());
        int n2 = string.indexOf(58, n);
        int n3 = string.indexOf(47, n);
        int n4 = 0;
        n4 = n2 < 0 && n3 < 0 ? string.length() : (n2 < 0 ? n3 : (n3 < 0 ? n2 : Math.min(n2, n3)));
        return string.substring(n, n4);
    }

    private static String b(String string) {
        String string2 = string;
        if (string2.startsWith("\\ ")) {
            string2 = string2.substring(2);
        }
        if (string2.endsWith("\\ ")) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        return NameMatcher.compressWhiteSpaces(string2).toUpperCase();
    }
}

