/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.OIDList;
import com.rsa.certj.CertJ;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_Signature;
import java.io.Serializable;
import java.security.SecureRandom;

public abstract class CRL
implements Cloneable,
Serializable {
    public static final int RSA_WITH_SHA1_PKCS = 0;
    public static final int RSA_WITH_SHA1_ISO_OIW = 1;
    public static final int DSA_WITH_SHA1_X930 = 2;
    public static final int DSA_WITH_SHA1_X957 = 3;
    protected byte[] signatureAlgorithmBER;
    protected int signatureAlgorithmFormat = -1;
    protected byte[] signature;
    protected String theDevice;
    protected String[] theDeviceList;
    private CertJ a = null;

    public final void setCertJ(CertJ certJ) {
        this.a = certJ;
    }

    public final CertJ getCertJ() {
        return this.a;
    }

    public String getSignatureAlgorithm() throws CertificateException {
        if (this.signatureAlgorithmBER == null) {
            throw new CertificateException("Object not set with signature algorithm.");
        }
        return OIDList.getTrans((byte[])this.signatureAlgorithmBER, (int)0, (int)this.signatureAlgorithmBER.length, (int)1);
    }

    public byte[] getSignatureAlgorithmDER() throws CertificateException {
        if (this.signatureAlgorithmBER == null) {
            throw new CertificateException("Object not set with signature algorithm.");
        }
        return (byte[])this.signatureAlgorithmBER.clone();
    }

    public abstract byte[] getSignature() throws CertificateException;

    public String getDevice() throws CertificateException {
        if (this.theDevice == null) {
            throw new CertificateException("Object not set with a device.");
        }
        return this.theDevice;
    }

    public String[] getDeviceList() throws CertificateException {
        if (this.theDeviceList == null) {
            throw new CertificateException("Object not set with a device.");
        }
        String[] stringArray = new String[this.theDeviceList.length];
        for (int i = 0; i < this.theDeviceList.length; ++i) {
            stringArray[i] = this.theDeviceList[i];
        }
        return stringArray;
    }

    public void setSignatureStandard(int n) {
        this.signatureAlgorithmFormat = n;
    }

    public int getSignatureStandard() {
        return this.signatureAlgorithmFormat;
    }

    public String getSignatureFormat() {
        switch (this.signatureAlgorithmFormat) {
            case 0: {
                return "RSAWithSHA1PKCS";
            }
            case 1: {
                return "RSAWithSHA1ISO_OIW";
            }
            case 2: {
                return "DSAWithSHA1X930";
            }
            case 3: {
                return "DSAWithSHA1X957";
            }
        }
        return null;
    }

    public abstract void signCRL(String var1, String var2, JSAFE_PrivateKey var3, SecureRandom var4) throws CertificateException;

    public void signCRL(byte[] byArray, int n, String string, JSAFE_PrivateKey jSAFE_PrivateKey, SecureRandom secureRandom) throws CertificateException {
        if (byArray == null || string == null || jSAFE_PrivateKey == null) {
            throw new CertificateException("Specified values are null.");
        }
        try {
            int n2 = 1 + ASN1Lengths.determineLengthLen((byte[])byArray, (int)(n + 1)) + ASN1Lengths.determineLength((byte[])byArray, (int)(n + 1));
            String string2 = OIDList.getTrans((byte[])byArray, (int)n, (int)n2, (int)1);
            this.signCRL(string2, string, jSAFE_PrivateKey, secureRandom);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Cannot sign cert:" + aSN_Exception.getMessage());
        }
    }

    public abstract boolean verifyCRLSignature(String var1, JSAFE_PublicKey var2, SecureRandom var3) throws CertificateException;

    public boolean verifyCRLSignature(String string, byte[] byArray, int n, SecureRandom secureRandom) throws CertificateException {
        if (string == null || byArray == null) {
            throw new CertificateException("Specified values are null.");
        }
        try {
            JSAFE_PublicKey jSAFE_PublicKey = JSAFE_PublicKey.getInstance((byte[])byArray, (int)n, (String)string);
            return this.verifyCRLSignature(string, jSAFE_PublicKey, secureRandom);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CertificateException("Cannot verify: " + jSAFE_Exception.getMessage());
        }
    }

    public boolean verifyCRLSignature(String string, Certificate certificate, SecureRandom secureRandom) throws CertificateException {
        if (string == null || certificate == null) {
            throw new CertificateException("Specified values are null.");
        }
        JSAFE_PublicKey jSAFE_PublicKey = certificate.getSubjectPublicKey(string);
        return this.verifyCRLSignature(string, jSAFE_PublicKey, secureRandom);
    }

    protected byte[] performSignature(String string, String string2, JSAFE_PrivateKey jSAFE_PrivateKey, SecureRandom secureRandom, byte[] byArray, int n, int n2) throws CertificateException {
        if (string == null || string2 == null || jSAFE_PrivateKey == null || byArray == null) {
            throw new CertificateException("Specified values are null.");
        }
        JSAFE_Signature jSAFE_Signature = null;
        try {
            jSAFE_Signature = JSAFE_Signature.getInstance((String)string, (String)string2);
            if (this.a == null) {
                jSAFE_Signature.signInit(jSAFE_PrivateKey, secureRandom);
            } else {
                jSAFE_Signature.signInit(jSAFE_PrivateKey, null, secureRandom, this.a.getPKCS11Sessions());
            }
            jSAFE_Signature.signUpdate(byArray, n, n2);
            byte[] byArray2 = jSAFE_Signature.signFinal();
            return byArray2;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CertificateException("Could not sign the CRL: " + jSAFE_Exception.getMessage());
        }
        finally {
            if (jSAFE_Signature != null) {
                jSAFE_Signature.clearSensitiveData();
            }
        }
    }

    protected boolean performSignatureVerification(String string, JSAFE_PublicKey jSAFE_PublicKey, SecureRandom secureRandom, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws CertificateException {
        if (string == null || jSAFE_PublicKey == null || byArray == null || byArray2 == null) {
            throw new CertificateException("Specified values are null.");
        }
        JSAFE_Signature jSAFE_Signature = null;
        try {
            jSAFE_Signature = JSAFE_Signature.getInstance((byte[])this.signatureAlgorithmBER, (int)0, (String)string);
            if (this.a == null) {
                jSAFE_Signature.verifyInit(jSAFE_PublicKey, secureRandom);
            } else {
                jSAFE_Signature.verifyInit(jSAFE_PublicKey, null, secureRandom, this.a.getPKCS11Sessions());
            }
            jSAFE_Signature.verifyUpdate(byArray, n, n2);
            boolean bl = jSAFE_Signature.verifyFinal(byArray2, n3, n4);
            return bl;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CertificateException("Could not verify the CRL signature: " + jSAFE_Exception.getMessage());
        }
        finally {
            if (jSAFE_Signature != null) {
                jSAFE_Signature.clearSensitiveData();
            }
        }
    }

    protected void clearSignature() {
        this.signature = null;
        this.theDevice = null;
        this.theDeviceList = null;
    }

    protected void clearComponents() {
        this.clearSignature();
        this.signatureAlgorithmBER = null;
    }
}

