/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BMPStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.GenTimeContainer;
import com.rsa.asn1.IA5StringContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.TeletexStringContainer;
import com.rsa.asn1.UTF8StringContainer;
import com.rsa.asn1.UniversalStringContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.CompatibilityType;
import com.rsa.certj.cert.Cf;
import com.rsa.certj.cert.Cg;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.NameMatcher;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

public class AttributeValueAssertion
implements Cloneable,
Serializable {
    public static final int UNKNOWN_ATTRIBUTE_TYPE = -1;
    public static final int BOUND_UNLIMITED = -1;
    public static final int UNSUPPORTED_ASN1_TYPE = -1;
    public static final int COMMON_NAME = 0;
    public static final byte[] COMMON_NAME_OID = new byte[]{85, 4, 3};
    public static final int UB_COMMON_NAME = 64;
    private static final int a = 500;
    public static final int COUNTRY_NAME = 1;
    public static final byte[] COUNTRY_NAME_OID = new byte[]{85, 4, 6};
    public static final int COUNTRY_NAME_LENGTH = 2;
    public static final int LOCALITY_NAME = 2;
    public static final byte[] LOCALITY_NAME_OID = new byte[]{85, 4, 7};
    public static final int UB_LOCALITY_NAME = 128;
    public static final int STATE_NAME = 3;
    public static final byte[] STATE_NAME_OID = new byte[]{85, 4, 8};
    public static final int UB_STATE_NAME = 128;
    public static final int ORGANIZATION_NAME = 4;
    public static final byte[] ORGANIZATION_NAME_OID = new byte[]{85, 4, 10};
    public static final int UB_ORGANIZATION_NAME = 64;
    public static final int ORGANIZATIONAL_UNIT_NAME = 5;
    public static final byte[] ORGANIZATIONAL_UNIT_NAME_OID = new byte[]{85, 4, 11};
    public static final int UB_ORGANIZATIONAL_UNIT_NAME = 128;
    public static final int TELEPHONE_NUMBER = 6;
    public static final byte[] TELEPHONE_NUMBER_OID = new byte[]{85, 4, 20};
    public static final int UB_TELEPHONE_NUMBER = 32;
    public static final int EMAIL_ADDRESS = 7;
    public static final byte[] EMAIL_ADDRESS_OID = new byte[]{42, -122, 72, -122, -9, 13, 1, 9, 1};
    public static final int UB_EMAIL_ADDRESS = 64;
    public static final int TITLE = 8;
    public static final byte[] TITLE_OID = new byte[]{85, 4, 12};
    public static final int UB_TITLE = 64;
    public static final int STREET_ADDRESS = 9;
    public static final byte[] STREET_ADDRESS_OID = new byte[]{85, 4, 9};
    public static final int UB_STREET_ADDRESS = 128;
    public static final int BUSINESS_CATEGORY = 10;
    public static final byte[] BUSINESS_CATEGORY_OID = new byte[]{85, 4, 15};
    public static final int UB_BUSINESS_CATEGORY = 128;
    public static final int POSTAL_CODE = 11;
    public static final byte[] POSTAL_CODE_OID = new byte[]{85, 4, 17};
    public static final int UB_POSTAL_CODE = 40;
    public static final int SURNAME = 12;
    public static final byte[] SURNAME_OID = new byte[]{85, 4, 4};
    public static final int UB_SURNAME = 32768;
    public static final int GIVEN_NAME = 13;
    public static final byte[] GIVEN_NAME_OID = new byte[]{85, 4, 42};
    public static final int UB_GIVEN_NAME = 32768;
    public static final int SERIAL_NUMBER = 14;
    public static final byte[] SERIAL_NUMBER_OID = new byte[]{85, 4, 5};
    public static final int UB_SERIAL_NUMBER = 64;
    public static final int INITIALS = 15;
    public static final byte[] INITIALS_OID = new byte[]{85, 4, 43};
    public static final int UB_INITIALS = 32768;
    public static final int GENERATION_QUALIFIER = 16;
    public static final byte[] GENERATION_QUALIFIER_OID = new byte[]{85, 4, 44};
    public static final int UB_GENERATION_QUALIFIER = 32768;
    public static final int NAME = 17;
    public static final byte[] NAME_OID = new byte[]{85, 4, 41};
    public static final int UB_NAME = 32768;
    public static final int DN_QUALIFIER = 18;
    public static final byte[] DN_QUALIFIER_OID = new byte[]{85, 4, 46};
    public static final int UB_DN_QUALIFIER = -1;
    public static final int DOMAIN_COMPONENT = 19;
    public static final byte[] DOMAIN_COMPONENT_OID = new byte[]{9, -110, 38, -119, -109, -14, 44, 100, 1, 25};
    public static final int UB_DOMAIN_COMPONENT = 64;
    public static final int POSTAL_ADDRESS = 20;
    public static final byte[] POSTAL_ADDRESS_OID = new byte[]{85, 4, 16};
    public static final int UB_POSTAL_ADDRESS = -1;
    public static final int PSEUDONYM = 21;
    public static final byte[] PSEUDONYM_OID = new byte[]{85, 4, 65};
    public static final int UB_PSEUDONYM = -1;
    public static final int DATE_OF_BIRTH = 22;
    public static final byte[] DATE_OF_BIRTH_OID = new byte[]{43, 6, 1, 5, 5, 7, 9, 1};
    public static final int UB_DATE_OF_BIRTH = -1;
    public static final int PLACE_OF_BIRTH = 23;
    public static final byte[] PLACE_OF_BIRTH_OID = new byte[]{43, 6, 1, 5, 5, 7, 9, 2};
    public static final int UB_PLACE_OF_BIRTH = 32768;
    public static final int GENDER = 24;
    public static final byte[] GENDER_OID = new byte[]{43, 6, 1, 5, 5, 7, 9, 3};
    public static final int UB_GENDER = 1;
    public static final int COUNTRY_OF_CITIZENSHIP = 25;
    public static final byte[] COUNTRY_OF_CITIZENSHIP_OID = new byte[]{43, 6, 1, 5, 5, 7, 9, 4};
    public static final int UB_COUNTRY_OF_CITIZENSHIP = 2;
    public static final int COUNTRY_OF_RESIDENCE = 26;
    public static final byte[] COUNTRY_OF_RESIDENCE_OID = new byte[]{43, 6, 1, 5, 5, 7, 9, 5};
    public static final int UB_COUNTRY_OF_RESIDENCE = 2;
    protected static final Cg[] ALL_NAME_ATTRIBUTE_IDS;
    protected static Cf[] alternativeAttributeNames;
    private int b;
    private byte[] c;
    private byte[] d;
    private int e;
    private int f;
    private int g = -1;
    private String h = null;
    protected ASN1Template asn1Template = null;

    protected AttributeValueAssertion() {
    }

    public AttributeValueAssertion(int n, byte[] byArray, byte[] byArray2, int n2, int n3) throws NameException {
        this.b = n;
        if (n >= ALL_NAME_ATTRIBUTE_IDS.length) {
            this.b = -1;
        }
        if (byArray2 == null || n3 == 0) {
            throw new NameException("BER encoding is null.");
        }
        this.d = byArray2;
        this.e = n2;
        this.f = n3;
        if (this.b == -1) {
            if (byArray == null) {
                throw new NameException("AVA type is missing.");
            }
            this.c = byArray;
            try {
                this.a(this.d, this.e, -1);
            }
            catch (NameException nameException) {
                this.h = null;
            }
            return;
        }
        this.b(byArray2, n2);
    }

    public AttributeValueAssertion(int n, byte[] byArray, int n2, String string) throws NameException {
        this.b = n;
        if (n >= ALL_NAME_ATTRIBUTE_IDS.length) {
            this.b = -1;
        }
        if (n2 == 0) {
            switch (n) {
                case 1: 
                case 6: 
                case 14: 
                case 18: 
                case 24: 
                case 25: 
                case 26: {
                    n2 = 4864;
                    break;
                }
                case 7: 
                case 19: {
                    n2 = 5632;
                    break;
                }
                case 22: {
                    n2 = 6144;
                    break;
                }
                case -1: {
                    throw new NameException("ASN.1 type is missing.");
                }
                default: {
                    n2 = 3072;
                }
            }
        }
        this.g = n2;
        if (this.b == -1) {
            if (byArray == null) {
                throw new NameException("AVA type is missing.");
            }
            this.c = byArray;
        } else {
            this.a(this.b, this.g, string);
        }
        if (!this.a(this.g)) {
            throw new NameException("Unsupported ASN1 type. Use another constructor that takes the DER form.");
        }
        if (string == null) {
            throw new NameException("AVA value is missing.");
        }
        this.h = string;
    }

    public AttributeValueAssertion(byte[] byArray, byte[] byArray2) throws NameException {
        if (byArray == null || byArray2 == null) {
            throw new NameException("AVA data is missing.");
        }
        this.b = AttributeValueAssertion.c(byArray, 0, byArray.length);
        this.c = byArray;
        this.d = byArray2;
        this.e = 0;
        this.f = byArray2.length;
        try {
            this.a(this.d, this.e, -1);
        }
        catch (NameException nameException) {
            this.h = null;
        }
    }

    public int getAttributeType() {
        return this.b;
    }

    public int getValueType() {
        return this.g;
    }

    public void setAttributeValue(String string) {
        if (string != null) {
            this.h = string;
        }
    }

    public void setAttributeValue(byte[] byArray, int n, int n2) throws NameException {
        if (byArray == null || n2 == 0) {
            throw new NameException("BER encoding is null.");
        }
        this.d = byArray;
        this.e = n;
        this.f = n2;
        if (this.b == -1) {
            return;
        }
        this.b(byArray, n);
    }

    private void b(byte[] byArray, int n) throws NameException {
        if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_STRICT_CERT)) {
            this.d(byArray, n);
        } else {
            this.c(byArray, n);
        }
    }

    private void c(byte[] byArray, int n) throws NameException {
        switch (this.b) {
            case 0: {
                this.a(byArray, n, Math.max(64, 500));
                break;
            }
            case 1: {
                this.a(byArray, n, 500);
                this.g = 4864;
                break;
            }
            case 2: {
                this.a(byArray, n, Math.max(128, 500));
                break;
            }
            case 3: {
                this.a(byArray, n, Math.max(128, 500));
                break;
            }
            case 4: {
                this.a(byArray, n, Math.max(64, 500));
                break;
            }
            case 5: {
                this.a(byArray, n, Math.max(128, 500));
                break;
            }
            case 6: {
                this.a(byArray, n, 1, Math.max(32, 500));
                break;
            }
            case 7: {
                this.a(byArray, n, Math.max(64, 500));
                break;
            }
            case 8: {
                this.a(byArray, n, Math.max(64, 500));
                break;
            }
            case 9: {
                this.a(byArray, n, Math.max(128, 500));
                break;
            }
            case 10: {
                this.a(byArray, n, Math.max(128, 500));
                break;
            }
            case 11: {
                this.a(byArray, n, Math.max(40, 500));
                break;
            }
            case 12: {
                this.a(byArray, n, Math.max(32768, 500));
                break;
            }
            case 13: {
                this.a(byArray, n, Math.max(32768, 500));
                break;
            }
            case 14: {
                this.a(byArray, n, 1, Math.max(64, 500));
                break;
            }
            case 15: {
                this.a(byArray, n, Math.max(32768, 500));
                break;
            }
            case 16: {
                this.a(byArray, n, Math.max(32768, 500));
                break;
            }
            case 17: {
                this.a(byArray, n, Math.max(32768, 500));
                break;
            }
            case 18: {
                this.a(byArray, n, 1, -1);
                break;
            }
            case 19: {
                this.b(byArray, n, 1, Math.max(64, 500));
                break;
            }
            case 20: {
                this.b(byArray, n, -1);
                break;
            }
            case 21: {
                this.a(byArray, n, -1);
                break;
            }
            case 22: {
                this.a(byArray, n);
                break;
            }
            case 23: {
                this.a(byArray, n, Math.max(32768, 500));
                break;
            }
            case 24: {
                this.a(byArray, n, 1, Math.max(1, 500));
                break;
            }
            case 25: {
                this.a(byArray, n, Math.max(2, 500));
                this.g = 4864;
                break;
            }
            case 26: {
                this.a(byArray, n, Math.max(2, 500));
                this.g = 4864;
                break;
            }
        }
    }

    private void d(byte[] byArray, int n) throws NameException {
        switch (this.b) {
            case 0: {
                this.a(byArray, n, 64);
                break;
            }
            case 1: {
                this.a(byArray, n, 2, 2);
                break;
            }
            case 2: {
                this.a(byArray, n, 128);
                break;
            }
            case 3: {
                this.a(byArray, n, 128);
                break;
            }
            case 4: {
                this.a(byArray, n, 64);
                break;
            }
            case 5: {
                this.a(byArray, n, 128);
                break;
            }
            case 6: {
                this.a(byArray, n, 1, 32);
                break;
            }
            case 7: {
                this.a(byArray, n, 64);
                break;
            }
            case 8: {
                this.a(byArray, n, 64);
                break;
            }
            case 9: {
                this.a(byArray, n, 128);
                break;
            }
            case 10: {
                this.a(byArray, n, 128);
                break;
            }
            case 11: {
                this.a(byArray, n, 40);
                break;
            }
            case 12: {
                this.a(byArray, n, 32768);
                break;
            }
            case 13: {
                this.a(byArray, n, 32768);
                break;
            }
            case 14: {
                this.a(byArray, n, 1, 64);
                break;
            }
            case 15: {
                this.a(byArray, n, 32768);
                break;
            }
            case 16: {
                this.a(byArray, n, 32768);
                break;
            }
            case 17: {
                this.a(byArray, n, 32768);
                break;
            }
            case 18: {
                this.a(byArray, n, 1, -1);
                break;
            }
            case 19: {
                this.b(byArray, n, 1, 64);
                break;
            }
            case 20: {
                this.b(byArray, n, -1);
                break;
            }
            case 21: {
                this.a(byArray, n, -1);
                break;
            }
            case 22: {
                this.a(byArray, n);
                break;
            }
            case 23: {
                this.a(byArray, n, 32768);
                break;
            }
            case 24: {
                this.a(byArray, n, 1, 1);
                break;
            }
            case 25: {
                this.a(byArray, n, 2, 2);
                break;
            }
            case 26: {
                this.a(byArray, n, 2, 2);
                break;
            }
        }
    }

    public String getStringAttribute() throws NameException {
        return this.getStringAttribute(true);
    }

    public String getStringAttribute(boolean bl) throws NameException {
        boolean bl2;
        String string;
        if (this.h == null) {
            if (this.d == null) {
                throw new NameException("Cannot form the attribute's value as a String.");
            }
            return this.b();
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(this.h, ",+\"\\<>;", true);
        block5: while (stringTokenizer.hasMoreElements()) {
            string = stringTokenizer.nextToken();
            if (string.length() == 1) {
                char c = string.charAt(0);
                switch (c) {
                    case '\"': 
                    case '+': 
                    case ',': 
                    case ';': 
                    case '<': 
                    case '>': 
                    case '\\': {
                        stringBuffer.append('\\');
                        stringBuffer.append(c);
                        continue block5;
                    }
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(string);
        }
        string = stringBuffer.toString();
        stringBuffer = new StringBuffer();
        stringTokenizer = new StringTokenizer(string, "#", true);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("#")) {
                if (stringBuffer.length() == 0) {
                    stringBuffer.append("\\#");
                    continue;
                }
                stringBuffer.append("\\23");
                continue;
            }
            stringBuffer.append(string2);
        }
        String string3 = stringBuffer.toString();
        boolean bl3 = bl2 = string3.length() == 1;
        if (string3.startsWith(" ")) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("\\");
            stringBuffer.append(string3);
            string3 = stringBuffer.toString();
        }
        if (string3.endsWith(" ") && !bl2) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(string3);
            stringBuffer.insert(string3.length() - 1, "\\");
            string3 = stringBuffer.toString();
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        if (bl) {
            return string3;
        }
        for (int i = 0; i < string3.length(); ++i) {
            char c = string3.charAt(i);
            char c2 = c;
            if (c2 > '\u0080' || c2 < ' ') {
                String string4 = string3.substring(i, i + 1);
                byte[] byArray = null;
                try {
                    byArray = string4.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new NameException(unsupportedEncodingException.getMessage());
                }
                for (int j = 0; j < byArray.length; ++j) {
                    stringBuffer2.append('\\');
                    String string5 = Integer.toHexString(byArray[j] & 0xFF).toUpperCase();
                    if (string5.length() == 1) {
                        stringBuffer2.append('0');
                    }
                    stringBuffer2.append(string5);
                }
                continue;
            }
            stringBuffer2.append(c);
        }
        return stringBuffer2.toString();
    }

    public String getStringAttributeNoEscapeSequences() throws NameException {
        if (this.h == null && this.d == null) {
            throw new NameException("Cannot form the attribute's value as a String.");
        }
        if (this.h == null) {
            return this.b();
        }
        return this.h;
    }

    protected Object clone() throws CloneNotSupportedException {
        AttributeValueAssertion attributeValueAssertion = new AttributeValueAssertion();
        attributeValueAssertion.b = this.b;
        if (this.c == null) {
            attributeValueAssertion.c = null;
        } else {
            attributeValueAssertion.c = new byte[this.c.length];
            System.arraycopy(this.c, 0, attributeValueAssertion.c, 0, this.c.length);
        }
        if (this.d == null) {
            attributeValueAssertion.d = null;
        } else {
            attributeValueAssertion.d = new byte[this.d.length];
            System.arraycopy(this.d, 0, attributeValueAssertion.d, 0, this.d.length);
        }
        attributeValueAssertion.e = this.e;
        attributeValueAssertion.f = this.f;
        attributeValueAssertion.g = this.g;
        attributeValueAssertion.h = this.h;
        return attributeValueAssertion;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AttributeValueAssertion)) {
            return false;
        }
        AttributeValueAssertion attributeValueAssertion = (AttributeValueAssertion)object;
        if (!this.a(attributeValueAssertion)) {
            return false;
        }
        return this.valueEquals(attributeValueAssertion);
    }

    public int hashCode() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.c != null) {
            stringBuffer.append(new String(this.c));
        }
        if (this.h != null) {
            stringBuffer.append(NameMatcher.compressWhiteSpaces(this.h));
        } else if (this.d != null) {
            stringBuffer.append(new String(this.d));
        }
        return stringBuffer.toString().hashCode();
    }

    private boolean a(AttributeValueAssertion attributeValueAssertion) {
        if (this.c == null) {
            if (attributeValueAssertion.c == null) {
                return this.b == attributeValueAssertion.b;
            }
            byte[] byArray = AttributeValueAssertion.ALL_NAME_ATTRIBUTE_IDS[this.b].a;
            return CertJUtils.byteArraysEqual(byArray, attributeValueAssertion.c);
        }
        if (attributeValueAssertion.c == null) {
            byte[] byArray = AttributeValueAssertion.ALL_NAME_ATTRIBUTE_IDS[attributeValueAssertion.b].a;
            return CertJUtils.byteArraysEqual(this.c, byArray);
        }
        return CertJUtils.byteArraysEqual(this.c, attributeValueAssertion.c);
    }

    public boolean valueEquals(AttributeValueAssertion attributeValueAssertion) {
        if (this.h != null) {
            if (attributeValueAssertion.h == null) {
                return false;
            }
            if (this.g == 4864) {
                String string = NameMatcher.compressWhiteSpaces(this.h);
                String string2 = NameMatcher.compressWhiteSpaces(attributeValueAssertion.h);
                return string.equalsIgnoreCase(string2);
            }
            return this.h.equals(attributeValueAssertion.h);
        }
        if (attributeValueAssertion.h != null) {
            return false;
        }
        if (this.d != null) {
            if (attributeValueAssertion.d == null) {
                return false;
            }
            return CertJUtils.byteArraysEqual(this.d, this.e, this.f, attributeValueAssertion.d, attributeValueAssertion.e, attributeValueAssertion.f);
        }
        return false;
    }

    private static int c(byte[] byArray, int n, int n2) {
        if (byArray == null || n2 == 0) {
            return -1;
        }
        for (int i = 0; i < ALL_NAME_ATTRIBUTE_IDS.length; ++i) {
            int n3;
            if (n2 != AttributeValueAssertion.ALL_NAME_ATTRIBUTE_IDS[i].a.length) continue;
            for (n3 = 0; n3 < n2 && (byArray[n3 + n] & 0xFF) == (AttributeValueAssertion.ALL_NAME_ATTRIBUTE_IDS[i].a[n3] & 0xFF); ++n3) {
            }
            if (n3 < n2) continue;
            return i;
        }
        return -1;
    }

    protected static int findAttributeType(String string) {
        int n;
        if (string == null) {
            return -1;
        }
        for (n = 0; n < ALL_NAME_ATTRIBUTE_IDS.length; ++n) {
            if (!string.equalsIgnoreCase(AttributeValueAssertion.ALL_NAME_ATTRIBUTE_IDS[n].b)) continue;
            return n;
        }
        for (n = 0; n < alternativeAttributeNames.length; ++n) {
            if (!string.equalsIgnoreCase(AttributeValueAssertion.alternativeAttributeNames[n].b)) continue;
            return AttributeValueAssertion.alternativeAttributeNames[n].a;
        }
        return -1;
    }

    protected static byte[] getAttributeOID(int n) {
        if (n < 0 || n >= ALL_NAME_ATTRIBUTE_IDS.length) {
            return null;
        }
        return AttributeValueAssertion.ALL_NAME_ATTRIBUTE_IDS[n].a;
    }

    private void a(int n, int n2, String string) throws NameException {
        if (string == null) {
            throw new NameException("AVA value is null.");
        }
        if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_STRICT_CERT)) {
            this.b(n, n2, string);
        } else {
            this.c(n, n2, string);
        }
    }

    private void b(int n, int n2, String string) throws NameException {
        switch (n) {
            case 0: {
                this.a(n2, string, 64);
                break;
            }
            case 1: {
                this.a(n2, string, 2, 2);
                break;
            }
            case 2: {
                this.a(n2, string, 128);
                break;
            }
            case 3: {
                this.a(n2, string, 128);
                break;
            }
            case 4: {
                this.a(n2, string, 64);
                break;
            }
            case 5: {
                this.a(n2, string, 128);
                break;
            }
            case 6: {
                this.a(n2, string, 1, 32);
                break;
            }
            case 7: {
                this.b(n2, string, 1, 64);
                break;
            }
            case 8: {
                this.a(n2, string, 64);
                break;
            }
            case 9: {
                this.a(n2, string, 128);
                break;
            }
            case 10: {
                this.a(n2, string, 128);
                break;
            }
            case 11: {
                this.a(n2, string, 40);
                break;
            }
            case 12: {
                this.a(n2, string, 32768);
                break;
            }
            case 13: {
                this.a(n2, string, 32768);
                break;
            }
            case 14: {
                this.a(n2, string, 1, 64);
                break;
            }
            case 15: {
                this.a(n2, string, 32768);
                break;
            }
            case 16: {
                this.a(n2, string, 32768);
                break;
            }
            case 17: {
                this.a(n2, string, 32768);
                break;
            }
            case 18: {
                this.a(n2, string, 1, -1);
                break;
            }
            case 19: {
                this.b(n2, string, 1, 64);
                break;
            }
            case 20: {
                this.a(n2, string, -1);
                break;
            }
            case 21: {
                this.a(n2, string, -1);
                break;
            }
            case 22: {
                this.a(n2, string);
                break;
            }
            case 23: {
                this.a(n2, string, 32768);
                break;
            }
            case 24: {
                this.a(n2, string, 1, 1);
                break;
            }
            case 25: {
                this.a(n2, string, 2, 2);
                break;
            }
            case 26: {
                this.a(n2, string, 2, 2);
                break;
            }
        }
    }

    private void c(int n, int n2, String string) throws NameException {
        switch (n) {
            case 0: {
                this.a(n2, string, Math.max(64, 500));
                break;
            }
            case 1: {
                this.a(n2, string, 500);
                this.g = 4864;
                break;
            }
            case 2: {
                this.a(n2, string, Math.max(128, 500));
                break;
            }
            case 3: {
                this.a(n2, string, Math.max(128, 500));
                break;
            }
            case 4: {
                this.a(n2, string, Math.max(64, 500));
                break;
            }
            case 5: {
                this.a(n2, string, Math.max(128, 500));
                break;
            }
            case 6: {
                this.a(n2, string, 1, Math.max(32, 500));
                break;
            }
            case 7: {
                this.b(n2, string, 1, Math.max(64, 500));
                break;
            }
            case 8: {
                this.a(n2, string, Math.max(64, 500));
                break;
            }
            case 9: {
                this.a(n2, string, Math.max(128, 500));
                break;
            }
            case 10: {
                this.a(n2, string, Math.max(128, 500));
                break;
            }
            case 11: {
                this.a(n2, string, Math.max(40, 500));
                break;
            }
            case 12: {
                this.a(n2, string, Math.max(32768, 500));
                break;
            }
            case 13: {
                this.a(n2, string, Math.max(32768, 500));
                break;
            }
            case 14: {
                this.a(n2, string, 1, Math.max(64, 500));
                break;
            }
            case 15: {
                this.a(n2, string, Math.max(32768, 500));
                break;
            }
            case 16: {
                this.a(n2, string, Math.max(32768, 500));
                break;
            }
            case 17: {
                this.a(n2, string, Math.max(32768, 500));
                break;
            }
            case 18: {
                this.a(n2, string, 1, -1);
                break;
            }
            case 19: {
                this.b(n2, string, 1, Math.max(64, 500));
                break;
            }
            case 20: {
                this.a(n2, string, -1);
                break;
            }
            case 21: {
                this.a(n2, string, -1);
                break;
            }
            case 22: {
                this.a(n2, string);
                break;
            }
            case 23: {
                this.a(n2, string, Math.max(32768, 500));
                break;
            }
            case 24: {
                this.a(n2, string, 1, Math.max(1, 500));
                break;
            }
            case 25: {
                this.a(n2, string, 500);
                this.g = 4864;
                break;
            }
            case 26: {
                this.a(n2, string, 500);
                this.g = 4864;
                break;
            }
        }
    }

    private void a(int n, String string, int n2) throws NameException {
        if (n != 4864 && n != 5120 && n != 7168 && n != 3072 && n != 7680 && n != 5632) {
            throw new NameException("DirectoryString expected.");
        }
        if (string.length() < 1) {
            throw new NameException("DirectoryString too small.");
        }
        if (n2 != -1 && string.length() > n2) {
            throw new NameException("DirectoryString too large.");
        }
    }

    private void a(int n, String string, int n2, int n3) throws NameException {
        if (n != 4864) {
            throw new NameException("PrintableString expected.");
        }
        if (n2 != -1 && string.length() < n2) {
            throw new NameException("PrintableString too small.");
        }
        if (n3 != -1 && string.length() > n3) {
            throw new NameException("PrintableString too large.");
        }
    }

    private void a(int n, String string) throws NameException {
        if (n != 6144) {
            throw new NameException("GenTime is expected expected.");
        }
    }

    private void b(int n, String string, int n2, int n3) throws NameException {
        if (n != 5632) {
            throw new NameException("IA5String expected.");
        }
        if (n2 != -1 && string.length() < n2) {
            throw new NameException("IA5String too small.");
        }
        if (n3 != -1 && string.length() > n3) {
            throw new NameException("IA5String too large.");
        }
    }

    private boolean a(int n) {
        if (n == 4864) {
            return true;
        }
        if (n == 5120) {
            return true;
        }
        if (n == 7168) {
            return true;
        }
        if (n == 5632) {
            return true;
        }
        if (n == 7680) {
            return true;
        }
        if (n == 3072) {
            return true;
        }
        return n == 6144;
    }

    void a(byte[] byArray, int n, int n2) throws NameException {
        IA5StringContainer iA5StringContainer;
        UTF8StringContainer uTF8StringContainer;
        BMPStringContainer bMPStringContainer;
        UniversalStringContainer universalStringContainer;
        TeletexStringContainer teletexStringContainer;
        PrintStringContainer printStringContainer;
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            ChoiceContainer choiceContainer = new ChoiceContainer(0);
            printStringContainer = new PrintStringContainer(0, 1, n2);
            teletexStringContainer = new TeletexStringContainer(0, 1, n2);
            universalStringContainer = new UniversalStringContainer(0, 1, n2);
            bMPStringContainer = new BMPStringContainer(0, 1, n2);
            uTF8StringContainer = new UTF8StringContainer(0);
            iA5StringContainer = new IA5StringContainer(0, 1, n2);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{choiceContainer, printStringContainer, teletexStringContainer, universalStringContainer, uTF8StringContainer, bMPStringContainer, iA5StringContainer, endContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("DirectoryString expected.");
        }
        if (printStringContainer.dataPresent) {
            this.g = 4864;
            this.h = printStringContainer.getValueAsString();
        } else if (teletexStringContainer.dataPresent) {
            this.g = 5120;
            this.h = teletexStringContainer.getValueAsString();
        } else if (universalStringContainer.dataPresent) {
            this.g = 7168;
            this.h = universalStringContainer.getValueAsString();
        } else if (bMPStringContainer.dataPresent) {
            this.g = 7680;
            this.h = bMPStringContainer.getValueAsString();
        } else if (uTF8StringContainer.dataPresent) {
            this.g = 3072;
            this.h = this.d(uTF8StringContainer.data, uTF8StringContainer.dataOffset, uTF8StringContainer.dataLen);
            this.a(this.b, this.g, this.h);
        } else if (iA5StringContainer.dataPresent) {
            this.g = 5632;
            this.h = iA5StringContainer.getValueAsString();
        } else {
            throw new NameException("DirectoryString expected.");
        }
    }

    void b(byte[] byArray, int n, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            OfContainer ofContainer = new OfContainer(0, 12288, (ASN1Container)new EncodedContainer(65280));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            EncodedContainer encodedContainer = null;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < ofContainer.getContainerCount(); ++i) {
                encodedContainer = (EncodedContainer)ofContainer.containerAt(i);
                this.a(encodedContainer.data, encodedContainer.dataOffset, n2);
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.h);
            }
            this.h = stringBuffer.toString();
            this.g = 3072;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Invalid encoding. " + aSN_Exception.getMessage());
        }
    }

    void a(byte[] byArray, int n, int n2, int n3) throws NameException {
        PrintStringContainer printStringContainer;
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            printStringContainer = new PrintStringContainer(0, n2, n3);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{printStringContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("PrintableString expected.");
        }
        this.g = 4864;
        this.h = printStringContainer.getValueAsString();
    }

    void a(byte[] byArray, int n) throws NameException {
        Object object;
        GenTimeContainer genTimeContainer;
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            genTimeContainer = new GenTimeContainer(0);
            object = new ASN1Container[]{genTimeContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])object);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("GenTime expected." + aSN_Exception.getMessage());
        }
        this.g = 6144;
        object = new SimpleDateFormat("EEE, MMM d, yyyy hh:mm:ss z");
        this.h = ((DateFormat)object).format(genTimeContainer.theTime);
    }

    void b(byte[] byArray, int n, int n2, int n3) throws NameException {
        IA5StringContainer iA5StringContainer;
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            iA5StringContainer = new IA5StringContainer(0, n2, n3);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{iA5StringContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("IA5String expected.");
        }
        this.g = 5632;
        this.h = iA5StringContainer.getValueAsString();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (this.h != null) {
                string = this.getStringAttribute(bl);
            }
        }
        catch (NameException nameException) {
            // empty catch block
        }
        if (this.b == -1) {
            stringBuffer.append(this.a());
            stringBuffer.append("=");
            if (string != null) {
                stringBuffer.append(string);
            } else if (this.d != null) {
                stringBuffer.append(this.b());
            }
        } else {
            if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_EMAIL_AVA_EA) && this.b == 7) {
                stringBuffer.append("Ea");
            } else {
                stringBuffer.append(AttributeValueAssertion.ALL_NAME_ATTRIBUTE_IDS[this.b].b);
            }
            stringBuffer.append("=");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String a() {
        if (this.c == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        stringBuffer = stringBuffer.append((this.c[n] & 0xFF) / 40);
        stringBuffer = stringBuffer.append('.');
        stringBuffer = stringBuffer.append((this.c[n] & 0xFF) % 40);
        ++n;
        while (n < this.c.length) {
            stringBuffer = stringBuffer.append('.');
            do {
                n2 = (n2 << 7) + (this.c[n] & 0x7F & 0xFF);
            } while ((this.c[n++] & 0x80) != 0 && n < this.c.length);
            stringBuffer = stringBuffer.append(n2);
            n2 = 0;
        }
        return stringBuffer.toString();
    }

    private String b() {
        if (this.d == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = stringBuffer.append("#");
        for (int i = this.e; i < this.f + this.e; ++i) {
            int n = this.d[i] & 0xFF;
            String string = Integer.toHexString(n);
            if (string.length() == 1) {
                stringBuffer = stringBuffer.append("0");
            }
            stringBuffer = stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private ASN1Container c() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, MMM d, yyyy hh:mm:ss z");
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = simpleDateFormat.parse(this.h, parsePosition);
        return new GenTimeContainer(0, true, 0, date);
    }

    private ASN1Container a(int n, int n2) throws NameException {
        try {
            ASN1Container aSN1Container = this.b(n, n2);
            SequenceContainer sequenceContainer = new SequenceContainer(0);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, aSN1Container, endContainer};
            this.asn1Template = new ASN1Template(aSN1ContainerArray);
            int n3 = this.asn1Template.derEncodeInit();
            byte[] byArray = new byte[n3];
            n3 = this.asn1Template.derEncode(byArray, 0);
            return new EncodedContainer(12288, true, 0, byArray, 0, n3);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Invalid String." + aSN_Exception.getMessage());
        }
    }

    private ASN1Container b(int n, int n2) throws NameException {
        try {
            switch (this.g) {
                case 4864: {
                    boolean bl = CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_STRICT_CERT);
                    int n3 = bl ? 0 : 0x8000000;
                    return new PrintStringContainer(n3, true, 0, this.h, n, n2);
                }
                case 5120: {
                    return new TeletexStringContainer(0, true, 0, this.h, n, n2);
                }
                case 7168: {
                    return new UniversalStringContainer(0, true, 0, this.h, n, n2);
                }
                case 5632: {
                    return new IA5StringContainer(0, true, 0, this.h, n, n2);
                }
                case 3072: {
                    byte[] byArray = this.a(this.h);
                    if (byArray.length < 2) {
                        throw new NameException("AttributeValueAssertion.createStringContainer: DataOutputStream.writeUTF() did not contain necessary 2 bytes specifying the encoding length.");
                    }
                    return new UTF8StringContainer(0, true, 0, byArray, 2, byArray.length - 2);
                }
                case 7680: {
                    return new BMPStringContainer(0, true, 0, this.h, n, n2);
                }
            }
            return null;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Invalid String." + aSN_Exception.getMessage());
        }
    }

    private byte[] a(String string) throws NameException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(string);
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new NameException("AttributeValueAssertion.utf8Encode: unable to utf8-encode " + string + "(" + iOException.getMessage() + ").");
        }
        return byteArrayOutputStream.toByteArray();
    }

    private String d(byte[] byArray, int n, int n2) throws NameException {
        byte[] byArray2 = new byte[n2 + 2];
        byArray2[0] = (byte)(n2 >> 8 & 0xFF);
        byArray2[1] = (byte)(n2 & 0xFF);
        System.arraycopy(byArray, n, byArray2, 2, n2);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2, 0, byArray2.length);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            return dataInputStream.readUTF();
        }
        catch (IOException iOException) {
            throw new NameException("AttributeValueAssertion.utf8Decode: " + iOException.getMessage() + ").");
        }
    }

    public int getDERLen() {
        try {
            Object object;
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            OIDContainer oIDContainer = null;
            if (this.b != -1) {
                object = AttributeValueAssertion.ALL_NAME_ATTRIBUTE_IDS[this.b].a;
                oIDContainer = new OIDContainer(0x1000000, true, 0, (byte[])object, 0, ((byte[])object).length);
            } else {
                oIDContainer = new OIDContainer(0x1000000, true, 0, this.c, 0, this.c.length);
            }
            object = null;
            object = this.g == -1 ? (Object)new EncodedContainer(65280, true, 0, this.d, this.e, this.f) : (this.g == 20 ? (Object)this.a(this.b(this.b), this.c(this.b)) : (this.g == 22 ? (Object)this.c() : (Object)this.b(this.b(this.b), this.c(this.b))));
            EndContainer endContainer = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, (ASN1Container)object, endContainer};
            this.asn1Template = new ASN1Template(aSN1ContainerArray);
            return this.asn1Template.derEncodeInit();
        }
        catch (NameException nameException) {
            return 0;
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    private int b(int n) {
        boolean bl = CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_STRICT_CERT);
        switch (n) {
            case 1: 
            case 25: 
            case 26: {
                return bl ? 2 : 1;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                return 1;
            }
        }
        return -1;
    }

    private int c(int n) {
        boolean bl = CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_STRICT_CERT);
        switch (n) {
            case 0: {
                return bl ? 64 : Math.max(64, 500);
            }
            case 1: {
                return bl ? 2 : Math.max(2, 500);
            }
            case 2: {
                return bl ? 128 : Math.max(128, 500);
            }
            case 3: {
                return bl ? 128 : Math.max(128, 500);
            }
            case 4: {
                return bl ? 64 : Math.max(64, 500);
            }
            case 5: {
                return bl ? 128 : Math.max(128, 500);
            }
            case 6: {
                return bl ? 32 : Math.max(32, 500);
            }
            case 7: {
                return bl ? 64 : Math.max(64, 500);
            }
            case 8: {
                return bl ? 64 : Math.max(64, 500);
            }
            case 9: {
                return bl ? 128 : Math.max(128, 500);
            }
            case 10: {
                return bl ? 128 : Math.max(128, 500);
            }
            case 11: {
                return bl ? 40 : Math.max(40, 500);
            }
            case 12: {
                return bl ? 32768 : Math.max(32768, 500);
            }
            case 13: {
                return bl ? 32768 : Math.max(32768, 500);
            }
            case 14: {
                return bl ? 64 : Math.max(64, 500);
            }
            case 15: {
                return bl ? 32768 : Math.max(32768, 500);
            }
            case 16: {
                return bl ? 32768 : Math.max(32768, 500);
            }
            case 17: {
                return bl ? 32768 : Math.max(32768, 500);
            }
            case 18: {
                return -1;
            }
            case 19: {
                return bl ? 64 : Math.max(64, 500);
            }
            case 20: {
                return -1;
            }
            case 21: {
                return -1;
            }
            case 22: {
                return -1;
            }
            case 23: {
                return bl ? 32768 : Math.max(32768, 500);
            }
            case 24: {
                return bl ? 1 : Math.max(1, 500);
            }
            case 25: {
                return bl ? 2 : Math.max(2, 500);
            }
            case 26: {
                return bl ? 2 : Math.max(2, 500);
            }
        }
        return -1;
    }

    public int getDEREncoding(byte[] byArray, int n) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int n2;
            if (this.asn1Template == null && (n2 = this.getDERLen()) == 0) {
                throw new NameException("Could not encode AVA. ");
            }
            n2 = this.asn1Template.derEncode(byArray, n);
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            throw new NameException("Could not encode: " + aSN_Exception.getMessage());
        }
    }

    static {
        Cg[] cgArray = new Cg[27];
        cgArray[0] = new Cg(COMMON_NAME_OID, "CN");
        cgArray[1] = new Cg(COUNTRY_NAME_OID, "C");
        cgArray[2] = new Cg(LOCALITY_NAME_OID, "L");
        cgArray[3] = new Cg(STATE_NAME_OID, "ST");
        cgArray[4] = new Cg(ORGANIZATION_NAME_OID, "O");
        cgArray[5] = new Cg(ORGANIZATIONAL_UNIT_NAME_OID, "OU");
        cgArray[6] = new Cg(TELEPHONE_NUMBER_OID, "TEL");
        cgArray[7] = new Cg(EMAIL_ADDRESS_OID, "E");
        cgArray[8] = new Cg(TITLE_OID, "TITLE");
        cgArray[9] = new Cg(STREET_ADDRESS_OID, "STREET");
        cgArray[10] = new Cg(BUSINESS_CATEGORY_OID, "BC");
        cgArray[11] = new Cg(POSTAL_CODE_OID, "postalCode");
        cgArray[12] = new Cg(SURNAME_OID, "SN");
        cgArray[13] = new Cg(GIVEN_NAME_OID, "givenName");
        cgArray[14] = new Cg(SERIAL_NUMBER_OID, "serialNumber");
        cgArray[15] = new Cg(INITIALS_OID, "initials");
        cgArray[16] = new Cg(GENERATION_QUALIFIER_OID, "generationQualifier");
        cgArray[17] = new Cg(NAME_OID, "name");
        cgArray[18] = new Cg(DN_QUALIFIER_OID, "dnQualifier");
        cgArray[19] = new Cg(DOMAIN_COMPONENT_OID, "dc");
        cgArray[20] = new Cg(POSTAL_ADDRESS_OID, "postalAddress");
        cgArray[21] = new Cg(PSEUDONYM_OID, "pseudonym");
        cgArray[22] = new Cg(DATE_OF_BIRTH_OID, "dateOfBirth");
        cgArray[23] = new Cg(PLACE_OF_BIRTH_OID, "placeOfBirth");
        cgArray[24] = new Cg(GENDER_OID, "gender");
        cgArray[25] = new Cg(COUNTRY_OF_CITIZENSHIP_OID, "citizenship");
        cgArray[26] = new Cg(COUNTRY_OF_RESIDENCE_OID, "residence");
        ALL_NAME_ATTRIBUTE_IDS = cgArray;
        Cf[] cfArray = new Cf[3];
        cfArray[0] = new Cf(7, "email");
        cfArray[1] = new Cf(7, "EmailAddress");
        cfArray[2] = new Cf(7, "Ea");
        alternativeAttributeNames = cfArray;
    }
}

