/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj;

import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.IssuerAltName;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.util.Vector;

public final class CertJUtils {
    private CertJUtils() {
    }

    public static void mergeLists(Vector vector, Vector vector2) {
        if (vector == null || vector2 == null) {
            return;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            Object e = vector2.elementAt(i);
            if (vector.contains(e)) continue;
            vector.addElement(e);
        }
    }

    public static void subtractLists(Vector vector, Vector vector2) {
        if (vector == null || vector2 == null) {
            return;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            Object e = vector2.elementAt(i);
            if (!vector.contains(e)) continue;
            vector.removeElement(e);
        }
    }

    public static void intersectLists(Vector vector, Vector vector2) {
        if (vector == null || vector2 == null) {
            return;
        }
        int n = vector.size();
        while (n > 0) {
            if (vector2.contains(vector.elementAt(--n))) continue;
            vector.removeElementAt(n);
        }
    }

    public static void uniteLists(Vector vector, Vector vector2) {
        if (vector == null || vector2 == null) {
            return;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            Object e = vector2.elementAt(i);
            if (vector.contains(e)) continue;
            vector.addElement(e);
        }
    }

    public static boolean byteArraysEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == null) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean byteArraysEqual(byte[] byArray, int n, int n2, byte[] byArray2) {
        return CertJUtils.byteArraysEqual(byArray, n, n2, byArray2, 0, byArray2.length);
    }

    public static boolean byteArraysEqual(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (byArray == null && byArray2 == null) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (n2 != n4) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (byArray[n + i] == byArray2[n3 + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean containsByteArray(Vector vector, byte[] byArray) {
        for (int i = 0; i < vector.size(); ++i) {
            if (!CertJUtils.byteArraysEqual((byte[])vector.elementAt(i), byArray)) continue;
            return true;
        }
        return false;
    }

    public static void intersectByteArrayLists(Vector vector, Vector vector2) {
        if (vector == null || vector2 == null) {
            return;
        }
        int n = vector.size();
        while (n > 0) {
            if (CertJUtils.containsByteArray(vector2, (byte[])vector.elementAt(--n))) continue;
            vector.removeElementAt(n);
        }
    }

    public static void uniteByteArrayLists(Vector vector, Vector vector2) {
        if (vector == null || vector2 == null) {
            return;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            byte[] byArray = (byte[])vector2.elementAt(i);
            if (CertJUtils.containsByteArray(vector, byArray)) continue;
            vector.addElement(byArray);
        }
    }

    public static boolean sequencesEqual(Vector vector, Vector vector2) {
        int n;
        int n2 = vector.size();
        if (n2 != (n = vector2.size())) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (vector.elementAt(i).equals(vector2.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean setsEqual(Vector vector, Vector vector2) {
        int n;
        int n2 = vector.size();
        if (n2 != (n = vector2.size())) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (vector.contains(vector2.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsExtension(X509V3Extension x509V3Extension, X509V3Extensions x509V3Extensions) {
        int n = x509V3Extension.getExtensionType();
        X509V3Extension x509V3Extension2 = null;
        try {
            x509V3Extension2 = x509V3Extensions.getExtensionByType(n);
        }
        catch (CertificateException certificateException) {
            return false;
        }
        if (x509V3Extension2 == null) {
            return false;
        }
        switch (n) {
            case 18: {
                GeneralNames generalNames = ((IssuerAltName)x509V3Extension).getGeneralNames();
                GeneralNames generalNames2 = ((IssuerAltName)x509V3Extension2).getGeneralNames();
                try {
                    for (int i = 0; i < generalNames.getNameCount(); ++i) {
                        if (!generalNames2.contains(generalNames.getGeneralName(i))) continue;
                        return true;
                    }
                }
                catch (NameException nameException) {
                    return false;
                }
                return false;
            }
        }
        byte[] byArray = new byte[x509V3Extension.getDERLen(0)];
        byte[] byArray2 = new byte[x509V3Extension2.getDERLen(0)];
        if (byArray.length != byArray2.length) {
            return false;
        }
        x509V3Extension.getDEREncoding(byArray, 0, 0);
        x509V3Extension2.getDEREncoding(byArray2, 0, 0);
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean compareExtensions(X509V3Extensions x509V3Extensions, X509V3Extensions x509V3Extensions2) {
        if (x509V3Extensions == null) {
            return true;
        }
        if (x509V3Extensions2 == null) {
            return false;
        }
        try {
            for (int i = 0; i < x509V3Extensions.getExtensionCount(); ++i) {
                if (CertJUtils.containsExtension(x509V3Extensions.getExtensionByIndex(i), x509V3Extensions2)) continue;
                return false;
            }
            return true;
        }
        catch (CertificateException certificateException) {
            return false;
        }
    }

    public static int bytesToHashCode(byte[] byArray) {
        return CertJUtils.bytesToHashCode(byArray, 0, byArray.length);
    }

    public static int bytesToHashCode(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = n + n2;
        int n6 = 0;
        for (int i = n; i < n5; ++i) {
            int n7 = (byArray[i] & 0xFF) << n6;
            n4 += byArray[i];
            n3 ^= n7;
            if (n6 == 24) {
                n6 = 0;
                continue;
            }
            n6 += 8;
        }
        n3 ^= n2;
        return n3 ^= n4;
    }

    public static String objectArrayToString(Object[] objectArray, String string) {
        if (objectArray == null) {
            return "";
        }
        String string2 = string == null ? ", " : string;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            stringBuffer.append(string2);
            if (object == null) continue;
            stringBuffer.append(object.toString());
        }
        if (objectArray.length > 0) {
            stringBuffer.delete(0, string2.length());
        }
        return stringBuffer.toString();
    }
}

