/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.ReportRoot;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IReportRootRequest;
import java.util.List;

public class ReportRootRequest
extends BaseRequest
implements IReportRootRequest {
    public ReportRootRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ReportRoot.class);
    }

    @Override
    public void get(ICallback<ReportRoot> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public ReportRoot get() throws ClientException {
        return (ReportRoot)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<ReportRoot> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(ReportRoot sourceReportRoot, ICallback<ReportRoot> callback) {
        this.send(HttpMethod.PATCH, callback, sourceReportRoot);
    }

    @Override
    public ReportRoot patch(ReportRoot sourceReportRoot) throws ClientException {
        return (ReportRoot)this.send(HttpMethod.PATCH, sourceReportRoot);
    }

    @Override
    public void post(ReportRoot newReportRoot, ICallback<ReportRoot> callback) {
        this.send(HttpMethod.POST, callback, newReportRoot);
    }

    @Override
    public ReportRoot post(ReportRoot newReportRoot) throws ClientException {
        return (ReportRoot)this.send(HttpMethod.POST, newReportRoot);
    }

    @Override
    public IReportRootRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IReportRootRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

