/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.OnenoteOperation;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IOnenoteOperationCollectionPage;
import com.microsoft.graph.requests.extensions.IOnenoteOperationCollectionRequest;
import com.microsoft.graph.requests.extensions.OnenoteOperationCollectionPage;
import com.microsoft.graph.requests.extensions.OnenoteOperationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.OnenoteOperationCollectionResponse;
import com.microsoft.graph.requests.extensions.OnenoteOperationRequestBuilder;
import java.util.List;

public class OnenoteOperationCollectionRequest
extends BaseCollectionRequest<OnenoteOperationCollectionResponse, IOnenoteOperationCollectionPage>
implements IOnenoteOperationCollectionRequest {
    public OnenoteOperationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OnenoteOperationCollectionResponse.class, IOnenoteOperationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IOnenoteOperationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(OnenoteOperationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IOnenoteOperationCollectionPage get() throws ClientException {
        OnenoteOperationCollectionResponse response = (OnenoteOperationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(OnenoteOperation newOnenoteOperation, ICallback<OnenoteOperation> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new OnenoteOperationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newOnenoteOperation, callback);
    }

    @Override
    public OnenoteOperation post(OnenoteOperation newOnenoteOperation) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new OnenoteOperationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newOnenoteOperation);
    }

    @Override
    public IOnenoteOperationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IOnenoteOperationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IOnenoteOperationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IOnenoteOperationCollectionPage buildFromResponse(OnenoteOperationCollectionResponse response) {
        OnenoteOperationCollectionRequestBuilder builder = response.nextLink != null ? new OnenoteOperationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        OnenoteOperationCollectionPage page = new OnenoteOperationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

