/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.EnrollmentConfigurationAssignment;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.EnrollmentConfigurationAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.EnrollmentConfigurationAssignmentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.EnrollmentConfigurationAssignmentCollectionResponse;
import com.microsoft.graph.requests.extensions.EnrollmentConfigurationAssignmentRequestBuilder;
import com.microsoft.graph.requests.extensions.IEnrollmentConfigurationAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.IEnrollmentConfigurationAssignmentCollectionRequest;
import java.util.List;

public class EnrollmentConfigurationAssignmentCollectionRequest
extends BaseCollectionRequest<EnrollmentConfigurationAssignmentCollectionResponse, IEnrollmentConfigurationAssignmentCollectionPage>
implements IEnrollmentConfigurationAssignmentCollectionRequest {
    public EnrollmentConfigurationAssignmentCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, EnrollmentConfigurationAssignmentCollectionResponse.class, IEnrollmentConfigurationAssignmentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IEnrollmentConfigurationAssignmentCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(EnrollmentConfigurationAssignmentCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IEnrollmentConfigurationAssignmentCollectionPage get() throws ClientException {
        EnrollmentConfigurationAssignmentCollectionResponse response = (EnrollmentConfigurationAssignmentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(EnrollmentConfigurationAssignment newEnrollmentConfigurationAssignment, ICallback<EnrollmentConfigurationAssignment> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new EnrollmentConfigurationAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newEnrollmentConfigurationAssignment, callback);
    }

    @Override
    public EnrollmentConfigurationAssignment post(EnrollmentConfigurationAssignment newEnrollmentConfigurationAssignment) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new EnrollmentConfigurationAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newEnrollmentConfigurationAssignment);
    }

    @Override
    public IEnrollmentConfigurationAssignmentCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IEnrollmentConfigurationAssignmentCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IEnrollmentConfigurationAssignmentCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IEnrollmentConfigurationAssignmentCollectionPage buildFromResponse(EnrollmentConfigurationAssignmentCollectionResponse response) {
        EnrollmentConfigurationAssignmentCollectionRequestBuilder builder = response.nextLink != null ? new EnrollmentConfigurationAssignmentCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        EnrollmentConfigurationAssignmentCollectionPage page = new EnrollmentConfigurationAssignmentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

