/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.editor.configuration.internal;

import com.liferay.item.selector.ItemSelectorCriterion;
import com.liferay.item.selector.ItemSelectorReturnType;
import com.liferay.item.selector.criteria.FileEntryItemSelectorReturnType;
import com.liferay.item.selector.criteria.URLItemSelectorReturnType;
import com.liferay.item.selector.criteria.image.criterion.ImageItemSelectorCriterion;
import com.liferay.item.selector.criteria.upload.criterion.UploadItemSelectorCriterion;
import com.liferay.item.selector.criteria.url.criterion.URLItemSelectorCriterion;
import com.liferay.portal.kernel.editor.configuration.BaseEditorConfigContributor;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.wiki.item.selector.criterion.WikiAttachmentItemSelectorCriterion;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletURL;

public abstract class BaseWikiAttachmentImageEditorConfigContributor
extends BaseEditorConfigContributor {
    public void populateConfigJSONObject(JSONObject jsonObject, Map<String, Object> inputEditorTaglibAttributes, ThemeDisplay themeDisplay, RequestBackedPortletURLFactory requestBackedPortletURLFactory) {
        boolean allowBrowseDocuments = GetterUtil.getBoolean((Object)inputEditorTaglibAttributes.get("liferay-ui:input-editor:allowBrowseDocuments"));
        if (!allowBrowseDocuments) {
            return;
        }
        Map fileBrowserParamsMap = (Map)inputEditorTaglibAttributes.get("liferay-ui:input-editor:fileBrowserParams");
        long wikiPageResourcePrimKey = 0L;
        if (fileBrowserParamsMap != null) {
            wikiPageResourcePrimKey = GetterUtil.getLong((String)((String)fileBrowserParamsMap.get("wikiPageResourcePrimKey")));
        }
        if (wikiPageResourcePrimKey == 0L) {
            String removePlugins = jsonObject.getString("removePlugins");
            removePlugins = Validator.isNotNull((String)removePlugins) ? removePlugins + ",ae_addimages" : "ae_addimages";
            jsonObject.put("removePlugins", removePlugins);
        }
        String name = GetterUtil.getString((Object)inputEditorTaglibAttributes.get("liferay-ui:input-editor:name"));
        boolean inlineEdit = GetterUtil.getBoolean((Object)inputEditorTaglibAttributes.get("liferay-ui:input-editor:inlineEdit"));
        if (!inlineEdit) {
            String namespace = GetterUtil.getString((Object)inputEditorTaglibAttributes.get("liferay-ui:input-editor:namespace"));
            name = namespace + name;
        }
        String itemSelectorURL = this.getItemSelectorURL(requestBackedPortletURLFactory, name + "selectItem", wikiPageResourcePrimKey, themeDisplay);
        jsonObject.put("filebrowserImageBrowseLinkUrl", itemSelectorURL).put("filebrowserImageBrowseUrl", itemSelectorURL);
    }

    protected ItemSelectorCriterion getImageItemSelectorCriterion(ItemSelectorReturnType ... desiredItemSelectorReturnTypes) {
        ImageItemSelectorCriterion imageItemSelectorCriterion = new ImageItemSelectorCriterion();
        imageItemSelectorCriterion.setDesiredItemSelectorReturnTypes(desiredItemSelectorReturnTypes);
        return imageItemSelectorCriterion;
    }

    protected abstract String getItemSelectorURL(RequestBackedPortletURLFactory var1, String var2, long var3, ThemeDisplay var5);

    protected ItemSelectorCriterion getUploadItemSelectorCriterion(long wikiPageResourcePrimKey, ThemeDisplay themeDisplay, RequestBackedPortletURLFactory requestBackedPortletURLFactory) {
        PortletURL uploadURL = requestBackedPortletURLFactory.createActionURL("com_liferay_wiki_web_portlet_WikiPortlet");
        uploadURL.setParameter("javax.portlet.action", "/wiki/upload_page_attachment");
        uploadURL.setParameter("mimeTypes", PropsValues.DL_FILE_ENTRY_PREVIEW_IMAGE_MIME_TYPES);
        uploadURL.setParameter("resourcePrimKey", String.valueOf(wikiPageResourcePrimKey));
        UploadItemSelectorCriterion itemSelectorCriterion = new UploadItemSelectorCriterion("com_liferay_wiki_web_portlet_WikiPortlet", uploadURL.toString(), LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"page-attachments"));
        itemSelectorCriterion.setDesiredItemSelectorReturnTypes(new ItemSelectorReturnType[]{new FileEntryItemSelectorReturnType()});
        return itemSelectorCriterion;
    }

    protected ItemSelectorCriterion getURLItemSelectorCriterion() {
        URLItemSelectorCriterion itemSelectorCriterion = new URLItemSelectorCriterion();
        itemSelectorCriterion.setDesiredItemSelectorReturnTypes(new ItemSelectorReturnType[]{new URLItemSelectorReturnType()});
        return itemSelectorCriterion;
    }

    protected ItemSelectorCriterion getWikiAttachmentItemSelectorCriterion(long wikiPageResourcePrimKey, ItemSelectorReturnType ... desiredItemSelectorReturnTypes) {
        WikiAttachmentItemSelectorCriterion itemSelectorCriterion = new WikiAttachmentItemSelectorCriterion(wikiPageResourcePrimKey, PropsValues.DL_FILE_ENTRY_PREVIEW_IMAGE_MIME_TYPES);
        itemSelectorCriterion.setDesiredItemSelectorReturnTypes(desiredItemSelectorReturnTypes);
        return itemSelectorCriterion;
    }
}

